/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.pushletClient;

import com.kingdee.messageCenter.IAdapter;
import com.kingdee.messageCenter.IClientManager;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.IMessagePool;
import com.kingdee.messageCenter.IWorker;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import com.kingdee.messageCenter.pushletClient.MessageClient;
import java.util.List;
import java.util.Map;

public class ClientAdapter
implements IAdapter {
    private MessageClient getMessageClient() {
        return MessageClient.getInstance();
    }

    private IMessagePool getMessagePool() {
        return ObjectFactory.getInstance().getMessagePool();
    }

    private IClientManager getClientManager() {
        return ObjectFactory.getInstance().getClientManager();
    }

    @Override
    public void start(IMessage messageServer) throws MessageException {
        List<Message> msgList = this.getMessagePool().getUnPushedMessage(this.getClientManager().getClientId());
        if (msgList != null) {
            for (Message message : msgList) {
                messageServer.pushMessage(message);
            }
        }
        Map<String, IWorker> workers = this.getClientManager().getWorkers();
        for (String subject : workers.keySet()) {
            this.getMessageClient().subscribe(subject);
        }
    }

    @Override
    public void pushMessage(Message message) throws MessageException {
        this.getMessageClient().pushMessage(message);
        this.getMessagePool().moveMessage2Old(message.getId());
    }

    @Override
    public void receive(Message message) throws MessageException {
    }

    @Override
    public String processSubject(String subject) throws MessageException {
        return "/" + this.getClientManager().getClientId() + subject;
    }

    @Override
    public Message getMessage(Message message) throws MessageException {
        this.getMessagePool().moveMessage2Old(message.getId());
        return this.getMessageClient().getMessage(message);
    }
}

