/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.server.dao;

import com.kingdee.messageCenter.IMessageDAO;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.utils.GsonUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.web.context.ContextLoader;

public class MessageDAO
implements IMessageDAO {
    public static final Logger logger = Logger.getLogger(MessageDAO.class);
    private static final String ACTIVE_TABLE_NAME = "T_MCT_MessageActive";
    private static final String HISTORY_TABLE_NAME = "T_MCT_MessageHistory";
    private JdbcTemplate jdbcTemplate = null;
    private MessageMapper messageMapper;

    private JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = (JdbcTemplate)ContextLoader.getCurrentWebApplicationContext().getBean("jdbcTemplate", JdbcTemplate.class);
        }
        return this.jdbcTemplate;
    }

    private MessageMapper getMapper() {
        if (this.messageMapper == null) {
            this.messageMapper = new MessageMapper();
        }
        return this.messageMapper;
    }

    private String getTableName(boolean isActive) {
        return isActive ? ACTIVE_TABLE_NAME : HISTORY_TABLE_NAME;
    }

    @Override
    public List<Message> getUnPushedMessage(String enterpriseId) throws MessageException {
        String sql = "select FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector  from  T_MCT_MessageActive where FEnterpriseId = ? and FDirector = ? ";
        Object[] args = new Object[]{enterpriseId, 10};
        return this.getJdbcTemplate().query(sql, args, (RowMapper)this.getMapper());
    }

    @Override
    public List<Message> getUnProcessedMessage() throws MessageException {
        String sql = "select FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector  from  T_MCT_MessageActive where FDirector = ? ";
        Object[] args = new Object[]{0};
        return this.getJdbcTemplate().query(sql, args, (RowMapper)this.getMapper());
    }

    @Override
    public void save(boolean isActive, Message message) throws MessageException {
        String sql = "insert into " + this.getTableName(isActive) + " (FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector) " + " values (?,?,?,?,?,?)";
        String body = GsonUtils.toJson(message.getBody());
        this.getJdbcTemplate().update(sql, new Object[]{message.getId(), message.getEnterpriseId(), message.getSubject(), body, message.getLastUpdatetime(), message.getDirector()}, new int[]{12, 12, 12, 12, 93, 4});
    }

    @Override
    public void update(boolean isActive, Message message) throws MessageException {
        String sql = "update " + this.getTableName(isActive) + " SET FEnterpriseId = ?,FSubject = ?,FBody = ?," + "FLastUpdatetime = ?,FDirector = ? " + "WHERE FID = ?";
        String body = GsonUtils.toJson(message.getBody());
        this.getJdbcTemplate().update(sql, new Object[]{message.getEnterpriseId(), message.getSubject(), body, message.getLastUpdatetime(), message.getDirector(), message.getId()}, new int[]{12, 12, 12, 93, 4, 12});
    }

    @Override
    public void delete(boolean isActive, String id) throws MessageException {
        String sql = "delete from " + this.getTableName(isActive) + " WHERE FID = ?";
        this.getJdbcTemplate().update(sql, new Object[]{id}, new int[]{12});
    }

    @Override
    public Message getValue(boolean isActive, String id) throws MessageException {
        String sql = "select FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector  from  " + this.getTableName(isActive) + " where FID = ? ";
        Message message = null;
        try {
            message = (Message)this.getJdbcTemplate().queryForObject(sql, new Object[]{id}, new int[]{12}, (RowMapper)this.getMapper());
        }
        catch (DataRetrievalFailureException e) {
            logger.error((Object)("id: " + id + ",error : " + e.getMessage()), (Throwable)e);
        }
        return message;
    }

    protected class MessageMapper
    implements RowMapper<Message> {
        protected MessageMapper() {
        }

        public Message mapRow(ResultSet rs, int rowNum) throws SQLException {
            Message m = new Message();
            m.setId(rs.getString("FID"));
            m.setEnterpriseId(rs.getString("FEnterpriseId"));
            m.setSubject(rs.getString("FSubject"));
            m.setDirector(rs.getInt("FDirector"));
            Map body = GsonUtils.fromJson(rs.getString("FBody"), HashMap.class);
            m.setBody(body);
            m.setLastUpdatetime(rs.getDate("FLastUpdatetime"));
            m.setStatus(10);
            return m;
        }
    }
}

