/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.report.client.IDealFilterPanel;
import com.kingdee.eas.base.report.client.ReportQueryDlg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class FiDialogAdapter
extends ReportQueryDlg {
    protected CommonQueryDialog queryDialog = null;
    private CustomerQueryPanel[] userPanels = null;
    private IMetaDataPK pk = new MetaDataPK("com.kingdee.eas.framework.report.app", "CommRptEmptyQuery");
    private String parentUIName;

    public FiDialogAdapter(CoreUI owner) {
        super(owner);
        this.setOwner(owner);
    }

    public void setCustomerQueryPanel(CustomerQueryPanel[] userPanels) {
        this.userPanels = userPanels;
        if (userPanels != null && userPanels.length > 0) {
            this.parentUIName = userPanels[0].getClass().getName();
        }
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanels != null) {
            int i;
            int n = this.userPanels.length;
            for (i = 0; i < n; ++i) {
                this.userPanels[i].loadFields();
                if (!(this.userPanels[i] instanceof IDealFilterPanel)) continue;
                ((IDealFilterPanel)this.userPanels[i]).init();
            }
            for (i = 0; i < n; ++i) {
                this.userPanels[i].initLayout();
                this.queryDialog.addUserPanel((KDPanel)this.userPanels[i]);
            }
            Dimension dd = this.getQueryDialogSize(this.userPanels);
            this.queryDialog.setWidth(dd.width);
            this.queryDialog.setShowFieldCompare(false);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.setOwner((Component)this.getOwner());
            this.queryDialog.setQueryObjectPK(this.pk);
            this.queryDialog.setDisShowRowCount(true);
            this.queryDialog.setTitle(this.getTitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            this.queryDialog.setShowFilter(this.isShowFilter());
            this.queryDialog.setShowSorter(this.isShowSorter());
            this.queryDialog.setParentUIClassName(this.parentUIName);
            this.initUserPanels(n);
        }
    }

    private void initUserPanels(int n) throws Exception, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < n; ++i) {
            this.userPanels[i].getUIContext().clear();
            this.userPanels[i].getUIContext().putAll(this.getOwner().getUIContext());
        }
    }

    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
        Dimension size = new Dimension(100, 100);
        int n = userPanels.length;
        for (int i = 0; i < n; ++i) {
            Dimension d = userPanels[i].getSize();
            if (d.height > size.height) {
                size.height = d.height;
            }
            if (d.width <= size.width) continue;
            size.width = d.width;
        }
        size.height += 35;
        size.width += 228;
        size.height += 105;
        if (size.width <= 290 && size.height <= 280) {
            size.width = 290;
            size.height = 280;
        } else if (size.width <= 580 && size.height <= 435) {
            size.width = 580;
            size.height = 435;
        } else if (size.width <= 680 && size.height <= 510) {
            size.width = 680;
            size.height = 510;
        } else if (size.width <= 792 && size.height <= 566) {
            size.width = 792;
            size.height = 566;
        }
        size.width -= 228;
        size.height -= 105;
        return size;
    }

    public boolean showQueryDialog(boolean useDefaultSolution) throws Exception {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            this.queryDialog.setOwner((Component)this.getOwner());
            this.initQueryDialog();
        }
        int n = this.userPanels.length;
        if (useDefaultSolution) {
            this.loadDefaultSolution(n);
        }
        boolean ok = false;
        if ((this.getFilter() == null || !useDefaultSolution) && this.queryDialog.show()) {
            if (this.getFilter() == null) {
                this.setFilter(new RptParams());
            } else {
                this.getFilter().clear();
            }
            for (int i = 0; i < n; ++i) {
                CustomerParams cp = this.userPanels[i].getCustomerParams();
                Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
                if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                    this.getFilter().putAll((Map)RptFilterUtils.toObjectFromRptFilterMap((Object)param));
                    continue;
                }
                this.getFilter().putAll((Map)param);
            }
            ok = true;
        }
        if (this.getFilter() != null && this.getFilter().keySet().size() > 0 && (ok || useDefaultSolution)) {
            CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.getFilter().toMap());
            for (int i = 0; i < n; ++i) {
                if (useDefaultSolution) continue;
                this.userPanels[i].setCustomerParams(cp);
            }
            return true;
        }
        return false;
    }

    private void loadDefaultSolution(int n) throws BOSException, EASBizException {
        block15: {
            String queryName;
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            if (iQuery.hasDefaultSolution(this.parentUIName, queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.pk).getFullName())) {
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.parentUIName, queryName);
                QueryPanelInfo[] qpi = new QueryPanelInfo[n];
                for (int i = 0; i < n; ++i) {
                    qpi[i] = solution.getQueryPanelInfo().get(i);
                }
                if (qpi[0] != null) {
                    try {
                        byte[] bs = qpi[0].getParam();
                        if (bs != null) {
                            this.setFilter((RptParams)CommonUtil.getObject((byte[])bs));
                        }
                        if (this.getFilter() != null) {
                            CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.getFilter());
                            for (int i = 0; i < n; ++i) {
                                this.userPanels[i].setCustomerParams(cp);
                            }
                            break block15;
                        }
                        CustomerParams[] cp = new CustomerParams[n];
                        Object obj = null;
                        for (int i = 0; i < n; ++i) {
                            cp[i] = CustomerParams.getCustomerParams2((String)qpi[i].getCustomerParams());
                            if (cp[i] == null) continue;
                            try {
                                obj = RptParamsUtil.getFromCustomerParams((CustomerParams)cp[i]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (obj instanceof RptParams) {
                                this.setFilter((RptParams)obj);
                                continue;
                            }
                            if (this.getFilter() == null) {
                                this.setFilter(new RptParams());
                            }
                            for (int j = 0; j < n; ++j) {
                                if (!this.userPanels[j].getClass().toString().endsWith(qpi[i].getPanelClassName().toString())) continue;
                                this.userPanels[j].setCustomerParams(cp[i]);
                                Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp[i]);
                                if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                                    this.getFilter().putAll((Map)RptFilterUtils.toObjectFromRptFilterMap((Object)param));
                                    continue;
                                }
                                this.getFilter().putAll((Map)param);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public boolean showFilterDialog(String filterUIName, boolean useDefaultSolution) throws Exception {
        if (this.queryDialog == null) {
            String[] uiName = filterUIName.split(",");
            CustomerQueryPanel[] filterUIs = new CustomerQueryPanel[uiName.length];
            for (int i = 0; i < uiName.length; ++i) {
                CustomerQueryPanel filterUI;
                filterUIs[i] = filterUI = (CustomerQueryPanel)Class.forName(uiName[i]).newInstance();
            }
            this.setCustomerQueryPanel(filterUIs);
            this.setShowFilter(false);
            this.setShowSorter(false);
        }
        return this.showQueryDialog(useDefaultSolution);
    }
}

