/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.evs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.RecordBaseConfigCollection;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.tool.FormatUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FilingEvsUtils {
    private static Logger logger = Logger.getLogger(FilingEvsUtils.class);
    public static List<String> billTypes = new ArrayList<String>(2);
    private static LoadingCache<String, RecordBaseInfo> recordBaseCache;

    public static Boolean canArchXbrl(Context ctx, String recordBaseId, String orgId) throws EASBizException {
        Boolean result = false;
        RecordBaseInfo info = null;
        try {
            info = (RecordBaseInfo)recordBaseCache.get((Object)recordBaseId);
            if (!billTypes.contains(info.getBillType().getBosType())) {
                return result;
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(orgId));
            CompanyOrgUnitInfo createOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(info.getOrg().getId()));
            String archLongNumber = companyOrgUnitInfo.getLongNumber();
            String creatorLongNumber = createOrg.getLongNumber();
            HashSet<String> set = new HashSet<String>();
            set.add(archLongNumber);
            while (archLongNumber.indexOf(creatorLongNumber) > -1 && !creatorLongNumber.equals(archLongNumber) && archLongNumber.lastIndexOf("!") > -1) {
                archLongNumber = archLongNumber.substring(0, archLongNumber.lastIndexOf("!"));
                set.add(archLongNumber);
            }
            set.add(creatorLongNumber);
            String sql = "SELECT T1.FelCertificate, T2.FLONGNUMBER, T2.FLEVEL, T1.FID, T1.FORGID FROM T_REC_RECORDBASEEXTEND  T1 inner join T_ORG_COMPANY T2 on T1.FRecordBaseId = ? and T2.FID = T1.FORGID and T2.FLONGNUMBER IN " + FormatUtils.list2Sql(set) + " and T1.FelCertificate is not null order by T2.FLEVEL desc";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{recordBaseId});
            if (executeQuery.next()) {
                result = executeQuery.getBoolean(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519"), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519"), (Throwable)e);
        }
        return result;
    }

    public static Boolean hasBeenEvsPatch() {
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.base.evs.app.apiservice.EvsServiceFacadeFactory");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    static {
        billTypes.add("2652E01E");
        billTypes.add("B76C5DF9");
        recordBaseCache = CacheBuilder.newBuilder().maximumSize(40L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, RecordBaseInfo>(){

            public RecordBaseInfo load(String key) throws Exception {
                RecordBaseInfo recordBaseInfo;
                RecordBaseConfigCollection configs;
                Context ctx = ContextUtils.getContextFromSessionNoException();
                if (null == ctx) {
                    ctx = ContextManager.getContext();
                }
                if (ctx != null && ctx.getCaller() == null) {
                    Map currentServiceEnv = GeniusBOSFactory.getCurrentServiceEnv();
                    ctx = (Context)currentServiceEnv.get("BOSCTX");
                }
                if ((configs = (recordBaseInfo = null != ctx && null != ctx.getCaller() ? RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo("select id, billType.bosType, org.id, configs.* where id ='" + key + "'") : RecordBaseFactory.getRemoteInstance().getRecordBaseInfo("select id, billType.bosType, org.id, configs.* where id ='" + key + "'")).getConfigs()) != null && configs.size() > 0) {
                    for (int i = 0; i < configs.size(); ++i) {
                        recordBaseInfo.put(configs.get(i).getNumber(), configs.get(i).getValue());
                    }
                }
                return recordBaseInfo;
            }
        });
    }
}

