/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.filing.instance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.el.rec.AchRecordDetailCollection;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.AchRecordDetailInfo;
import com.kingdee.eas.el.rec.ArcLogInfo;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.ArchPeriodFactory;
import com.kingdee.eas.el.rec.ArchPeriodInfo;
import com.kingdee.eas.el.rec.ArchSchemeCollection;
import com.kingdee.eas.el.rec.ArchSchemeFactory;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.ArchSchemeScopeOrgEntryCollection;
import com.kingdee.eas.el.rec.ArchSchemeStateEnum;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailFactory;
import com.kingdee.eas.el.rec.AttachBillAchDetailInfo;
import com.kingdee.eas.el.rec.IJob;
import com.kingdee.eas.el.rec.JobCollection;
import com.kingdee.eas.el.rec.JobEntryFactory;
import com.kingdee.eas.el.rec.JobEntryInfo;
import com.kingdee.eas.el.rec.JobFactory;
import com.kingdee.eas.el.rec.JobInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.TaskLogInfo;
import com.kingdee.eas.el.rec.TaskStateEnum;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.filing.IFilingInstance;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfos;
import com.kingdee.eas.el.rec.model.RecordInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.model.dataprovider.AbstractBatchDataProvider;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelper;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelperFactory;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.ThreadUtil;
import com.kingdee.eas.el.rec.thread.UploadArchInfosThreadPool;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.IDUtils;
import com.kingdee.eas.el.rec.tool.LockDataUtils;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.RECStringUtil;
import com.kingdee.eas.el.rec.tool.RecLogUtils;
import com.kingdee.eas.el.rec.tool.ThreadPoolInitFactory;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.dom4j.Document;

public abstract class AbstractFilingStrategy
implements IFilingInstance {
    private static Logger logger = Logger.getLogger(AbstractFilingStrategy.class);
    public static ConcurrentHashMap<String, Object> clz = new ConcurrentHashMap();
    private static String DUMP_ARCRECORDDETAIL_SQL = "INSERT INTO T_REC_AchRecordDetailDel(FBillId,FBillNumber,FState,FRecordBaseInstID,FArcRecordID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID)  SELECT FBillId,FBillNumber,FState,FRecordBaseInstID,FArcRecordID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID FROM T_REC_AchRecordDetail WHERE FID = ?";
    private static String DELETE_ARCRECORDDETAIL_SQL = "DELETE FROM T_REC_AchRecordDetail WHERE FID = ?";
    private static String DUMP_ATTACHBILLACHDETAIL_SQL = "INSERT INTO T_REC_AttachBillAchDetailDel( FBillId,FBillNumber,FState,FOriginsBillId,FArcContentID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAchRecordDetailID,FID)  SELECT FBillId,FBillNumber,FState,FOriginsBillId,FArcContentID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAchRecordDetailID,FID FROM T_REC_AttachBillAchDetail WHERE FID = ?";
    private static String DELETE_ATTACHBILLACHDETAIL_SQL = "DELETE FROM T_REC_AttachBillAchDetail WHERE FID = ?";

    @Override
    public void execute(final Context ctx, final ArchSchemeInfo asInfo, final ArcheSchemeContentEntryCollection contents, final ArchSchemeScopeOrgEntryCollection orgs) throws Exception {
        boolean successLocked;
        String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
        NoticeArchSysHelperFactory.getInstance(ctx, arch_type).checkService(ctx);
        if (!StringUtils.isEmpty((String)ArchUtils.getOwner(asInfo.getId().toString()))) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"[" + asInfo.getNumber() + "]\u6b63\u5728\u6267\u884c"});
        }
        if (ArchSchemeStateEnum.DISABLE.equals((Object)asInfo.getState())) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"[" + asInfo.getNumber() + "]\u4e3a\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u6267\u884c"});
        }
        boolean bl = successLocked = StringUtils.isEmpty((String)asInfo.getString("rec_execuschmeme")) ? LockDataUtils.getLock(ctx, asInfo.getId().toString(), "rec_execuschmeme") : true;
        if (!successLocked) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"[" + asInfo.getNumber() + "]\u6b63\u5728\u6267\u884c"});
        }
        try {
            this.checkScheme(ctx, asInfo);
            Thread runnable = new Thread(){

                @Override
                public void run() {
                    try {
                        WebContextUtil.initRpcConfig((Context)ctx);
                        AbstractFilingStrategy.this.doExecute(ctx, asInfo, contents, orgs);
                        AbstractFilingStrategy.this.startHandleJob(ctx, null);
                    }
                    catch (Exception e) {
                        logger.error((Object)("[" + asInfo.getNumber() + "]\u65b9\u6848\u6267\u884c\u5f02\u5e38"), (Throwable)e);
                    }
                    finally {
                        LockDataUtils.releaseLock(ctx, asInfo.getId().toString());
                        ArchUtils.archFlagCache.remove(asInfo.getId().toString());
                    }
                }
            };
            runnable.start();
        }
        catch (Exception e) {
            LockDataUtils.releaseLock(ctx, asInfo.getId().toString());
            ArchUtils.archFlagCache.remove(asInfo.getId().toString());
            throw e;
        }
    }

    protected abstract void checkScheme(Context var1, ArchSchemeInfo var2) throws Exception;

    protected abstract void doExecute(Context var1, ArchSchemeInfo var2, ArcheSchemeContentEntryCollection var3, ArchSchemeScopeOrgEntryCollection var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doArch(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        this.setArching(ctx, recordInfo);
        try {
            this.prepreDataTx(ctx, new RecordInfo(ctx, recordInfo, periodInfo));
            this.startHandleJob(ctx, recordInfo);
        }
        finally {
            this.releaseMutex(ctx, recordInfo);
        }
    }

    @Override
    public void increReArch(Context ctx, String recordId) throws Exception {
        final ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, null, false);
        final Context fianlCtx = (Context)this.deeplyCopy((Serializable)ctx);
        final PeriodInfo periodInfo = this.getPeriodInfo(fianlCtx, recordInfo);
        if (ArcStateEnum.ARC_SUCCESS.equals((Object)recordInfo.getState()) && !this.isCurrentPeriod(ctx, recordInfo, periodInfo)) {
            throw new RecException(RecException.UNKNOWN, new Object[]{recordInfo.getArcRecordNum() + "\u5f52\u6863\u6210\u529f\uff0c\u4e0d\u662f\u5f53\u524d\u671f\u4e0d\u80fd\u8fdb\u884c\u91cd\u65b0\u5f52\u6863\u64cd\u4f5c"});
        }
        String latestHisPeriod = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_DATADUMP_PERIOD);
        if (!StringUtils.isEmpty((String)latestHisPeriod) && recordInfo.getPeriodNum() <= Integer.valueOf(latestHisPeriod) && (ArcStateEnum.ARC_SUCCESS.equals((Object)recordInfo.getState()) || ArcStateEnum.ARC_FAIL.equals((Object)recordInfo.getState()))) {
            throw new RecException(RecException.UNKNOWN, new Object[]{recordInfo.getArcRecordNum() + "\u6570\u636e\u5df2\u8f6c\u50a8\uff0c\u53ea\u80fd\u8fdb\u884c\u5168\u91cf\u91cd\u65b0\u5f52\u6863\u64cd\u4f5c"});
        }
        try {
            Thread increReArchThread = new Thread(){

                @Override
                public void run() {
                    try {
                        WebContextUtil.initRpcConfig((Context)fianlCtx);
                        AbstractFilingStrategy.this.doArch(fianlCtx, recordInfo, periodInfo);
                    }
                    catch (Exception e) {
                        AbstractFilingStrategy.this.handleArchException(fianlCtx, recordInfo, e);
                    }
                    finally {
                        AbstractFilingStrategy.this.releaseMutex(fianlCtx, recordInfo);
                    }
                }
            };
            increReArchThread.start();
        }
        catch (Exception e) {
            this.handleArchException(ctx, recordInfo, e);
            throw e;
        }
    }

    @Override
    public void arch(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        try {
            boolean exists = ArcRecordFactory.getLocalInstance(ctx).exists("where arcRecordNum = '" + recordInfo.getArcRecordNum() + "'");
            if (exists) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("arcRecordNum", (Object)recordInfo.getArcRecordNum()));
                String newSchemeId = recordInfo.getArcSchemeId();
                recordInfo = this.getRecordInfo(ctx, filter, null, false);
                if (ArcStateEnum.ARC_SUCCESS.equals((Object)recordInfo.getState()) && !this.isCurrentPeriod(ctx, recordInfo, periodInfo)) {
                    return;
                }
                this.updateSchemeId(ctx, newSchemeId, recordInfo);
                this.doArch(ctx, recordInfo, periodInfo);
            } else {
                recordInfo.setState(ArcStateEnum.WAITING);
                this.saveArchRecordInfo(ctx, recordInfo);
                recordInfo = this.getRecordInfo(ctx, recordInfo.getId().toString());
                this.doArch(ctx, recordInfo, periodInfo);
            }
        }
        catch (Exception e) {
            this.handleArchException(ctx, recordInfo, e);
            logger.error((Object)("[" + recordInfo.getArcRecordNum() + "]\u6267\u884c\u5f52\u6863\u5f02\u5e38"), (Throwable)e);
        }
    }

    protected void updateSchemeId(Context ctx, String newSchemeId, ArcRecordInfo recordInfo) throws Exception {
        if (!(newSchemeId.equals(recordInfo.getArcSchemeId()) || !StringUtils.isEmpty((String)recordInfo.getArcSchemeId()) && ArchSchemeFactory.getLocalInstance(ctx).exists("where id = '" + recordInfo.getArcSchemeId() + "'"))) {
            recordInfo.setArcSchemeId(newSchemeId);
            FilingUtils.updateRecordPartial(ctx, recordInfo, "arcSchemeId");
        }
    }

    protected void saveArchRecordInfo(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        try {
            recordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            ArcRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)recordInfo);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u4fdd\u5b58\u5f52\u6863\u8bb0\u5f55\u5931\u8d25"});
        }
    }

    protected void updateArchRecordInfo(Context ctx, ArcRecordInfo recordInfo, SelectorItemCollection selectorItem) throws RecException {
        try {
            recordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            selectorItem.add(new SelectorItemInfo("lastUpdateTime"));
            ArcRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selectorItem);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u66f4\u65b0\u5f52\u6863\u8bb0\u5f55\u5931\u8d25"});
        }
    }

    protected boolean isCurrentPeriod(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws EASBizException, BOSException {
        PeriodInfo currentPeriodInfo = PeriodUtil.getBillCurrentPeriodInfo(ctx, recordInfo.getContent().getBillType().getPeriodSys(), recordInfo.getOrg().getId() + "");
        if (null == currentPeriodInfo) {
            return false;
        }
        return currentPeriodInfo.getId().equals((Object)periodInfo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String reverseArch(Context ctx, String recordId) throws EASBizException, Exception {
        ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, null, false);
        try {
            this.setArching(ctx, recordInfo);
            if (!ArcStateEnum.ARC_SUCCESS.equals((Object)recordInfo.getState())) {
                throw new RecException(RecException.UNKNOWN, new Object[]{"\u53ea\u6709\u5f52\u6863\u6210\u529f\u624d\u80fd\u53cd\u5f52\u6863"});
            }
            this.doBusinessReverse(ctx, recordInfo);
            recordInfo.setState(ArcStateEnum.REVERSE_ARC);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            recordInfo.setLatelyRevArcUserId(userInfo);
            recordInfo.setLatelyRevArcTime(new Timestamp(System.currentTimeMillis()));
            SelectorItemCollection selectorItem = new SelectorItemCollection();
            selectorItem.add(new SelectorItemInfo("state"));
            selectorItem.add(new SelectorItemInfo("latelyRevArcUserId"));
            selectorItem.add(new SelectorItemInfo("latelyRevArcTime"));
            this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
            this.recordReverseOperation(ctx, recordId);
            String string = "";
            return string;
        }
        finally {
            this.releaseMutex(ctx, recordInfo);
        }
    }

    protected abstract void doBusinessReverse(Context var1, ArcRecordInfo var2) throws RecException;

    @Override
    public void fullReArch(Context ctx, String recordId) throws Exception {
        final ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, false);
        this.canFullReArch(ctx, recordInfo);
        try {
            final Context fianlCtx = ctx;
            Thread doFullReArchThread = new Thread(){

                @Override
                public void run() {
                    try {
                        WebContextUtil.initRpcConfig((Context)fianlCtx);
                        AbstractFilingStrategy.this.doFullReArch(fianlCtx, recordInfo);
                    }
                    catch (Exception e) {
                        AbstractFilingStrategy.this.handleArchException(fianlCtx, recordInfo, e);
                    }
                    finally {
                        AbstractFilingStrategy.this.releaseMutex(fianlCtx, recordInfo);
                    }
                }
            };
            doFullReArchThread.start();
        }
        catch (Exception e) {
            this.handleArchException(ctx, recordInfo, e);
            throw e;
        }
    }

    protected void canFullReArch(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        if (ArcStateEnum.ARC_SUCCESS.equals((Object)recordInfo.getState())) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u5f52\u6863\u6210\u529f\u4e0d\u80fd\u8fdb\u884c\u5168\u91cf\u91cd\u65b0\u5f52\u6863\u64cd\u4f5c"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFullReArch(Context ctx, ArcRecordInfo recordInfo) throws Exception {
        this.setArching(ctx, recordInfo);
        try {
            this.noticeSysReArch(ctx, recordInfo);
            JobFactory.getLocalInstance(ctx).delete("where record = '" + recordInfo.getId().toString() + "'");
            recordInfo.setLastGetBillTime(null);
            SelectorItemCollection selectorItem = new SelectorItemCollection();
            selectorItem.add(new SelectorItemInfo("lastGetBillTime"));
            this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
            this.deleteArchedData(ctx, recordInfo);
        }
        finally {
            this.releaseMutex(ctx, recordInfo);
        }
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
        this.doArch(ctx, recordInfo, periodInfo);
    }

    protected void noticeSysReArch(Context ctx, ArcRecordInfo recordInfo) throws Exception {
        String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
        NoticeArchSysHelper noticeArchSysHelper = NoticeArchSysHelperFactory.getInstance(ctx, arch_type);
        ArrayList<ArcRecordInfo> arcRecordInfoList = new ArrayList<ArcRecordInfo>();
        arcRecordInfoList.add(recordInfo);
        noticeArchSysHelper.reverseArch(ctx, arcRecordInfoList, new HashMap<String, String>());
    }

    @Override
    public void markFailed(Context ctx, String recordId) throws Exception {
        ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, null, false);
        if (!ArcStateEnum.ARC_LOADING.equals((Object)recordInfo.getState())) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u53ea\u6709\u6b63\u5728\u5f52\u6863\u624d\u80fd\u6807\u8bb0\u5f52\u6863\u5931\u8d25"});
        }
        boolean existsHandleJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordId + "' and (state = '" + "wating" + "' or state = '" + "running" + "' or state = '" + "uploaded" + "' or state = '" + "noticed" + "')");
        if (existsHandleJob) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u4efb\u52a1\u6b63\u5728\u5904\u7406\u4e2d"});
        }
        this.processFinalStateTx(ctx, recordId);
    }

    @Deprecated
    protected abstract ArchInfos prepareData(Context var1, ArcRecordInfo var2, PeriodInfo var3) throws Exception;

    protected void prepreDataTx(Context ctx, RecordInfo recordInfo) throws Exception {
        ArcRecordFactory.getLocalInstance(ctx).prepareDataTx(this, recordInfo);
    }

    public abstract void prepareData(Context var1, RecordInfo var2) throws Exception;

    protected void noticeSysArch(Context ctx, ArchFormatInfo archFormatInfo) {
        String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
        NoticeArchSysHelper noticeArchSysHelper = NoticeArchSysHelperFactory.getInstance(ctx, arch_type);
        String recordId = archFormatInfo.getRecordInfo().getId().toString();
        boolean successLocked = LockDataUtils.getLock(ctx, recordId, "rec_arch");
        if (!successLocked) {
            return;
        }
        try {
            noticeArchSysHelper.noticeArchSys(ctx, archFormatInfo.getPeriodInfo(), archFormatInfo.getRecordInfo().getOrg(), archFormatInfo.getTaskFlag());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            LockDataUtils.releaseLock(ctx, recordId);
        }
    }

    protected void noticeSysArchBatch(Context ctx, ArchFormatInfo archFormatInfo) {
        String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
        NoticeArchSysHelper noticeArchSysHelper = NoticeArchSysHelperFactory.getInstance(ctx, arch_type);
        try {
            noticeArchSysHelper.noticeArchSysBatch(ctx, archFormatInfo, archFormatInfo.getPeriodInfo(), archFormatInfo.getRecordInfo().getOrg());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getTaskFlag() {
        return IDUtils.getId();
    }

    protected void upload(Context ctx, CompanyOrgUnitInfo org, PeriodInfo periodInfo, ArchFormatInfo formatInfo) throws Exception {
        ArrayList<ArchFormatInfo> list = new ArrayList<ArchFormatInfo>();
        list.add(formatInfo);
        String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
        NoticeArchSysHelper noticeArchSysHelper = NoticeArchSysHelperFactory.getInstance(ctx, arch_type);
        noticeArchSysHelper.uploadArchInfos(ctx, org, periodInfo, list);
    }

    protected void updateRecordState(Context ctx, ArcRecordInfo recordInfo, ArcStateEnum state) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        recordInfo.setId(recordInfo.getId());
        recordInfo.setState(state);
        recordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        try {
            ArcRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, sic);
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u5f52\u6863\u8bb0\u5f55\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    private void recordReverseOperation(Context ctx, String recordId) {
        try {
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordId, ArcStateEnum.REVERSE_ARC, "\u53cd\u5f52\u6863\u6210\u529f", "");
        }
        catch (Exception ex) {
            logger.error((Object)"\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25", (Throwable)ex);
        }
    }

    protected void handleArchException(Context ctx, ArcRecordInfo recordInfo, Exception e) {
        logger.error((Object)("\u5f52\u6863\u8bb0\u5f55[" + recordInfo.getArcRecordNum() + "]\u6267\u884c\u64cd\u4f5c\u5f02\u5e38"), (Throwable)e);
        this.updateRecordState(ctx, recordInfo, ArcStateEnum.ARC_FAIL);
        try {
            String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordInfo.getId().toString(), ArcStateEnum.ARC_FAIL, easInstanceHome.substring(easInstanceHome.lastIndexOf("/") + 1) + ":" + e.getMessage(), RECStringUtil.exception2String(e));
        }
        catch (Exception ex) {
            logger.error((Object)"\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        this.releaseMutex(ctx, recordInfo);
    }

    protected void handleNoData(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        ArcStateEnum arcNodata = ArcStateEnum.ARC_NODATA;
        if (recordInfo.getVoucherNum() > 0) {
            arcNodata = ArcStateEnum.ARC_SUCCESS;
        }
        this.updateRecordState(ctx, recordInfo, arcNodata);
        try {
            JobFactory.getLocalInstance(ctx).delete("where record = '" + recordInfo.getId() + "'");
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordInfo.getId().toString(), arcNodata, "\u65e0\u6570\u636e", null);
        }
        catch (Exception ex) {
            logger.error((Object)("handleNoData:" + recordInfo.getArcRecordNum()), (Throwable)ex);
        }
        this.releaseMutex(ctx, recordInfo);
    }

    protected abstract void handleDeletedData(Context var1, ArchInfos var2, ArcRecordInfo var3) throws Exception;

    @Deprecated
    protected void processData(Context ctx, ArcRecordInfo recordInfo, ArchInfos archInfos) throws Exception {
        this.processDataThread(ctx, recordInfo, recordInfo.getContent(), archInfos.getMainBills(), "0", this.getTaskFlag());
    }

    protected void processDataThread(final Context ctx, final ArcRecordInfo recordInfo, final RecordBaseInfo content, List<XmlBase> xmlBaseList, String subName, final String taskFlag) {
        int size = ThreadPoolInitFactory.getThreadPoolParam(ctx, "thread.upload.billsize", 100);
        int i = 0;
        ThreadUtil.ThreadInfo threadInfo = ThreadUtil.getLock(taskFlag);
        int times = xmlBaseList.size() / size;
        int forTime = 0;
        if (xmlBaseList.size() % size == 0) {
            threadInfo.addThreadCount(times);
            forTime = times;
        } else {
            threadInfo.addThreadCount(times + 1);
            forTime = times + 1;
        }
        while (i < forTime) {
            final String _subName = subName + "_" + i;
            final ArrayList<XmlBase> bills = new ArrayList<XmlBase>(xmlBaseList.subList(size * i, Math.min(xmlBaseList.size(), size * (i + 1))));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Context newCtx = (Context)AbstractFilingStrategy.this.deeplyCopy((Serializable)ctx);
                        WebContextUtil.initRpcConfig((Context)newCtx);
                        AbstractFilingStrategy.this.doUploadData(newCtx, recordInfo, content, bills, _subName, taskFlag);
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                        ArchRecordUtils.writeLogs(ctx, bills, recordInfo.getId().toString(), e);
                    }
                }
            };
            UploadArchInfosThreadPool.execute(ctx, runnable);
            ++i;
        }
    }

    protected Object deeplyCopy(Serializable obj) throws IOException, ClassNotFoundException {
        return this.bytes2object(this.object2bytes(obj));
    }

    private byte[] object2bytes(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object bytes2object(byte[] bytes) throws IOException, ClassNotFoundException {
        Object var3;
        try (ObjectInputStream ois = null;){
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            var3 = ois.readObject();
        }
        return var3;
    }

    protected abstract void doUploadData(Context var1, ArcRecordInfo var2, RecordBaseInfo var3, List<XmlBase> var4, String var5, String var6) throws Exception;

    protected void setArching(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        boolean successLocked = LockDataUtils.getLock(ctx, recordInfo.getArcRecordNum(), "rec_preparedata");
        if (!successLocked) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"[" + recordInfo.getArcRecordNum() + "]\u6b63\u5728\u5904\u7406\u4e2d"});
        }
    }

    protected void isArching(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        boolean successLocked = LockDataUtils.getLock(ctx, recordInfo.getArcRecordNum(), "rec_preparedata");
        if (!successLocked) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"[" + recordInfo.getArcRecordNum() + "]\u6b63\u5728\u5904\u7406\u4e2d"});
        }
    }

    protected void releaseMutex(Context ctx, ArcRecordInfo recordInfo) {
        LockDataUtils.releaseLock(ctx, recordInfo.getArcRecordNum());
    }

    protected abstract void deleteArchedData(Context var1, ArcRecordInfo var2) throws RecException;

    protected ArchFormatInfo getArchFormatInfo(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo, RecordBaseInfo recordBaseInfo, String taskFlag) throws RecException {
        ArchFormatInfo formatInfo = new ArchFormatInfo();
        formatInfo.setRecordInfo(recordInfo);
        formatInfo.setTaskFlag(taskFlag);
        formatInfo.setContent(recordBaseInfo);
        formatInfo.setPeriodInfo(periodInfo);
        return formatInfo;
    }

    protected ArchFormatInfo getArchFormatInfo(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo, RecordBaseInfo recordBaseInfo, JobInfo jobInfo) throws RecException {
        ArchFormatInfo archFormatInfo = this.getArchFormatInfo(ctx, recordInfo, periodInfo, recordBaseInfo, jobInfo.getFileFlag());
        archFormatInfo.setJobInfo(jobInfo);
        return archFormatInfo;
    }

    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId) throws Exception {
        return this.getRecordInfo(ctx, recorId, null);
    }

    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId, boolean queryChildRelation) throws Exception {
        return this.getRecordInfo(ctx, recorId, null, queryChildRelation);
    }

    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId, SelectorItemCollection selector) throws RecException {
        FilterInfo filter = this.getFilter(ctx, new String[]{"id"}, new Object[]{recorId}, null);
        return this.getRecordInfo(ctx, filter, selector);
    }

    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId, SelectorItemCollection selector, boolean queryChildRelation) throws RecException {
        FilterInfo filter = this.getFilter(ctx, new String[]{"id"}, new Object[]{recorId}, null);
        return this.getRecordInfo(ctx, filter, selector, queryChildRelation);
    }

    protected ArcRecordInfo getRecordInfo(Context ctx, FilterInfo filter, SelectorItemCollection selector) throws RecException {
        return this.getRecordInfo(ctx, filter, selector, false);
    }

    protected ArcRecordInfo getRecordInfo(Context ctx, FilterInfo filter, SelectorItemCollection selector, boolean queryChildRelation) throws RecException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelector(ctx, selector));
        view.setFilter(filter);
        view.setBaseOnSelector(true);
        ArcRecordCollection cols = null;
        ArcRecordInfo arcRecordInfo = null;
        try {
            cols = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(view);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{filter + "\u83b7\u53d6\u5f52\u6863\u8bb0\u5f55\u5931\u8d25"});
        }
        if (null == cols || cols.size() == 0) {
            return null;
        }
        arcRecordInfo = cols.get(0);
        if (queryChildRelation) {
            FilterItemCollection filterItem = new FilterItemCollection();
            filterItem.add(new FilterItemInfo("arcRecord", (Object)arcRecordInfo.getId().toString()));
            SelectorItemCollection selectorItem = new SelectorItemCollection();
            selectorItem.add("id");
            selectorItem.add("state");
            selectorItem.add("attachBillAchDetails.id");
            selectorItem.add("attachBillAchDetails.state");
            selectorItem.add("attachBillAchDetails.achRecordDetail.id");
            try {
                AchRecordDetailCollection achRecordDetailCollection = ArchUtils.getAchRecordDetailCollectionLimit(ctx, selectorItem, filterItem, "where a.FArcRecordID = '" + arcRecordInfo.getId().toString() + "'  ");
                arcRecordInfo.put("achRecordDetails", (Object)achRecordDetailCollection);
            }
            catch (BOSException e) {
                throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6\u5f52\u6863\u8bb0\u5f55\u5931\u8d25"});
            }
        }
        return arcRecordInfo;
    }

    protected FilterInfo getFilter(Context ctx, String[] attrs, Object[] vals, String mask) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        for (int i = 0; i < attrs.length; ++i) {
            filterItems.add(new FilterItemInfo(attrs[i], vals[i]));
        }
        if (!StringUtils.isEmpty((String)mask)) {
            filter.setMaskString(mask);
        }
        return filter;
    }

    protected SelectorItemCollection getSelector(Context ctx, SelectorItemCollection selector) {
        if (null == selector || selector.size() == 0) {
            selector = new SelectorItemCollection();
            selector.addObjectCollection((IObjectCollection)this.getBasicSelector(ctx));
            selector.add("content.*");
            selector.add("content.billType.*");
            selector.add("content.org.longNumber");
            selector.add("org.*");
            selector.add("template.name");
            selector.add("template.number");
            selector.add("template.templateType");
            selector.add("mergeScheme.number");
            selector.add("mergeScope.*");
            selector.add("mergeUnitGroup.unit.name");
            selector.add("mergeUnitGroup.unit.number");
            selector.add("mergeUnitGroup.displayname");
            selector.add("currency.name");
            selector.add("currency.number");
            selector.remove(new SelectorItemInfo("achRecordDetails.id"));
        }
        return selector;
    }

    private SelectorItemCollection getBasicSelector(Context ctx) {
        SelectorItemCollection selector = new SelectorItemCollection();
        EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)"6B892DF6"));
        PropertyCollection props = bo.getInheritedPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo fld = props.get(i);
            String fieldName = null;
            if (fld instanceof OwnPropertyInfo) {
                fieldName = fld.getName();
            } else {
                PropertyCollection keyProps;
                EntityObjectInfo childObj;
                RelationshipInfo relation = ImplUtils.getRTRelation((EntityObjectInfo)bo, (LinkPropertyInfo)((LinkPropertyInfo)fld));
                if (relation.isReverseLink(bo)) continue;
                if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                    childObj = relation.getChildObject(bo);
                    if (childObj == null || (keyProps = childObj.getLogicalKeyPropertiesRuntime()) == null || keyProps.size() != 1) continue;
                    fieldName = fld.getName() + '.' + keyProps.get(0).getName();
                } else if (RelationshipType.COMPOSITION.equals((Object)relation.getType())) {
                    childObj = relation.getChildObject(bo);
                    if (childObj == null || (keyProps = childObj.getLogicalKeyPropertiesRuntime()) == null || keyProps.size() != 1) continue;
                    fieldName = fld.getName() + '.' + keyProps.get(0).getName();
                }
            }
            if (StringUtils.isEmpty((String)fieldName)) continue;
            selector.add(new SelectorItemInfo(fieldName));
        }
        return selector;
    }

    protected PeriodInfo getPeriodInfo(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        PeriodInfo periodInfo = null;
        try {
            periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(recordInfo.getPeriodNum() / 100, recordInfo.getPeriodNum() % 100, recordInfo.getOrg().getAccountPeriodType());
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u8f6c\u5316\u671f\u95f4\u53d1\u751f\u5f02\u5e38"});
        }
        return periodInfo;
    }

    protected ArcRecordInfo createBaseArcRecordInfo(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo recordBaseInfo, CompanyOrgUnitInfo org, PeriodInfo periodInfo) throws Exception {
        ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        arcRecordInfo.setCreator(userInfo);
        arcRecordInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        arcRecordInfo.setArcSchemeId(asInfo.getId().toString());
        arcRecordInfo.setContentType(asInfo.getRecType());
        if (null != periodInfo.getBeginDate()) {
            arcRecordInfo.setPeriodStartTime(new Timestamp(periodInfo.getBeginDate().getTime()));
        }
        if (null != periodInfo.getEndDate()) {
            arcRecordInfo.setPeriodEndTime(new Timestamp(periodInfo.getEndDate().getTime()));
        }
        arcRecordInfo.setContent(recordBaseInfo);
        arcRecordInfo.setPeriodNum(periodInfo.getNumber());
        String periodId = this.genPeriod(ctx, periodInfo.getNumber() + "");
        arcRecordInfo.setPeriodId(periodId);
        arcRecordInfo.setOrg(org);
        BOSUuid id = BOSUuid.create((BOSObjectType)arcRecordInfo.getBOSType());
        arcRecordInfo.setId(id);
        arcRecordInfo.setMergeScope(asInfo.getMergeScope());
        arcRecordInfo.setMergeScheme(asInfo.getMergeScheme());
        return arcRecordInfo;
    }

    private String genPeriod(Context ctx, String periodNumber) {
        String periodId = "";
        try {
            ArchPeriodInfo info = new ArchPeriodInfo();
            info = ArchPeriodFactory.getLocalInstance(ctx).getArchPeriodCollection("where number='" + periodNumber + "'").get(0);
            if (info != null) {
                periodId = info.getId().toString();
            } else {
                info = new ArchPeriodInfo();
                BOSUuid id = BOSUuid.create((String)"6DAD4F64");
                info.setId(id);
                info.setPeriodYear(Integer.parseInt(periodNumber.substring(0, 4)));
                info.setPeriod(Integer.parseInt(periodNumber.substring(4, 6)));
                info.setNumber(periodNumber);
                info.setName(periodNumber);
                ArchPeriodFactory.getLocalInstance(ctx).addnew(info);
                periodId = id.toString();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("periodNumber:" + periodNumber), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return periodId;
    }

    protected ArchSchemeInfo getArchemeInfo(Context ctx, String archSchemeID) throws EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)archSchemeID));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("currency.*");
        selectorItemCollection.add("currency.currency.*");
        selectorItemCollection.add("archemeContent.archContent.*");
        selectorItemCollection.add("archemeContent.archContent.org.*");
        selectorItemCollection.add("archemeContent.archContent.billType.*");
        selectorItemCollection.add("schemeOrg.*");
        selectorItemCollection.add("schemeOrg.org.*");
        selectorItemCollection.add("schemeOrg.org.baseCurrency.*");
        selectorItemCollection.add("template.template.*");
        selectorItemCollection.add("currency.currency.*");
        selectorItemCollection.add("mergeScope.*");
        selectorItemCollection.add("mergeScheme.*");
        entityViewInfo.setSelector(selectorItemCollection);
        ArchSchemeCollection asInfos = null;
        try {
            asInfos = ArchSchemeFactory.getLocalInstance(ctx).getArchSchemeCollection(entityViewInfo);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6\u5f52\u6863\u65b9\u6848\u5931\u8d25"});
        }
        if (null == asInfos || asInfos.size() == 0) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u65b9\u6848\u5df2\u7ecf\u4e0d\u5b58\u5728"});
        }
        return asInfos.get(0);
    }

    protected Map<String, RecordBaseInfo> getContents(Context ctx, ArcheSchemeContentEntryCollection contents, RecordBaseInfo content, CompanyOrgUnitInfo org) {
        Map<String, RecordBaseInfo> contentMap = FilingUtils.getContents(ctx, contents, content, org);
        return contentMap;
    }

    protected RecordBaseInfo getContent(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org) {
        RecordBaseInfo recordBaseInfo = FilingUtils.getContent(ctx, content, org);
        return recordBaseInfo;
    }

    protected abstract void setBatchData(Context var1, List<XmlBase> var2, ArcRecordInfo var3, JobInfo var4);

    @Override
    public void processJob(Context ctx, JobInfo jobInfo) throws Exception {
        ArchFormatInfo archFormatInfo = null;
        try {
            ArcRecordInfo arcRecordInfo = this.getRecordInfo(ctx, jobInfo.getRecord(), false);
            String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
            jobInfo.setState("running");
            jobInfo.setFilePath(NoticeArchSysHelperFactory.getInstance(ctx, arch_type).getDirectory(jobInfo.getContent().getXmlDocType()));
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state", "filePath"});
            this.updateRecordState(ctx, arcRecordInfo, ArcStateEnum.ARC_LOADING);
            archFormatInfo = this.getArchFormatInfo(ctx, arcRecordInfo, this.getPeriodInfo(ctx, arcRecordInfo), arcRecordInfo.getContent(), jobInfo);
            long t1 = System.currentTimeMillis();
            List<XmlBase> xmlBaseList = this.getXmlBaseList(ctx, arcRecordInfo, jobInfo);
            if (xmlBaseList.isEmpty()) {
                JobFactory.getLocalInstance(ctx).delete(H.PK(jobInfo.getId().toString()));
                return;
            }
            int xmlBaseSize = xmlBaseList.size();
            long t2 = System.currentTimeMillis();
            archFormatInfo.setXmlBases(xmlBaseList);
            archFormatInfo.setPreparDataTime(t2 - t1);
            CountDownLatch countDownLatch = null;
            if (xmlBaseSize > 1) {
                countDownLatch = new CountDownLatch(xmlBaseSize);
            }
            this.setBatchData(ctx, xmlBaseList, arcRecordInfo, jobInfo);
            for (int i = 0; i < xmlBaseSize; ++i) {
                Context newCtx = (Context)this.deeplyCopy((Serializable)ctx);
                newCtx.put((Object)"jobId", (Object)jobInfo.getId().toString());
                UploadArchInfosThreadPool.execute(newCtx, new HandleXmlBaseThread(countDownLatch, newCtx, archFormatInfo, xmlBaseList.get(i), i));
            }
            if (xmlBaseSize > 1) {
                Context newCtx = (Context)this.deeplyCopy((Serializable)ctx);
                UploadArchInfosThreadPool.execute(newCtx, new UploadxmlThread(countDownLatch, newCtx, archFormatInfo));
            }
        }
        catch (Throwable e) {
            this.handleJobException(ctx, archFormatInfo, jobInfo, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadXml(Context ctx, ArchFormatInfo archFormatInfo) {
        JobInfo jobInfo = archFormatInfo.getJobInfo();
        String jobId = jobInfo.getId().toString();
        try {
            long t1 = System.currentTimeMillis();
            boolean lastJobFlag = this.doUploadXml(ctx, archFormatInfo);
            long t2 = System.currentTimeMillis();
            archFormatInfo.setUploadXmlTime(t2 - t1);
            this.addTaskLog(ctx, archFormatInfo.getRecordInfo().getId().toString(), archFormatInfo.getContent().getId().toString(), archFormatInfo.getXmlBases().size(), archFormatInfo.getPreparDataTime(), archFormatInfo.getPreparePdfTime(), archFormatInfo.getUploadPdfTime(), archFormatInfo.getPrepareAttaTime(), archFormatInfo.getUploadAttaTime(), archFormatInfo.getUploadXmlTime());
            if (lastJobFlag) {
                this.handelNoticeSysArch(ctx, archFormatInfo, jobInfo);
            }
        }
        catch (Throwable e) {
            this.handleJobException(ctx, archFormatInfo, jobInfo, e);
        }
        finally {
            Map map = (Map)AbstractBatchDataProvider.batchData.getIfPresent((Object)jobId);
            map = null;
            AbstractBatchDataProvider.batchData.invalidate((Object)jobId);
            LockDataUtils.releaseLock(ctx, jobId);
        }
    }

    private void handelNoticeSysArch(Context ctx, ArchFormatInfo archFormatInfo, JobInfo jobInfo) throws Exception {
        String arch_type;
        boolean exists3TimeFailJob;
        boolean existsUorCJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + jobInfo.getRecord() + "' and state = '" + "uploaded" + "' or state = '" + "completed" + "'");
        if (existsUorCJob && !(exists3TimeFailJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + jobInfo.getRecord() + "' and state = '" + "fail" + "' and failNum <" + 3))) {
            this.noticeSysArch(ctx, archFormatInfo);
        }
        if (ArchConstant.ARCH_SYS_TYPE_GXHC.equals(arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE))) {
            boolean existsNJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + jobInfo.getRecord() + "' and fileFlag = '" + jobInfo.getFileFlag() + "' and state = '" + "noticed" + "'");
            if (!existsNJob) {
                this.processFinalStateTx(ctx, jobInfo.getRecord());
            } else {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(jobInfo.getRecord(), ArcStateEnum.ARC_LOADING, "\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210", null);
            }
        } else {
            if (existsUorCJob) {
                this.updateJob2Completed(ctx, jobInfo.getRecord(), jobInfo.getFileFlag());
            }
            this.processFinalStateTx(ctx, jobInfo.getRecord());
        }
    }

    protected void updateJob2Completed(Context ctx, String recordID, String fileFlag) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_REC_Job set FLastUpdateTime = now(), Fstate = ? where FRecordID = ? and FileFlag = ? and FState = ?", (Object[])new Object[]{"completed", recordID, fileFlag, "uploaded"});
    }

    private void handleJobException(Context ctx, ArchFormatInfo archFormatInfo, JobInfo jobInfo, Throwable e) {
        try {
            this.removeFaileJob(ctx, jobInfo, archFormatInfo);
            jobInfo.setState("fail");
            jobInfo.setFailNum(jobInfo.getFailNum() + 1);
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"failNum", "state"});
            LockDataUtils.releaseLock(ctx, jobInfo.getId().toString());
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(jobInfo.getRecord(), ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
            boolean existsWJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + jobInfo.getRecord() + "' and fileFlag = '" + jobInfo.getFileFlag() + "' and (state = '" + "wating" + "' or state = '" + "running" + "')");
            if (!existsWJob) {
                this.handelNoticeSysArch(ctx, archFormatInfo, jobInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("com.kingdee.eas.el.rec.filing.error.handleJobException:recordId," + jobInfo.getRecord() + ",jobId:" + jobInfo.getId()), (Throwable)ex);
        }
    }

    private void removeFaileJob(Context ctx, JobInfo jobInfo, ArchFormatInfo archFormatInfo) throws BOSException, EASBizException {
        if (archFormatInfo == null || archFormatInfo.getAttachFailXmlBases() == null) {
            return;
        }
        for (int i = 0; i < jobInfo.getEntry().size(); ++i) {
            JobEntryInfo jobEntryInfo = jobInfo.getEntry().get(i);
            for (int j = 0; j < archFormatInfo.getAttachFailXmlBases().size(); ++j) {
                XmlBase xmlBase = archFormatInfo.getAttachFailXmlBases().get(j);
                if (!jobEntryInfo.getRecordDetail().equals(xmlBase.getId())) continue;
                jobInfo.getEntry().removeObject(i--);
                JobEntryFactory.getLocalInstance(ctx).delete(H.PK(jobEntryInfo.getId()));
            }
        }
    }

    protected abstract boolean doUploadXml(Context var1, ArchFormatInfo var2) throws Exception;

    protected InputStream generateXml(Context ctx, RecordBaseInfo content, List<XmlBase> xmlBaseList) throws Exception {
        Document document = ParsingEngineUtil.getInstance(ctx, content).getXMLFromInfoByConfig(xmlBaseList, content);
        return null == document ? null : new ByteArrayInputStream(document.asXML().getBytes());
    }

    protected abstract void handleArchXmlbaseException(Context var1, ArchFormatInfo var2, XmlBase var3, Throwable var4);

    protected abstract void processXmlBase(Context var1, ArchFormatInfo var2, XmlBase var3, int var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileUpLoad(Context ctx, ArchFormatInfo archFormatInfo, InputStream is, String fileName) throws Exception {
        if (null != is) {
            String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
            NoticeArchSysHelper noticeArchSysHelper = NoticeArchSysHelperFactory.getInstance(ctx, arch_type);
            String businessType = noticeArchSysHelper.getbusinessType(ctx, archFormatInfo.getContent(), archFormatInfo.getContent().getXmlDocType());
            if (!StringUtils.isEmpty((String)businessType) && !StringUtils.isEmpty((String)fileName) && fileName.endsWith(".xml")) {
                if ("2".equals(businessType)) {
                    businessType = "1";
                } else if ("4".equals(businessType)) {
                    businessType = "3";
                }
            }
            archFormatInfo.setXmlName(fileName.endsWith(".xml") ? fileName : "");
            String tempFilePath = (String)ctx.get((Object)"tempFile");
            if (("null".equals(tempFilePath) || StringUtils.isEmpty((String)tempFilePath)) && is.available() > Integer.parseInt(ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TEMPFILE_LENGTH))) {
                is = FilingUtils.createTempFile(ctx, is, fileName);
            }
            try {
                noticeArchSysHelper.fileUpLoad(ctx, archFormatInfo, archFormatInfo.getPeriodInfo(), is, archFormatInfo.getJobInfo().getFileFlag(), businessType, fileName, archFormatInfo.getRecordInfo().getOrg());
            }
            finally {
                FilingUtils.deleteTempFile(ctx);
            }
        }
    }

    protected abstract List<XmlBase> getXmlBaseList(Context var1, ArcRecordInfo var2, JobInfo var3) throws Exception;

    private void addTaskLog(Context ctx, String recordId, String recordbaseId, int num, AtomicLong ... times) throws BOSException, EASBizException {
        TaskLogInfo taskLog = new TaskLogInfo();
        taskLog.setRecord(recordId);
        taskLog.setContent(recordbaseId);
        taskLog.setCreateTime(new Timestamp(System.currentTimeMillis()));
        taskLog.setThreadNum(UploadArchInfosThreadPool.getExecutor().getCorePoolSize() + "," + UploadArchInfosThreadPool.getExecutor().getMaximumPoolSize());
        taskLog.setNum(num);
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        taskLog.setServerNum(easInstanceHome.substring(easInstanceHome.lastIndexOf("/") + 1, easInstanceHome.length()));
        taskLog.setTime1(times[0].get());
        taskLog.setTime2(times[1].get());
        taskLog.setTime3(times[2].get());
        taskLog.setTime4(times[3].get());
        taskLog.setTime5(times[4].get());
        taskLog.setTime6(times[5].get());
        RecLogUtils.executeLogRecord(ctx, taskLog);
    }

    @Override
    public void processFinalStateTx(Context ctx, String recordId) throws Exception {
        ArcRecordFactory.getLocalInstance(ctx).processFinalStateTx(this, recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFinalState(Context ctx, String recordId) throws Exception {
        boolean existsHandleJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordId + "' and (state = '" + "wating" + "' or state = '" + "running" + "' or state = '" + "uploaded" + "' or state = '" + "noticed" + "')");
        if (existsHandleJob) {
            return;
        }
        boolean successLocked = LockDataUtils.getLock(ctx, recordId, "rec_arch");
        if (!successLocked) {
            return;
        }
        try {
            int i;
            ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, true);
            recordInfo.setTotalNum(0);
            recordInfo.setFailNum(0);
            recordInfo.setAttachFailNum(0);
            AchRecordDetailCollection achRecordDetails = recordInfo.getAchRecordDetails();
            AttachBillAchDetailCollection attachBillAchDetailCollection = new AttachBillAchDetailCollection();
            for (int i2 = 0; i2 < achRecordDetails.size(); ++i2) {
                AchRecordDetailInfo recordDetailInfo = achRecordDetails.get(i2);
                attachBillAchDetailCollection.addCollection(recordDetailInfo.getAttachBillAchDetails());
                recordDetailInfo.remove("attachBillAchDetails");
            }
            JobCollection jobCollection = this.getJobs(ctx, recordId, ArchFlagEnum.ADDNEW, TaskStateEnum.COMPLETED);
            int size = jobCollection.size();
            for (i = 0; i < size; ++i) {
                this.updateDetailState(ctx, jobCollection.get(i), ArcStateEnum.ARC_SUCCESS, achRecordDetails, attachBillAchDetailCollection);
                this.addArclog(ctx, jobCollection.get(i), ArcStateEnum.ARC_SUCCESS, achRecordDetails, attachBillAchDetailCollection, "\u5f52\u6863\u6210\u529f");
            }
            jobCollection = this.getJobs(ctx, recordId, ArchFlagEnum.ADDNEW, TaskStateEnum.FAIL);
            for (i = 0; i < jobCollection.size(); ++i) {
                this.updateDetailState(ctx, jobCollection.get(i), ArcStateEnum.ARC_FAIL, achRecordDetails, attachBillAchDetailCollection);
                this.updateFailNum(jobCollection.get(i), recordInfo);
            }
            jobCollection = this.getJobs(ctx, recordId, ArchFlagEnum.UPDATE, TaskStateEnum.COMPLETED);
            for (i = 0; i < jobCollection.size(); ++i) {
                this.updateDetailState(ctx, jobCollection.get(i), ArcStateEnum.ARC_SUCCESS, achRecordDetails, attachBillAchDetailCollection);
                this.addArclog(ctx, jobCollection.get(i), ArcStateEnum.ARC_SUCCESS, achRecordDetails, attachBillAchDetailCollection, "\u66f4\u65b0\u6210\u529f");
            }
            jobCollection = this.getJobs(ctx, recordId, ArchFlagEnum.UPDATE, TaskStateEnum.FAIL);
            for (i = 0; i < jobCollection.size(); ++i) {
                this.updateFailNum(jobCollection.get(i), recordInfo);
            }
            jobCollection = this.getJobs(ctx, recordId, ArchFlagEnum.DELETE, TaskStateEnum.COMPLETED);
            for (i = 0; i < jobCollection.size(); ++i) {
                JobInfo jobInfo = jobCollection.get(i);
                this.dumpDeleteBillRecord(ctx, jobInfo);
                if (jobInfo.getContent().isIsRefBill()) {
                    recordInfo.setOriginVcNum(recordInfo.getOriginVcNum() - jobInfo.getEntry().size());
                    continue;
                }
                recordInfo.setVoucherNum(recordInfo.getVoucherNum() - jobInfo.getEntry().size());
            }
            jobCollection = this.getJobs(ctx, recordId, ArchFlagEnum.DELETE, TaskStateEnum.FAIL);
            for (i = 0; i < jobCollection.size(); ++i) {
                this.updateFailNum(jobCollection.get(i), recordInfo);
            }
            this.updateMainBillS(ctx, recordId);
            int failTimes = 0;
            if (recordInfo.getFailNum() + recordInfo.getAttachFailNum() == 0) {
                recordInfo.setState(ArcStateEnum.ARC_SUCCESS);
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordId, ArcStateEnum.ARC_SUCCESS, "\u5f52\u6863\u6210\u529f", null);
            } else {
                StringBuilder message = new StringBuilder("\u5f52\u6863\u5931\u8d25");
                JobCollection failJobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("where record = '" + recordId + "' and state = '" + "fail" + "'");
                recordInfo.setState(ArcStateEnum.ARC_FAIL);
                failTimes = failJobCollection.get(0).getFailNum();
                if (failTimes < 3) {
                    recordInfo.setTotalNum(recordInfo.getFailNum() + recordInfo.getAttachFailNum());
                }
                message.append(failTimes + "\u6b21");
                message.append("\uff0c\u4e3b\u5355\u5931\u8d25\uff1a" + recordInfo.getFailNum() + "\u6761\uff0c\u9644\u5c5e\u5355\u636e\u5931\u8d25\uff1a" + recordInfo.getAttachFailNum() + "\u6761\uff0c\u8bf7\u5728\u660e\u7ec6\u4e2d\u67e5\u770b\u65e5\u5fd7");
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordId, ArcStateEnum.ARC_FAIL, message.toString(), null);
            }
            SelectorItemCollection selectorItem = new SelectorItemCollection();
            selectorItem.add(new SelectorItemInfo("totalNum"));
            selectorItem.add(new SelectorItemInfo("failNum"));
            selectorItem.add(new SelectorItemInfo("attachFailNum"));
            selectorItem.add(new SelectorItemInfo("originVcNum"));
            selectorItem.add(new SelectorItemInfo("voucherNum"));
            selectorItem.add(new SelectorItemInfo("state"));
            this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
            if (ArcStateEnum.ARC_SUCCESS.equals((Object)recordInfo.getState()) || failTimes >= 3) {
                JobFactory.getLocalInstance(ctx).delete("where record = '" + recordId + "' and state = '" + "completed" + "'");
                String latestHisPeriod = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_DATADUMP_PERIOD);
                if (!StringUtils.isEmpty((String)latestHisPeriod) && recordInfo.getPeriodNum() <= Integer.valueOf(latestHisPeriod)) {
                    ArcRecordCollection arcRecordCollection = new ArcRecordCollection();
                    arcRecordCollection.add(recordInfo);
                    FilingUtils.dumpRecords(ctx, recordInfo.getPeriodNum() + "", arcRecordCollection);
                }
            }
            if (ArcStateEnum.ARC_FAIL.equals((Object)recordInfo.getState()) && failTimes < 3) {
                this.updateFailJobWating(ctx, recordId);
                this.startHandleJob(ctx, null);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("com.kingdee.eas.el.rec.filing.error.processFinalState:" + recordId + " \u5904\u7406\u5931\u8d25"), e);
            ArcRecordFactory.getLocalInstance(ctx).processFinalStateError(recordId, e);
        }
        finally {
            logger.error((Object)("com.kingdee.eas.el.rec.filing.info.processFinalState:" + recordId));
            LockDataUtils.releaseLock(ctx, recordId);
        }
    }

    protected void updateFailJobWating(Context ctx, String recordId) throws BOSException {
        String updateSql = "UPDATE T_REC_Job SET Fstate = ?, FLastUpdateTime = now() WHERE FRecordID = ? and Fstate = ? and FailNum < ?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{"wating", recordId, "fail", 3});
    }

    private void updateMainBillS(Context ctx, String recordId) throws BOSException, EASBizException {
        String updateSql = "UPDATE T_REC_AchRecordDetail SET FOriginBillState = 2  WHERE FArcRecordID = '" + recordId + "' and FOriginBillState = 3";
        DbUtil.execute((Context)ctx, (String)updateSql);
        SelectorItemCollection selectorItem = new SelectorItemCollection();
        selectorItem.add("attachBillAchDetails.state");
        FilterItemCollection filterItem = new FilterItemCollection();
        filterItem.add(new FilterItemInfo("arcRecord", (Object)recordId));
        filterItem.add(new FilterItemInfo("originBillState", (Object)0));
        AchRecordDetailCollection achRecordDetailCollection = ArchUtils.getAchRecordDetailCollectionLimit(ctx, selectorItem, filterItem, "where a.FArcRecordID = '" + recordId + "'  and a.foriginBillState = 0 ");
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        ArcStateEnum orginaState = ArcStateEnum.ARC_SUCCESS;
        block0: for (int i = 0; i < achRecordDetailCollection.size(); ++i) {
            AchRecordDetailInfo achRecordDetailInfo = achRecordDetailCollection.get(i);
            AttachBillAchDetailCollection attachBillAchDetails = achRecordDetailInfo.getAttachBillAchDetails();
            orginaState = ArcStateEnum.ARC_SUCCESS;
            if (attachBillAchDetails.isEmpty()) {
                orginaState = ArcStateEnum.ARC_NODATA;
            } else {
                for (int j = 0; j < attachBillAchDetails.size(); ++j) {
                    if (ArcStateEnum.ARC_FAIL.equals((Object)attachBillAchDetails.get(j).getState())) continue block0;
                }
            }
            param.add(new Object[]{orginaState.getValue(), achRecordDetailInfo.getId().toString()});
        }
        if (!param.isEmpty()) {
            String sql = "update T_REC_AchRecordDetail set FOriginBillState = ?,FLastUpdateTime = now() where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, param);
        }
    }

    private void updateDetailState(Context ctx, JobInfo jobInfo, ArcStateEnum arcStateEnum, AchRecordDetailCollection achRecordDetailCollection, AttachBillAchDetailCollection attachBillAchDetailCollection) throws BOSException, EASBizException {
        boolean isRefBill = jobInfo.getContent().isIsRefBill();
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        ArrayList<Object[]> param1 = new ArrayList<Object[]>();
        ArrayList<Object[]> param2 = new ArrayList<Object[]>();
        int size = jobInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            JobEntryInfo jobEntryInfo = jobInfo.getEntry().get(i);
            BOSUuid id = BOSUuid.read((String)jobEntryInfo.getRecordDetail());
            Map<String, Object> state = this.getAchRecordDetailState(achRecordDetailCollection, attachBillAchDetailCollection, arcStateEnum, id, isRefBill);
            ArcStateEnum stateEnum = (ArcStateEnum)((Object)state.get("arcState"));
            if (stateEnum.equals((Object)arcStateEnum)) continue;
            if (isRefBill) {
                param1.add(new Object[]{arcStateEnum.getValue(), jobEntryInfo.getRecordDetail()});
                if (!ArcStateEnum.ARC_FAIL.equals((Object)arcStateEnum) || !state.containsKey("recordDetailId")) continue;
                param2.add(new Object[]{ArcStateEnum.ARC_FAIL.getValue(), ((BOSUuid)state.get("recordDetailId")).toString()});
                continue;
            }
            param.add(new Object[]{arcStateEnum.getValue(), jobEntryInfo.getRecordDetail()});
        }
        if (!param.isEmpty()) {
            String sql = "update T_REC_AchRecordDetail set FState = ?,FLastUpdateTime = now() where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, param);
        }
        if (!param1.isEmpty()) {
            String sql = "update T_REC_AttachBillAchDetail set FState = ?,FLastUpdateTime = now() where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, param1);
        }
        if (!param2.isEmpty()) {
            String sql = "update T_REC_AchRecordDetail set FOriginBillState = ?,FLastUpdateTime = now() where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, param2);
        }
    }

    private Map<String, Object> getAchRecordDetailState(AchRecordDetailCollection achRecordDetailCollection, AttachBillAchDetailCollection attachBillAchDetailCollection, ArcStateEnum arcStateEnum, BOSUuid id, boolean isRefBill) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("arcState", (Object)ArcStateEnum.ARC_FAIL);
        if (isRefBill) {
            IObjectValue object = attachBillAchDetailCollection.getObject(id);
            if (object != null) {
                AttachBillAchDetailInfo info = (AttachBillAchDetailInfo)object;
                ArcStateEnum state = info.getState();
                result.put("arcState", (Object)state);
                result.put("recordDetailId", info.getAchRecordDetail().getId());
                info.setState(arcStateEnum);
            }
        } else {
            IObjectValue object = achRecordDetailCollection.getObject(id);
            if (object != null) {
                AchRecordDetailInfo info = (AchRecordDetailInfo)object;
                ArcStateEnum state = info.getState();
                result.put("arcState", (Object)state);
                result.put("recordDetailId", info.getId());
                info.setState(arcStateEnum);
            }
        }
        return result;
    }

    private void addArclog(Context ctx, JobInfo jobInfo, ArcStateEnum arcStateEnum, AchRecordDetailCollection achRecordDetailCollection, AttachBillAchDetailCollection attachBillAchDetailCollection, String msg) throws BOSException, EASBizException {
        boolean isRefBill = jobInfo.getContent().isIsRefBill();
        CoreBaseCollection arcLogInfoColls = new CoreBaseCollection();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < jobInfo.getEntry().size(); ++i) {
            JobEntryInfo jobEntryInfo = jobInfo.getEntry().get(i);
            Map<String, Object> state = this.getAchRecordDetailState(achRecordDetailCollection, attachBillAchDetailCollection, arcStateEnum, BOSUuid.read((String)jobEntryInfo.getRecordDetail()), isRefBill);
            ArcStateEnum stateEnum = (ArcStateEnum)((Object)state.get("arcState"));
            if (stateEnum.equals((Object)arcStateEnum)) continue;
            ids.add(jobEntryInfo.getRecordDetail());
        }
        if (ids.isEmpty()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        selectorItemCollection.add("billNumber");
        selectorItemCollection.add("billId");
        selectorItemCollection.add("lastUpdateUser");
        selectorItemCollection.add("creator");
        view.setSelector(selectorItemCollection);
        view.setBaseOnSelector(true);
        CoreBaseCollection collection = null;
        collection = isRefBill ? AttachBillAchDetailFactory.getLocalInstance(ctx).getCollection(view) : AchRecordDetailFactory.getLocalInstance(ctx).getCollection(view);
        ArcLogInfo arcLogInfo = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (int i = 0; i < collection.size(); ++i) {
            CoreBaseInfo coreBaseInfo = collection.get(i);
            arcLogInfo = new ArcLogInfo();
            arcLogInfo.setResult(arcStateEnum);
            arcLogInfo.setMessage(msg);
            arcLogInfo.setBillId((String)coreBaseInfo.get("billId"));
            arcLogInfo.setBillNumber((String)coreBaseInfo.get("billNumber"));
            arcLogInfo.setBillRefid(((BOSUuid)coreBaseInfo.get("id")).toString());
            arcLogInfo.setLastUpdateUser((UserInfo)coreBaseInfo.get("lastUpdateUser"));
            arcLogInfo.setCreator((UserInfo)coreBaseInfo.get("creator"));
            arcLogInfo.setCreateTime(timestamp);
            arcLogInfo.setLastUpdateTime(timestamp);
            arcLogInfoColls.add((CoreBaseInfo)arcLogInfo);
        }
        if (arcLogInfoColls.size() > 0) {
            RecLogUtils.executeLogRecord(ctx, arcLogInfoColls);
        }
    }

    private void dumpDeleteBillRecord(Context ctx, JobInfo jobInfo) throws BOSException, EASBizException {
        boolean isRefBill = jobInfo.getContent().isIsRefBill();
        for (int i = 0; i < jobInfo.getEntry().size(); ++i) {
            JobEntryInfo jobEntryInfo = jobInfo.getEntry().get(i);
            if (!isRefBill) {
                DbUtil.execute((Context)ctx, (String)DUMP_ARCRECORDDETAIL_SQL, (Object[])new Object[]{jobEntryInfo.getRecordDetail()});
                DbUtil.execute((Context)ctx, (String)DELETE_ARCRECORDDETAIL_SQL, (Object[])new Object[]{jobEntryInfo.getRecordDetail()});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)DUMP_ATTACHBILLACHDETAIL_SQL, (Object[])new Object[]{jobEntryInfo.getRecordDetail()});
            DbUtil.execute((Context)ctx, (String)DELETE_ATTACHBILLACHDETAIL_SQL, (Object[])new Object[]{jobEntryInfo.getRecordDetail()});
        }
    }

    private void updateFailNum(JobInfo jobInfo, ArcRecordInfo recordInfo) {
        boolean isRefBill = jobInfo.getContent().isIsRefBill();
        if (isRefBill) {
            recordInfo.setAttachFailNum(recordInfo.getAttachFailNum() + jobInfo.getEntry().size());
        } else {
            recordInfo.setFailNum(recordInfo.getFailNum() + jobInfo.getEntry().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobCollection getJobs(Context ctx, String recordId, ArchFlagEnum archFlagEnum, TaskStateEnum taskStateEnum) throws BOSException {
        JobCollection jobs;
        block17: {
            String sql = "select count(a.fid) count from T_REC_JOB a left join T_REC_JOBENTRY b on a.fid = b.FPARENTID where a.FRecordID = '" + recordId + "' and a.FTaskType = '" + archFlagEnum.getValue() + "' and a.FState = '" + taskStateEnum.getValue() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            int count = 0;
            int criticalCollection = 100000;
            try {
                if (rowSet.next()) {
                    count = rowSet.getInt("count");
                    logger.error((Object)("count:" + count));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u6570\u91cf\u62a5\u9519", (Throwable)e);
            }
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            if (manager != null) {
                criticalCollection = manager.getCriticalCollection();
            }
            if (count < criticalCollection) {
                return JobFactory.getLocalInstance(ctx).getJobCollection("select * , content.isRefBill, entry.* where record = '" + recordId + "' and taskType = '" + archFlagEnum.getValue() + "' and state = '" + taskStateEnum.getValue() + "'");
            }
            jobs = new JobCollection();
            IJob iJob = JobFactory.getLocalInstance(ctx);
            String sql1 = "select a.Fid id from T_REC_Job a left join T_REC_JOBENTRY b on a.fid = b.FPARENTID where a.FRecordID = '" + recordId + "' and a.FTaskType = '" + archFlagEnum.getValue() + "' and a.FState = '" + taskStateEnum.getValue() + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1);
                int idSize = criticalCollection / 100;
                HashSet<String> jobIds = new HashSet<String>(idSize);
                String idTmpTable = "";
                while (rs.next()) {
                    String id = rs.getString("id");
                    jobIds.add(id);
                    if (jobIds.size() != idSize) continue;
                    try {
                        idTmpTable = ArchUtils.createIdTmpTable(ctx, jobIds);
                        jobs.addCollection(iJob.getJobCollection("select * , content.isRefBill, entry.* where id in (select fid from " + idTmpTable + ")"));
                    }
                    finally {
                        if (!StringUtils.isEmpty((String)idTmpTable)) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(idTmpTable);
                        }
                    }
                    jobIds.clear();
                }
                if (jobIds.isEmpty()) break block17;
                try {
                    idTmpTable = ArchUtils.createIdTmpTable(ctx, jobIds);
                    jobs.addCollection(iJob.getJobCollection("select * , content.isRefBill, entry.* where id in (select fid from " + idTmpTable + ")"));
                }
                finally {
                    if (!StringUtils.isEmpty((String)idTmpTable)) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(idTmpTable);
                    }
                }
                jobIds.clear();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)("jobs:" + jobs.size()));
        return jobs;
    }

    private void startHandleJob(Context ctx, ArcRecordInfo recordInfo) throws BOSException, EASBizException {
        logger.error((Object)("com.kingdee.eas.el.rec.filing.error.startHandleJob,ctx.hashCode:" + ctx.hashCode() + ",ctx info:" + ctx.toString()));
        JobFactory.getLocalInstance(ctx).executeJob();
    }

    @Override
    public void archFailed(Context ctx, String recordId) throws Exception {
        ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, null, false);
        if (!ArcStateEnum.ARC_FAIL.equals((Object)recordInfo.getState())) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u53ea\u6709\u5f52\u6863\u5931\u8d25\u624d\u80fd\u5931\u8d25\u518d\u5f52\u6863"});
        }
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
        this.arch(ctx, recordInfo, periodInfo);
    }

    class HandleXmlBaseThread
    implements Runnable {
        private CountDownLatch countDownLatch;
        private Context ctx;
        private ArchFormatInfo archFormatInfo;
        private XmlBase xmlBase;
        private int index;

        public HandleXmlBaseThread(CountDownLatch countDownLatch, Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase, int index) {
            this.countDownLatch = countDownLatch;
            this.ctx = ctx;
            this.archFormatInfo = archFormatInfo;
            this.xmlBase = xmlBase;
            this.index = index;
        }

        @Override
        public void run() {
            try {
                try {
                    Context newCtx = (Context)AbstractFilingStrategy.this.deeplyCopy((Serializable)this.ctx);
                    WebContextUtil.initRpcConfig((Context)newCtx);
                    AbstractFilingStrategy.this.processXmlBase(this.ctx, this.archFormatInfo, this.xmlBase, this.index);
                }
                catch (Throwable e) {
                    logger.error((Object)("com.kingdee.eas.el.rec.filing.error.processXmlBase:recordId," + this.archFormatInfo.getRecordInfo().getId() + ",jobId:" + this.archFormatInfo.getJobInfo().getId() + ",content:" + this.archFormatInfo.getJobInfo().getContent().getName() + ",billId:" + this.xmlBase.getDataId()), e);
                    AbstractFilingStrategy.this.handleArchXmlbaseException(this.ctx, this.archFormatInfo, this.xmlBase, e);
                }
                if (null == this.countDownLatch) {
                    AbstractFilingStrategy.this.uploadXml(this.ctx, this.archFormatInfo);
                }
            }
            finally {
                if (null != this.countDownLatch) {
                    try {
                        this.countDownLatch.countDown();
                    }
                    catch (Exception e) {
                        logger.error((Object)("com.kingdee.eas.el.rec.filing.error.countDownLatch.countDown:recordId," + this.archFormatInfo.getRecordInfo().getId() + ",jobId:" + this.archFormatInfo.getJobInfo().getId()), (Throwable)e);
                        AbstractFilingStrategy.this.handleArchXmlbaseException(this.ctx, this.archFormatInfo, this.xmlBase, e);
                    }
                }
            }
        }
    }

    class UploadxmlThread
    implements Runnable {
        private CountDownLatch countDownLatch;
        private Context ctx;
        private ArchFormatInfo archFormatInfo;

        public UploadxmlThread(CountDownLatch countDownLatch, Context ctx, ArchFormatInfo archFormatInfo) {
            this.countDownLatch = countDownLatch;
            this.ctx = ctx;
            this.archFormatInfo = archFormatInfo;
        }

        @Override
        public void run() {
            WebContextUtil.initRpcConfig((Context)this.ctx);
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                AbstractFilingStrategy.this.handleJobException(this.ctx, this.archFormatInfo, this.archFormatInfo.getJobInfo(), e);
                return;
            }
            AbstractFilingStrategy.this.uploadXml(this.ctx, this.archFormatInfo);
        }
    }
}

