/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.filing.instance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.AchRecordDetailHisFactory;
import com.kingdee.eas.el.rec.AchRecordDetailInfo;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.ArchSchemeScopeOrgEntryCollection;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryCollection;
import com.kingdee.eas.el.rec.CurrencyEntryCollection;
import com.kingdee.eas.el.rec.CurrencyEntryInfo;
import com.kingdee.eas.el.rec.FilingInstanceFacadeFactory;
import com.kingdee.eas.el.rec.JobCollection;
import com.kingdee.eas.el.rec.JobFactory;
import com.kingdee.eas.el.rec.JobInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.filing.instance.AbstractFilingStrategy;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfos;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.RecordInfo;
import com.kingdee.eas.el.rec.model.ReportArchInfo;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.ThreadUtil;
import com.kingdee.eas.el.rec.thread.UploadArchInfosThreadPool;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.DateUtil;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.RECUtil;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FilingReport
extends AbstractFilingStrategy {
    private static Logger logger = Logger.getLogger(AbstractFilingStrategy.class);

    @Override
    protected void checkScheme(Context ctx, ArchSchemeInfo asInfo) throws EASBizException {
        ArchSchemeScopeOrgEntryCollection orgs = asInfo.getSchemeOrg();
        if (null == orgs || orgs.size() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"\u5f52\u6863\u7ec4\u7ec7\u8303\u56f4"});
        }
    }

    @Override
    public void arch(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        try {
            String oldArcRecordNum = recordInfo.getArcRecordNum().replace("_" + recordInfo.getReportCycleType().getValue() + "_", "_");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("arcRecordNum", (Object)recordInfo.getArcRecordNum(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("arcRecordNum", (Object)oldArcRecordNum, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("reportCycleType", (Object)recordInfo.getReportCycleType().getValue(), CompareType.EQUALS));
            filter.setMaskString("#0 OR (#1 AND #2)");
            boolean exists = ArcRecordFactory.getLocalInstance(ctx).exists(filter);
            if (exists) {
                String newSchemeId = recordInfo.getArcSchemeId();
                recordInfo = this.getRecordInfo(ctx, filter, null);
                if (ArcStateEnum.ARC_SUCCESS.equals((Object)recordInfo.getState()) && !this.isCurrentPeriod(ctx, recordInfo, periodInfo)) {
                    return;
                }
                this.updateSchemeId(ctx, newSchemeId, recordInfo);
                this.doArch(ctx, recordInfo, periodInfo);
            } else {
                recordInfo.setState(ArcStateEnum.WAITING);
                this.saveArchRecordInfo(ctx, recordInfo);
                recordInfo = this.getRecordInfo(ctx, recordInfo.getId().toString());
                this.doArch(ctx, recordInfo, periodInfo);
            }
        }
        catch (Exception e) {
            this.handleArchException(ctx, recordInfo, e);
            logger.error((Object)("[" + recordInfo.getArcRecordNum() + "]\u6267\u884c\u5f52\u6863\u5f02\u5e38"), (Throwable)e);
        }
    }

    @Override
    protected void doExecute(Context ctx, ArchSchemeInfo asInfo, ArcheSchemeContentEntryCollection contents, ArchSchemeScopeOrgEntryCollection orgs) throws Exception {
        CompanyOrgUnitCollection companyOrgs;
        try {
            companyOrgs = FilingUtils.getCompanyOrgs(ctx, orgs, true, asInfo.getLastUpdateUser().getId() + "", "el_rec_ArchSchemeList_addNew");
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u65b9\u6848[" + asInfo.getNumber() + "]\u83b7\u53d6\u5f52\u6863\u7ec4\u7ec7\u5f02\u5e38"});
        }
        for (int i = 0; i < companyOrgs.size(); ++i) {
            for (int k = 0; k < contents.size(); ++k) {
                PeriodCollection periods;
                CompanyOrgUnitInfo org = companyOrgs.get(i);
                RecordBaseInfo archContent = contents.get(k).getArchContent();
                try {
                    periods = this.getPeriodsForReport(ctx, asInfo, archContent, org);
                }
                catch (Exception e) {
                    throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u65b9\u6848[" + asInfo.getNumber() + "]\u83b7\u53d6\u5f52\u6863\u671f\u95f4\u5f02\u5e38"});
                }
                for (int j = 0; j < periods.size(); ++j) {
                    CurrencyEntryCollection currencys = this.getCurrencyEntry(ctx, asInfo, archContent, org);
                    for (int l = 0; l < currencys.size(); ++l) {
                        PeriodInfo periodInfo;
                        ArcRecordInfo baseArcRecordInfo;
                        if (ArcContentTypeEnum.OtherReport.equals((Object)asInfo.getRecType())) {
                            archContent.setExportFileType(asInfo.getExportFileType());
                        }
                        if (null == (baseArcRecordInfo = this.createBaseArcRecordInfo(ctx, asInfo, archContent, org, periodInfo = periods.get(j)))) continue;
                        baseArcRecordInfo.setFailNum(0);
                        CurrencyInfo currency = currencys.get(l).getCurrency();
                        baseArcRecordInfo.setCurrency(currency);
                        String reportArcRecordNum = FilingUtils.getReportArcRecordNum(ctx, archContent, org.getNumber(), periodInfo.getNumber() + "", currency.getIsoCode(), baseArcRecordInfo.getReportCycleType().getValue());
                        baseArcRecordInfo.setArcRecordNum(reportArcRecordNum);
                        FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(baseArcRecordInfo).arch(ctx, baseArcRecordInfo, periodInfo);
                    }
                }
            }
        }
    }

    @Override
    protected ArcRecordInfo createBaseArcRecordInfo(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo recordBaseInfo, CompanyOrgUnitInfo org, PeriodInfo periodInfo) throws Exception {
        if (ArcContentTypeEnum.REPORT.equals((Object)asInfo.getRecType())) {
            PeriodCollection perCol = PeriodUtil.transformToPeriods(ctx, periodInfo, asInfo.getReportCycleType(), org);
            if (perCol.isEmpty()) {
                return null;
            }
            periodInfo.setBeginDate(perCol.get(0).getBeginDate());
            periodInfo.setEndDate(perCol.get(perCol.size() - 1).getEndDate());
        }
        ArcRecordInfo baseArcRecordInfo = super.createBaseArcRecordInfo(ctx, asInfo, recordBaseInfo, org, periodInfo);
        baseArcRecordInfo.setReportCycleType(asInfo.getReportCycleType());
        return baseArcRecordInfo;
    }

    @Override
    protected PeriodInfo getPeriodInfo(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        PeriodInfo periodInfo = super.getPeriodInfo(ctx, recordInfo);
        if (ArcContentTypeEnum.REPORT.equals((Object)recordInfo.getContentType())) {
            PeriodCollection perCol = PeriodUtil.transformToPeriods(ctx, periodInfo, recordInfo.getReportCycleType(), recordInfo.getOrg());
            periodInfo.setBeginDate(perCol.get(0).getBeginDate());
            periodInfo.setEndDate(perCol.get(perCol.size() - 1).getEndDate());
        }
        return periodInfo;
    }

    protected PeriodCollection getPeriodsForReport(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo archContent, CompanyOrgUnitInfo companyOrgUnitInfo) throws RecException {
        try {
            return PeriodUtil.getPeriodsForReport(ctx, asInfo, archContent, companyOrgUnitInfo);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{asInfo.getNumber() + "\u83b7\u53d6\u5f52\u6863\u671f\u95f4\u5f02\u5e38"});
        }
    }

    private CurrencyEntryCollection getCurrencyEntry(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo archContent, CompanyOrgUnitInfo companyOrgUnitInfo) throws BOSException, EASBizException {
        CurrencyEntryCollection currencys = asInfo.getCurrency();
        if (currencys.size() == 0) {
            CurrencyEntryCollection result = new CurrencyEntryCollection();
            String number = archContent.getBillType().getNumber();
            if ("GeneralLedger".equals(number) || "Subledger".equals(number) || "AuxiliarySubledger".equals(number) || "AuxiliaryGL".equals(number) || "AuxiliaryAccountBalance".equals(number)) {
                CurrencyEntryInfo currencyEntryInfo = new CurrencyEntryInfo();
                currencyEntryInfo.setCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo(H.PK("11111111-1111-1111-1111-111111111111DEB58FDC")));
                result.add(currencyEntryInfo);
            } else {
                CurrencyEntryInfo currencyEntryInfo = new CurrencyEntryInfo();
                currencyEntryInfo.setCurrency(companyOrgUnitInfo.getBaseCurrency());
                result.add(currencyEntryInfo);
            }
            return result;
        }
        return currencys;
    }

    @Override
    protected void doUploadData(Context ctx, ArcRecordInfo recordInfo, RecordBaseInfo content, List<XmlBase> xmlBaseList, String subName, String taskFlag) throws Exception {
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
        ArchFormatInfo formatInfo = this.getArchFormatInfo(ctx, recordInfo, periodInfo, content, taskFlag);
        this.putFile(ctx, recordInfo, formatInfo, xmlBaseList);
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < xmlBaseList.size(); ++i) {
            if (xmlBaseList.get(i) == null) continue;
            ReportArchInfo reportArchInfo = (ReportArchInfo)xmlBaseList.get(i);
            AchRecordDetailInfo detailInfo = new AchRecordDetailInfo();
            detailInfo.setArcRecord(recordInfo);
            detailInfo.setState(recordInfo.getState());
            BOSUuid bosIdDetail = BOSUuid.create((BOSObjectType)detailInfo.getBOSType());
            String detailId = bosIdDetail.toString();
            detailInfo.setId(bosIdDetail);
            reportArchInfo.setRecordId(recordInfo.getId().toString());
            reportArchInfo.setId(detailId);
            coreColl.add((CoreBaseInfo)detailInfo);
        }
        AchRecordDetailFactory.getLocalInstance(ctx).save(coreColl);
        if (formatInfo.getAttaInputStrams().size() == 0) {
            if (periodInfo.getPeriodNumber() > 12 && ArcContentTypeEnum.REPORT.equals((Object)recordInfo.getContentType())) {
                ArcRecordFactory.getLocalInstance(ctx).delete(H.PK(recordInfo.getId()));
                this.releaseMutex(ctx, recordInfo);
            } else {
                this.handleNoData(ctx, recordInfo);
            }
            return;
        }
        formatInfo.setXmlBases(xmlBaseList);
        StringBuffer xmlName = new StringBuffer(recordInfo.getArcRecordNum());
        xmlName.append("_").append(subName).append("_").append(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
        formatInfo.setXmlName(xmlName + ".xml");
        formatInfo.getContent().setReportCycleType(recordInfo.getReportCycleType());
        this.upload(ctx, recordInfo.getOrg(), periodInfo, formatInfo);
    }

    protected void putFile(Context ctx, ArcRecordInfo recordInfo, ArchFormatInfo formatInfo, List<XmlBase> mainBills) throws Exception {
        RecordBaseInfo content = recordInfo.getContent();
        ReportParsingEngineUtil reportParsingEngineUtil = (ReportParsingEngineUtil)ParsingEngineUtil.getInstance(ctx, content);
        for (int i = mainBills.size() - 1; i >= 0; --i) {
            InputStream fileIS;
            ReportArchInfo reportArchInfo = (ReportArchInfo)mainBills.get(i);
            ReportFilter reportFilter = reportArchInfo.getReportFilter();
            IXmlSrcObj iXmlSrcObjs = reportParsingEngineUtil.getReportDataSources(ctx, reportFilter);
            if (iXmlSrcObjs == null) {
                mainBills.remove(i);
                continue;
            }
            reportArchInfo.setData(iXmlSrcObjs);
            InputStream[] fileISArray = reportParsingEngineUtil.getFileISArray(ctx, reportArchInfo.getData());
            if ((null == fileISArray || fileISArray.length == 0) && null != (fileIS = this.getFileIS(ctx, reportParsingEngineUtil, reportArchInfo))) {
                fileISArray = new InputStream[]{fileIS};
            }
            if (null != fileISArray && fileISArray.length > 0) {
                LinkedHashSet<FileInfo> fileInfos = new LinkedHashSet<FileInfo>();
                String reportFileType = RECUtil.getReportFileType(recordInfo.getContent());
                String reportName = (String)iXmlSrcObjs.get("reportName");
                String reportSrcName = (String)iXmlSrcObjs.get("reportSrcName");
                if (StringUtils.isEmpty((String)reportName)) {
                    Set<FileInfo> fileInfosBase = reportArchInfo.getFileInfos();
                    FileInfo fileInfoBase = fileInfosBase.iterator().next();
                    Iterator<FileInfo> iterator = fileInfosBase.iterator();
                    while (iterator.hasNext()) {
                        FileInfo fileInfo;
                        fileInfoBase = fileInfo = iterator.next();
                    }
                    reportName = fileInfoBase.getName();
                    reportSrcName = fileInfoBase.getSrcname();
                }
                for (int j = 0; j < fileISArray.length; ++j) {
                    FileInfo fileInfo = new FileInfo(null, reportName + "_" + j + reportFileType, reportSrcName + "_" + j + reportFileType);
                    fileInfos.add(fileInfo);
                    formatInfo.setAttachment(fileInfo.getName(), fileISArray[j]);
                }
                reportArchInfo.setFileInfos(fileInfos);
                continue;
            }
            mainBills.remove(i);
        }
    }

    protected InputStream getFileIS(Context ctx, ReportParsingEngineUtil reportParsingEngineUtil, ReportArchInfo reportArchInfo) throws Exception {
        return reportParsingEngineUtil.getFileIS(ctx, reportArchInfo.getData());
    }

    @Override
    protected ArchInfos prepareData(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        List<XmlBase> xmlBaseList = this.getXmlBaseList(ctx, recordInfo);
        ArchInfos archInfos = new ArchInfos(ctx);
        archInfos.setMainBills(xmlBaseList);
        return archInfos;
    }

    protected List<XmlBase> getXmlBaseList(Context ctx, ArcRecordInfo recordInfo) throws Exception {
        ReportArchInfo reportArchInfo = this.getReportArchInfo(ctx, recordInfo);
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
        ReportFilter reportFilter = this.getReportFilter(recordInfo);
        reportFilter.setYear(String.valueOf(periodInfo.getPeriodYear()));
        reportFilter.setPeriod(String.valueOf(periodInfo.getPeriodNumber()));
        if ("Subledger".equals(recordInfo.getContent().getBillType().getNumber())) {
            List<XmlBase> reportArchInfos = this.handleSubledger(ctx, recordInfo, reportFilter);
            return reportArchInfos;
        }
        if ("AuxiliarySubledger".equals(recordInfo.getContent().getBillType().getNumber())) {
            List<XmlBase> reportArchInfos = this.handleAuxiliarySubledgerForAsstAccount(ctx, recordInfo, reportFilter);
            return reportArchInfos;
        }
        reportArchInfo.setReportFilter(reportFilter);
        String fileName = recordInfo.getArcRecordNum();
        reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
        ArrayList<XmlBase> reportArchInfos = new ArrayList<XmlBase>();
        reportArchInfos.add(reportArchInfo);
        return reportArchInfos;
    }

    private ReportArchInfo getReportArchInfo(Context ctx, ArcRecordInfo recordInfo) {
        ReportArchInfo reportArchInfo = new ReportArchInfo();
        reportArchInfo.setId(recordInfo.getId().toString());
        reportArchInfo.setDataCenter(ctx.getAIS());
        reportArchInfo.setReportCycleType(recordInfo.getReportCycleType().getName());
        reportArchInfo.setDocType(recordInfo.getContent().getXmlDocType());
        return reportArchInfo;
    }

    private List<XmlBase> handleSubledger(Context ctx, ArcRecordInfo recordInfo, ReportFilter reportFilter) throws BOSException, EASBizException {
        Map<String, AccountViewInfo> acIdSets = this.getAccountIdByOrg(ctx, recordInfo.getOrg());
        ArrayList<XmlBase> reportInfoList = new ArrayList<XmlBase>();
        if (acIdSets == null || acIdSets.size() == 0) {
            return reportInfoList;
        }
        HashSet<String> accountIds = null;
        int count = 0;
        StringBuffer buffer = new StringBuffer(1000);
        for (String accountId : acIdSets.keySet()) {
            AccountViewInfo accountViewInfo = acIdSets.get(accountId);
            accountIds = new HashSet<String>();
            accountIds.add(accountId);
            ReportFilter newReportFilter = this.getReportFilter(recordInfo);
            newReportFilter.setYear(reportFilter.getYear());
            newReportFilter.setPeriod(reportFilter.getPeriod());
            newReportFilter.setAcIdSet(accountIds);
            newReportFilter.setAccountName(acIdSets.get(accountId).getName());
            newReportFilter.setAccountNumber(acIdSets.get(accountId).getNumber());
            newReportFilter.setAccountViewInfo(acIdSets.get(accountId));
            ReportArchInfo reportArchInfo = this.getReportArchInfo(ctx, recordInfo);
            reportArchInfo.setReportFilter(newReportFilter);
            String fileName = recordInfo.getArcRecordNum() + "_" + ++count + "_" + accountViewInfo.getNumber();
            reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
            reportInfoList.add(reportArchInfo);
        }
        return reportInfoList;
    }

    private List<XmlBase> handleAuxiliarySubledgerForAsstAccount(Context ctx, ArcRecordInfo recordInfo, ReportFilter reportFilter) throws BOSException, EASBizException {
        AsstAccountCollection asstAccountCollection = new AsstAccountCollection();
        asstAccountCollection = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection();
        ArrayList<XmlBase> reportInfoList = new ArrayList<XmlBase>();
        int count = 0;
        for (int i = 0; i < asstAccountCollection.size(); ++i) {
            AsstAccountInfo asstAccountInfo = asstAccountCollection.get(i);
            ReportFilter newReportFilter = this.getReportFilter(recordInfo);
            newReportFilter.setYear(reportFilter.getYear());
            newReportFilter.setPeriod(reportFilter.getPeriod());
            newReportFilter.setAsstAccountInfo(asstAccountInfo);
            ReportArchInfo reportArchInfo = this.getReportArchInfo(ctx, recordInfo);
            reportArchInfo.setReportFilter(newReportFilter);
            String fileName = recordInfo.getArcRecordNum() + "_" + ++count + "_" + asstAccountInfo.getNumber();
            reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
            reportInfoList.add(reportArchInfo);
        }
        return reportInfoList;
    }

    private Map<String, AccountViewInfo> getAccountIdByOrg(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        String companyId = company.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("companyId", (Object)companyId));
        view.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accountcurrency.*");
        view.setSelector(sic);
        HashMap<String, AccountViewInfo> results = null;
        AccountViewCollection acs = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (acs != null && acs.size() > 0) {
            results = new HashMap<String, AccountViewInfo>();
            int size = acs.size();
            for (int i = 0; i < size; ++i) {
                AccountViewInfo ac = acs.get(i);
                results.put(ac.getId().toString(), ac);
            }
        }
        return results;
    }

    protected ReportFilter getReportFilter(ArcRecordInfo recordInfo) {
        ReportFilter reportFilter = new ReportFilter(recordInfo);
        reportFilter.setRecordBaseInfo(recordInfo.getContent());
        reportFilter.setReportCycleType(recordInfo.getReportCycleType());
        reportFilter.setOrgId(recordInfo.getOrg().getId().toString());
        reportFilter.setCurrency(recordInfo.getCurrency());
        reportFilter.setExportFileType(recordInfo.getContent().getExportFileType());
        return reportFilter;
    }

    @Override
    public void increReArch(Context ctx, String recordId) throws Exception {
        this.fullReArch(ctx, recordId);
    }

    @Override
    public void archFailed(Context ctx, String recordId) throws Exception {
        this.fullReArch(ctx, recordId);
    }

    @Override
    protected void handleDeletedData(Context ctx, ArchInfos archInfos, ArcRecordInfo recordInfo) {
    }

    @Override
    protected void deleteArchedData(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        try {
            AchRecordDetailFactory.getLocalInstance(ctx).delete("where arcRecord = '" + recordInfo.getId().toString() + "'");
            AchRecordDetailHisFactory.getLocalInstance(ctx).delete("where arcRecord = '" + recordInfo.getId().toString() + "'");
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u5220\u9664\u5355\u636e\u5931\u8d25"});
        }
    }

    @Override
    protected void doBusinessReverse(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        ReportFilter reportFilter = this.getReportFilter(recordInfo);
        try {
            ArrayList<ReportFilter> reportFilters = new ArrayList<ReportFilter>();
            reportFilters.add(reportFilter);
            ((ReportParsingEngineUtil)ParsingEngineUtil.getInstance(ctx, recordInfo.getContent())).revokeArch(ctx, reportFilters);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u4e1a\u52a1\u53cd\u5f52\u6863\u5931\u8d25"});
        }
    }

    @Override
    protected void processDataThread(final Context ctx, final ArcRecordInfo recordInfo, final RecordBaseInfo content, List<XmlBase> xmlBaseList, String subName, final String taskFlag) {
        ThreadUtil.ThreadInfo threadInfo = ThreadUtil.getLock(taskFlag);
        threadInfo.addThreadCount(0);
        final String _subName = subName;
        final List<XmlBase> bills = xmlBaseList;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Context newCtx = (Context)FilingReport.this.deeplyCopy((Serializable)ctx);
                    WebContextUtil.initRpcConfig((Context)newCtx);
                    FilingReport.this.doUploadData(newCtx, recordInfo, content, bills, _subName, taskFlag);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                    ArchRecordUtils.writeLogs(ctx, bills, recordInfo.getId().toString(), e);
                }
            }
        };
        UploadArchInfosThreadPool.execute(ctx, runnable);
    }

    @Override
    public void prepareData(Context ctx, RecordInfo recordInfo) throws Exception {
        JobInfo jobInfo = null;
        boolean exists = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordInfo.getArcRecordInfo().getId() + "'");
        if (!exists) {
            jobInfo = new JobInfo(recordInfo.getArcRecordInfo());
            jobInfo.setTaskType("ADDNEW");
            jobInfo.setFileFlag(this.getTaskFlag());
            StringBuilder xmlName = new StringBuilder(recordInfo.getArcRecordNum());
            xmlName.append("_").append(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            jobInfo.setXmlName(xmlName.toString());
            JobFactory.getLocalInstance(ctx).addnew(jobInfo);
        } else {
            jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo("where record = '" + recordInfo.getArcRecordInfo().getId() + "'");
        }
        ArcStateEnum state = recordInfo.getArcRecordInfo().getState();
        if (ArcStateEnum.ARC_SUCCESS.equals((Object)state) || ArcStateEnum.REVERSE_ARC.equals((Object)state)) {
            this.noticeSysReArch(ctx, recordInfo.getArcRecordInfo());
            this.deleteArchedData(ctx, recordInfo.getArcRecordInfo());
            jobInfo.setFileFlag(this.getTaskFlag());
            jobInfo.setState("wating");
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"fileFlag", "state"});
        }
        if (ArcStateEnum.ARC_NODATA.equals((Object)state)) {
            jobInfo.setFileFlag(this.getTaskFlag());
            jobInfo.setState("wating");
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"fileFlag", "state"});
        }
        if (ArcStateEnum.ARC_LOADING.equals((Object)state) || recordInfo.getArcRecordInfo().getLastUpdateTime().before(new Date(System.currentTimeMillis() - 86400000L))) {
            jobInfo.setFileFlag(this.getTaskFlag());
            jobInfo.setState("wating");
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"fileFlag", "state"});
        }
        if (ArcStateEnum.ARC_FAIL.equals((Object)state)) {
            StringBuilder sqlBuilderJob = new StringBuilder("update t_rec_job set FailNum = ").append(0).append(", FState = ?, FileFlag = '").append(this.getTaskFlag()).append("' ");
            sqlBuilderJob.append("where FrecordID = '").append(recordInfo.getArcRecordInfo().getId().toString()).append("' and  FailNum >= ").append(3);
            DbUtil.execute((Context)ctx, (String)sqlBuilderJob.toString(), (Object[])new Object[]{"wating"});
        }
        this.updateRecordState(ctx, recordInfo.getArcRecordInfo(), ArcStateEnum.WAITING);
    }

    @Override
    protected void doFullReArch(Context ctx, ArcRecordInfo recordInfo) throws Exception {
        JobCollection collection;
        if (ArcStateEnum.ARC_FAIL.equals((Object)recordInfo.getState()) && !(collection = JobFactory.getLocalInstance(ctx).getJobCollection("where record = '" + recordInfo.getId() + "'")).isEmpty()) {
            JobInfo jobInfo = collection.get(0);
            jobInfo.setFailNum(0);
            jobInfo.setFileFlag(this.getTaskFlag());
            jobInfo.setState("wating");
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"failNum", "fileFlag", "state"});
            this.updateRecordState(ctx, recordInfo, ArcStateEnum.WAITING);
        }
        super.doFullReArch(ctx, recordInfo);
    }

    @Override
    protected List<XmlBase> getXmlBaseList(Context ctx, ArcRecordInfo recordInfo, JobInfo jobInfo) throws Exception {
        ReportArchInfo reportArchInfo = this.getReportArchInfo(ctx, recordInfo);
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
        ReportFilter reportFilter = this.getReportFilter(recordInfo);
        reportFilter.setYear(String.valueOf(periodInfo.getPeriodYear()));
        reportFilter.setPeriod(String.valueOf(periodInfo.getPeriodNumber()));
        if ("Subledger".equals(recordInfo.getContent().getBillType().getNumber())) {
            List<XmlBase> reportArchInfos = this.handleSubledger(ctx, recordInfo, reportFilter);
            return reportArchInfos;
        }
        if ("AuxiliarySubledger".equals(recordInfo.getContent().getBillType().getNumber()) || "AuxiliaryGL".equals(recordInfo.getContent().getBillType().getNumber())) {
            List<XmlBase> reportArchInfos = this.handleAuxiliarySubledgerForAsstAccount(ctx, recordInfo, reportFilter);
            return reportArchInfos;
        }
        reportArchInfo.setReportFilter(reportFilter);
        String fileName = recordInfo.getArcRecordNum();
        reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
        ArrayList<XmlBase> reportArchInfos = new ArrayList<XmlBase>();
        reportArchInfos.add(reportArchInfo);
        return reportArchInfos;
    }

    private void saveReportDetail(Context ctx, ArchFormatInfo archFormatInfo) {
        List<XmlBase> xmlBaseList = archFormatInfo.getXmlBases();
        ArcRecordInfo recordInfo = archFormatInfo.getRecordInfo();
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < xmlBaseList.size(); ++i) {
            if (xmlBaseList.get(i) == null) continue;
            ReportArchInfo reportArchInfo = (ReportArchInfo)xmlBaseList.get(i);
            AchRecordDetailInfo detailInfo = new AchRecordDetailInfo();
            detailInfo.setArcRecord(recordInfo);
            detailInfo.setState(recordInfo.getState());
            BOSUuid bosIdDetail = BOSUuid.create((BOSObjectType)detailInfo.getBOSType());
            String detailId = bosIdDetail.toString();
            detailInfo.setId(bosIdDetail);
            reportArchInfo.setRecordId(recordInfo.getId().toString());
            reportArchInfo.setId(detailId);
            reportArchInfo.setDataId(detailId);
            coreColl.add((CoreBaseInfo)detailInfo);
        }
        try {
            AchRecordDetailFactory.getLocalInstance(ctx).save(coreColl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void uploadAttach(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase, ReportParsingEngineUtil reportParsingEngineUtil) throws Exception {
        ReportArchInfo info = (ReportArchInfo)xmlBase;
        Map<FileInfo, InputStream> filesMap = reportParsingEngineUtil.getAttachmentFileISArray(ctx, info);
        for (Map.Entry<FileInfo, InputStream> entry : filesMap.entrySet()) {
            FileInfo fileInfo = entry.getKey();
            if (StringUtils.isEmpty((String)fileInfo.getException())) {
                InputStream is = entry.getValue();
                if (null == is) continue;
                long t2 = System.currentTimeMillis();
                this.fileUpLoad(ctx, archFormatInfo, is, fileInfo.getName());
                long t3 = System.currentTimeMillis();
                archFormatInfo.setUploadAttaTime(t3 - t2);
                continue;
            }
            ArchRecordUtils.writeLog(ctx, info, archFormatInfo.getRecordId(), (Exception)((Object)new RecException(RecException.UNKNOWN, fileInfo.getE(), new Object[]{"\u9644\u4ef6[" + fileInfo.getSrcname() + "]\u5b58\u5728\u5f02\u5e38:" + fileInfo.getE().getMessage()})));
            throw fileInfo.getE();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processXmlBase(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase, int index) throws Exception {
        long t1 = System.currentTimeMillis();
        ReportParsingEngineUtil reportParsingEngineUtil = (ReportParsingEngineUtil)ParsingEngineUtil.getInstance(ctx, archFormatInfo.getContent());
        ReportArchInfo reportArchInfo = (ReportArchInfo)xmlBase;
        ReportFilter reportFilter = reportArchInfo.getReportFilter();
        IXmlSrcObj iXmlSrcObjs = reportParsingEngineUtil.getReportDataSources(ctx, reportFilter);
        try {
            InputStream fileIS;
            if (iXmlSrcObjs == null) {
                archFormatInfo.getXmlBases().set(index, null);
                return;
            }
            if (iXmlSrcObjs.get("id") != null) {
                List<FileInfo> attachmentFiles = ArchUtils.getEASAttachment(ctx, String.valueOf(iXmlSrcObjs.get("id")), index, ArchUtils.getDefaultNumber());
                reportArchInfo.getAttachmentFileInfos().addAll(attachmentFiles);
            }
            reportArchInfo.setData(iXmlSrcObjs);
            reportArchInfo.setReArchFlag(ArchFlagEnum.ADDNEW);
            InputStream[] fileISArray = reportParsingEngineUtil.getFileISArray(ctx, reportArchInfo.getData());
            if ((null == fileISArray || fileISArray.length == 0) && null != (fileIS = this.getFileIS(ctx, reportParsingEngineUtil, reportArchInfo))) {
                fileISArray = new InputStream[]{fileIS};
            }
            long t2 = System.currentTimeMillis();
            archFormatInfo.setPreparePdfTime(t2 - t1);
            if (null != fileISArray && fileISArray.length > 0) {
                LinkedHashSet<FileInfo> fileInfos = new LinkedHashSet<FileInfo>();
                String reportFileType = RECUtil.getReportFileType(archFormatInfo.getContent());
                String reportName = (String)iXmlSrcObjs.get("reportName");
                String reportSrcName = (String)iXmlSrcObjs.get("reportSrcName");
                if (StringUtils.isEmpty((String)reportName)) {
                    Set<FileInfo> fileInfosBase = reportArchInfo.getFileInfos();
                    FileInfo fileInfoBase = fileInfosBase.iterator().next();
                    Iterator<FileInfo> iterator = fileInfosBase.iterator();
                    while (iterator.hasNext()) {
                        FileInfo fileInfo;
                        fileInfoBase = fileInfo = iterator.next();
                    }
                    reportName = fileInfoBase.getName();
                    reportSrcName = fileInfoBase.getSrcname();
                }
                archFormatInfo.getContent().setReportCycleType(archFormatInfo.getRecordInfo().getReportCycleType());
                File[] tempFiles = (File[])iXmlSrcObjs.get("tempFile");
                for (int j = 0; j < fileISArray.length; ++j) {
                    FileInfo fileInfo = new FileInfo(null, reportName + "_" + j + reportFileType, reportSrcName + "_" + j + reportFileType);
                    fileInfos.add(fileInfo);
                    if (tempFiles != null) {
                        ctx.put((Object)"tempFile", (Object)tempFiles[j].getAbsolutePath());
                    }
                    this.fileUpLoad(ctx, archFormatInfo, fileISArray[j], fileInfo.getName());
                }
                reportArchInfo.setFileInfos(fileInfos);
                this.uploadAttach(ctx, archFormatInfo, xmlBase, reportParsingEngineUtil);
            } else {
                archFormatInfo.getXmlBases().set(index, null);
            }
            long t3 = System.currentTimeMillis();
            archFormatInfo.setPreparePdfTime(t3 - t2);
        }
        finally {
            if (iXmlSrcObjs != null) {
                FilingUtils.deleteTempFile((File[])iXmlSrcObjs.get("tempFile"));
            }
        }
    }

    @Override
    protected boolean doUploadXml(Context ctx, ArchFormatInfo archFormatInfo) throws Exception {
        List<XmlBase> xmlBases = archFormatInfo.getXmlBases();
        boolean noData = true;
        for (int i = 0; i < xmlBases.size(); ++i) {
            XmlBase xmlBase = xmlBases.get(i);
            if (null != xmlBase) {
                noData = false;
                if (null == xmlBase.getException()) continue;
                throw xmlBase.getException();
            }
            xmlBases.remove(i--);
        }
        if (noData) {
            ArcRecordInfo recordInfo = archFormatInfo.getRecordInfo();
            if (archFormatInfo.getPeriodInfo().getPeriodNumber() > 12 && ArcContentTypeEnum.REPORT.equals((Object)recordInfo.getContentType())) {
                ArcRecordFactory.getLocalInstance(ctx).delete(H.PK(recordInfo.getId()));
            } else {
                this.handleNoData(ctx, recordInfo);
            }
            this.releaseMutex(ctx, recordInfo);
            return true;
        }
        this.saveReportDetail(ctx, archFormatInfo);
        InputStream inputStream = this.generateXml(ctx, archFormatInfo.getContent(), archFormatInfo.getXmlBases());
        archFormatInfo.getContent().setReportCycleType(archFormatInfo.getRecordInfo().getReportCycleType());
        JobInfo jobInfo = archFormatInfo.getJobInfo();
        String xmlSuffix = (jobInfo.getFailNum() > 0 ? "_" + jobInfo.getFailNum() : "") + ".xml";
        this.fileUpLoad(ctx, archFormatInfo, inputStream, jobInfo.getXmlName() + xmlSuffix);
        jobInfo.setState("uploaded");
        JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
        this.noticeSysArchBatch(ctx, archFormatInfo);
        String arch_type = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_TYPE);
        if (ArchConstant.ARCH_SYS_TYPE_GXHC.equals(arch_type)) {
            jobInfo.setState("noticed");
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
            return false;
        }
        return true;
    }

    @Override
    protected void handleArchXmlbaseException(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase, Throwable e) {
        archFormatInfo.setHasFail(true);
        xmlBase.setException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFinalState(Context ctx, String recordId) throws Exception {
        try {
            JobCollection jobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("select failNum, state where record = '" + recordId + "'");
            if (jobCollection.isEmpty()) {
                return;
            }
            ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, false);
            JobInfo jobInfo = jobCollection.get(0);
            if ("completed".equals(jobInfo.getState())) {
                this.updateRecordState(ctx, recordInfo, ArcStateEnum.ARC_SUCCESS);
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordId, ArcStateEnum.ARC_SUCCESS, "\u5f52\u6863\u6210\u529f", null);
                JobFactory.getLocalInstance(ctx).delete("where record = '" + recordId + "' and state = '" + "completed" + "'");
            }
            if ("fail".equals(jobInfo.getState())) {
                this.updateRecordState(ctx, recordInfo, ArcStateEnum.ARC_FAIL);
                if (jobInfo.getFailNum() < 3) {
                    this.updateFailJobWating(ctx, recordId);
                    JobFactory.getLocalInstance(ctx).executeJob();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("com.kingdee.eas.el.rec.filing.error.processFinalState:" + recordId + " \u5904\u7406\u5931\u8d25"), (Throwable)e);
        }
        finally {
            logger.error((Object)("com.kingdee.eas.el.rec.filing.info.processFinalState:" + recordId));
        }
    }

    @Override
    public void processArcSysNotice(Context ctx, String recorId, String jobId, List<Object> fileList) throws Exception {
        int beforeSize = fileList.size();
        JobInfo jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo("select * where id = '" + jobId + "'");
        for (int i = 0; i < fileList.size(); ++i) {
            if (!"0".equals(((Map)fileList.get(i)).get("return"))) continue;
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(jobInfo.getRecord().toString(), ArcStateEnum.ARC_FAIL, "\u6863\u6848\u7cfb\u7edf\u8fd4\u56de\uff1a" + ((Map)fileList.get(i)).get("desc"), null);
            fileList.remove(i--);
        }
        if (fileList.size() == beforeSize) {
            jobInfo.setState("completed");
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
        } else {
            jobInfo.setState("fail");
            jobInfo.setFailNum(jobInfo.getFailNum() + 1);
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state", "failNum"});
        }
        this.processFinalStateTx(ctx, recorId);
    }

    @Override
    protected void setBatchData(Context ctx, List<XmlBase> xmlBaseList, ArcRecordInfo arcRecordInfo, JobInfo jobInfo) {
    }
}

