/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.filing.instance;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.filing.instance.AbstractMergeFilingReport;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.tool.MergeReportUtils;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FilingRptsReport
extends AbstractMergeFilingReport {
    private static Logger logger = Logger.getLogger(FilingRptsReport.class);

    @Override
    protected List<OrgStructureInfo> getOrgStructureList(Context ctx, ArchSchemeInfo asInfo, PeriodInfo periodInfo) throws RecException {
        ArrayList<OrgStructureInfo> orgStructureList = new ArrayList();
        try {
            RptPeriodTypeEnum rptPeriodTypeEnum = FilingUtils.convertToRptEnum(asInfo.getReportCycleType());
            orgStructureList = MergeReportUtils.getOrgStructureInfos(ctx, asInfo.getMergeScope().getId().toString(), periodInfo, rptPeriodTypeEnum);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6\u6cd5\u5b9a\u5408\u5e76\u5355\u5143\u5f02\u5e38"});
        }
        return orgStructureList;
    }

    @Override
    protected StringBuilder getArcRecordNum(ArchSchemeInfo asInfo, OrgStructureInfo orgStructureInfo, CurrencyInfo currencyInfo, PeriodInfo periodInfo, RecordBaseInfo archContent) {
        StringBuilder arcRecordNum = new StringBuilder(archContent.getNumber());
        arcRecordNum.append("_").append(this.getNumber(orgStructureInfo.getLongNumber()));
        arcRecordNum.append("-").append(archContent.getReportCycleType().getValue());
        arcRecordNum.append("_").append(periodInfo.getNumber());
        arcRecordNum.append("_").append(asInfo.getMergeScope().getNumber());
        arcRecordNum.append("_").append(currencyInfo.getIsoCode());
        return arcRecordNum;
    }

    private String getNumber(String longNumber) {
        String[] split = longNumber.split("!");
        int index = split.length - 1;
        return split[index];
    }
}

