/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.model.dataprovider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucherAssistRecord;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherQueryDelegateZSJ
implements BOSQueryDelegate {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.model.dataprovider.VoucherQueryDelegate");
    private String[] voucherIds;
    private VoucherPrintSettingInfo printSetting;
    private Context ctx;

    public VoucherQueryDelegateZSJ(Context ctx, List<String> voucherIds) {
        this.ctx = ctx;
        this.voucherIds = voucherIds.toArray(new String[voucherIds.size()]);
        try {
            String function = "fi.gl.voucher.printSetting";
            UserSettingObject userSetObj = UserSettingFactory.getLocalInstance((Context)ctx).getValue(null, function);
            HashMap setting = null;
            if (userSetObj != null) {
                setting = userSetObj.getData();
            }
            if (setting == null) {
                setting = new HashMap();
            }
            this.printSetting = this.toVoucherPrintSettingInfo(setting);
        }
        catch (Exception e) {
            this.logger.error((Object)"qeury voucher print setting error!", (Throwable)e);
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            VoucherCollection vchCol = this.getPrintVoucherCollection(this.voucherIds, this.printSetting);
            VoucherCollection col = new VoucherCollection();
            for (VoucherInfo voucherInfo : vchCol) {
                VoucherInfo info = this.handle(voucherInfo, this.printSetting);
                col.add(info);
            }
            Locale locale = this.ctx.getLocale();
            VoucherRowSetProvider provider = new VoucherRowSetProvider(locale, col, this.printSetting, this.ctx);
            return provider.getRowSet(ds.getID());
        }
        catch (Exception e) {
            this.logger.error((Object)"print voucher error!", (Throwable)e);
            return null;
        }
    }

    public VoucherPrintSettingInfo toVoucherPrintSettingInfo(Map userSetting) {
        VoucherPrintSettingInfo setting = new VoucherPrintSettingInfo();
        setting.setPrintCashFlow("true".equals(userSetting.get("printCashflow") == null ? "false" : userSetting.get("printCashflow").toString()));
        setting.setPrintCashflowMeOrOther("true".equals(userSetting.get("cashPrintAtAccount") == null ? "false" : userSetting.get("cashPrintAtAccount").toString()));
        setting.setPrintAssistant("true".equals(userSetting.get("printAsst") == null ? "false" : userSetting.get("printAsst").toString()));
        setting.setDebitCredit("true".equals(userSetting.get("debitCredit") == null ? "false" : userSetting.get("debitCredit").toString()));
        setting.setShowAsstFullName("true".equals(userSetting.get("showFullAsstName") == null ? "false" : userSetting.get("showFullAsstName").toString()));
        setting.setShowAsstNumber("true".equals(userSetting.get("showAsstNumber") == null ? "false" : userSetting.get("showAsstNumber").toString()));
        setting.setAutoMachAsstTemplate("true".equals(userSetting.get("asstAutoTemplate") == null ? "false" : userSetting.get("asstAutoTemplate").toString()));
        setting.setAutoMachMulCurrencyTemplate("true".equals(userSetting.get("currencyAutoTemplate") == null ? "false" : userSetting.get("currencyAutoTemplate").toString()));
        setting.setPrintCashflowMeOrOther("true".equals(setting.isPrintCashFlow()) && !"true".equals(userSetting.get("cashPrintAtOppAccount") == null ? "false" : userSetting.get("cashPrintAtOppAccount").toString()));
        setting.setShowAccountNumber("true".equals(userSetting.get("showAccountNumber") == null ? "false" : userSetting.get("showAccountNumber").toString()));
        setting.setShowAccountFullName("true".equals(userSetting.get("showFullAccountName") == null ? "false" : userSetting.get("showFullAccountName").toString()));
        setting.setSumByAccountLevel("true".equals(userSetting.get("isAccountLevel") == null ? "false" : userSetting.get("isAccountLevel").toString()));
        setting.setSumDetailSameAsst("true".equals(userSetting.get("isSumDetailSameAsst") == null ? "false" : userSetting.get("isSumDetailSameAsst").toString()));
        setting.setSumByAccountDC("true".equals(userSetting.get("sumByAccountDC") == null ? "false" : userSetting.get("sumByAccountDC").toString()));
        setting.setNotShowAmountIsZero("true".equals(userSetting.get("notShowAmountIsZero") == null ? "false" : userSetting.get("notShowAmountIsZero").toString()));
        if (userSetting.get("accountLevel") != null && !StringUtils.isEmpty((String)userSetting.get("accountLevel").toString())) {
            setting.setAccountLevel(new BigDecimal(userSetting.get("accountLevel").toString()).intValue());
        }
        return setting;
    }

    public VoucherCollection getPrintVoucherCollection(String[] ids, VoucherPrintSettingInfo printSetting) throws BOSException, EASBizException {
        printSetting.setPrintAssistant(true);
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        v.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        fic.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SorterItemCollection sorters = v.getSorter();
        sorters.add(new SorterItemInfo("id"));
        if (printSetting.isDebitCredit()) {
            sorters.add(new SorterItemInfo("entries.entryDC"));
        }
        sorters.add(new SorterItemInfo("entries.seq"));
        if (printSetting.isPrintAssistant()) {
            sorters.add(new SorterItemInfo("entries.assistRecords.seq"));
        }
        SelectorItemCollection sic = this.createVoucherQuerySelectorItem(printSetting.isPrintAssistant(), printSetting.isPrintCashFlow(), printSetting.isPrintCashflowMeOrOther());
        v.getSelector().addObjectCollection((IObjectCollection)sic);
        VoucherCollection vchColl = VoucherFactory.getLocalInstance((Context)this.ctx).getVoucherCollection(v);
        return this.sortVoucherCollection(vchColl, ids);
    }

    private SelectorItemCollection createVoucherQuerySelectorItem(boolean isChkAssistant, boolean isChkPrintCashFlow, boolean isPrintCashflowMeOrOther) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("company.reportCurrency.precision"));
        sic.add(new SelectorItemInfo("company.baseCurrency.name"));
        sic.add(new SelectorItemInfo("company.reportCurrency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("attachments"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("localDebitAmount"));
        sic.add(new SelectorItemInfo("localCreditAmount"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("poster.name"));
        sic.add(new SelectorItemInfo("canceller.name"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.description"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.account.longnumber"));
        sic.add(new SelectorItemInfo("entries.account.name"));
        sic.add(new SelectorItemInfo("entries.account.longName"));
        sic.add(new SelectorItemInfo("entries.account.level"));
        sic.add(new SelectorItemInfo("entries.account.parent.id"));
        sic.add(new SelectorItemInfo("entries.account.CAA"));
        sic.add(new SelectorItemInfo("entries.account.CAA.isQty"));
        sic.add(new SelectorItemInfo("entries.account.AC"));
        sic.add(new SelectorItemInfo("entries.account.isQty"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.currency.isoCode"));
        sic.add(new SelectorItemInfo("entries.currency.precision"));
        sic.add(new SelectorItemInfo("entries.currency.deletedStatus"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.localExchangeRate"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.customer.name"));
        sic.add(new SelectorItemInfo("entries.customer.number"));
        if (isChkAssistant) {
            sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
            sic.add(new SelectorItemInfo("entries.assistRecords.bizDate"));
            sic.add(new SelectorItemInfo("entries.assistRecords.description"));
            sic.add(new SelectorItemInfo("entries.assistRecords.endDate"));
            sic.add(new SelectorItemInfo("entries.assistRecords.price"));
            sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
            sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
            sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.isFullProp"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.displayNameGroup"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.longNameGroup"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.asstAccount.id"));
            sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.coefficient"));
            sic.add(new SelectorItemInfo("entries.assistRecords.verifiedCussent.id"));
            sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.settlementCode"));
            sic.add(new SelectorItemInfo("entries.assistRecords.bizNumber"));
            sic.add(new SelectorItemInfo("entries.assistRecords.ticketNumber"));
            sic.add(new SelectorItemInfo("entries.assistRecords.invoiceNumber"));
        }
        if (isChkPrintCashFlow) {
            if (isPrintCashflowMeOrOther) {
                sic.add(new SelectorItemInfo("entries.cashflowEntry.originalAmount"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.localAmount"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.reportingAmount"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.primaryCoefficient"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.supplementaryCoefficient"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.primaryItem.number"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.primaryItem.name"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.supplementaryItem.number"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.supplementaryItem.name"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.fullInfoItem.number"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.fullInfoItem.name"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.itemFlag"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.entry.id"));
                sic.add(new SelectorItemInfo("entries.cashflowEntry.entry.seq"));
            } else {
                sic.add(new SelectorItemInfo("entries.cashflowRecords.originalAmount"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.localAmount"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.reportingAmount"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.primaryCoefficient"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.supplementaryCoefficient"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.primaryItem.number"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.primaryItem.name"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.supplementaryItem.number"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.supplementaryItem.name"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.fullInfoItem.number"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.fullInfoItem.name"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.itemFlag"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.oppVoucherAssistRecord.id"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.oppVoucherAssistRecord.seq"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.cashflowEntry.id"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.cashflowEntry.seq"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.opposingAccountEntry.id"));
                sic.add(new SelectorItemInfo("entries.cashflowRecords.opposingAccountEntry.seq"));
            }
        }
        return sic;
    }

    public VoucherCollection sortVoucherCollection(VoucherCollection voucherColl, String[] voucherIds) {
        VoucherCollection vouColl = new VoucherCollection();
        for (int i = 0; i < voucherIds.length; ++i) {
            vouColl.add(voucherColl.get((Object)BOSUuid.read((String)voucherIds[i])));
        }
        return vouColl;
    }

    protected VoucherInfo handle(VoucherInfo info, VoucherPrintSettingInfo printSetting) {
        return info;
    }

    public static class VoucherPrintDataProvider {
        private Context ctx;
        public static final String[] col = new String[]{"pageCount", "pageCurrent", "pageTotal", "company", "helpCode", "companyBaseCurreny", "companyReportCurreny", "description", "attachments", "attachmentsChinese", "sum", "periodYear", "periodNumber", "bizDate", "voucherDate", "bookedDate", "bookedDateYear", "bookedDateMonth", "bookedDateDay", "sysDateNow", "vchId", "bizStatus", "voucherType", "number", "numberShort", "vouchtTypeNumber", "currency", "amountTotalChinese", "amountTotal", "creditTotal", "debitTotal", "localAmountDebit", "localAmountCredit", "reportingAmountDebit", "reportingAmountCredit", "handler", "creator", "auditor", "cashier", "poster", "canceller", "e_seq", "e_description", "e_account", "e_profitCenter", "zc_account", "e_currency", "e_isoCode", "e_measureUnitName", "e_measureUnitNumber", "e_price", "e_quantity", "e_originalAmount", "e_originalAmountDebit", "e_originalAmountCredit", "e_localExchangeRate", "e_localAmountDebit", "e_localAmountCredit", "e_reportingExchangeRate", "e_reportingAmountDebit", "e_reportingAmountCredit", "r_description", "r_settlementType", "r_settlementCode", "r_bizNumber", "r_originalAmount", "r_originalAmountDebit", "r_originalAmountCredit", "r_localAmount", "r_localAmountDebit", "r_localAmountCredit", "r_reportingAmount", "r_reportingAmountDebit", "r_reportingAmountCredit", "r_measureUnitName", "r_measureUnitNumber", "r_price", "r_quantity", "r_bizDate", "r_invoice", "r_endDate", "r_customer", "r_supplier", "r_orgUnit", "r_matirial", "r_assGrp", "r_longName", "r_AsstHeadNumber", "r_AsstNumber", "r_AsstHeadName", "r_AsstName", "r_AsstLevelName", "r_accountAsst", "r_accountAsstPrimItem", "zc_assGrp", "c_item", "c_itemEbb", "c_primItem", "c_supp", "c_suppEbb", "c_suppItem", "c_fullInfo", "c_fullInfoEbb", "c_fullInfoItem", "c_oppAccount", "c_originalAmount", "c_localAmount", "c_reportingAmount", "c_primItemName", "c_suppItemName", "customer.number", "customer.name", "cusNumberName", "c_asstactName", "c_asstactNumber", "c_cashFlowAndAsstactGoupName", "c_asstactDisplayNameGroup", "c_asstactLongGroupName"};
        protected Map asstributeMap = new HashMap();
        private VoucherPrintSettingInfo settingInfo;
        private int pricePre = 2;
        private int qtyPre = 2;
        private Map mapPrecision;
        private boolean isAstQty = false;
        private boolean generalAsstShowLongNumber = false;
        private boolean commonVoucherProcess = false;

        public VoucherPrintDataProvider(VoucherPrintSettingInfo settingInfo, Context ctx) throws EASBizException, BOSException {
            this.ctx = ctx;
            this.settingInfo = settingInfo;
            Map sysParam = this.getSysParam();
            this.isAstQty = Boolean.valueOf(sysParam.get("G010").toString());
        }

        private Map getSysParam() throws BOSException, EASBizException {
            HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
            hmParamIn.put("G010", null);
            return ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(hmParamIn);
        }

        public void fillVoucherHeaderData(BaseVoucherInfo vch, IRowSet rs, DateFormat df, DateFormat dft, int size, BigDecimal allDeit, BigDecimal allCret) throws Exception {
            CompanyOrgUnitInfo com = vch.getCompany();
            CompanyOrgUnitInfo c2 = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo("select code where id = '" + com.getId().toString() + "'");
            this.initGLMap(com.getId().toString());
            rs.updateString("company", com.getName());
            rs.updateString("helpCode", c2.getCode());
            rs.updateString("companyBaseCurreny", com.getBaseCurrency().getName().toString());
            if (com.getReportCurrency() != null) {
                rs.updateString("companyReportCurreny", com.getReportCurrency().getName().toString());
            }
            rs.updateString("description", vch.getDescription());
            rs.updateDate("bookedDate", new Date(vch.getBookedDate().getTime()));
            rs.updateDate("voucherDate", new Date(vch.getBookedDate().getTime()));
            Date voucherBookDate = (Date)vch.getBookedDate();
            Calendar now = Calendar.getInstance();
            now.setTime(voucherBookDate);
            rs.updateString("bookedDateYear", String.valueOf(now.get(1)));
            int month = now.get(2) + 1;
            rs.updateString("bookedDateMonth", month < 10 ? "0" + month : "" + month);
            int date = now.get(5);
            rs.updateString("bookedDateDay", date < 10 ? "0" + date : "" + date);
            rs.updateDate("bizDate", new Date(vch.getBizDate().getTime()));
            PeriodInfo prd = vch.getPeriod();
            if (prd != null) {
                rs.updateString("periodYear", Integer.toString(prd.getPeriodYear()));
                rs.updateString("periodNumber", Integer.toString(prd.getPeriodNumber()));
            }
            rs.updateString("sysDateNow", GlUtils.formatDate((DateFormat)dft, (java.util.Date)SysUtil.getAppServerTime((Context)this.ctx)));
            String type = GlUtils.getName((IObjectValue)vch, (String)"voucherType");
            rs.updateString("voucherType", type);
            String strNumber = vch.getNumber();
            String strNumberShort = "";
            if (strNumber != null) {
                int n = strNumber.length();
                int il = 0;
                char[] ch = new char[n];
                for (int i = 0; i < n; ++i) {
                    ch[i] = strNumber.charAt(i);
                    if (ch[i] != '0') break;
                    ++il;
                }
                strNumberShort = strNumber.substring(il, n);
            }
            rs.updateString("number", vch.getNumber());
            rs.updateString("numberShort", strNumberShort);
            rs.updateString("vouchtTypeNumber", type + vch.getNumber());
            rs.updateString("currency", GlUtils.getName((IObjectValue)vch, (String)"currency"));
            rs.updateString("handler", GlUtils.getName((IObjectValue)vch, (String)"handler"));
            rs.updateString("creator", GlUtils.getName((IObjectValue)vch, (String)"creator"));
            rs.updateString("auditor", GlUtils.getName((IObjectValue)vch, (String)"auditor"));
            rs.updateString("cashier", GlUtils.getName((IObjectValue)vch, (String)"cashier"));
            rs.updateString("poster", GlUtils.getName((IObjectValue)vch, (String)"poster"));
            rs.updateString("canceller", GlUtils.getName((IObjectValue)vch, (String)"canceller"));
        }

        public void fillVoucherEntryData(String vchId, BaseVoucherEntryInfo e, IRowSet rs, int lcpre, int rcpre, String companyId) throws Exception {
            rs.updateString("vchId", vchId);
            rs.updateString("e_seq", Integer.toString(e.getSeq()));
            rs.updateString("e_description", e.getDescription());
            if (rs.getString("r_description") == null) {
                rs.updateString("r_description", e.getDescription());
            }
            String acctname = GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account");
            acctname = this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account") : (!this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getLongName((IObjectValue)e, (String)"account") : (this.settingInfo.isShowAccountNumber() && !this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndName((IObjectValue)e, (String)"account") : GlUtils.getName((IObjectValue)e, (String)"account")));
            String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account");
            String topAccountNumer = null;
            AccountViewInfo account = (AccountViewInfo)e.get("account");
            if (account != null && account.getLongNumber() != null && account.getLevel() != 1) {
                String longNumber = account.getLongNumber();
                int idx = longNumber.indexOf("!");
                topAccountNumer = longNumber.substring(0, idx);
            }
            String zc_acctname = "";
            if (acctnameZC != null) {
                zc_acctname = acctnameZC.indexOf("_", 0) != -1 && acctnameZC.indexOf("_", 0) != -1 ? (this.settingInfo.isShowAccountNumber() && topAccountNumer != null ? topAccountNumer + " - " + acctnameZC.substring(acctnameZC.indexOf("-", 0) + 2, acctnameZC.indexOf("_", 0)) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 2, acctnameZC.indexOf("_", 0))) : (this.settingInfo.isShowAccountNumber() ? acctnameZC : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 2, acctnameZC.length()));
            } else {
                acctname = "";
            }
            rs.updateString("e_account", acctname);
            String r_accountAsstAcctname = this.getR_accountAsstAcctname((IObjectValue)e, "account");
            StringBuffer buffer = new StringBuffer();
            if (e instanceof VoucherEntryInfo) {
                VoucherEntryInfo veInfo = (VoucherEntryInfo)e;
                VoucherAssistRecordCollection vardColl = veInfo.getAssistRecords();
                if (vardColl != null && vardColl.size() > 0) {
                    buffer.append("(");
                }
                for (int i = 0; i < vardColl.size(); ++i) {
                    VoucherAssistRecordInfo vardInfo = vardColl.get(i);
                    AssistantHGInfo atthgInfo = vardInfo.getAssGrp();
                    buffer.append(atthgInfo.getNumberGroup());
                }
                if (buffer.length() > 0) {
                    buffer.append(")");
                }
            }
            r_accountAsstAcctname = r_accountAsstAcctname + buffer.toString();
            rs.updateString("r_accountAsst", r_accountAsstAcctname);
            rs.updateString("r_accountAsstPrimItem", acctname);
            rs.updateString("zc_account", zc_acctname);
            if (e.getAssistRecords() == null || e.getAssistRecords().size() == 0) {
                String accountLongName = GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account");
                String accountDetail = "";
                accountDetail = accountLongName.indexOf("_", 0) != -1 ? accountLongName.substring(accountLongName.indexOf("_", 0) + 1, accountLongName.length()) : accountLongName.substring(accountLongName.indexOf("-", 0) + 1, accountLongName.length());
                if (accountDetail != null && !"".equals(accountDetail.trim())) {
                    rs.updateString("zc_assGrp", accountDetail);
                } else {
                    rs.updateString("zc_assGrp", GlUtils.getName((IObjectValue)e, (String)"account"));
                }
            }
            if (e.getAccount() != null && e.getAccount().isIsQty()) {
                if (e.getMeasureUnit() != null) {
                    rs.updateString("e_measureUnitName", e.getMeasureUnit().getName());
                    rs.updateString("e_measureUnitNumber", e.getMeasureUnit().getNumber());
                }
                rs.updateString("e_price", GlUtils.formatNumber((BigDecimal)e.getPrice(), (int)this.pricePre));
                rs.updateString("e_quantity", GlUtils.formatNumber((BigDecimal)e.getQuantity(), (int)this.qtyPre));
            }
            if (e.getCustomer() != null) {
                rs.updateString("customer.number", e.getCustomer().getNumber());
                rs.updateString("customer.name", e.getCustomer().getName());
                rs.updateString("cusNumberName", e.getCustomer().getNumber() + "\uff1a" + e.getCustomer().getName());
            }
            if (this.commonVoucherProcess) {
                ProfitCenterOrgUnitInfo p = null;
                if (e instanceof VoucherEntryInfo) {
                    p = ((VoucherEntryInfo)e).getProfitCenter();
                }
                rs.updateString("e_profitCenter", p == null ? "" : p.getName());
            }
            rs.updateString("e_currency", GlUtils.getName((IObjectValue)e, (String)"currency"));
            if (e.getCurrency() != null) {
                rs.updateString("e_isoCode", e.getCurrency().getIsoCode());
                rs.updateString("e_localExchangeRate", GlUtils.formatNumber((BigDecimal)e.getLocalExchangeRate()));
                rs.updateString("e_reportingExchangeRate", GlUtils.formatNumber((BigDecimal)e.getReportingExchangeRate()));
            }
            rs.updateString("e_originalAmount", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
            rs.updateString("r_originalAmount", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
            EntryDC dc = e.getEntryDC();
            if (EntryDC.DEBIT.equals((Object)dc)) {
                rs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                rs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                rs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                rs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                rs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                rs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
            } else {
                rs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                rs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                rs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                rs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                rs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                rs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
            }
        }

        private String getR_accountAsstAcctname(IObjectValue obj, String prop) {
            IObjectValue val = (IObjectValue)obj.get(prop);
            if (val == null) {
                return null;
            }
            String number = val.get("number") + "";
            String longName = val.get("longName") + "";
            return number + " - " + longName;
        }

        public void fillVoucherASSTData(BaseVoucherAssistRecordInfo r, IRowSet rs, DateFormat adf, int lcpre, EntryDC dc, IAssistantHG assistantHG, IBaseVoucherAssistRecord asstre, BaseVoucherEntryInfo e, String companyId) throws Exception {
            String acctname = rs.getString("e_account");
            rs.updateString("r_description", r.getDescription());
            if (rs.getString("r_description") == null) {
                rs.updateString("r_description", e.getDescription());
            }
            if (r.getMeasureUnit() != null) {
                rs.updateString("r_measureUnitName", r.getMeasureUnit().getName());
                rs.updateString("r_measureUnitNumber", r.getMeasureUnit().getNumber());
                rs.updateString("e_measureUnitName", r.getMeasureUnit().getName());
                rs.updateString("e_measureUnitNumber", r.getMeasureUnit().getNumber());
            }
            if (r.getSettlementType() != null) {
                rs.updateString("r_settlementType", r.getSettlementType().getDisplayName());
            }
            if (e.getAccount() != null && e.getAccount().isAC()) {
                if (r.getEndDate() != null) {
                    rs.updateDate("r_endDate", new Date(r.getEndDate().getTime()));
                } else {
                    rs.updateString("r_endDate", "");
                }
            } else {
                rs.updateString("r_endDate", "");
            }
            rs.updateString("r_settlementCode", r.getSettlementCode());
            rs.updateString("r_bizNumber", r.getBizNumber());
            rs.updateDate("r_bizDate", new Date(r.getBizDate().getTime()));
            rs.updateString("r_invoice", r.getInvoiceNumber());
            if (EntryDC.DEBIT.equals((Object)dc)) {
                rs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)r.getOriginalAmount(), (int)lcpre));
                rs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)r.getLocalAmount(), (int)lcpre));
                rs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)r.getReportingAmount(), (int)lcpre));
                rs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)r.getOriginalAmount(), (int)lcpre));
                rs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)r.getLocalAmount(), (int)lcpre));
                rs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)r.getReportingAmount(), (int)lcpre));
            } else {
                rs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)r.getLocalAmount(), (int)lcpre));
                rs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)r.getOriginalAmount(), (int)lcpre));
                rs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)r.getReportingAmount(), (int)lcpre));
                rs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)r.getOriginalAmount(), (int)lcpre));
                rs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)r.getLocalAmount(), (int)lcpre));
                rs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)r.getReportingAmount(), (int)lcpre));
            }
            rs.updateString("r_originalAmount", GlUtils.formatNumber((BigDecimal)r.getOriginalAmount(), (int)lcpre));
            rs.updateString("r_reportingAmount", GlUtils.formatNumber((BigDecimal)r.getReportingAmount(), (int)lcpre));
            rs.updateString("r_localAmount", GlUtils.formatNumber((BigDecimal)r.getLocalAmount(), (int)lcpre));
            String assGrpId = null;
            String name = null;
            String fullName = null;
            String levelName = null;
            String assGrp = null;
            String assGrpNumber = null;
            String asstFull = null;
            String asstFullNumber = null;
            String asstheadnumber = null;
            String asstnumber = null;
            String asstShortNumber = null;
            String asstheadname = null;
            String asstname = null;
            String asstlevelname = null;
            String asstLevelNameNumber = null;
            String zc_listacctname = "";
            AssistantHGInfo assistantHGInfo = r.getAssGrp();
            if (assistantHGInfo != null) {
                if (e.getAccount().getCAA() != null && e.getAccount().isIsQty() && (e.getAccount().getCAA().isIsQty() || !this.isAstQty)) {
                    rs.updateString("r_price", GlUtils.formatNumber((BigDecimal)r.getPrice(), (int)this.pricePre));
                    rs.updateString("r_quantity", GlUtils.formatNumber((BigDecimal)r.getQuantity(), (int)this.qtyPre));
                    rs.updateString("e_price", GlUtils.formatNumber((BigDecimal)r.getPrice(), (int)this.pricePre));
                    rs.updateString("e_quantity", GlUtils.formatNumber((BigDecimal)r.getQuantity(), (int)this.qtyPre));
                }
                IObjectValue value = null;
                assGrpId = assistantHGInfo.getId().toString();
                levelName = this.settingInfo.isShowAsstFullName() ? this.getAsstribute("r_AsstLevelNameNumber", assGrpId) : this.getAsstribute("r_AsstLevelName", assGrpId);
                if (this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                    fullName = this.getAsstribute("r_asstFullNumber", assGrpId);
                } else if (this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                    fullName = this.getAsstribute("r_asstFull", assGrpId);
                } else if (!this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                    fullName = this.getAsstribute("r_assGrp", assGrpId);
                } else if (!this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                    fullName = this.getAsstribute("r_assGrpNumber", assGrpId);
                }
                assGrp = this.getAsstribute("assGrp", assGrpId);
                assGrpNumber = this.getAsstribute("assGrpNumber", assGrpId);
                asstFull = this.getAsstribute("asstFull", assGrpId);
                asstFullNumber = this.getAsstribute("asstFullNumber", assGrpId);
                asstheadnumber = this.getAsstribute("r_AsstHeadNumber", assGrpId);
                asstnumber = this.getAsstribute("r_AsstNumber", assGrpId);
                asstShortNumber = this.getAsstribute("r_AsstShortNumber", assGrpId);
                asstheadname = this.getAsstribute("r_AsstHeadName", assGrpId);
                asstname = this.getAsstribute("r_AsstName", assGrpId);
                asstlevelname = this.getAsstribute("r_AsstLevelName", assGrpId);
                asstLevelNameNumber = this.getAsstribute("r_AsstLevelNameNumber", assGrpId);
                if (name == null) {
                    value = this.getAsstValue(r.getAssGrp().getId().toString(), assistantHG, asstre);
                    assGrp = value.getString("assGrp");
                    this.setAsstribute("r_assGrp", assGrpId, assGrp);
                    asstnumber = value.getString("asstnumber");
                    this.setAsstribute("r_AsstNumber", assGrpId, asstnumber);
                    asstShortNumber = value.getString("asstShortNumber");
                    this.setAsstribute("r_AsstShortNumber", assGrpId, asstShortNumber);
                    assGrpNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("assGrpNumber"));
                    this.setAsstribute("r_assGrpNumber", assGrpId, assGrpNumber);
                    asstFull = value.getString("asstFull");
                    this.setAsstribute("r_asstFull", assGrpId, asstFull);
                    asstFullNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstFullNumber"));
                    this.setAsstribute("r_asstFullNumber", assGrpId, asstFullNumber);
                    asstheadnumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstheadnumber"));
                    this.setAsstribute("r_AsstHeadNumber", assGrpId, asstheadnumber);
                    asstheadname = value.getString("asstheadname");
                    this.setAsstribute("r_AsstHeadName", assGrpId, asstheadname);
                    asstname = "";
                    String tempasstheadname = this.getStr(asstheadname);
                    if (!"".equals(tempasstheadname)) {
                        String[] cutByFs = tempasstheadname.split(";");
                        for (int i = 0; i < cutByFs.length; ++i) {
                            String[] cutByMs = cutByFs[i].split(":");
                            if (cutByMs.length < 2) continue;
                            asstname = asstname + cutByMs[1] + ";";
                        }
                    }
                    asstname = asstname.substring(0, asstname.length() > 0 ? asstname.length() - 1 : 0);
                    this.setAsstribute("r_AsstName", assGrpId, asstname);
                    asstlevelname = value.getString("asstlevelname");
                    this.setAsstribute("r_AsstLevelName", assGrpId, asstlevelname);
                    asstLevelNameNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstLevelNameNumber"));
                    this.setAsstribute("r_AsstLevelNameNumber", assGrpId, asstLevelNameNumber);
                    levelName = this.settingInfo.isShowAsstFullName() ? asstLevelNameNumber : asstlevelname;
                    if (this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                        fullName = asstFullNumber;
                        name = this.getNameAndAssGrpNumber(asstheadname, asstnumber, asstlevelname);
                    } else if (this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                        name = fullName = asstFull;
                    } else if (!this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                        name = fullName = assGrp;
                    } else if (!this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                        fullName = assGrpNumber;
                        name = this.getNameAndAssGrpNumber(asstheadname, asstnumber, asstname);
                    }
                }
                fullName = assGrpNumber;
                acctname = this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account") : (!this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getLongName((IObjectValue)e, (String)"account") : (this.settingInfo.isShowAccountNumber() && !this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndName((IObjectValue)e, (String)"account") : GlUtils.getName((IObjectValue)e, (String)"account")));
                String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account");
                zc_listacctname = acctnameZC.indexOf("_", 0) != -1 ? acctnameZC.substring(acctnameZC.indexOf("_", 0) + 1, acctnameZC.length()) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 1, acctnameZC.length());
            } else {
                String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account");
                zc_listacctname = acctnameZC.indexOf("_", 0) != -1 ? acctnameZC.substring(acctnameZC.indexOf("_", 0) + 1, acctnameZC.length()) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 1, acctnameZC.length());
            }
            String accountNumber = GlUtils.getNumber((IObjectValue)e, (String)"account");
            if (fullName == null || "null".equals(fullName)) {
                name = fullName = "";
            }
            String name_refactory = this.getStr(name);
            String fullName_refactory = "";
            if (fullName != null && !"null".equals(fullName) && fullName.length() > 0 && this.getStr(fullName) != null && this.getStr(fullName).length() > 0) {
                fullName_refactory = "(" + this.getStr(fullName) + ")";
            }
            if (!this.settingInfo.isNotPrintSelectedAccountAsst()) {
                rs.updateString("r_assGrp", name_refactory);
                rs.updateString("r_longName", this.getStr(fullName));
                rs.updateString("r_AsstHeadNumber", asstheadnumber);
                rs.updateString("r_AsstNumber", this.generalAsstShowLongNumber ? asstnumber : asstShortNumber);
                rs.updateString("r_AsstHeadName", asstheadname);
                rs.updateString("r_AsstName", asstname);
                rs.updateString("r_AsstLevelName", levelName);
                rs.updateString("r_accountAsst", accountNumber + " - " + acctname + "" + fullName_refactory + "");
                rs.updateString("zc_assGrp", zc_listacctname + "" + fullName_refactory + "");
                rs.updateString("r_accountAsstPrimItem", acctname + "" + fullName_refactory + "");
            } else if (this.settingInfo.isNotPrintSelectedAccountAsst() && !this.balanceAccountIsInExistence(accountNumber)) {
                rs.updateString("r_assGrp", name_refactory);
                rs.updateString("r_longName", fullName_refactory);
                rs.updateString("r_AsstHeadNumber", asstheadnumber);
                rs.updateString("r_AsstNumber", this.generalAsstShowLongNumber ? asstnumber : asstShortNumber);
                rs.updateString("r_AsstHeadName", asstheadname);
                rs.updateString("r_AsstName", asstname);
                rs.updateString("r_AsstLevelName", levelName);
                rs.updateString("r_accountAsst", accountNumber + " - " + acctname + "" + fullName_refactory + "");
                rs.updateString("zc_assGrp", zc_listacctname + "" + this.getStr(fullName) + "");
                rs.updateString("r_accountAsstPrimItem", acctname + "" + fullName_refactory + "");
            } else {
                rs.updateString("r_assGrp", "");
                rs.updateString("r_longName", "");
                rs.updateString("r_AsstHeadNumber", "");
                rs.updateString("r_AsstNumber", "");
                rs.updateString("r_AsstHeadName", "");
                rs.updateString("r_AsstName", "");
                rs.updateString("r_AsstLevelName", "");
                rs.updateString("r_accountAsst", accountNumber + " - " + acctname + "" + fullName_refactory + "");
                rs.updateString("r_accountAsstPrimItem", "");
                rs.updateString("zc_assGrp", "");
                rs.updateString("r_description", e.getDescription());
            }
        }

        private String getNameAndAssGrpNumber(String asstheadname, String asstnumber, String asstname) {
            String newAsstnumber = asstnumber.substring(0, asstnumber.length() - 1);
            String[] split = asstheadname.split(":");
            StringBuffer sb = new StringBuffer();
            sb.append(split[0]).append(":").append(newAsstnumber).append("_").append(asstname).append(asstnumber.substring(asstnumber.length() - 1, asstnumber.length()));
            return sb.toString();
        }

        protected void printCashflow(DynamicRowSet drs, VoucherEntryInfo e, VoucherAssistRecordInfo r, int lcpre) throws Exception {
            StringBuffer sbOriginalAmount = new StringBuffer();
            StringBuffer sblocalAmount = new StringBuffer();
            StringBuffer sbreportingAmount = new StringBuffer();
            StringBuffer sbprimItem = new StringBuffer();
            StringBuffer sbitem = new StringBuffer();
            StringBuffer sbitemEbb = new StringBuffer();
            StringBuffer sbsuppItem = new StringBuffer();
            StringBuffer sbsupp = new StringBuffer();
            StringBuffer sbsuppEbb = new StringBuffer();
            StringBuffer sbfullInfoItem = new StringBuffer();
            StringBuffer sbfullInfo = new StringBuffer();
            StringBuffer sbfullInfoEbb = new StringBuffer();
            BigDecimal bdPrimary = null;
            BigDecimal bdSupp = null;
            CashflowRecordCollection cashflowRecordsCollection = null;
            int seq = e.getSeq();
            cashflowRecordsCollection = this.settingInfo.isPrintCashflowMeOrOther() ? e.getCashflowEntry() : e.getCashflowRecords();
            if (cashflowRecordsCollection != null && cashflowRecordsCollection.size() > 0) {
                for (CashflowRecordInfo cfrInfo : cashflowRecordsCollection) {
                    CashFlowItemInfo cfInfo_fullInfoItem;
                    CashFlowItemInfo cfinfo_suppItem;
                    if (cfrInfo.getItemFlag() == null || cfrInfo.getItemFlag().getValue() == 5 || (this.settingInfo.isPrintCashflowMeOrOther() ? seq != cfrInfo.getEntry().getSeq() : seq != cfrInfo.getOpposingAccountEntry().getSeq() || r != null && (cfrInfo.getItemFlag().getValue() == 1 || cfrInfo.getItemFlag().getValue() == 2 || cfrInfo.getItemFlag().getValue() == 3) && cfrInfo.getOppVoucherAssistRecord() != null && r.getSeq() != cfrInfo.getOppVoucherAssistRecord().getSeq())) continue;
                    bdPrimary = new BigDecimal(String.valueOf(cfrInfo.getPrimaryCoefficient()));
                    bdSupp = new BigDecimal(String.valueOf(cfrInfo.getSupplementaryCoefficient()));
                    sbOriginalAmount.append(GlUtils.formatNumber((BigDecimal)cfrInfo.getOriginalAmount(), (int)lcpre) + ";");
                    sblocalAmount.append(GlUtils.formatNumber((BigDecimal)cfrInfo.getLocalAmount(), (int)lcpre) + ";");
                    sbreportingAmount.append(GlUtils.formatNumber((BigDecimal)cfrInfo.getReportingAmount(), (int)lcpre) + ";");
                    drs.updateString("c_originalAmount", sbOriginalAmount.toString());
                    drs.updateString("c_localAmount", sblocalAmount.toString());
                    drs.updateString("c_reportingAmount", sbreportingAmount.toString());
                    CashFlowItemInfo cfinfo_primItem = cfrInfo.getPrimaryItem();
                    if (cfinfo_primItem != null) {
                        String str_primItem_number = cfinfo_primItem.getNumber();
                        String str_primItem_name = cfinfo_primItem.getName();
                        sbprimItem.append(str_primItem_number + str_primItem_name + ";");
                        sbitem.append(cfinfo_primItem + GlUtils.formatNumber((BigDecimal)cfrInfo.getLocalAmount().multiply(bdPrimary), (int)lcpre) + ";");
                        sbitemEbb.append("(" + str_primItem_name + ")" + GlUtils.formatNumber((BigDecimal)cfrInfo.getLocalAmount().multiply(bdPrimary), (int)lcpre) + ";");
                        drs.updateString("c_primItem", sbprimItem.toString());
                        drs.updateString("c_item", sbitem.toString());
                        drs.updateString("c_itemEbb", sbitemEbb.toString());
                        drs.updateString("c_primItemName", str_primItem_name + ";");
                        drs.updateString("r_accountAsstPrimItem", drs.getString("r_accountAsstPrimItem") + " " + str_primItem_name);
                        ICashflowRecord recCtrl = CashflowRecordFactory.getLocalInstance((Context)this.ctx);
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("id"));
                        selector.add(new SelectorItemInfo("assGrp.id"));
                        CashflowRecordInfo info = (CashflowRecordInfo)recCtrl.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cfrInfo.getId().toString())), selector);
                        if (info.getAssGrp() != null) {
                            String[] rem_cut_DisplayNameGroup;
                            int i;
                            String[] cut_DisplayNameGroup;
                            StringBuffer displayNameGp;
                            selector.clear();
                            selector.add(new SelectorItemInfo("longNameGroup"));
                            selector.add(new SelectorItemInfo("disPlayNameGroup"));
                            selector.add(new SelectorItemInfo("numberGroup"));
                            AssistantHGInfo assistantHGInfo = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getAssGrp().get("id").toString())), selector);
                            StringBuffer name = new StringBuffer();
                            String[] names = assistantHGInfo.getLongNameGroup().split(";");
                            for (int i2 = 0; i2 < names.length; ++i2) {
                                name.append(names[i2].split(":")[1]).append(";");
                            }
                            String displayNameGroup = assistantHGInfo.getDisplayNameGroup();
                            if (!this.settingInfo.isShowAsstFullName()) {
                                displayNameGp = new StringBuffer();
                                cut_DisplayNameGroup = displayNameGroup.split(";");
                                for (i = 0; i < cut_DisplayNameGroup.length; ++i) {
                                    rem_cut_DisplayNameGroup = cut_DisplayNameGroup[i].split("!");
                                    String[] LongNameGroups = assistantHGInfo.getLongNameGroup().split(";");
                                    displayNameGp.append(rem_cut_DisplayNameGroup[0]).append("!").append(LongNameGroups[i].split(":")[1]).append(";");
                                }
                                displayNameGroup = displayNameGp.toString();
                            }
                            if (!this.settingInfo.isShowAsstNumber()) {
                                displayNameGp = new StringBuffer();
                                cut_DisplayNameGroup = displayNameGroup.split(";");
                                for (i = 0; i < cut_DisplayNameGroup.length; ++i) {
                                    rem_cut_DisplayNameGroup = cut_DisplayNameGroup[i].split("!");
                                    displayNameGp.append(rem_cut_DisplayNameGroup[0].split(":")[0]).append(":");
                                    displayNameGp.append(rem_cut_DisplayNameGroup[1]).append(";");
                                }
                                displayNameGroup = displayNameGp.toString();
                            }
                            drs.updateString("c_asstactName", name.toString().substring(0, name.toString().length() - 1));
                            if (this.settingInfo.isShowAsstNumber()) {
                                StringBuffer number = new StringBuffer();
                                String[] numberGroup = assistantHGInfo.getNumberGroup().split(";");
                                for (i = 0; i < numberGroup.length; ++i) {
                                    String[] numbers = numberGroup[i].split(":");
                                    number.append(numbers[1].split("_!")[0]).append(";");
                                }
                                drs.updateString("c_asstactNumber", number.toString().substring(0, number.toString().length() - 1));
                            } else {
                                drs.updateString("c_asstactNumber", "");
                            }
                            drs.updateString("c_asstactLongGroupName", assistantHGInfo.getLongNameGroup());
                            drs.updateString("c_asstactDisplayNameGroup", cfinfo_primItem.getName() + "(" + displayNameGroup.replaceAll("!", "") + ")");
                            drs.updateString("c_cashFlowAndAsstactGoupName", cfinfo_primItem.getName() + "(" + assistantHGInfo.getLongNameGroup() + ")");
                        }
                    }
                    if ((cfinfo_suppItem = cfrInfo.getSupplementaryItem()) != null) {
                        String str_suppItem_number = cfinfo_suppItem.getNumber();
                        String str_suppItem_name = cfinfo_suppItem.getName();
                        sbsuppItem.append(str_suppItem_number + str_suppItem_name + ";");
                        sbsupp.append(cfinfo_suppItem + GlUtils.formatNumber((BigDecimal)cfrInfo.getLocalAmount().multiply(bdSupp), (int)lcpre) + ";");
                        sbsuppEbb.append("(" + str_suppItem_name + ")" + GlUtils.formatNumber((BigDecimal)cfrInfo.getLocalAmount().multiply(bdSupp), (int)lcpre) + ";");
                        drs.updateString("c_suppItem", sbsuppItem.toString());
                        drs.updateString("c_supp", sbsupp.toString());
                        drs.updateString("c_suppEbb", sbsuppEbb.toString());
                        drs.updateString("c_suppItemName", str_suppItem_name + ";");
                    }
                    if ((cfInfo_fullInfoItem = cfrInfo.getFullInfoItem()) == null) continue;
                    String str_fullInfoItem_number = cfInfo_fullInfoItem.getNumber();
                    String str_fullInfoItem_name = cfInfo_fullInfoItem.getName();
                    sbfullInfoItem.append(str_fullInfoItem_number + str_fullInfoItem_name + ";");
                    sbfullInfo.append(str_fullInfoItem_number + str_fullInfoItem_name + GlUtils.formatNumber((BigDecimal)cfrInfo.getLocalAmount(), (int)lcpre) + ";");
                    sbfullInfoEbb.append("(" + str_fullInfoItem_name + ")" + GlUtils.formatNumber((BigDecimal)cfrInfo.getLocalAmount(), (int)lcpre) + ";");
                    drs.updateString("c_fullInfoItem", sbfullInfoItem.toString());
                    drs.updateString("c_fullInfo", sbfullInfo.toString());
                    drs.updateString("c_fullInfoEbb", sbfullInfoEbb.toString());
                }
            }
        }

        private String getAsstribute(String asstribute, String id) {
            Map<String, String> map = null;
            String name = null;
            if (this.asstributeMap == null) {
                this.asstributeMap = new HashMap();
            }
            if (this.asstributeMap.containsKey(asstribute)) {
                map = (Map)this.asstributeMap.get(asstribute);
            } else {
                map = new HashMap();
                this.asstributeMap.put(asstribute, map);
            }
            if (map.containsKey(id)) {
                name = (String)map.get(id);
                map.put(id, name);
            }
            return name;
        }

        private void setAsstribute(String asstribute, String id, String value) {
            Map<String, String> map = null;
            if (this.asstributeMap == null) {
                this.asstributeMap = new HashMap();
            }
            if (this.asstributeMap.containsKey(asstribute)) {
                map = (Map)this.asstributeMap.get(asstribute);
            } else {
                map = new HashMap();
                this.asstributeMap.put(asstribute, map);
            }
            if (!map.containsKey(id)) {
                map.put(id, value);
            }
        }

        private IObjectValue getAsstValue(String assGrpId, IAssistantHG assistantHG, IBaseVoucherAssistRecord asstre) throws EASBizException, BOSException {
            if (assistantHG == null) {
                assistantHG = AssistantHGFactory.getLocalInstance((Context)this.ctx);
            }
            ObjectUuidPK objectUUidPK = new ObjectUuidPK(assGrpId);
            AssistantHGInfo info = assistantHG.getAssistantHGInfo((IObjectPK)objectUUidPK);
            if (asstre == null) {
                asstre = VoucherAssistRecordFactory.getLocalInstance((Context)this.ctx);
            }
            IObjectValue value = asstre.getDefaultAssitInfo(info.getAsstAccount().getId().toString(), assGrpId.toString());
            return value;
        }

        private String processGL_064(String asstnumber, String asstShortNumber, String toProcess) {
            if (this.generalAsstShowLongNumber || asstnumber == null || asstShortNumber == null || toProcess == null || asstnumber.equals(asstShortNumber)) {
                return toProcess;
            }
            String[] longNumber = asstnumber.split(";");
            String[] shortNumber = asstShortNumber.split(";");
            String[] process = toProcess.split(";");
            StringBuffer newStr = new StringBuffer();
            int j = process.length;
            for (int i = 0; i < j; ++i) {
                newStr.append(process[i].replace(longNumber[i], shortNumber[i]));
                newStr.append(";");
            }
            return newStr.toString();
        }

        private String getStr(String name) {
            String string = "";
            String[] names = null;
            if (name != null) {
                names = StringUtils.split((String)name, (String)";");
                String[] asstActList = this.getAsstActList();
                if (asstActList != null) {
                    for (int i = 0; i < names.length; ++i) {
                        String s = names[i];
                        String[] temp = s.split(":");
                        for (int j = 0; j < asstActList.length; ++j) {
                            String asst = asstActList[j];
                            if (temp[0].toString().indexOf(asst.split("-")[1].toString()) == -1) continue;
                            names[i] = "";
                        }
                    }
                }
            }
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (names[i] == null || names[i].length() == 0) continue;
                    if (string.length() > 0 && !")".equals(names[i]) && !"(".equals(names[i])) {
                        string = string + ";";
                    }
                    string = string + names[i];
                }
            }
            if (string.indexOf("(") != -1 && string.indexOf(")") != -1) {
                return string;
            }
            if (string.indexOf(")") != -1 && string.indexOf(")") != 0 && string.indexOf("(") == -1) {
                string = "(" + string;
            } else if (string.indexOf(")") == 0) {
                string = "";
            }
            return string;
        }

        private String[] getAsstActList() {
            if (this.settingInfo.isNotPrintSelectedAss()) {
                String[] asstActList = StringUtils.split((String)this.settingInfo.getSeleectedAsstList(), (String)",");
                return asstActList;
            }
            return null;
        }

        private boolean balanceAccountIsInExistence(String strAccountNumber) throws Exception {
            boolean isInExistence = false;
            if (this.settingInfo.getSelectedAccountList().length() != 0) {
                String[] objToSelect = this.settingInfo.getSelectedAccountList().split("\\,");
                Object[] objSelectNumber = new Object[objToSelect.length];
                int n = objToSelect.length;
                for (int i = 0; i < n; ++i) {
                    String[] objTemp = objToSelect[i].toString().split("\\ ");
                    objSelectNumber[i] = objTemp[0];
                }
                int m = objSelectNumber.length;
                for (int j = 0; j < m; ++j) {
                    if (!strAccountNumber.equalsIgnoreCase(objSelectNumber[j].toString())) continue;
                    isInExistence = true;
                }
                return isInExistence;
            }
            return isInExistence;
        }

        public void clearRow(IRowSet rs) throws Exception {
            int colCount = rs.getRowSetMetaData().getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                rs.updateString(i, null);
            }
        }

        public boolean isAstQty() {
            return this.isAstQty;
        }

        public void initGLMap(String companyId) throws EASBizException, BOSException {
            Object pre;
            if (this.mapPrecision == null) {
                this.mapPrecision = new HashMap();
            }
            if ((pre = this.mapPrecision.get(companyId)) != null) {
                String[] pres = ((String)pre).split(":");
                this.qtyPre = Integer.valueOf(pres[0]);
                this.pricePre = Integer.valueOf(pres[1]);
                if (this.mapPrecision.get(companyId + "GL_064") != null) {
                    this.generalAsstShowLongNumber = Boolean.valueOf(this.mapPrecision.get(companyId + "GL_064").toString());
                }
                if (this.mapPrecision.get(companyId + "GL_111") != null) {
                    this.commonVoucherProcess = Boolean.valueOf(this.mapPrecision.get(companyId + "GL_111").toString());
                }
            } else {
                HashMap<String, String> hmParamIn = new HashMap<String, String>();
                hmParamIn.put("GL_002", companyId);
                hmParamIn.put("GL_003", companyId);
                hmParamIn.put("GL_064", companyId);
                hmParamIn.put("GL_111", companyId);
                HashMap params = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(hmParamIn);
                this.qtyPre = Integer.parseInt(params.get("GL_002").toString());
                this.pricePre = Integer.parseInt(params.get("GL_003").toString());
                this.mapPrecision.put(companyId, this.qtyPre + ":" + this.pricePre);
                this.mapPrecision.put(companyId + "GL_064", params.get("GL_064").toString());
                this.mapPrecision.put(companyId + "GL_111", params.get("GL_111").toString());
                this.commonVoucherProcess = Boolean.valueOf(params.get("GL_111").toString());
            }
        }
    }

    public class VoucherRowSetProvider
    implements BOSQueryDelegate {
        private final Logger logger = Logger.getLogger(VoucherRowSetProvider.class);
        private Locale locale;
        private DateFormat df;
        private DateFormat dft;
        private Context ctx;
        private VoucherCollection vchCol;
        private VoucherPrintSettingInfo settingInfo;
        private VoucherPrintDataProvider provider;

        public VoucherRowSetProvider(Locale locale, VoucherCollection vc, VoucherPrintSettingInfo settingInfo, Context ctx) throws EASBizException, BOSException {
            this.locale = locale;
            if (this.locale == null) {
                this.locale = SysContext.getSysContext().getLocale();
            }
            this.df = new SimpleDateFormat(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI", (Locale)this.locale));
            this.dft = DateFormat.getDateTimeInstance(2, 2, this.locale);
            this.vchCol = vc;
            this.settingInfo = settingInfo;
            this.ctx = ctx;
            this.provider = new VoucherPrintDataProvider(settingInfo, ctx);
        }

        public VoucherRowSetProvider(VoucherCollection vc, VoucherPrintSettingInfo settingInfo, Context ctx) throws EASBizException, BOSException {
            this(null, vc, settingInfo, ctx);
        }

        public IRowSet execute(BOSQueryDataSource ds) {
            return this.getRowSet(ds.getID());
        }

        public IRowSet getRowSet(String dsId) {
            this.logger.error((Object)("dsId:" + dsId));
            IRowSet rs = null;
            for (int i = 4; i <= 30; ++i) {
                if (("dsStandard" + i).equalsIgnoreCase(dsId)) {
                    rs = this.getRowSet(false, i);
                    break;
                }
                if (("flowStandard" + i).equalsIgnoreCase(dsId)) {
                    rs = this.getRowSetFlow(false, i);
                    break;
                }
                if (("ds1_Standard" + i).equalsIgnoreCase(dsId)) {
                    rs = this.getRowSet(true, i);
                    break;
                }
                if (("flow1_Standard" + i).equalsIgnoreCase(dsId)) {
                    rs = this.getRowSetFlow(true, i);
                    break;
                }
                if (("ds2_subtotal" + i).equalsIgnoreCase(dsId)) {
                    rs = this.getRowSet2(i);
                    break;
                }
                if (("ds" + i).equalsIgnoreCase(dsId)) {
                    rs = this.getRowSet3(i);
                    break;
                }
                if (("voucher_ds" + i).equalsIgnoreCase(dsId)) {
                    rs = this.getRowSet4(i);
                    break;
                }
                if (!("vchFlow" + i).equalsIgnoreCase(dsId)) continue;
                rs = this.getRowSet5(i);
                break;
            }
            return rs;
        }

        private IRowSet getRowSet(boolean pltype, int rowLineCount) {
            int colCount = VoucherPrintDataProvider.col.length;
            DynamicRowSet drs = null;
            try {
                drs = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo ci = new ColInfo();
                    ci.colType = 12;
                    ci.columnName = VoucherPrintDataProvider.col[i];
                    ci.nullable = 1;
                    drs.setColInfo(i + 1, ci);
                }
                drs.beforeFirst();
                Iterator itrVch = this.vchCol.iterator();
                int size = this.vchCol.size();
                BigDecimal allDeit = SysConstant.BIGZERO;
                BigDecimal allCret = SysConstant.BIGZERO;
                int vchCount = 0;
                while (itrVch.hasNext()) {
                    int lcpre;
                    VoucherInfo vch = (VoucherInfo)itrVch.next();
                    if (pltype && this.computerVoucherType(vch)) {
                        vch = this.changeVoucher(vch);
                    }
                    ++vchCount;
                    String vchId = null;
                    if (null != vch.getId()) {
                        vchId = vch.getId().toString();
                    }
                    CompanyOrgUnitInfo com = vch.getCompany();
                    CurrencyInfo localCurrency = com.getBaseCurrency();
                    int rcpre = lcpre = localCurrency.getPrecision();
                    CurrencyInfo reportingCurrency = com.getReportCurrency();
                    if (reportingCurrency != null) {
                        rcpre = reportingCurrency.getPrecision();
                    }
                    allDeit = vch.getLocalDebitAmount();
                    allCret = vch.getLocalCreditAmount();
                    Iterator itrEntry = vch.getEntries().iterator();
                    int entrySize = vch.getEntries().size();
                    int voucherCount = 0;
                    voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                    int entryCount = 1;
                    while (itrEntry.hasNext()) {
                        VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                        }
                        drs.insertRow();
                    }
                }
                drs.beforeFirst();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Get rowset error!", (Throwable)ex);
                return null;
            }
            return drs;
        }

        private IRowSet getRowSetFlow(boolean pltype, int rowLineCount) {
            int colCount = VoucherPrintDataProvider.col.length;
            DynamicRowSet drs = null;
            try {
                drs = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo ci = new ColInfo();
                    ci.colType = 12;
                    ci.columnName = VoucherPrintDataProvider.col[i];
                    ci.nullable = 1;
                    drs.setColInfo(i + 1, ci);
                }
                drs.beforeFirst();
                Iterator itrVch = this.vchCol.iterator();
                int size = this.vchCol.size();
                BigDecimal allDeit = SysConstant.BIGZERO;
                BigDecimal allCret = SysConstant.BIGZERO;
                int vchCount = 0;
                while (itrVch.hasNext()) {
                    int lcpre;
                    VoucherInfo vch = (VoucherInfo)itrVch.next();
                    if (pltype && this.computerVoucherType(vch)) {
                        vch = this.changeVoucher(vch);
                    }
                    ++vchCount;
                    String vchId = null;
                    if (null != vch.getId()) {
                        vchId = vch.getId().toString();
                    }
                    CompanyOrgUnitInfo com = vch.getCompany();
                    CurrencyInfo localCurrency = com.getBaseCurrency();
                    int rcpre = lcpre = localCurrency.getPrecision();
                    CurrencyInfo reportingCurrency = com.getReportCurrency();
                    if (reportingCurrency != null) {
                        rcpre = reportingCurrency.getPrecision();
                    }
                    allDeit = vch.getLocalDebitAmount();
                    allCret = vch.getLocalCreditAmount();
                    Iterator itrEntry = vch.getEntries().iterator();
                    int entrySize = vch.getEntries().size();
                    int voucherCount = 0;
                    voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                    int entryCount = 1;
                    while (itrEntry.hasNext()) {
                        VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                        EntryDC dc = e.getEntryDC();
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                        }
                        if (this.settingInfo.isPrintCashFlow()) {
                            this.provider.printCashflow(drs, e, null, lcpre);
                        }
                        drs.insertRow();
                    }
                }
                drs.beforeFirst();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Get rowset error!", (Throwable)ex);
                return null;
            }
            return drs;
        }

        private IRowSet getRowSet2(int rowLineCount) {
            int colCount = VoucherPrintDataProvider.col.length;
            DynamicRowSet drs = null;
            IAssistantHG assistantHG = null;
            IBaseVoucherAssistRecord asstre = null;
            try {
                drs = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo ci = new ColInfo();
                    ci.colType = 12;
                    ci.columnName = VoucherPrintDataProvider.col[i];
                    ci.nullable = 1;
                    drs.setColInfo(i + 1, ci);
                }
                drs.beforeFirst();
                Iterator itrVch = this.vchCol.iterator();
                int size = this.vchCol.size();
                BigDecimal allDeit = SysConstant.BIGZERO;
                BigDecimal allCret = SysConstant.BIGZERO;
                int vchCount = 0;
                while (itrVch.hasNext()) {
                    int lcpre;
                    VoucherInfo vch = (VoucherInfo)itrVch.next();
                    ++vchCount;
                    String vchId = null;
                    if (null != vch.getId()) {
                        vchId = vch.getId().toString();
                    }
                    CompanyOrgUnitInfo com = vch.getCompany();
                    CurrencyInfo localCurrency = com.getBaseCurrency();
                    int rcpre = lcpre = localCurrency.getPrecision();
                    CurrencyInfo reportingCurrency = com.getReportCurrency();
                    if (reportingCurrency != null) {
                        rcpre = reportingCurrency.getPrecision();
                    }
                    allDeit = vch.getLocalDebitAmount();
                    allCret = vch.getLocalCreditAmount();
                    Iterator itr = vch.getEntries().iterator();
                    int entrySize = 0;
                    int seq = 0;
                    while (itr.hasNext()) {
                        VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                        seq = e.getSeq();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            entrySize += assitCollection.size();
                            continue;
                        }
                        ++entrySize;
                    }
                    Iterator itrEntry = vch.getEntries().iterator();
                    int voucherCount = 0;
                    voucherCount = (entrySize + seq) % rowLineCount == 0 ? (entrySize + seq) / rowLineCount : (entrySize + seq) / rowLineCount + 1;
                    int entryCount = 1;
                    while (itrEntry.hasNext()) {
                        int page;
                        VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        EntryDC dc = e.getEntryDC();
                        int asstCount = 0;
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            for (VoucherAssistRecordInfo r : assitCollection) {
                                drs.moveToInsertRow();
                                this.provider.clearRow((IRowSet)drs);
                                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                                if (this.settingInfo.isPrintAssistant()) {
                                    this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                }
                                if (++asstCount > 1) {
                                    drs.updateString("e_seq", " ");
                                    drs.updateString("e_account", null);
                                }
                                int page2 = 0;
                                page2 = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                                drs.updateString("pageCount", page2 + "/" + voucherCount);
                                drs.updateString("pageCurrent", page2 + "");
                                drs.updateString("pageTotal", "" + voucherCount);
                                drs.updateString("bizStatus", vch.getBizStatus().toString());
                                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                                if (page2 == voucherCount) {
                                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                    drs.updateString("sum", "");
                                }
                                drs.insertRow();
                            }
                        } else {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                                drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                                drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                                drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                                drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                                drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            } else {
                                drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                                drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                                drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                                drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                                drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                                drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            }
                            page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", vch.getBizStatus().toString());
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                                drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                                drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                drs.updateString("sum", "");
                            }
                            drs.insertRow();
                        }
                        drs.moveToInsertRow();
                        drs.updateString("e_seq", "");
                        drs.updateString("e_description", "");
                        drs.updateString("e_account", "");
                        drs.updateString("zc_account", "");
                        drs.updateString("e_currency", "");
                        drs.updateString("e_measureUnitName", "");
                        drs.updateString("e_measureUnitNumber", "");
                        drs.updateString("periodYear", "");
                        drs.updateString("periodNumber", "");
                        drs.updateString("bizDate", "");
                        drs.updateString("bookedDate", "");
                        drs.updateString("bookedDateYear", "");
                        drs.updateString("bookedDateMonth", "");
                        drs.updateString("r_description", "");
                        drs.updateString("r_settlementType", "");
                        drs.updateString("r_settlementCode", "");
                        drs.updateString("r_bizNumber", "");
                        drs.updateString("r_originalAmount", "");
                        drs.updateString("r_originalAmount", "");
                        drs.updateString("r_originalAmountDebit", "");
                        drs.updateString("r_localAmount", "");
                        drs.updateString("r_localAmountDebit", "");
                        drs.updateString("r_localAmountCredit", "");
                        drs.updateString("r_reportingAmount", "");
                        drs.updateString("r_reportingAmountDebit", "");
                        drs.updateString("r_reportingAmountCredit", "");
                        drs.updateString("r_measureUnitName", "");
                        drs.updateString("r_measureUnitNumber", "");
                        drs.updateString("r_price", "");
                        drs.updateString("r_quantity", "");
                        drs.updateString("r_bizDate", "");
                        drs.updateString("r_invoice", "");
                        drs.updateString("r_endDate", "");
                        drs.updateString("r_assGrp", "");
                        drs.updateString("r_longName", "");
                        drs.updateString("r_accountAsst", "");
                        drs.updateString("r_accountAsstPrimItem", "");
                        drs.updateString("r_AsstHeadNumber", "");
                        drs.updateString("r_AsstNumber", "");
                        drs.updateString("r_AsstHeadName", "");
                        drs.updateString("r_AsstName", "");
                        drs.updateString("r_AsstLevelName", "");
                        drs.updateString("zc_assGrp", "");
                        drs.updateString("c_item", "");
                        drs.updateString("c_itemEbb", "");
                        drs.updateString("c_primItem", "");
                        drs.updateString("c_suppItem", "");
                        drs.updateString("c_oppAccount", "");
                        drs.updateString("c_originalAmount", "");
                        drs.updateString("c_localAmount", "");
                        drs.updateString("c_reportingAmount", "");
                        drs.updateString("c_primItemName", "");
                        drs.updateString("c_suppItemName", "");
                        drs.updateString("customer.number", "");
                        drs.updateString("customer.name", "");
                        drs.updateString("cusNumberName", "");
                        drs.updateString("vchId", vchId);
                        drs.updateString("e_isoCode", GLResUtil.getRes((String)"subtotal", (Locale)this.locale));
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        } else {
                            drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        }
                        page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                        }
                        drs.insertRow();
                    }
                }
                drs.beforeFirst();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Get rowset error!", (Throwable)ex);
                return null;
            }
            return drs;
        }

        private IRowSet getRowSet3(int rowLineCount) {
            int colCount = VoucherPrintDataProvider.col.length;
            DynamicRowSet drs = null;
            IAssistantHG assistantHG = null;
            IBaseVoucherAssistRecord asstre = null;
            VoucherEntryInfo e = null;
            try {
                drs = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo ci = new ColInfo();
                    ci.colType = 12;
                    ci.columnName = VoucherPrintDataProvider.col[i];
                    ci.nullable = 1;
                    drs.setColInfo(i + 1, ci);
                }
                drs.beforeFirst();
                Iterator itrVch = this.vchCol.iterator();
                int size = this.vchCol.size();
                BigDecimal allDeit = SysConstant.BIGZERO;
                BigDecimal allCret = SysConstant.BIGZERO;
                int vchCount = 0;
                while (itrVch.hasNext()) {
                    int lcpre;
                    VoucherInfo vch = (VoucherInfo)itrVch.next();
                    ++vchCount;
                    String vchId = "";
                    if (vch.getId() != null) {
                        vchId = vch.getId().toString();
                    }
                    CompanyOrgUnitInfo com = vch.getCompany();
                    CurrencyInfo localCurrency = com.getBaseCurrency();
                    int rcpre = lcpre = localCurrency.getPrecision();
                    CurrencyInfo reportingCurrency = com.getReportCurrency();
                    if (reportingCurrency != null) {
                        rcpre = reportingCurrency.getPrecision();
                    }
                    allDeit = vch.getLocalDebitAmount();
                    allCret = vch.getLocalCreditAmount();
                    Iterator itr = vch.getEntries().iterator();
                    int entrySize = 0;
                    while (itr.hasNext()) {
                        e = (VoucherEntryInfo)itr.next();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            entrySize += assitCollection.size();
                            continue;
                        }
                        ++entrySize;
                    }
                    Iterator itrEntry = vch.getEntries().iterator();
                    int voucherCount = 0;
                    voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                    int entryCount = 0;
                    while (itrEntry.hasNext()) {
                        e = (VoucherEntryInfo)itrEntry.next();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        EntryDC dc = e.getEntryDC();
                        int asstCount = 0;
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            for (VoucherAssistRecordInfo r : assitCollection) {
                                drs.moveToInsertRow();
                                this.provider.clearRow((IRowSet)drs);
                                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                                if (this.settingInfo.isPrintAssistant()) {
                                    this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                }
                                if (++asstCount > 1) {
                                    drs.updateString("e_seq", " ");
                                }
                                int page = 0;
                                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                                drs.updateString("pageCount", page + "/" + voucherCount);
                                drs.updateString("pageCurrent", page + "");
                                drs.updateString("pageTotal", "" + voucherCount);
                                drs.updateString("bizStatus", vch.getBizStatus().toString());
                                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                                if (page == voucherCount) {
                                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                }
                                drs.insertRow();
                            }
                            continue;
                        }
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        } else {
                            drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        }
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                        }
                        drs.insertRow();
                    }
                }
                drs.beforeFirst();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Get rowset error!", (Throwable)ex);
                return null;
            }
            return drs;
        }

        private IRowSet getRowSet4(int rowLineCount) {
            int colCount = VoucherPrintDataProvider.col.length;
            DynamicRowSet drs = null;
            IAssistantHG assistantHG = null;
            IBaseVoucherAssistRecord asstre = null;
            try {
                drs = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo ci = new ColInfo();
                    ci.colType = 12;
                    ci.columnName = VoucherPrintDataProvider.col[i];
                    ci.nullable = 1;
                    drs.setColInfo(i + 1, ci);
                }
                drs.beforeFirst();
                Iterator itrVch = this.vchCol.iterator();
                int size = this.vchCol.size();
                BigDecimal allDeit = SysConstant.BIGZERO;
                BigDecimal allCret = SysConstant.BIGZERO;
                int vchCount = 0;
                while (itrVch.hasNext()) {
                    int lcpre;
                    VoucherInfo vch = (VoucherInfo)itrVch.next();
                    ++vchCount;
                    String vchId = null;
                    if (null != vch.getId()) {
                        vchId = vch.getId().toString();
                    }
                    CompanyOrgUnitInfo com = vch.getCompany();
                    CurrencyInfo localCurrency = com.getBaseCurrency();
                    int rcpre = lcpre = localCurrency.getPrecision();
                    CurrencyInfo reportingCurrency = com.getReportCurrency();
                    if (reportingCurrency != null) {
                        rcpre = reportingCurrency.getPrecision();
                    }
                    allDeit = vch.getLocalDebitAmount();
                    allCret = vch.getLocalCreditAmount();
                    Iterator itr = vch.getEntries().iterator();
                    int entrySize = 0;
                    while (itr.hasNext()) {
                        VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            entrySize += assitCollection.size();
                            continue;
                        }
                        ++entrySize;
                    }
                    Iterator itrEntry = vch.getEntries().iterator();
                    int voucherCount = 0;
                    voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                    int entryCount = 0;
                    BigDecimal creditTotal = GlUtils.zero;
                    BigDecimal debitTotal = GlUtils.zero;
                    HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
                    HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
                    for (VoucherEntryInfo e : vch.getEntries()) {
                        EntryDC dc = e.getEntryDC();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            for (VoucherAssistRecordInfo r : assitCollection) {
                                int page = 0;
                                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                                if (entryCount % rowLineCount == 1) {
                                    creditTotal = GlUtils.zero;
                                    debitTotal = GlUtils.zero;
                                }
                                if (EntryDC.DEBIT.equals((Object)dc)) {
                                    debitTotal = debitTotal.add(r.getLocalAmount());
                                } else {
                                    creditTotal = creditTotal.add(r.getLocalAmount());
                                }
                                if (entryCount % rowLineCount != 0) continue;
                                creditmap.put(String.valueOf(page), creditTotal);
                                debitmap.put(String.valueOf(page), debitTotal);
                            }
                            continue;
                        }
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(e.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(e.getLocalAmount());
                        }
                        if (entryCount % rowLineCount != 0) continue;
                        creditmap.put(String.valueOf(page), creditTotal);
                        debitmap.put(String.valueOf(page), debitTotal);
                    }
                    entryCount = 0;
                    while (itrEntry.hasNext()) {
                        VoucherEntryInfo e;
                        e = (VoucherEntryInfo)itrEntry.next();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        EntryDC dc = e.getEntryDC();
                        int asstCount = 0;
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            for (VoucherAssistRecordInfo r : assitCollection) {
                                drs.moveToInsertRow();
                                this.provider.clearRow((IRowSet)drs);
                                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                                if (this.settingInfo.isPrintAssistant()) {
                                    this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                }
                                if (++asstCount > 1) {
                                    drs.updateString("e_seq", " ");
                                }
                                int page = 0;
                                if (++entryCount % rowLineCount == 0) {
                                    page = entryCount / rowLineCount;
                                } else {
                                    page = entryCount / rowLineCount + 1;
                                    if (entryCount % rowLineCount == 1) {
                                        creditTotal = GlUtils.zero;
                                        debitTotal = GlUtils.zero;
                                    }
                                }
                                if (EntryDC.DEBIT.equals((Object)dc)) {
                                    debitTotal = debitTotal.add(r.getLocalAmount());
                                } else {
                                    creditTotal = creditTotal.add(r.getLocalAmount());
                                }
                                drs.updateString("pageCount", page + "/" + voucherCount);
                                drs.updateString("pageCurrent", page + "");
                                drs.updateString("pageTotal", "" + voucherCount);
                                drs.updateString("bizStatus", vch.getBizStatus().toString());
                                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                                if (page == voucherCount) {
                                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                    drs.updateString("sum", "");
                                } else {
                                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                                    drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                                }
                                drs.insertRow();
                            }
                            continue;
                        }
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        } else {
                            drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        }
                        int page = 0;
                        if (++entryCount % rowLineCount == 0) {
                            page = entryCount / rowLineCount;
                        } else {
                            page = entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(e.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(e.getLocalAmount());
                        }
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("sum", "");
                        } else {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                        }
                        drs.insertRow();
                    }
                }
                drs.beforeFirst();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Get rowset error!", (Throwable)ex);
                return null;
            }
            return drs;
        }

        private IRowSet getRowSet5(int rowLineCount) {
            int colCount = VoucherPrintDataProvider.col.length;
            DynamicRowSet drs = null;
            IAssistantHG assistantHG = null;
            IBaseVoucherAssistRecord asstre = null;
            try {
                drs = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo ci = new ColInfo();
                    ci.colType = 12;
                    ci.columnName = VoucherPrintDataProvider.col[i];
                    ci.nullable = 1;
                    drs.setColInfo(i + 1, ci);
                }
                drs.beforeFirst();
                Iterator itrVch = this.vchCol.iterator();
                int size = this.vchCol.size();
                BigDecimal allDeit = SysConstant.BIGZERO;
                BigDecimal allCret = SysConstant.BIGZERO;
                int vchCount = 0;
                while (itrVch.hasNext()) {
                    int lcpre;
                    VoucherInfo vch = (VoucherInfo)itrVch.next();
                    ++vchCount;
                    String vchId = null;
                    if (null != vch.getId()) {
                        vchId = vch.getId().toString();
                    }
                    CompanyOrgUnitInfo com = vch.getCompany();
                    CurrencyInfo localCurrency = com.getBaseCurrency();
                    int rcpre = lcpre = localCurrency.getPrecision();
                    CurrencyInfo reportingCurrency = com.getReportCurrency();
                    if (reportingCurrency != null) {
                        rcpre = reportingCurrency.getPrecision();
                    }
                    allDeit = vch.getLocalDebitAmount();
                    allCret = vch.getLocalCreditAmount();
                    Iterator itr = vch.getEntries().iterator();
                    int entrySize = 0;
                    while (itr.hasNext()) {
                        VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            entrySize += assitCollection.size();
                            continue;
                        }
                        ++entrySize;
                    }
                    Iterator itrEntry = vch.getEntries().iterator();
                    int voucherCount = 0;
                    voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                    int entryCount = 0;
                    BigDecimal creditTotal = GlUtils.zero;
                    BigDecimal debitTotal = GlUtils.zero;
                    HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
                    HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
                    for (VoucherEntryInfo e : vch.getEntries()) {
                        EntryDC dc = e.getEntryDC();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            for (VoucherAssistRecordInfo r : assitCollection) {
                                int page = 0;
                                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                                if (entryCount % rowLineCount == 1) {
                                    creditTotal = GlUtils.zero;
                                    debitTotal = GlUtils.zero;
                                }
                                if (EntryDC.DEBIT.equals((Object)dc)) {
                                    debitTotal = debitTotal.add(r.getLocalAmount());
                                } else {
                                    creditTotal = creditTotal.add(r.getLocalAmount());
                                }
                                if (entryCount % rowLineCount != 0) continue;
                                creditmap.put(String.valueOf(page), creditTotal);
                                debitmap.put(String.valueOf(page), debitTotal);
                            }
                            continue;
                        }
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(e.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(e.getLocalAmount());
                        }
                        if (entryCount % rowLineCount != 0) continue;
                        creditmap.put(String.valueOf(page), creditTotal);
                        debitmap.put(String.valueOf(page), debitTotal);
                    }
                    entryCount = 0;
                    while (itrEntry.hasNext()) {
                        VoucherEntryInfo e;
                        e = (VoucherEntryInfo)itrEntry.next();
                        VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                        EntryDC dc = e.getEntryDC();
                        int asstCount = 0;
                        if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                            for (VoucherAssistRecordInfo r : assitCollection) {
                                drs.moveToInsertRow();
                                this.provider.clearRow((IRowSet)drs);
                                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                                if (this.settingInfo.isPrintAssistant()) {
                                    this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                }
                                if (++asstCount > 1) {
                                    drs.updateString("e_seq", " ");
                                }
                                int page = 0;
                                if (++entryCount % rowLineCount == 0) {
                                    page = entryCount / rowLineCount;
                                } else {
                                    page = entryCount / rowLineCount + 1;
                                    if (entryCount % rowLineCount == 1) {
                                        creditTotal = GlUtils.zero;
                                        debitTotal = GlUtils.zero;
                                    }
                                }
                                if (EntryDC.DEBIT.equals((Object)dc)) {
                                    debitTotal = debitTotal.add(r.getLocalAmount());
                                } else {
                                    creditTotal = creditTotal.add(r.getLocalAmount());
                                }
                                drs.updateString("pageCount", page + "/" + voucherCount);
                                drs.updateString("pageCurrent", page + "");
                                drs.updateString("pageTotal", "" + voucherCount);
                                drs.updateString("bizStatus", vch.getBizStatus().toString());
                                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                                if (page == voucherCount) {
                                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                                    drs.updateString("sum", "");
                                } else {
                                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                                    drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                                }
                                if (this.settingInfo.isPrintCashFlow()) {
                                    this.provider.printCashflow(drs, e, r, lcpre);
                                }
                                drs.insertRow();
                            }
                            continue;
                        }
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        } else {
                            drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                            drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                            drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                            drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        }
                        int page = 0;
                        if (++entryCount % rowLineCount == 0) {
                            page = entryCount / rowLineCount;
                        } else {
                            page = entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(e.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(e.getLocalAmount());
                        }
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("sum", "");
                        } else {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                        }
                        if (this.settingInfo.isPrintCashFlow()) {
                            this.provider.printCashflow(drs, e, null, lcpre);
                        }
                        drs.insertRow();
                    }
                }
                drs.beforeFirst();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Get rowset error!", (Throwable)ex);
                return null;
            }
            return drs;
        }

        private boolean computerVoucherType(VoucherInfo vch) {
            boolean pnlAccExist = false;
            int count = vch.getEntryCount();
            for (int i = 0; i < count; ++i) {
                AccountViewInfo acc = vch.getEntries().get(i).getAccount();
                if (!AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) continue;
                pnlAccExist = true;
            }
            return pnlAccExist;
        }

        private VoucherInfo changeVoucher(VoucherInfo vch) {
            VoucherInfo info = new VoucherInfo();
            info.setId(vch.getId());
            info.setNumber(vch.getNumber());
            info.setAttachments(vch.getAttachments());
            info.setBizOU(vch.getBizOU());
            info.setPeriod(vch.getPeriod());
            info.setBizDate(vch.getBizDate());
            info.setBookedDate(vch.getBookedDate());
            info.setCompany(vch.getCompany());
            info.setCreateTime(vch.getCreateTime());
            info.setCreator(vch.getCreator());
            info.setCU(vch.getCU());
            info.setCurrency(vch.getCurrency());
            info.setDescription(vch.getDescription());
            info.setDisplayFormat(vch.getDisplayFormat());
            info.setLocalCreditAmount(vch.getLocalCreditAmount());
            info.setLocalDebitAmount(vch.getLocalDebitAmount());
            info.setReportingCreditAmount(vch.getReportingCreditAmount());
            info.setReportingDebitAmount(vch.getReportingDebitAmount());
            info.setHandler(vch.getHandler());
            info.setAuditor(vch.getAuditor());
            info.setCashier(vch.getCashier());
            info.setCanceller(vch.getCanceller());
            info.setPoster(vch.getPoster());
            info.setHasCashAccount(vch.isHasCashAccount());
            info.setHasEffected(vch.isHasEffected());
            info.setLastUpdateTime(vch.getLastUpdateTime());
            info.setLastUpdateUser(vch.getLastUpdateUser());
            info.setVoucherType(vch.getVoucherType());
            info.setVoucherTypeDetail(vch.getVoucherTypeDetail());
            int infoCount = 0;
            HashMap<String, VoucherEntryInfo> acctMap = new HashMap<String, VoucherEntryInfo>();
            int count = vch.getEntryCount();
            VoucherEntryCollection vchEntryCol = vch.getEntries();
            VoucherEntryCollection infoEntryCol = info.getEntries();
            for (int i = 0; i < count; ++i) {
                VoucherEntryInfo vchEntryInfo = vchEntryCol.get(i);
                VoucherEntryInfo entry = new VoucherEntryInfo();
                entry.setAccount(vchEntryInfo.getAccount());
                entry.setBill(info);
                entry.setId(vchEntryInfo.getId());
                entry.setCurrency(vchEntryInfo.getCurrency());
                entry.setDescription(vchEntryInfo.getDescription());
                entry.setDisplayFormat(vchEntryInfo.getDisplayFormat());
                entry.setEntryDC(vchEntryInfo.getEntryDC());
                entry.setMeasureUnit(vchEntryInfo.getMeasureUnit());
                entry.setOriginalAmount(vchEntryInfo.getOriginalAmount());
                entry.setLocalAmount(vchEntryInfo.getLocalAmount());
                entry.setReportingAmount(vchEntryInfo.getReportingAmount());
                entry.setLocalExchangeRate(vchEntryInfo.getLocalExchangeRate());
                entry.setReportingExchangeRate(vchEntryInfo.getReportingExchangeRate());
                entry.setPrice(vchEntryInfo.getPrice());
                entry.setQuantity(vchEntryInfo.getQuantity());
                entry.setStandardQuantity(vchEntryInfo.getStandardQuantity());
                AccountViewInfo acc = entry.getAccount();
                if (AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) {
                    AccountViewInfo accInfo = null;
                    try {
                        BOSUuid accID = acc.getId();
                        ObjectUuidPK objectUUidPK = new ObjectUuidPK(accID);
                        accInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)objectUUidPK);
                    }
                    catch (BOSException e) {
                        this.logger.error((Object)e);
                    }
                    catch (EASBizException e) {
                        this.logger.error((Object)e);
                    }
                    String flongnumber = accInfo.getLongNumber();
                    String flongname = accInfo.getLongName();
                    String fnumber = flongnumber;
                    String fname = flongname;
                    int index = flongnumber.indexOf("!");
                    if (index != -1) {
                        fnumber = flongnumber.substring(0, flongnumber.indexOf("!"));
                        fname = flongname.substring(0, flongname.indexOf("_"));
                    }
                    acc.setName(fname);
                    acc.setNumber(fnumber);
                    acc.setLongName(fname);
                    acc.setLongNumber(fnumber);
                    if (acctMap.containsKey(fnumber)) {
                        VoucherEntryInfo entryInfo = (VoucherEntryInfo)acctMap.get(fnumber);
                        entryInfo.setOriginalAmount(entryInfo.getOriginalAmount().add(entry.getOriginalAmount()));
                        entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(entry.getLocalAmount()));
                        entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(entry.getReportingAmount()));
                        entryInfo.setQuantity(entryInfo.getQuantity().add(entry.getQuantity()));
                        entryInfo.setStandardQuantity(entryInfo.getStandardQuantity().add(entry.getStandardQuantity()));
                        continue;
                    }
                    entry.setSeq(++infoCount);
                    acctMap.put(fnumber, entry);
                    continue;
                }
                entry.setSeq(++infoCount);
                infoEntryCol.add(entry);
            }
            info.setEntryCount(infoCount);
            Set set = acctMap.keySet();
            for (String fnumber : set) {
                VoucherEntryInfo entryInfo = (VoucherEntryInfo)acctMap.get(fnumber);
                infoEntryCol.add(entryInfo);
            }
            return info;
        }
    }
}

