/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.outputmodule.archsys.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.exception.ArchSystemException;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelper;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.BusinessTypeMappingUtil;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.InvoUtil;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.ThreadUtil;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.MD5;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.dom4j.Document;

public class NoticeArchSysHelper_INVO
extends NoticeArchSysHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelper_INVO");
    private static String DOMAIN_NAME = "https://api.piaozone.com";
    protected static String DATASOURCE = "eas";
    private static TokenInfo tokenInfo;

    @Override
    public boolean getResultFiles(Context ctx, String[] filePaths, String address, String port) throws BOSException, ArchSystemException {
        throw new ArchSystemException(ArchSystemException.NOT_ACHIEVE_EXCEPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String reverseArch(Context ctx, List<ArcRecordInfo> arcRecordInfos, Map<String, String> otherParams) throws Exception {
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        for (ArcRecordInfo arcRecordInfo : arcRecordInfos) {
            String accessToken = "";
            String stack = "";
            String url = "";
            String result = "";
            String logparam = "";
            boolean res = false;
            try {
                try {
                    accessToken = this.getAccessToken(ctx);
                }
                catch (JSONException e) {
                    stack = e.getMessage();
                    throw new EASBizException(new NumericExceptionSubItem("00", "reverseArch get accessToken error[id:" + arcRecordInfo.getId().toString() + ";ArcRecordNum:" + arcRecordInfo.getArcRecordNum() + "]" + e.getMessage()));
                }
                String ip = this.getUrl(ctx, DOMAIN_NAME);
                String reverse_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_REVERSE);
                if (org.apache.commons.lang.StringUtils.isBlank((String)reverse_arch_sys)) {
                    reverse_arch_sys = "/archive/auth/data/delete?access_token=";
                }
                url = ip + reverse_arch_sys + accessToken;
                logger.error((Object)("reverseArch url:" + url));
                JSONObject param = new JSONObject();
                RecordBaseInfo content = arcRecordInfo.getContent();
                content.setReportCycleType(arcRecordInfo.getReportCycleType());
                String businessType = this.getbusinessType(ctx, content, content.getXmlDocType());
                if ("2".equals(businessType)) {
                    businessType = "1";
                } else if ("4".equals(businessType)) {
                    businessType = "3";
                }
                String period = arcRecordInfo.getPeriodNum() / 100 + "-" + String.format("%02d", arcRecordInfo.getPeriodNum() % 100);
                param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
                param.put((Object)"businessType", (Object)businessType);
                param.put((Object)"period", (Object)period);
                param.put((Object)"accountBookNo", (Object)arcRecordInfo.getOrg().getNumber());
                param.put((Object)"accountBookName", (Object)arcRecordInfo.getOrg().getName());
                param.put((Object)"reportType", (Object)arcRecordInfo.getContent().getName());
                param.put((Object)"currency", (Object)(null == arcRecordInfo.getCurrency() ? "" : arcRecordInfo.getCurrency().getName()));
                param.put((Object)"dataSource", (Object)DATASOURCE);
                logparam = param.toString();
                logger.error((Object)("reverseArch param:" + logparam));
                result = InvoUtil.postInterface(url, param.toString()).toString();
                logger.error((Object)("reverseArch param:" + result));
                JSONObject json = JSONObject.fromObject((Object)result);
                if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                    tokenInfo = new TokenInfo();
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u901a\u77e5\u53d1\u7968\u4e91\u5931\u8d25\uff01" + json.getString("description")));
                }
                res = true;
            }
            finally {
                try {
                    retMap.put(arcRecordInfo.getId().toString(), res);
                    ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "reverseArch", logparam, res, result, stack);
                }
                catch (Exception e) {
                    logger.error((Object)("reverseArch writeInterfaceLog error" + e.getMessage()));
                }
            }
        }
        return JSONUtils.convertObjectToJson((Context)ctx, retMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String markFail(Context ctx, List<ArcRecordInfo> arcRecordInfos, Map<String, String> otherParams) throws Exception {
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        for (ArcRecordInfo arcRecordInfo : arcRecordInfos) {
            if ("otherReport" == arcRecordInfo.getContentType().getValue() || "report" == arcRecordInfo.getContentType().getValue()) {
                String accessToken = "";
                String stack = "";
                String url = "";
                String result = "";
                String logparam = "";
                boolean res = false;
                try {
                    try {
                        accessToken = this.getAccessToken(ctx);
                    }
                    catch (JSONException e) {
                        stack = e.getMessage();
                        throw new EASBizException(new NumericExceptionSubItem("00", "markFail get accessToken error[id:" + arcRecordInfo.getId().toString() + ";ArcRecordNum:" + arcRecordInfo.getArcRecordNum() + "]" + e.getMessage()));
                    }
                    String ip = this.getUrl(ctx, DOMAIN_NAME);
                    String reverse_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_REVERSE);
                    if (org.apache.commons.lang.StringUtils.isBlank((String)reverse_arch_sys)) {
                        reverse_arch_sys = "/archive/auth/data/delete?access_token=";
                    }
                    url = ip + reverse_arch_sys + accessToken;
                    logger.error((Object)("reverseArch url:" + url));
                    JSONObject param = new JSONObject();
                    String businessType = BusinessTypeMappingUtil.getBusinessType(ctx, arcRecordInfo.getContent().getXmlDocType());
                    if ("2".equals(businessType)) {
                        businessType = "1";
                    } else if ("4".equals(businessType)) {
                        businessType = "3";
                    }
                    String period = arcRecordInfo.getPeriodNum() / 100 + "-" + String.format("%02d", arcRecordInfo.getPeriodNum() % 100);
                    param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
                    param.put((Object)"businessType", (Object)businessType);
                    param.put((Object)"period", (Object)period);
                    param.put((Object)"accountBookNo", (Object)arcRecordInfo.getOrg().getNumber());
                    param.put((Object)"accountBookName", (Object)arcRecordInfo.getOrg().getName());
                    param.put((Object)"dataSource", (Object)DATASOURCE);
                    logparam = param.toString();
                    logger.error((Object)("markFail param:" + logparam));
                    result = InvoUtil.postInterface(url, param.toString()).toString();
                    logger.error((Object)("markFail param:" + result));
                    JSONObject json = JSONObject.fromObject((Object)result);
                    if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                        throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u901a\u77e5\u53d1\u7968\u4e91\u5931\u8d25\uff01" + json.getString("description")));
                    }
                    res = true;
                    continue;
                }
                finally {
                    try {
                        retMap.put(arcRecordInfo.getId().toString(), res);
                        ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "markFail", logparam, res, result, stack);
                    }
                    catch (Exception e) {
                        logger.error((Object)("markFail writeInterfaceLog error" + e.getMessage()));
                    }
                    continue;
                }
            }
            retMap.put(arcRecordInfo.getId().toString(), true);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, retMap);
    }

    @Override
    public boolean uploadArchInfos(Context ctx, CompanyOrgUnitInfo orgUnitInfo, PeriodInfo periodInfo, List<ArchFormatInfo> archFormatInfos) throws BOSException, ArchSystemException, RecException {
        logger.error((Object)"NoticeArchSysHelper_INVO.uploadArchInfos()\u5f00\u59cb\u6267\u884c\u3002\u3002\u3002");
        String taskFlag = "";
        ThreadUtil.ThreadInfo threadInfo = null;
        for (ArchFormatInfo archFormatInfo : archFormatInfos) {
            taskFlag = archFormatInfo.getTaskFlag();
            threadInfo = ThreadUtil.getLock(taskFlag);
            logger.error((Object)taskFlag);
            try {
                this.forEachUploadFile(ctx, archFormatInfo, orgUnitInfo, periodInfo, taskFlag);
            }
            catch (Exception e) {
                logger.error((Object)("\u4e0a\u4f20\u6863\u6848\u6587\u4ef6\u5931\u8d25\uff01" + archFormatInfo.getXmlName() + e.getMessage()));
                logger.error((Object)e.getStackTrace());
                throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38"});
            }
            if (StringUtils.isEmpty((String)taskFlag)) {
                logger.error((Object)"NoticeArchSysHelper_INVO noticeArchSys error taskFlag is null");
            }
            ArrayList<ArchFormatInfo> failArchFormatInfos = new ArrayList<ArchFormatInfo>();
            failArchFormatInfos.add(archFormatInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("state", "1");
            params.put("message", "success");
            this.updateRecordDate(ctx, archFormatInfos, params, periodInfo, orgUnitInfo, taskFlag);
        }
        if (null != threadInfo && 0 >= threadInfo.subThreadCount(1)) {
            ThreadUtil.removeLock(taskFlag);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachUploadFile(Context ctx, ArchFormatInfo archFormatInfo, CompanyOrgUnitInfo orgUnitInfo, PeriodInfo periodInfo, String taskFlag) throws Exception {
        List<XmlBase> xmlBases = archFormatInfo.getXmlBases();
        String docType = xmlBases.size() > 0 ? xmlBases.get(0).getDocType() : "";
        String businessType = this.getbusinessType(ctx, archFormatInfo.getContent(), docType);
        this.uploadReport(ctx, archFormatInfo, orgUnitInfo, periodInfo, taskFlag, businessType);
        if (null != archFormatInfo.getContent() && ArcContentTypeEnum.BILL.equals((Object)archFormatInfo.getContent().getRecordType())) {
            IBillHandler billHandler = FilingUtils.getBillHandler(ctx, archFormatInfo.getContent());
            Map<String, byte[]> receiptPdfs = billHandler.getReceiptPdfs(ctx, archFormatInfo.getContent(), xmlBases);
            for (int i = xmlBases.size() - 1; i >= 0; --i) {
                ArchInfo info = (ArchInfo)xmlBases.get(i);
                billHandler.setXmlBaseProperties(ctx, info, archFormatInfo.getContent(), i);
                if (ArchFlagEnum.DELETE.equals((Object)info.getReArchFlag())) continue;
                try {
                    Set<FileInfo> fileInfos = info.getFileInfos();
                    if (null == fileInfos) continue;
                    for (FileInfo fileInfo : fileInfos) {
                        if (!StringUtils.isEmpty((String)fileInfo.getId())) {
                            InputStream billAttachmentIs = null;
                            try {
                                billAttachmentIs = billHandler.getBillAttachmentIs(ctx, info, fileInfo);
                                this.fileUpLoad(ctx, archFormatInfo, periodInfo, billAttachmentIs, taskFlag, businessType, fileInfo.getName(), orgUnitInfo);
                            }
                            catch (Exception e) {
                                try {
                                    fileInfo.setException("\u9644\u4ef6\u5b58\u5728\u5f02\u5e38");
                                    ArchRecordUtils.writeLog(ctx, info, archFormatInfo.getRecordId(), (Exception)((Object)new EASBizException(new NumericExceptionSubItem("", "\u9644\u4ef6\u5b58\u5728\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e)));
                                }
                                catch (Throwable throwable) {
                                    FilingUtils.safeClose(billAttachmentIs);
                                    throw throwable;
                                }
                                FilingUtils.safeClose(billAttachmentIs);
                                continue;
                            }
                            FilingUtils.safeClose(billAttachmentIs);
                            continue;
                        }
                        byte[] bytes = receiptPdfs.get(info.getBillId());
                        InputStream billPdfIs = null != bytes ? new ByteArrayInputStream(bytes) : billHandler.getBillPdfIs(ctx, archFormatInfo.getContent(), info, fileInfo);
                        this.fileUpLoad(ctx, archFormatInfo, periodInfo, billPdfIs, taskFlag, businessType, fileInfo.getName(), orgUnitInfo);
                    }
                    continue;
                }
                catch (Exception e) {
                    xmlBases.remove(i);
                    ArchRecordUtils.writeLog(ctx, info, archFormatInfo.getRecordId(), (Exception)((Object)new RecException(RecException.UNKNOWN, e, new Object[]{"[" + info.getBillNumber() + "]\u5f52\u6863\u5931\u8d25" + e.getMessage()})));
                }
            }
        }
        try {
            if ("2".equals(businessType)) {
                businessType = "1";
            } else if ("4".equals(businessType)) {
                businessType = "3";
            }
            Document document = ParsingEngineUtil.getInstance(ctx, archFormatInfo.getContent()).getXMLFromInfoByConfig(archFormatInfo.getXmlBases(), archFormatInfo.getContent());
            archFormatInfo.setXml(new ByteArrayInputStream(document.asXML().getBytes()));
            InputStream iss = archFormatInfo.getXml();
            this.fileUpLoad(ctx, archFormatInfo, periodInfo, iss, taskFlag, businessType, archFormatInfo.getXmlName(), orgUnitInfo);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("", "[" + archFormatInfo.getXmlName() + "]\u4e0a\u4f20\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
    }

    protected void uploadReport(Context ctx, ArchFormatInfo archFormatInfo, CompanyOrgUnitInfo orgUnitInfo, PeriodInfo periodInfo, String taskFlag, String businessType) throws EASBizException {
        Map<String, InputStream> map = archFormatInfo.getAttaInputStrams();
        Set<Map.Entry<String, InputStream>> entrySet = map.entrySet();
        for (Map.Entry<String, InputStream> entry : entrySet) {
            String key = entry.getKey();
            try {
                InputStream value = entry.getValue();
                this.fileUpLoad(ctx, archFormatInfo, periodInfo, value, taskFlag, businessType, key, orgUnitInfo);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", "[" + key + "]\u4e0a\u4f20\u5931\u8d25" + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public String getbusinessType(Context ctx, RecordBaseInfo content, String docType) throws EASBizException {
        String businessType = BusinessTypeMappingUtil.getBusinessType(ctx, docType);
        if (content != null && StringUtils.isEmpty((String)businessType) && content.getRecordType().equals((Object)ArcContentTypeEnum.REPORT)) {
            docType = FilingUtils.getXMLDocType(content.getReportCycleType());
            businessType = BusinessTypeMappingUtil.getBusinessType(ctx, docType);
        }
        if (businessType == null) {
            if (StringUtils.isEmpty((String)docType)) {
                logger.error((Object)("businessType error:[" + docType + "] docType is null"));
                throw new EASBizException(new NumericExceptionSubItem("", "docType is null"));
            }
            logger.error((Object)("businessType error:[" + docType + "] businessType is null"));
            throw new EASBizException(new NumericExceptionSubItem("", "\u6863\u6848\u7cfb\u7edf\u6682\u4e0d\u652f\u6301\uff3b" + docType + "\uff3d\u6587\u4ef6\u5f52\u6863"));
        }
        return businessType;
    }

    @Override
    public void noticeArchSysBatch(Context ctx, ArchFormatInfo archFormatInfo, PeriodInfo periodInfo, CompanyOrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noticeArchSys(Context ctx, PeriodInfo periodInfo, CompanyOrgUnitInfo orgUnitInfo, String batchNumber) throws BOSException, EASBizException {
        String accessToken = "";
        JSONObject logparam = new JSONObject();
        String result = "";
        String stack = "";
        boolean res = false;
        String url = "";
        try {
            try {
                accessToken = this.getAccessToken(ctx);
            }
            catch (JSONException e) {
                throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()), (Throwable)e);
            }
            String ip = this.getUrl(ctx, DOMAIN_NAME);
            String notic_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_NOTICE);
            url = ip + notic_arch_sys + accessToken;
            JSONObject param = new JSONObject();
            param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
            param.put((Object)"accountBookNo", (Object)orgUnitInfo.getNumber());
            param.put((Object)"accountBookName", (Object)orgUnitInfo.getName());
            String[] periodInfos = periodInfo.getLogInfo().split("-");
            if (periodInfos[1].length() == 2) {
                param.put((Object)"period", (Object)periodInfo.getLogInfo());
            } else {
                periodInfos[1] = "0" + periodInfos[1];
                param.put((Object)"period", (Object)(periodInfos[0] + "-" + periodInfos[1]));
            }
            param.put((Object)"batchNumber", (Object)batchNumber);
            param.put((Object)"archivist", (Object)ctx.getUserName());
            param.put((Object)"dataSource", (Object)DATASOURCE);
            logparam = param;
            JSONObject json = null;
            try {
                result = InvoUtil.postInterface(url, param.toString()).toString();
                json = JSONObject.fromObject((Object)result);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u901a\u77e5\u53d1\u7968\u4e91\u5931\u8d25\uff01" + e.getMessage()), (Throwable)e);
            }
            if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                tokenInfo = new TokenInfo();
                throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u6863\u6848\u7cfb\u7edf\u8fd4\u56de\u9519\u8bef\uff1a" + json.getString("description")));
            }
            res = true;
        }
        finally {
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "noticeArchSys", logparam.toString(), res, result, stack);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileUpLoad(Context ctx, ArchFormatInfo archFormatInfo, PeriodInfo periodInfo, InputStream is, String batchNumber, String businessType, String fileName, CompanyOrgUnitInfo orgUnitInfo) throws Exception {
        String accessToken = "";
        JSONObject logparam = new JSONObject();
        String result = "";
        String stack = "";
        boolean res = false;
        String url = "";
        try {
            accessToken = this.getAccessToken(ctx);
            String ip = this.getUrl(ctx, DOMAIN_NAME);
            String upload_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_UPLOAD);
            url = ip + upload_arch_sys + accessToken;
            JSONObject param = new JSONObject();
            param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
            param.put((Object)"accountBookNo", (Object)orgUnitInfo.getNumber());
            param.put((Object)"accountBookName", (Object)orgUnitInfo.getName());
            param.put((Object)"period", (Object)periodInfo.getLogInfo());
            param.put((Object)"batchNumber", (Object)batchNumber);
            param.put((Object)"businessType", (Object)businessType);
            param.put((Object)"fileName", (Object)fileName);
            logparam.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
            logparam.put((Object)"accountBookNo", (Object)orgUnitInfo.getNumber());
            logparam.put((Object)"accountBookName", (Object)orgUnitInfo.getName());
            String[] periodInfos = periodInfo.getLogInfo().split("-");
            if (periodInfos[1].length() == 2) {
                param.put((Object)"period", (Object)periodInfo.getLogInfo());
            } else {
                periodInfos[1] = "0" + periodInfos[1];
                param.put((Object)"period", (Object)(periodInfos[0] + "-" + periodInfos[1]));
            }
            logparam.put((Object)"period", param.get("period"));
            logparam.put((Object)"batchNumber", (Object)batchNumber);
            logparam.put((Object)"businessType", (Object)businessType);
            logparam.put((Object)"fileName", (Object)fileName);
            logparam.put((Object)"filebase64", (Object)"ABCD...");
            result = InvoUtil.uploadFile(ctx, ip, is, param.toString(), accessToken).toString();
            JSONObject json = JSONObject.fromObject((Object)result);
            if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                tokenInfo = new TokenInfo();
                throw new EASBizException(new NumericExceptionSubItem("00", fileName + ":\u7535\u5b50\u5f52\u6863\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01\u53d1\u7968\u4e91\u8fd4\u56de\u9519\u8bef\uff1a" + json.getString("description")));
            }
            res = true;
            String string = "1";
            return string;
        }
        finally {
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "fileUpLoad", logparam.toString(), res, result, stack);
            }
            catch (Exception exception) {}
        }
    }

    protected String getAccessToken(Context ctx) throws BOSException, JSONException, EASBizException {
        String token;
        if (null != tokenInfo && !StringUtils.isEmpty((String)(token = tokenInfo.getToken()))) {
            return token;
        }
        String accessToken = "";
        String archivesCode = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE);
        String sign = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_CLIENT_SECRET);
        String timestamp = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_TIMESTAMP);
        timestamp = new Date().getTime() + "";
        sign = archivesCode + sign + timestamp;
        try {
            sign = MD5.md5crypt(sign);
        }
        catch (Exception e1) {
            logger.error((Object)("\u52a0\u7b7e\u5931\u8d25" + e1.getMessage()));
            throw new EASBizException(new NumericExceptionSubItem("00", "\u52a0\u7b7e\u5931\u8d25\uff01"), (Throwable)e1);
        }
        String ip = this.getUrl(ctx, DOMAIN_NAME);
        JSONObject param = new JSONObject();
        param.put((Object)"archivesCode", (Object)archivesCode);
        param.put((Object)"sign", (Object)sign);
        param.put((Object)"timestamp", (Object)timestamp);
        String access_token = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_ACCESSTOKEN);
        String url = ip + access_token;
        int expireTime = 0;
        try {
            JSONObject successData = InvoUtil.getSuccessData(url, param.toString());
            accessToken = (String)successData.get("accessToken");
            Integer expireTimeS = (Integer)successData.get("expiresTime");
            if (null != expireTimeS) {
                expireTime = expireTimeS;
            }
        }
        catch (Exception e) {
            logger.error((Object)("accessToken error:" + param.toString() + "--" + url));
            throw new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage() + ",\u7535\u5b50\u5f52\u6863\u83b7\u53d6\u8ba4\u8bc1\u7801\u5931\u8d25:param:" + param + "url:" + url});
        }
        tokenInfo = new TokenInfo(accessToken, expireTime);
        return accessToken;
    }

    private void updateRecordDate(Context ctx, List<ArchFormatInfo> archFormatInfos, Map<String, String> params, PeriodInfo periodInfo, CompanyOrgUnitInfo orgUnitInfo, String taskFlag) throws BOSException {
        ArrayList list = new ArrayList();
        String state = params.get("state");
        String message = params.get("message");
        for (ArchFormatInfo archFormatInfo : archFormatInfos) {
            for (XmlBase xmlBase : archFormatInfo.getXmlBases()) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", xmlBase.getId());
                tmpMap.put("return", state);
                tmpMap.put("desc", message);
                list.add(tmpMap);
            }
            try {
                HashMap<String, Object> otherMap = null;
                if (list.size() > 0) {
                    otherMap = new HashMap<String, Object>();
                    ThreadUtil.ThreadInfo threadInfo = ThreadUtil.getLock(taskFlag);
                    otherMap.put("notic", threadInfo.getNotice());
                    otherMap.put("batchNumber", taskFlag);
                    ArcRecordInfo recordInfo = archFormatInfo.getRecordInfo();
                    CompanyOrgUnitInfo noticeOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitInfo.clone();
                    if (ArcContentTypeEnum.QmsReport.equals((Object)recordInfo.getContentType()) || ArcContentTypeEnum.RptsReport.equals((Object)recordInfo.getContentType())) {
                        orgUnitInfo.setName(recordInfo.getMergeUnitGroup().getDisplayName());
                        orgUnitInfo.setNumber(recordInfo.getMergeUnitGroup().getUnit().getNumber());
                    }
                    this.noticeArchSys(ctx, periodInfo, noticeOrgUnitInfo, taskFlag);
                }
                ArchRecordUtils.updateRecordData(ctx, archFormatInfo.getRecordId(), list, otherMap);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getStackTrace());
            }
        }
    }

    @Override
    public void checkService(Context ctx) throws Exception {
    }

    @Override
    public String getDirectory(String docType) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArcStateEnum archProgress(Context ctx, ArcRecordInfo arcRecordInfo, Map<String, String> otherParams) throws Exception {
        ArcStateEnum arcStateEnum = null;
        String accessToken = "";
        String stack = "";
        String url = "";
        String result = "";
        String logparam = "";
        try {
            try {
                accessToken = this.getAccessToken(ctx);
            }
            catch (JSONException e) {
                stack = e.getMessage();
                throw new EASBizException(new NumericExceptionSubItem("00", "reverseArch get accessToken error[id:" + arcRecordInfo.getId().toString() + ";ArcRecordNum:" + arcRecordInfo.getArcRecordNum() + "]" + e.getMessage()));
            }
            String ip = this.getUrl(ctx, DOMAIN_NAME);
            String reverse_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_REVERSE);
            if (org.apache.commons.lang.StringUtils.isBlank((String)reverse_arch_sys)) {
                reverse_arch_sys = "/archive/auth/data/delete?access_token=";
            }
            url = ip + reverse_arch_sys + accessToken;
            logger.error((Object)("reverseArch url:" + url));
            JSONObject param = new JSONObject();
            RecordBaseInfo content = arcRecordInfo.getContent();
            content.setReportCycleType(arcRecordInfo.getReportCycleType());
            String businessType = this.getbusinessType(ctx, content, content.getXmlDocType());
            if ("2".equals(businessType)) {
                businessType = "1";
            } else if ("4".equals(businessType)) {
                businessType = "3";
            }
            String period = arcRecordInfo.getPeriodNum() / 100 + "-" + String.format("%02d", arcRecordInfo.getPeriodNum() % 100);
            param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
            param.put((Object)"businessType", (Object)businessType);
            param.put((Object)"period", (Object)period);
            param.put((Object)"accountBookNo", (Object)arcRecordInfo.getOrg().getNumber());
            param.put((Object)"accountBookName", (Object)arcRecordInfo.getOrg().getName());
            param.put((Object)"batchNumber", (Object)otherParams.get("batchNumber"));
            param.put((Object)"dataSource", (Object)DATASOURCE);
            logparam = param.toString();
            logger.error((Object)("reverseArch param:" + logparam));
            result = InvoUtil.postInterface(url, param.toString()).toString();
            logger.error((Object)("reverseArch param:" + result));
            JSONObject json = JSONObject.fromObject((Object)result);
            if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                tokenInfo = new TokenInfo();
                throw new RecException(RecException.UNKNOWN, new Object[]{"\u67e5\u8be2\u6863\u6848\u7cfb\u7edf\u5f52\u6863\u8fdb\u5ea6\u5931\u8d25\uff1a" + json.getString("description")});
            }
            String data = json.getString("data");
            arcStateEnum = ArcStateEnum.getEnum(Integer.parseInt(data));
        }
        catch (Throwable throwable) {
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "reverseArch", logparam, !StringUtils.isEmpty((String)result), result, stack);
            }
            catch (Exception e) {
                logger.error((Object)("archProgress writeInterfaceLog error" + e.getMessage()));
            }
            throw throwable;
        }
        try {
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "reverseArch", logparam, !StringUtils.isEmpty((String)result), result, stack);
        }
        catch (Exception e) {
            logger.error((Object)("archProgress writeInterfaceLog error" + e.getMessage()));
        }
        return arcStateEnum;
    }

    @Override
    public void downloadAttach(Context ctx, String billId, String name, int type, File file) throws Exception {
    }

    private class TokenInfo {
        private String token = "";
        private Date expiresTime;

        public TokenInfo() {
        }

        public TokenInfo(String token, int expiresT) {
            this.token = token;
            expiresT = 0 == expiresT ? 5400 : expiresT;
            this.expiresTime = new Date(new Date().getTime() + (long)((expiresT - 60) * 1000));
        }

        public String getToken() {
            if (StringUtils.isEmpty((String)this.token)) {
                return "";
            }
            Date now = new Date();
            if (now.after(this.expiresTime)) {
                return "";
            }
            return this.token;
        }
    }
}

