/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateUtil {
    private static final Object lockObj = new Object();
    private static Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new ConcurrentHashMap<String, ThreadLocal<SimpleDateFormat>>();

    private static SimpleDateFormat getSdf(final String pattern) {
        ThreadLocal<SimpleDateFormat> tl = sdfMap.get(pattern);
        if (tl == null) {
            System.out.println("put new sdf of pattern " + pattern + " to map");
            tl = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    System.out.println("thread: " + Thread.currentThread() + " init pattern: " + pattern);
                    return new SimpleDateFormat(pattern);
                }
            };
            sdfMap.put(pattern, tl);
        }
        return tl.get();
    }

    public static String format(Date date, String pattern) {
        return DateUtil.getSdf(pattern).format(date);
    }

    public static Date parse(String dateStr, String pattern) throws ParseException {
        return DateUtil.getSdf(pattern).parse(dateStr);
    }
}

