/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseConfigCollection;
import com.kingdee.eas.el.rec.RecordBaseConfigInfo;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.evs.FilingEvsUtils;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.ReverseBillMsgInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.ArchCloudUtil;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.AttachmentDownloadServer;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultBillHandler
implements IBillHandler {
    protected static Logger logger = Logger.getLogger(DefaultBillHandler.class);
    AttachmentDownloadServer attachmentDownloadServer = new AttachmentDownloadServer();

    @Override
    public Boolean canArch(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org) throws BOSException {
        return true;
    }

    @Override
    public Map<String, IObjectValue> getMainBills(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org) throws Exception {
        BOSObjectType bosTyp = BOSObjectType.create((String)bosType);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)org.getId()));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5));
        if (null != period.getBeginDate()) {
            filter.getFilterItems().add(new FilterItemInfo("lastUpdateTime", (Object)new Timestamp(period.getBeginDate().getTime()), CompareType.GREATER));
        }
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        selectorItemCollection.add("number");
        selectorItemCollection.add("createTime");
        selectorItemCollection.add("lastUpdateTime");
        boolean ctVType = this.containVType(ctx, bosType);
        if (ctVType) {
            selectorItemCollection.add("voucherType.name");
        }
        entityViewInfo.setSelector(selectorItemCollection);
        IObjectCollection collections = this.getObjectCollection(ctx, bosTyp, entityViewInfo);
        if (0 == collections.size()) {
            return null;
        }
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>(collections.size());
        for (int i = 0; i < collections.size(); ++i) {
            map.put(collections.getObject(i).getString("id"), collections.getObject(i));
        }
        return map;
    }

    private boolean containVType(Context ctx, String bosType) throws Exception {
        RecordBaseInfo recordBaseInfo = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo("select id, collectImplType, lastUpdateTime, configs.* where billType.bosType = '" + bosType + "'");
        RecordBaseConfigCollection configs = recordBaseInfo.getConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            RecordBaseConfigInfo recordBaseConfigInfo = configs.get(i);
            if (!recordBaseConfigInfo.getNumber().equals("vnctype") || !Boolean.valueOf(recordBaseConfigInfo.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean archSuccess(Context ctx, List<String> billIds) {
        return false;
    }

    @Override
    public ReverseBillMsgInfo revokeArch(Context ctx, List<String> billIds) {
        return null;
    }

    @Override
    public Map<String, IObjectValue> getCurrentPeriodCanArchMainBills(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org, Timestamp beginTime, Timestamp lastUpdateTime) throws BOSException {
        return null;
    }

    @Override
    public ArrayList<String> getAllRelationBill(Context ctx, String destObjId, Map<String, RecordBaseInfo> contents) throws Exception {
        return ArchUtils.getAllBOTPRelationBill(ctx, destObjId, contents);
    }

    @Override
    public ArrayList<String> getAllRelationBill(Context ctx, IObjectValue billInfo, Map<String, RecordBaseInfo> contents) throws Exception {
        return this.getAllRelationBill(ctx, billInfo.getString("id"), contents);
    }

    @Override
    public IObjectCollection getObjectCollection(Context ctx, BOSObjectType bosType, EntityViewInfo viewInfo) throws Exception {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        IObjectCollection collections = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosType, viewInfo);
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return collections;
    }

    @Override
    public boolean existsBill(Context ctx, String billId) throws BOSException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        ObjectUuidPK billUuidPK = new ObjectUuidPK(billId);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
        if (billUuidPK.getObjectType().toString().equals("2652E01E")) {
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5));
        }
        boolean existsBill = DynamicObjectFactory.getLocalInstance((Context)ctx).exists(billUuidPK.getObjectType(), filter);
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return existsBill;
    }

    @Override
    public void setXmlBaseProperties(Context ctx, XmlBase xmlBase, RecordBaseInfo content, int index) throws Exception {
        ArchInfo info = (ArchInfo)xmlBase;
        if (ArchFlagEnum.DELETE == info.getReArchFlag()) {
            return;
        }
        String bosType = content.getBillType().getBosType();
        ArchUtils.setAttatchInfo(ctx, info, bosType, index);
        ArchUtils.setImageInfo(ctx, info, bosType);
        ArchUtils.setInvoiceInfo(ctx, info, content.isInvoice());
    }

    @Override
    public InputStream getBillAttachmentIs(Context ctx, ArchInfo archInfo, FileInfo fileInfo) throws Exception {
        InputStream is = this.attachmentDownloadServer.downloadFile1(ctx, fileInfo.getId());
        return is;
    }

    @Override
    public InputStream getBillPdfIs(Context ctx, RecordBaseInfo content, ArchInfo info, FileInfo fileInfo) throws Exception {
        ObjectUuidPK uuidPK = new ObjectUuidPK(info.getBillId());
        boolean isOfd = FilingEvsUtils.canArchXbrl(ctx, content.isIsRefBill() ? content.getRefMainBill().getId().toString() : content.getId().toString(), info.getCompany().getId().toString());
        String bosType = uuidPK.getObjectType().toString();
        if ("F8FF7C09".equalsIgnoreCase(bosType)) {
            byte[] byteS;
            block13: {
                byteS = null;
                try {
                    ArrayList<String> idList = new ArrayList<String>();
                    idList.add(info.getBillId());
                    Class<?> clazz = Class.forName("com.kingdee.eas.fm.common.EReceiptCommonHelper");
                    Method method = null;
                    try {
                        clazz.getMethod("getPDFValueByIdList", Context.class, List.class, Boolean.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)"EReceiptCommonHelper\u6ca1\u6709\u65b9\u6cd5getPDFValueByIdList(Context,List,Boolean)\uff0c\u8c03\u7528pdf\u751f\u6210\u65b9\u6cd5");
                        isOfd = false;
                    }
                    if (isOfd) {
                        method = clazz.getMethod("getPDFValueByIdList", Context.class, List.class, Boolean.class);
                        Object iobj = method.invoke(null, ctx, idList, false);
                        if (iobj instanceof Map) {
                            String sourceFileName;
                            Map mapObj = (Map)iobj;
                            if (mapObj.isEmpty()) {
                                logger.error((Object)("billid:[" + info.getBillId() + "];fileName:[" + fileInfo.getName() + "]\uff1bgetPDFValue is null"));
                                throw new RecException(RecException.UNKNOWN, new Object[]{"\u7535\u5b50\u56de\u5355\u63a5\u53e3\u65e0\u6570\u636e\u8fd4\u56de"});
                            }
                            Map mapFile = (Map)mapObj.get("pdfMap");
                            byteS = (byte[])mapFile.get(info.getBillId());
                            Map objInfo = (Map)((Map)mapObj.get("erMap")).get(info.getBillId());
                            String string = sourceFileName = objInfo == null ? "" : (String)objInfo.get("fileName");
                            if (!StringUtils.isEmpty((String)sourceFileName)) {
                                String sourceFileNameSuffix = sourceFileName.substring(sourceFileName.lastIndexOf(".") + 1);
                                fileInfo.setName(fileInfo.getName().substring(0, fileInfo.getName().lastIndexOf(".") + 1) + sourceFileNameSuffix);
                                fileInfo.setSrcname(sourceFileName);
                            }
                            break block13;
                        }
                        logger.error((Object)("\u7535\u5b50\u56de\u5355---[" + info.getBillId() + "]\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u7c7b\u578b\u662f[" + iobj.getClass().getName() + "]"));
                        throw new RecException(RecException.UNKNOWN, new Object[]{"\u7535\u5b50\u56de\u5355\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff1a" + iobj.getClass().getName()});
                    }
                    method = clazz.getMethod("getPDFValueByIdList", Context.class, List.class);
                    Object iobj = method.invoke(null, ctx, idList);
                    if (iobj instanceof List) {
                        List listObj = (List)iobj;
                        if (listObj.isEmpty()) {
                            logger.error((Object)("billid:[" + info.getBillId() + "];fileName:[" + fileInfo.getName() + "]\uff1bgetPDFValue is null"));
                            throw new RecException(RecException.UNKNOWN, new Object[]{"\u7535\u5b50\u56de\u5355\u63a5\u53e3\u65e0\u6570\u636e\u8fd4\u56de"});
                        }
                        byteS = (byte[])listObj.get(0);
                        break block13;
                    }
                    if (iobj instanceof Map) {
                        Map mapObj = (Map)iobj;
                        if (mapObj.isEmpty()) {
                            logger.error((Object)("billid:[" + info.getBillId() + "];fileName:[" + fileInfo.getName() + "]\uff1bgetPDFValue is null"));
                            throw new RecException(RecException.UNKNOWN, new Object[]{"\u7535\u5b50\u56de\u5355\u63a5\u53e3\u65e0\u6570\u636e\u8fd4\u56de"});
                        }
                        byteS = (byte[])mapObj.get(info.getBillId());
                        break block13;
                    }
                    logger.error((Object)("\u7535\u5b50\u56de\u5355---[" + info.getBillId() + "]\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u7c7b\u578b\u662f[" + iobj.getClass().getName() + "]"));
                    throw new RecException(RecException.UNKNOWN, new Object[]{"\u7535\u5b50\u56de\u5355\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff1a" + iobj.getClass().getName()});
                }
                catch (Throwable e) {
                    logger.error((Object)e, e);
                    throw new RecException(RecException.UNKNOWN, e);
                }
            }
            ByteArrayInputStream is = new ByteArrayInputStream(byteS);
            logger.error((Object)("billid:[" + info.getBillId() + "];fileName:[" + fileInfo.getName() + "];success"));
            return is;
        }
        InputStream is = ArchCloudUtil.getFileStream(ctx, info, content, fileInfo.getName());
        return is;
    }

    @Override
    public Map<String, byte[]> getReceiptPdfs(Context ctx, RecordBaseInfo content, List<XmlBase> xmlBaseList) throws Exception {
        HashMap<String, byte[]> mapObj;
        block6: {
            mapObj = new HashMap<String, byte[]>();
            if (null == xmlBaseList || xmlBaseList.size() == 0) {
                return mapObj;
            }
            ArchInfo info = (ArchInfo)xmlBaseList.get(0);
            ObjectUuidPK uuidPK = new ObjectUuidPK(info.getBillId());
            String bosType = uuidPK.getObjectType().toString();
            if (!"F8FF7C09".equalsIgnoreCase(bosType)) {
                return mapObj;
            }
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < xmlBaseList.size(); ++i) {
                idList.add(((ArchInfo)xmlBaseList.get(i)).getBillId());
            }
            Class<?> clazz = Class.forName("com.kingdee.eas.fm.common.EReceiptCommonHelper");
            Method method = null;
            try {
                method = clazz.getMethod("getPDFValueByIdList", Context.class, List.class, Boolean.class);
                Object iobj = method.invoke(null, ctx, idList, false);
                if (iobj instanceof Map) {
                    Map retMap = (Map)iobj;
                    return (Map)retMap.get("pdfMap");
                }
            }
            catch (Throwable e) {
                method = clazz.getMethod("getPDFValueByIdList", Context.class, List.class);
                Object iobj = method.invoke(null, ctx, idList);
                if (!(iobj instanceof Map)) break block6;
                return (Map)iobj;
            }
        }
        return mapObj;
    }

    @Override
    public void revokeArch(Context ctx, ArcRecordInfo info) throws Exception {
    }
}

