/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReverseBillMsgInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EleBankStatementBillHandler
implements IBillHandler {
    @Override
    public Boolean canArch(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org) throws BOSException {
        return true;
    }

    @Override
    public Map<String, IObjectValue> getCurrentPeriodCanArchMainBills(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org, Timestamp beginTime, Timestamp lastUpdateTime) throws BOSException {
        return null;
    }

    @Override
    public Map<String, IObjectValue> getMainBills(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org) throws Exception {
        IObjectCollection collections;
        Class<?> serviceClz = Class.forName("com.kingdee.eas.fm.common.ElStatementCommonHelper");
        Method method = serviceClz.getMethod("getElStatementCollection", Context.class, Integer.TYPE, Integer.TYPE, Timestamp.class, String.class);
        int year = period.getPeriodYear();
        int month = period.getPeriodNumber();
        String companyId = org.getId().toString();
        Timestamp ts = null;
        if (null != period.getBeginDate()) {
            ts = new Timestamp(period.getBeginDate().getTime());
        }
        if (0 == (collections = (IObjectCollection)method.invoke(serviceClz.newInstance(), ctx, year, month, ts, companyId)).size()) {
            return null;
        }
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>(collections.size());
        for (int i = 0; i < collections.size(); ++i) {
            map.put(collections.getObject(i).getString("id"), collections.getObject(i));
        }
        return map;
    }

    @Override
    public Boolean archSuccess(Context ctx, List<String> billIds) {
        return null;
    }

    @Override
    public ReverseBillMsgInfo revokeArch(Context ctx, List<String> billIds) {
        return null;
    }

    @Override
    public ArrayList<String> getAllRelationBill(Context ctx, IObjectValue billInfo, Map<String, RecordBaseInfo> contents) throws Exception {
        return this.getAllRelationBill(ctx, billInfo.getString("id"), contents);
    }

    @Override
    public ArrayList<String> getAllRelationBill(Context ctx, String destObjId, Map<String, RecordBaseInfo> contents) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public IObjectCollection getObjectCollection(Context ctx, BOSObjectType bosType, EntityViewInfo viewInfo) throws Exception {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        IObjectCollection collections = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosType, viewInfo);
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return collections;
    }

    @Override
    public boolean existsBill(Context ctx, String billId) throws BOSException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        ObjectUuidPK billUuidPK = new ObjectUuidPK(billId);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
        boolean existsBill = DynamicObjectFactory.getLocalInstance((Context)ctx).exists(billUuidPK.getObjectType(), filter);
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return existsBill;
    }

    @Override
    public void setXmlBaseProperties(Context ctx, XmlBase xmlBase, RecordBaseInfo content, int index) throws Exception {
        ArchInfo info = (ArchInfo)xmlBase;
        if (ArchFlagEnum.DELETE == info.getReArchFlag()) {
            return;
        }
        IXmlSrcObj data = info.getData();
        if (data.get("fileName") != null) {
            String name = (String)data.get("filename");
            String fileName = name.substring(0, name.lastIndexOf("."));
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            String timeBill = System.currentTimeMillis() + "";
            timeBill = timeBill.substring(timeBill.length() - 6);
            FileInfo file = new FileInfo(null, fileName + "_" + index + "_" + timeBill + "." + suffix, name);
            info.addFileInfo(file);
        }
    }

    @Override
    public InputStream getBillPdfIs(Context ctx, RecordBaseInfo content, ArchInfo info, FileInfo fileInfo) throws Exception {
        Class<?> serviceClz = Class.forName("com.kingdee.eas.fm.common.ElStatementCommonHelper");
        Method method = serviceClz.getMethod("getFilesByElStateIdList", Context.class, List.class, Boolean.class);
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(info.getBillId());
        Map maps = (Map)method.invoke(serviceClz.newInstance(), ctx, ids, false);
        ByteArrayInputStream is = new ByteArrayInputStream((byte[])maps.get(info.getBillId()));
        return is;
    }

    @Override
    public InputStream getBillAttachmentIs(Context ctx, ArchInfo archInfo, FileInfo fileInfo) throws Exception {
        return null;
    }

    @Override
    public Map<String, byte[]> getReceiptPdfs(Context ctx, RecordBaseInfo content, List<XmlBase> xmlBaseList) throws Exception {
        return null;
    }

    @Override
    public void revokeArch(Context ctx, ArcRecordInfo info) throws Exception {
    }
}

