/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.ctrl.print.io.KDFontMapper;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.model.FileStreamInfo;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import jxl.Cell;
import jxl.Range;
import jxl.Workbook;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Test;

public class ExcelToPdfUtil {
    private static Logger logger = Logger.getLogger(ExcelToPdfUtil.class);
    private static KDFontMapper.BaseFontParameters simSun = new KDFontMapper().getBaseFontParameters("SimSun");

    @Test
    public void test() throws Exception {
    }

    public static FileStreamInfo excel2Pdf(InputStream is, String suffix) throws Exception {
        File tempFile = File.createTempFile("el_rec", suffix);
        tempFile.deleteOnExit();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(tempFile);
            ExcelToPdfUtil.excel2Pdf(is, os, suffix);
            FileStreamInfo fileStreamInfo = new FileStreamInfo(tempFile, tempFile.toURI().toURL().openStream());
            return fileStreamInfo;
        }
        catch (Exception e) {
            tempFile.delete();
            throw e;
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    os = null;
                }
            }
        }
    }

    public static void excel2Pdf(InputStream is, OutputStream os, String suffix) throws Exception {
        try {
            if ("xls".equals(suffix)) {
                ExcelToPdfUtil.excel2Pdf(is, os);
                return;
            }
            Document document = new Document(PageSize.A4, 0.0f, 0.0f, 50.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            BaseFont bf = BaseFont.createFont((String)ExcelToPdfUtil.simSun.fontName, (String)ExcelToPdfUtil.simSun.encoding, (boolean)ExcelToPdfUtil.simSun.embedded);
            Font font = new Font(bf, 13.0f, 0);
            int rowNum = 0;
            int colNum = 0;
            XSSFWorkbook workbook = new XSSFWorkbook(is);
            for (int im = 0; im < workbook.getNumberOfSheets(); ++im) {
                Sheet sheet = workbook.getSheetAt(im);
                ArrayList nullCol = new ArrayList();
                ArrayList nullRow = new ArrayList();
                int column = 0;
                for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
                    int sheetColumn;
                    if (sheet.getRow(i) == null || column >= (sheetColumn = sheet.getRow(i).getLastCellNum())) continue;
                    column = sheetColumn;
                }
                if (column <= 0) continue;
                PdfPTable table = new PdfPTable(column);
                PdfPCell cell1 = new PdfPCell();
                for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
                    if (nullRow.contains(i)) continue;
                    for (int j = 0; j < column; ++j) {
                        org.apache.poi.ss.usermodel.Cell cell;
                        if (nullCol.contains(j)) continue;
                        boolean flag = true;
                        Row row = sheet.getRow(i);
                        String cellStr = "";
                        if (null != row && null != (cell = row.getCell(j))) {
                            cellStr = cell.toString();
                        }
                        for (int k = 0; k < sheet.getNumMergedRegions(); ++k) {
                            CellRangeAddress range = sheet.getMergedRegion(k);
                            if (j < range.getFirstColumn() || j > range.getLastColumn() || i < range.getFirstRow() || i > range.getLastRow()) continue;
                            if (j > range.getFirstColumn() || i > range.getFirstRow()) {
                                flag = false;
                                break;
                            }
                            rowNum = range.getLastRow() - range.getFirstRow() + 1;
                            if (rowNum > (colNum = range.getLastColumn() - range.getFirstColumn() + 1)) {
                                cell1 = ExcelToPdfUtil.mergeRow(cellStr, font, rowNum);
                                cell1.setColspan(colNum);
                                table.addCell(cell1);
                            } else {
                                cell1 = ExcelToPdfUtil.mergeCol(cellStr, font, colNum);
                                cell1.setRowspan(rowNum);
                                table.addCell(cell1);
                            }
                            flag = false;
                            break;
                        }
                        if (!flag) continue;
                        table.addCell(ExcelToPdfUtil.getPDFCell(cellStr, font));
                    }
                }
                if (!document.isOpen()) {
                    document.open();
                }
                document.add((Element)new Paragraph(sheet.getSheetName()));
                document.add((Element)table);
            }
            workbook.close();
            document.close();
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"excel\u8f6cpdf\u5f02\u5e38"});
        }
    }

    private static void excel2Pdf(InputStream is, OutputStream os) throws IOException, DocumentException, RecException {
        Document document = new Document(PageSize.A4, 0.0f, 0.0f, 50.0f, 0.0f);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
        BaseFont bf = BaseFont.createFont((String)ExcelToPdfUtil.simSun.fontName, (String)ExcelToPdfUtil.simSun.encoding, (boolean)ExcelToPdfUtil.simSun.embedded);
        Font font = new Font(bf, 13.0f, 0);
        int rowNum = 0;
        int colNum = 0;
        try {
            Workbook workbook = Workbook.getWorkbook((InputStream)is);
            jxl.Sheet[] sheets = workbook.getSheets();
            for (int im = 0; im < sheets.length; ++im) {
                String str;
                Cell cell;
                jxl.Sheet sheet = sheets[im];
                int column = sheet.getColumns();
                ArrayList<Integer> nullCol = new ArrayList<Integer>();
                ArrayList<Integer> nullRow = new ArrayList<Integer>();
                for (int j = 0; j < sheet.getColumns(); ++j) {
                    int nullColNum = 0;
                    for (int i = 0; i < sheet.getRows(); ++i) {
                        cell = sheet.getCell(j, i);
                        str = cell.getContents();
                        if (str != null && !"".equals(str)) continue;
                        ++nullColNum;
                    }
                    if (nullColNum != sheet.getRows()) continue;
                    nullCol.add(j);
                    --column;
                }
                for (int i = 0; i < sheet.getRows(); ++i) {
                    int nullRowNum = 0;
                    for (int j = 0; j < sheet.getColumns(); ++j) {
                        cell = sheet.getCell(j, i);
                        str = cell.getContents();
                        if (str != null && !"".equals(str)) continue;
                        ++nullRowNum;
                    }
                    if (nullRowNum != sheet.getColumns()) continue;
                    nullRow.add(i);
                }
                if (column == 0) continue;
                PdfPTable table = new PdfPTable(column);
                Range[] ranges = sheet.getMergedCells();
                PdfPCell cell1 = new PdfPCell();
                for (int i = 0; i < sheet.getRows(); ++i) {
                    if (nullRow.contains(i)) continue;
                    for (int j = 0; j < sheet.getColumns(); ++j) {
                        if (nullCol.contains(j)) continue;
                        boolean flag = true;
                        Cell cell2 = sheet.getCell(j, i);
                        String str2 = cell2.getContents();
                        for (Range range : ranges) {
                            if (j < range.getTopLeft().getColumn() || j > range.getBottomRight().getColumn() || i < range.getTopLeft().getRow() || i > range.getBottomRight().getRow()) continue;
                            if (str2 == null || "".equals(str2)) {
                                flag = false;
                                break;
                            }
                            rowNum = range.getBottomRight().getRow() - range.getTopLeft().getRow() + 1;
                            if (rowNum > (colNum = range.getBottomRight().getColumn() - range.getTopLeft().getColumn() + 1)) {
                                cell1 = ExcelToPdfUtil.mergeRow(str2, font, rowNum);
                                cell1.setColspan(colNum);
                                table.addCell(cell1);
                            } else {
                                cell1 = ExcelToPdfUtil.mergeCol(str2, font, colNum);
                                cell1.setRowspan(rowNum);
                                table.addCell(cell1);
                            }
                            flag = false;
                            break;
                        }
                        if (!flag) continue;
                        table.addCell(ExcelToPdfUtil.getPDFCell(str2, font));
                    }
                }
                if (!document.isOpen()) {
                    document.open();
                }
                document.add((Element)new Paragraph(sheet.getName()));
                document.add((Element)table);
            }
            workbook.close();
            document.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"excel\u8f6cpdf\u5f02\u5e38"});
        }
    }

    private static PdfPCell mergeRow(String str, Font font, int i) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(str, font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setRowspan(i);
        return cell;
    }

    private static PdfPCell mergeCol(String str, Font font, int i) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(str, font));
        cell.setMinimumHeight(25.0f);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setColspan(i);
        return cell;
    }

    private static PdfPCell getPDFCell(String string, Font font) {
        if (string.indexOf(".") > 0) {
            try {
                DecimalFormat decimalFormat = new DecimalFormat(",###.00");
                string = decimalFormat.format(Double.parseDouble(string));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(string, font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setMinimumHeight(25.0f);
        return cell;
    }
}

