/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.KDNoteWebServerHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class RecordBaseUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.tool.RecordBaseUtils");

    public static boolean isDefault(Context ctx, String recordBaseId) {
        try {
            RecordBaseInfo recordBaseInfo = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo(H.PK(recordBaseId));
            return recordBaseInfo.isIsDefault();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static void checkPrint(Context ctx, RecordBaseInfo recordBaseInfo) throws RecException {
        if (!"pdf".equalsIgnoreCase(recordBaseInfo.getExportFileType()) || !recordBaseInfo.isIsCustomPrint()) {
            return;
        }
        String dataProviderStr = recordBaseInfo.getBillType().getDataProvider();
        if (!StringUtils.isEmpty((String)dataProviderStr)) {
            try {
                Class.forName(dataProviderStr);
            }
            catch (ClassNotFoundException e) {
                throw new RecException(RecException.UNKNOWN, e, new Object[]{"[" + dataProviderStr + "]\u4e0d\u5b58\u5728"});
            }
            catch (Throwable e) {
                throw new RecException(RecException.UNKNOWN, e, new Object[]{"[" + dataProviderStr + "]\u6709\u8bef," + e.getMessage()});
            }
        }
        String billId = null;
        try {
            billId = RecordBaseUtils.getBillId(ctx, null, recordBaseInfo.getBillType());
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6\u5355\u636eid[" + billId + "]\u5f02\u5e38"});
        }
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        try {
            KDNoteWebServerHelper h = new KDNoteWebServerHelper();
            Object dataProvider = h.getDataProvider(ctx, dataProviderStr, recordBaseInfo.getBillType().getTdQueryPK(), billId, "");
            String printTemplate = (String)recordBaseInfo.get("extendPrintTemplate");
            printTemplate = StringUtils.isEmpty((String)printTemplate) ? recordBaseInfo.getPrintTemplate() : printTemplate;
            Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            h.exportPDF(ctx, printTemplate, dataProvider);
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        }
        catch (Throwable e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u8f93\u51fapdf\u65f6\u51fa\u73b0\u5f02\u5e38," + e.getMessage()});
        }
    }

    public static String getBillId(Context ctx, String bill, BillTypeInfo billType) throws BOSException {
        block11: {
            if (StringUtils.isEmpty((String)bill)) {
                if (billType.getBosType() == null) {
                    try {
                        billType = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(H.PK(billType.getId()));
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                }
                EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)billType.getBosType()));
                String keyColumn = entityObjectInfo.getLogicalKey().getKeyPropertys().get(0).getMappingField().getName();
                DataTableInfo table = entityObjectInfo.getTable();
                String sql = "select top 1 t." + keyColumn + " id from " + table.getName() + " t";
                if ("2652E01E".equals(billType.getBosType())) {
                    sql = sql + " where t.FbizStatus = 5";
                }
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rs.next()) {
                        return rs.getString("id");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            try {
                BOSUuid.read((String)bill);
            }
            catch (Exception e) {
                logger.error((Object)("bill:" + bill + " ,mess" + e.getMessage()), (Throwable)e);
                if (StringUtils.isEmpty((String)bill)) break block11;
                IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(BOSObjectType.create((String)billType.getBosType()), "select id where number = '" + bill + "'");
                if (collection.size() > 0) {
                    return collection.getObject(0).get("id").toString();
                }
                return "";
            }
        }
        return bill;
    }

    private static Timestamp getTimesMonthmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }
}

