/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.el.rec.RecordBaseCollectImplType;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ElTemplateReportInfo;
import com.kingdee.eas.el.rec.model.FileStreamInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.OtherReportFilter;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.ReverseReportMsgInfo;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class HasTemplateReportParsingEngineUtil
extends ReportParsingEngineUtil {
    @Override
    public InputStream[] getFileISArray(Context ctx, IXmlSrcObj iXmlSrcObj) throws Exception {
        InputStream input = this.getFileIS(ctx, iXmlSrcObj);
        InputStream[] inputs = new InputStream[]{input};
        return inputs;
    }

    @Override
    public InputStream getFileIS(Context ctx, IXmlSrcObj iXmlSrcObj) throws Exception {
        ReportBaseInfo eportInfo = ((ElTemplateReportInfo)iXmlSrcObj).getBaseRepInfo();
        Book book = eportInfo.getBook();
        book.setAutoCalculate(false);
        BookDataWrapper bdWrapper = new BookDataWrapper(book);
        File tempFile = File.createTempFile("el_rec", "xlsx");
        tempFile.deleteOnExit();
        try {
            bdWrapper.setExportHideCols(true);
            bdWrapper.setExportHideRows(true);
            bdWrapper.setExportFormula(false);
            bdWrapper.setExportCustomerFomulas(true);
            bdWrapper.setShowValue(true);
            SXSSFExportWrapper sxssfExportWrapper = new SXSSFExportWrapper((AbstractDataWrapper)bdWrapper);
            sxssfExportWrapper.write(tempFile.getAbsolutePath());
            File[] tempFiles = null;
            FileStreamInfo fileStreamInfo = this.excel2pdf(iXmlSrcObj, tempFile.toURI().toURL().openStream());
            InputStream fileInputStream = null;
            if (fileStreamInfo.isTempFile()) {
                tempFile.delete();
                tempFiles = new File[]{fileStreamInfo.getTempFile()};
                fileInputStream = fileStreamInfo.getInputStream();
            } else {
                tempFiles = new File[]{tempFile};
                fileInputStream = tempFile.toURI().toURL().openStream();
            }
            iXmlSrcObj.put("tempFile", tempFiles);
            return fileInputStream;
        }
        catch (Exception e) {
            tempFile.delete();
            throw e;
        }
    }

    @Override
    public IXmlSrcObj getReportDataSources(Context ctx, ReportFilter info) throws Exception {
        RecordBaseInfo baseInfo = info.getRecordBaseInfo();
        RecordBaseCollectImplType type = baseInfo.getCollectImplType();
        if (!RecordBaseCollectImplType.BASEREPORT.equals((Object)type)) {
            throw new RuntimeException("\u5fc5\u987b\u662f\u57fa\u7840\u62a5\u8868\u7c7b\u578b\u7684RecordBaseInfo\u624d\u4f7f\u7528CslReportParsingEngineUtil\u5de5\u5177\u7c7b!");
        }
        List<Map<String, Object>> cfgList = this.readConfig(baseInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        for (int i = 1; i < cfgList.size(); ++i) {
            Map<String, Object> rule = cfgList.get(i);
            String srcfield = rule.get("srcfield").toString();
            String[] srcs = srcfield.split(",");
            for (int j = 0; j < srcs.length; ++j) {
                sic.add(new SelectorItemInfo(srcs[j]));
            }
        }
        RptPeriodTypeEnum rptPeriodTypeEnum = FilingUtils.convertToRptEnum(info.getReportCycleType());
        OtherReportFilter orFilter = new OtherReportFilter();
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo(H.PK(info.getCurrency()));
        orFilter.setCurrencyInfo(currencyInfo);
        orFilter.setOrgId(info.getOrgId());
        orFilter.setPeriod(Short.parseShort(info.getPeriod()));
        orFilter.setPeriodType(rptPeriodTypeEnum);
        orFilter.setTemplateId(info.getRecordBaseInfo().getPrintTemplate());
        orFilter.setYear(Integer.parseInt(info.getYear()));
        ElTemplateReportInfo temlateCsl = new ElTemplateReportInfo();
        ReportBaseInfo reportBaseInfo = this.getReportBaseInfo(ctx, orFilter, sic);
        if (reportBaseInfo != null) {
            temlateCsl.setBaseRepInfo(reportBaseInfo);
            temlateCsl.getBaseRepInfo().put("exportFileType", (Object)this.getExportFileType(info.getRecordBaseInfo()));
            return temlateCsl;
        }
        return null;
    }

    protected abstract ReportBaseInfo getReportBaseInfo(Context var1, OtherReportFilter var2, SelectorItemCollection var3) throws Exception;

    @Override
    public List<ReverseReportMsgInfo> revokeArch(Context ctx, List<ReportFilter> filterList) throws Exception {
        return null;
    }

    protected byte[] blobToByte(InputStream in) throws SQLException {
        if (in == null) {
            return null;
        }
        int blockSize = 1024;
        byte[] block = new byte[1024];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int len = -1;
        do {
            try {
                len = in.read(block);
            }
            catch (IOException e1) {
                throw new SQLException(e1.getMessage());
            }
            if (len <= 0) continue;
            byteOut.write(block, 0, len);
        } while (len == 1024);
        return byteOut.toByteArray();
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "EXCEL");
        map1.put("value", "xls");
        list.add(map1);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "PDF");
        map2.put("value", "pdf");
        list.add(map2);
        return list;
    }

    @Override
    protected String getDefaultExportFileType() {
        return "xls";
    }
}

