/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.arap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.engine.arap.dataGridExcel.DataGridExcelAdapter;
import com.kingdee.eas.el.rec.tool.engine.arap.param.ArApQueryParam;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public abstract class ArApRptBaseService {
    ArApQueryParam params;
    String asstActTypeId;
    Context ctx;
    String[] colModel;
    boolean isAr = true;
    boolean isUseWEBDefaultSolution = false;
    Map solutionParam;
    static final String SUPPLIERI_ID = "YW3xsAEJEADgAAVEwKgTB0c4VZA=";
    static final String CUSYOMER_ID = "YW3xsAEJEADgAAUWwKgTB0c4VZA=";

    public ArApRptBaseService(Context ctx, ArApQueryParam params) {
        this.params = params;
        this.ctx = ctx;
    }

    protected ArApQueryParam buildQueryCondition(ReportFilter info, PeriodCollection perCol, String billTypeNumber, boolean isAr) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo(H.PK(info.getOrgId()));
        this.params.setCompanyId(info.getOrgId());
        this.params.setCuId(company.getCU() == null ? null : company.getCU().getId().toString());
        this.params.setIsArRpt(isAr);
        this.isAr = isAr;
        this.params.setShare(true);
        if (!this.isUseWEBDefaultSolution) {
            this.convertAsstActType(null);
            this.params.setCurrencyId("all");
            this.params.setBizeCheckBox(true);
            this.params.setBizeIndex(0);
            return this.params;
        }
        this.solutionParam = this.getWEBDefaultSolution(info);
        Object obj = this.solutionParam.get("f7_asstActType");
        String asstActTypeId = null;
        if (obj == null) {
            asstActTypeId = null;
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            asstActTypeId = map.get("id").toString();
        } else {
            asstActTypeId = obj.toString();
        }
        this.convertAsstActType(asstActTypeId);
        this.convertAsstActTypeType();
        this.convertAsstAct();
        this.convertCurrency();
        this.convertCashSale();
        return this.params;
    }

    private void convertCashSale() {
        int cashSale = !this.solutionParam.containsKey("combo_cashSale") ? -1 : Integer.valueOf(this.solutionParam.get("combo_cashSale").toString());
        if (cashSale == 1) {
            this.params.setBizeCheckBox(false);
        } else {
            this.params.setBizeCheckBox(true);
            if (cashSale == 2) {
                cashSale = 1;
            }
            this.params.setBizeIndex(cashSale);
        }
    }

    private void convertCurrency() throws EASBizException, BOSException {
        Object obj = this.solutionParam.get("f7_currency");
        String currencyId = null;
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                currencyId = map.get("id").toString();
            } else if (obj instanceof List) {
                List list = (List)obj;
                Map map = (Map)list.get(0);
                currencyId = map.get("id").toString();
            } else {
                currencyId = obj.toString();
            }
        } else {
            currencyId = "all";
        }
        this.params.setCurrencyId(currencyId);
        if (!"all".equals(currencyId)) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            this.params.setCurrencyInfo(currency);
        }
    }

    private void convertAsstAct() {
        Map map;
        String f7_asstAct_fromId = "f7_asstAct_from";
        String f7_asstAct_toId = "f7_asstAct_to";
        String locale = this.ctx.getLocale().toString();
        Object obj = this.solutionParam.get(f7_asstAct_fromId);
        if (obj != null) {
            if (obj instanceof String && !StringUtils.isEmpty((String)obj.toString())) {
                String[] strArr = obj.toString().split(",");
                if (strArr.length > 1) {
                    this.params.setCussAcctFromIds(Arrays.asList(strArr));
                } else {
                    this.params.setCussAcctFromId(strArr[0]);
                    this.params.setCussAcctFromIds(Arrays.asList(strArr));
                }
            }
            if (obj instanceof List) {
                List asstActFroms = (List)obj;
                int size = asstActFroms.size();
                if (size == 1) {
                    obj = (Map)asstActFroms.get(0);
                } else {
                    ArrayList<String> asstActIds = new ArrayList<String>();
                    int len = asstActFroms.size();
                    for (int i = 0; i < len; ++i) {
                        map = (Map)asstActFroms.get(i);
                        asstActIds.add(map.get("id").toString());
                    }
                    this.params.setCussAcctFromIds(asstActIds);
                }
            }
            if (obj instanceof Map) {
                map = (Map)obj;
                this.params.setCussAcctFromId(map.get("id").toString());
                this.params.setCussAcctFromName(((Map)map.get("name")).get(locale).toString());
                this.params.setCussAcctFromNum(map.get("number").toString());
            }
        }
        if ((obj = this.solutionParam.get(f7_asstAct_toId)) != null) {
            if (obj instanceof Map) {
                map = (Map)obj;
                this.params.setCussAcctToId(map.get("id").toString());
                this.params.setCussAcctToName(((Map)map.get("name")).get(locale).toString());
                this.params.setCussAcctToNum(map.get("number").toString());
            } else if (obj instanceof String) {
                this.params.setCussAcctToId(obj.toString());
            }
        }
    }

    private void convertAsstActTypeType() throws BOSException {
        try {
            String oql = null;
            Map map = (Map)this.solutionParam.get("f7_asstActTypeType");
            if (map != null) {
                oql = "select id, name, number, groupStandard.id where id='" + map.get("id").toString() + "'";
                CSSPGroupInfo cSSPGroupInfo = CSSPGroupFactory.getLocalInstance((Context)this.ctx).getCSSPGroupInfo(oql);
                if (cSSPGroupInfo != null) {
                    if (cSSPGroupInfo.getGroupStandard() != null) {
                        String grpStdId = cSSPGroupInfo.getGroupStandard().getId().toString();
                        this.params.setCsspGrpStdId(grpStdId);
                    }
                    this.params.setCsspGrpId(cSSPGroupInfo.getString("id"));
                    this.params.setCsspGrpName(cSSPGroupInfo.getName());
                    this.params.setCsspGrpNum(cSSPGroupInfo.getNumber());
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void convertAsstActType(String asstActTypeId) throws EASBizException, BOSException {
        if (asstActTypeId == null || "".equals(asstActTypeId)) {
            asstActTypeId = this.params.isArRpt() ? ArApRptBaseService.getAsstactTypeCustomerId(null) : ArApRptBaseService.getAsstactTypeSupplierId(null);
        }
        if (asstActTypeId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            AsstActTypeInfo cussTypeInfo = AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActTypeId), sic);
            this.params.setCussAcctTypeInfo(cussTypeInfo);
            this.params.setCussTypeId(asstActTypeId);
            this.params.setCussTable(cussTypeInfo.getRealtionDataObject());
        }
    }

    public static String getAsstactTypeCustomerId(Context ctx) throws BOSException {
        String asstactId = ArApRptBaseService.getAsstactTypeId(ctx, "customer");
        if (StringUtils.isEmpty((String)asstactId)) {
            asstactId = CUSYOMER_ID;
        }
        return asstactId;
    }

    public static String getAsstactTypeSupplierId(Context ctx) throws BOSException {
        String asstactId = ArApRptBaseService.getAsstactTypeId(ctx, "provider");
        if (StringUtils.isEmpty((String)asstactId)) {
            asstactId = SUPPLIERI_ID;
        }
        return asstactId;
    }

    public static String getAsstactTypeId(Context ctx, String asstHGAttribute) throws BOSException {
        String asstactId = null;
        IAsstActType iAsstActType = null;
        iAsstActType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(coll);
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("asstHGAttribute", (Object)asstHGAttribute, CompareType.EQUALS));
        AsstActTypeCollection col = iAsstActType.getAsstActTypeCollection(viewInfo);
        if (col != null && col.size() > 0) {
            asstactId = col.get(0).getId().toString();
        }
        return asstactId;
    }

    protected InputStream getPrintIS(Context ctx, RptParams rptParams) throws IOException, BOSException, EASBizException, WriteException {
        int frozenCount = 0;
        List<Object> datas = new ArrayList();
        datas = this.convert(rptParams);
        String[] columnModel = this.getColModel();
        if (columnModel == null && columnModel.length == 0) {
            return null;
        }
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)boas);
        int maxSheetLine = 50000;
        int iStartRow = 0;
        int iEndRow = 0;
        int dataSize = datas.size();
        int sheetPage = dataSize / maxSheetLine;
        int lastPageLines = dataSize % maxSheetLine;
        if (sheetPage >= 1 && lastPageLines > 0) {
            ++sheetPage;
        }
        if (sheetPage == 0) {
            sheetPage = 1;
        }
        for (int i = 0; i < sheetPage; ++i) {
            WritableSheet wsheet = wbook.createSheet("ExportData" + i, i);
            SheetSettings sheetSettings = wsheet.getSettings();
            if (frozenCount > 0) {
                sheetSettings.setHorizontalFreeze(frozenCount);
            }
            iStartRow = i * maxSheetLine;
            iEndRow = i == sheetPage - 1 ? dataSize - 1 : (i + 1) * maxSheetLine - 1;
            ArrayList<Object> onePageDatas = new ArrayList<Object>();
            for (int j = iStartRow; j <= iEndRow; ++j) {
                if (datas.get(j) == null) continue;
                onePageDatas.add(datas.get(j));
            }
            DataGridExcelAdapter iDataGridExcelAdapter = new DataGridExcelAdapter();
            wsheet = iDataGridExcelAdapter.createWsheet(wsheet, this.getTitle(), columnModel, this.getHeaderModel(), onePageDatas, ctx);
        }
        wbook.write();
        wbook.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(boas.toByteArray());
        boas.close();
        this.releaseTempTable();
        return inputStream;
    }

    protected String[] getHeaderModel() {
        return new String[]{""};
    }

    protected abstract List<Map<String, Object>> convert(RptParams var1);

    protected abstract String[] convertColModel(RptParams var1);

    protected abstract String getTitle();

    protected abstract void releaseTempTable() throws EASBizException, BOSException;

    protected abstract String getWEBUIPK();

    public String[] getColModel() {
        return this.colModel;
    }

    public void setColModel(String[] colModel) {
        this.colModel = colModel;
    }

    protected Map getWEBDefaultSolution(ReportFilter reportFilter) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        Map queryParams = null;
        String uipk = this.getWEBUIPK();
        String parentUIName = uipk + (this.isAr ? "_ar" : "_ap") + "_noshare";
        IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
        QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo = this.getQuerySolutionViewInfo(this.ctx, parentUIName, reportFilter.getOrgId()));
        if (solutionCol == null) {
            return null;
        }
        for (QuerySolutionInfo solutionInfo : solutionCol) {
            if (!solutionInfo.isIsUserDefaultSolu()) continue;
            String customerParams = "";
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                QueryPanelInfo info = queryPanels.get(i0);
                customerParams = info.getCustomerParams();
                queryParams = (Map)JSONUtils.convertJsonToObject((Context)this.ctx, (String)customerParams, HashMap.class);
            }
        }
        return queryParams;
    }

    public EntityViewInfo getQuerySolutionViewInfo(Context ctx, String parentUIName, String orgId) throws EASBizException, BOSException {
        if (orgId == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        Object queryName = null;
        IObjectPK userID = ctx.getCaller();
        BOSUuid orgID = BOSUuid.read((String)orgId);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("queryObjectName", queryName);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("parentUIName", (Object)parentUIName);
        filterInfo.getFilterItems().add(filterItemInfo);
        FilterItemInfo userOrgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(1));
        FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
        FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
        FilterItemInfo userLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(16));
        filterInfo.getFilterItems().add(userOrgLevelFilterItem);
        filterInfo.getFilterItems().add(ownerFilterItem);
        filterInfo.getFilterItems().add(orgFilterItem);
        filterInfo.getFilterItems().add(userLevelFilterItem);
        filterInfo.getFilterItems().add(ownerFilterItem);
        filterInfo.setMaskString("#0 AND #1 AND ((#2 AND #3 AND #4 ) OR (#5 AND #6))");
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectorItemCollection());
        return viewInfo;
    }

    public SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    protected boolean getBoolean(String key) {
        if (!this.solutionParam.containsKey(key)) {
            return false;
        }
        return Boolean.valueOf(this.solutionParam.get(key).toString());
    }

    protected int getInt(String key) {
        if (!this.solutionParam.containsKey(key)) {
            return -1;
        }
        return Integer.valueOf(this.solutionParam.get(key).toString());
    }
}

