/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.arap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.tool.engine.arap.ArApRptBaseService;
import com.kingdee.eas.el.rec.tool.engine.arap.param.AccountAgeQueryParam;
import com.kingdee.eas.el.rec.tool.engine.arap.param.ArApQueryParam;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApRptVirtualAgingService
extends ArApRptBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.tool.engine.arap.ArApRptVirtualAgingService");
    AccountAgeQueryParam params;
    IVirtualRptBaseFacade iRpt = null;
    Date beginDate;
    Date endDate;
    Date agingCompareDate;
    String tempTable;
    Class clazz = null;
    Context ctx = null;

    public ArApRptVirtualAgingService(Context ctx, ArApQueryParam params) throws BOSException {
        super(ctx, params);
        this.ctx = ctx;
        try {
            this.clazz = Class.forName("com.kingdee.eas.fi.arap.util.rptService.VirtualAgingService");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected ArApQueryParam buildQueryCondition(ReportFilter info, PeriodCollection perCol, String billTypeNumber, boolean isAr) throws EASBizException, BOSException {
        Date d;
        int i;
        AccountAgeQueryParam param = (AccountAgeQueryParam)super.buildQueryCondition(info, perCol, billTypeNumber, isAr);
        PeriodInfo startPeriod = perCol.get(0);
        PeriodInfo endPeriod = perCol.get(perCol.size() - 1);
        this.beginDate = startPeriod.getBeginDate();
        this.endDate = endPeriod.getEndDate();
        String companyId = info.getOrgId();
        ArrayList<String> companyIds = new ArrayList<String>();
        companyIds.add(companyId);
        if (companyIds.size() == 1) {
            companyIds.add(companyId);
        }
        param.setCompanyIds(companyIds);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        HashSet set = new HashSet(companyIds);
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ev.setFilter(fi);
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        CompanyOrgUnitCollection companys = icompany.getCompanyOrgUnitCollection(ev);
        CompanyOrgUnitInfo company = null;
        companyId = param.getCompanyId();
        ArrayList<String> ids = new ArrayList<String>();
        int len = companys.size();
        for (i = 0; i < len; ++i) {
            company = companys.get(i);
            if (companyId.equals(company.getId().toString())) {
                param.setCuId(company.getCU().getId().toString());
            }
            ids.add(company.getCU().getId().toString());
        }
        param.setCuIds(ids);
        if (!this.isUseWEBDefaultSolution) {
            PeriodInfo currentPeriodInfo;
            this.agingCompareDate = new Date();
            CompanyOrgUnitInfo firstCompanyInfo = companys.get(0);
            Calendar calendar = Calendar.getInstance();
            if (firstCompanyInfo != null && (currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)(param.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE), (CompanyOrgUnitInfo)firstCompanyInfo)) != null) {
                calendar.set(currentPeriodInfo.getPeriodYear() - 1, 0, 1);
                calendar.roll(6, -1);
                this.agingCompareDate = calendar.getTime();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String date = sdf.format(this.agingCompareDate);
            param.setAnalyseObjIndex(0);
            param.setDirIndex(0);
            param.setDateFldIndex(1);
            param.setBizeCheckBox(false);
            param.setBizeIndex(0);
            param.setPaymentTypeCheckBox(true);
            param.setPaymentTypeIndex(0);
            param.setGroupTypeIndex(0);
            if (param.getDirIndex() == 0) {
                ArrayList<String> arapTypes = new ArrayList<String>();
                if (param.isArRpt()) {
                    arapTypes.add("101");
                    arapTypes.add("102");
                    arapTypes.add("103");
                    arapTypes.add("104");
                } else {
                    arapTypes.add("201");
                    arapTypes.add("202");
                    arapTypes.add("203");
                    arapTypes.add("204");
                }
                param.setArapBillTypes(arapTypes);
            } else {
                param.setRecpayBillTypes(new ArrayList());
            }
            param.setEndDateBal(false);
            param.setHasLocAmt(false);
            ArrayList<Integer> dayList = new ArrayList<Integer>();
            dayList.add(30);
            dayList.add(31);
            param.setUndueList(dayList);
            dayList = new ArrayList();
            if (param.isArRpt()) {
                dayList.add(30);
                dayList.add(60);
                dayList.add(90);
                dayList.add(120);
                dayList.add(150);
                dayList.add(330);
                dayList.add(690);
                dayList.add(1050);
                dayList.add(1410);
                dayList.add(1770);
                dayList.add(1771);
            } else {
                dayList.add(30);
                dayList.add(60);
                dayList.add(90);
                dayList.add(91);
            }
            param.setOverdueList(dayList);
            this.params = param;
            return param;
        }
        this.agingCompareDate = d = new Date(Double.valueOf(this.solutionParam.get("dp_agingCompareDate").toString()).longValue());
        param.setAnalyseObjIndex(Integer.valueOf(this.solutionParam.get("combo_analyseObjIndex").toString()));
        param.setDirIndex(Integer.valueOf(this.solutionParam.get("combo_dirIndex").toString()));
        param.setDateFldIndex(Integer.valueOf(this.solutionParam.get("combo_dateFldIndex").toString()));
        int bizBillType = this.getInt("combo_bizType");
        if (bizBillType == 1) {
            param.setBizeCheckBox(false);
        } else {
            param.setBizeCheckBox(true);
            if (bizBillType == 2) {
                bizBillType = 1;
            }
            param.setBizeIndex(bizBillType);
        }
        int cashSale = this.getInt("combo_cashSale");
        if (cashSale == 1) {
            param.setPaymentTypeCheckBox(false);
        } else {
            param.setPaymentTypeCheckBox(true);
            if (cashSale == 2) {
                cashSale = 1;
            }
            param.setPaymentTypeIndex(cashSale);
        }
        param.setGroupTypeIndex(Integer.valueOf(this.solutionParam.get("combo_groupTypeIndex").toString()));
        Locale loc = this.ctx.getLocale();
        Object obj = null;
        List list = null;
        Map map = null;
        obj = this.solutionParam.get("f7_department");
        if (obj != null && !(obj instanceof String)) {
            if (obj instanceof List) {
                list = (List)obj;
                ids = new ArrayList();
                len = list.size();
                for (i = 0; i < len; ++i) {
                    map = (Map)list.get(i);
                    ids.add(map.get("id").toString());
                }
                param.setAdminOrgIds(ids);
            } else if (obj instanceof Map) {
                map = (Map)obj;
                param.setAdminOrgId(map.get("id").toString());
                param.setAdminOrgName(((Map)map.get("name")).get(loc.toString()).toString());
                param.setAdminOrgNum(map.get("number").toString());
            }
        }
        if ((obj = (Object)this.solutionParam.get("f7_person")) != null && !(obj instanceof String)) {
            if (obj instanceof List) {
                list = (List)obj;
                ids = new ArrayList();
                len = list.size();
                for (i = 0; i < len; ++i) {
                    map = (Map)list.get(i);
                    ids.add(map.get("id").toString());
                }
                param.setPersonIds(ids);
            } else if (obj instanceof Map) {
                map = (Map)obj;
                param.setSalesId(map.get("id").toString());
                param.setSalesName(((Map)map.get("name")).get(loc.toString()).toString());
                param.setSalesNum(map.get("number").toString());
            }
        }
        if ((obj = (Object)this.solutionParam.get("f7_recPayBillType")) != null && !(obj instanceof String)) {
            ids = new ArrayList();
            if (obj instanceof List) {
                list = (List)obj;
                len = list.size();
                for (i = 0; i < len; ++i) {
                    map = (Map)list.get(i);
                    ids.add(map.get("id").toString());
                }
            } else if (obj instanceof Map) {
                map = (Map)obj;
                ids.add(map.get("id").toString());
            }
            param.setRecpayBillTypes(ids);
        }
        if (!StringUtils.isEmpty((String)(obj = (Object)this.solutionParam.get("multiCombo_arapType")).toString())) {
            List<String> arapTypes = Arrays.asList(this.solutionParam.get("multiCombo_arapType").toString().split(","));
            param.setArapBillTypes(arapTypes);
        }
        param.setEndDateBal(Boolean.valueOf(this.solutionParam.get("chkEndDateBal").toString()));
        param.setHasLocAmt(false);
        int day = 0;
        ArrayList<Integer> dayList = null;
        obj = this.solutionParam.get("undue");
        if (obj != null && obj instanceof List) {
            dayList = new ArrayList<Integer>();
            list = (List)obj;
            len = list.size();
            for (i = 0; i < len; ++i) {
                map = (Map)list.get(i);
                day = Double.valueOf(map.get("undue_day").toString()).intValue();
                dayList.add(day);
            }
            dayList.add(day + 1);
            param.setUndueList(dayList);
        }
        if ((obj = this.solutionParam.get("overdue")) != null && obj instanceof List) {
            dayList = new ArrayList();
            list = (List)obj;
            len = list.size();
            for (i = 0; i < len; ++i) {
                map = (Map)list.get(i);
                day = Double.valueOf(map.get("overdue_day").toString()).intValue();
                dayList.add(day);
            }
            dayList.add(day + 1);
            param.setOverdueList(dayList);
        }
        this.params = param;
        return this.params;
    }

    protected Object executeQuery() throws EASBizException, BOSException {
        RptParams rptRslt = null;
        if (this.clazz != null) {
            try {
                String tempTable;
                Method methodCreateTempTable = this.clazz.getDeclaredMethod("createTempTable", Map.class);
                Object obj = this.clazz.newInstance();
                HashMap<String, Object> invokparam = new HashMap<String, Object>();
                invokparam.put("ctx", this.ctx);
                invokparam.put("beginDate", this.beginDate);
                invokparam.put("endDate", this.endDate);
                invokparam.put("agingCompareDate", this.agingCompareDate);
                invokparam.put("virtualAgingRptQueryParamMap", JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.params));
                rptRslt = (RptParams)methodCreateTempTable.invoke(obj, invokparam);
                String[] colModel = this.convertColModel(rptRslt);
                this.setColModel(colModel);
                this.tempTable = tempTable = rptRslt.getString("tempTable");
                this.params.setTempTable(tempTable);
                invokparam.put("virtualAgingRptQueryParamMap", JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.params));
                Method methodQuery = this.clazz.getDeclaredMethod("query", Map.class);
                invokparam.put("from", 0);
                invokparam.put("length", 1);
                rptRslt = (RptParams)methodQuery.invoke(obj, invokparam);
                int totalRowCount = rptRslt.getInt("totalRowCount");
                invokparam.put("from", 0);
                invokparam.put("length", totalRowCount);
                rptRslt = (RptParams)methodQuery.invoke(obj, invokparam);
                return rptRslt;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected List<Map<String, Object>> convert(RptParams rptParams) {
        RptRowSet rs = (RptRowSet)rptParams.getObject("rowset");
        ArrayList<Map<String, Object>> gridData = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> rowdata = null;
        String[] columnNames = rs.getColumnNames();
        while (rs.next()) {
            rowdata = new HashMap<String, Object>();
            for (String colName : columnNames) {
                if ("FBillDate".equalsIgnoreCase(colName)) {
                    Timestamp timestamp = (Timestamp)rs.getObject(colName);
                    if (timestamp == null) continue;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String dateStr = sdf.format(timestamp);
                    rowdata.put(colName.toLowerCase(), dateStr);
                    continue;
                }
                rowdata.put(colName.toLowerCase(), rs.getObject(colName));
            }
            gridData.add(rowdata);
        }
        return gridData;
    }

    @Override
    protected String[] convertColModel(RptParams rptParams) {
        ArrayList cols = new ArrayList();
        Map<String, Boolean> col = null;
        List rptFlds = this.params.getReportFields();
        int size = rptFlds.size();
        int amtStartIndex = this.params.getAmtColStartIndex();
        String res = "com.kingdee.eas.fi.arap.ArApRptResource";
        Locale locale = this.ctx.getLocale();
        String fld = null;
        String[] aligns = new String[]{"left", "center", "right"};
        List<Integer> undues = this.params.getUndueList();
        int undueSize = undues == null ? 0 : undues.size();
        List<Integer> overdues = this.params.getOverdueList();
        int overdueSize = overdues == null ? 0 : overdues.size();
        ArrayList _cols = null;
        for (int i = 0; i < size; ++i) {
            fld = ((String)rptFlds.get(i)).toLowerCase();
            _cols = cols;
            col = new HashMap();
            _cols.add(col);
            col.put("label", (Boolean)((Object)this.getColTitle(res, fld, locale)));
            col.put("name", (Boolean)((Object)fld));
            col.put("dataBind", (Boolean)((Object)fld));
            col.put("sortable", false);
            col.put("align", (Boolean)((Object)aligns[1]));
            if (this.params.isAmtCol(fld)) {
                col.put("formatter", (Boolean)((Object)"precisionFormatter"));
            }
            if (fld.toLowerCase(Locale.ENGLISH).endsWith("id")) {
                col.put("hidden", true);
                col.put("settable", false);
            }
            if ("fbilldate".equalsIgnoreCase(fld)) {
                col.put("formatter", (Boolean)((Object)"dateFormatter"));
            }
            if ("fcurrency".equalsIgnoreCase(fld)) {
                col.put("rowSpanKey", true);
            }
            if ("fcurrency|fasstactnumber|fcussacct".contains(fld.toLowerCase())) {
                col.put("rowspan", true);
            }
            if (this.params.isAmtCol(fld)) {
                col.put("width", (Boolean)((Object)Integer.valueOf(120)));
                continue;
            }
            col.put("width", (Boolean)((Object)Integer.valueOf(107)));
        }
        col = new HashMap<String, Object>();
        col.put("key", true);
        col.put("id", (Boolean)((Object)"queryGrid_id"));
        col.put("name", (Boolean)((Object)"id"));
        col.put("label", (Boolean)((Object)"id"));
        col.put("dataBind", (Boolean)((Object)"id"));
        col.put("hidden", true);
        col.put("settable", false);
        cols.add(0, col);
        ArrayList<String> colModels = new ArrayList<String>();
        String colModel = "";
        for (int i = 0; i < cols.size(); ++i) {
            col = (Map)cols.get(i);
            colModel = col.get("name") + "," + col.get("hidden") + "," + (String)col.get("label") + "," + (col.get("width") == null ? Integer.valueOf(100) : col.get("width")) + "," + col.get("align");
            colModels.add(colModel);
        }
        return colModels.toArray(new String[colModels.size()]);
    }

    @Override
    protected String[] getHeaderModel() {
        Locale locale = this.ctx.getLocale();
        String res = "com.kingdee.eas.fi.arap.ArApRptResource";
        String aging_UndueStr = ResourceBase.getString((String)res, (String)"Aging_Undue", (Locale)locale);
        String aging_OverdueStr = ResourceBase.getString((String)res, (String)"Aging_Overdue", (Locale)locale);
        List<Integer> undues = this.params.getUndueList();
        List<Integer> overdues = this.params.getOverdueList();
        String[] colModel = this.convertColModel(null);
        String firstAging_UndueCol = null;
        String firstAging_Overdue = null;
        for (int i = 0; i < colModel.length; ++i) {
            if (colModel[i].split(",")[0].startsWith("ful_") && firstAging_UndueCol == null) {
                firstAging_UndueCol = colModel[i].split(",")[0];
            }
            if (!colModel[i].split(",")[0].toLowerCase(Locale.ENGLISH).startsWith("fol_") || firstAging_Overdue != null) continue;
            firstAging_Overdue = colModel[i].split(",")[0];
        }
        ArrayList<String> headerModel = new ArrayList<String>();
        if (firstAging_UndueCol != null && undues != null) {
            headerModel.add(firstAging_UndueCol + "," + undues.size() + "," + aging_UndueStr);
        }
        if (firstAging_Overdue != null && overdues != null) {
            headerModel.add(firstAging_Overdue + "," + overdues.size() + "," + aging_OverdueStr);
        }
        return headerModel.toArray(new String[headerModel.size()]);
    }

    private String getColTitle(String res, String col, Locale locale) {
        String title = null;
        if (col.toLowerCase(Locale.ENGLISH).endsWith("company")) {
            title = ResourceBase.getString((String)res, (String)"Company", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("cussacct")) {
            title = ResourceBase.getString((String)res, (String)"AsstActName", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("asstactnumber")) {
            title = ResourceBase.getString((String)res, (String)"AsstActNumber", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("currency")) {
            title = ResourceBase.getString((String)res, (String)"Currency", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("billdate")) {
            title = ResourceBase.getString((String)res, (String)"Aging_BillDate", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("billtype")) {
            title = ResourceBase.getString((String)res, (String)"Aging_BillType", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("billnum")) {
            title = ResourceBase.getString((String)res, (String)"Aging_BillNumber", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("description")) {
            title = ResourceBase.getString((String)res, (String)"Aging_Remark", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("balance")) {
            title = ResourceBase.getString((String)res, (String)"Aging_Balance", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).endsWith("due")) {
            title = ResourceBase.getString((String)res, (String)"Aging_DueAmt", (Locale)locale);
        } else if (col.toLowerCase(Locale.ENGLISH).startsWith("ful_")) {
            Object[] args = col.substring(col.indexOf("_") + 1).split("t");
            if (col.toLowerCase(Locale.ENGLISH).startsWith("ful_t")) {
                title = ResourceBase.getString((String)res, (String)"Aging_UndueMore", (Locale)locale);
                title = MessageFormat.format(title, args[1]);
            } else {
                title = ResourceBase.getString((String)res, (String)"Aging_UndueRange", (Locale)locale);
                title = MessageFormat.format(title, args);
            }
        } else if (col.toLowerCase(Locale.ENGLISH).startsWith("fol_")) {
            Object[] args = col.substring(col.indexOf("_") + 1).split("t");
            if (col.toLowerCase(Locale.ENGLISH).startsWith("fol_t")) {
                title = ResourceBase.getString((String)res, (String)"Aging_OverdueMore", (Locale)locale);
                title = MessageFormat.format(title, args[1]);
            } else {
                title = ResourceBase.getString((String)res, (String)"Aging_OverdueRange", (Locale)locale);
                title = MessageFormat.format(title, args);
            }
        }
        return title;
    }

    @Override
    protected String getTitle() {
        String title = "";
        if (this.params == null) {
            return title;
        }
        title = this.params.isArRpt() ? "\u5e94\u6536\u8d26\u9f84\u5206\u6790\u8868" : "\u5e94\u4ed8\u8d26\u9f84\u5206\u6790\u8868";
        return title;
    }

    @Override
    protected void releaseTempTable() throws EASBizException, BOSException {
        if (this.tempTable == null) {
            return;
        }
        if (this.clazz == null) {
            return;
        }
        try {
            Method dropPoolTempTableMethod = this.clazz.getDeclaredMethod("dropPoolTempTable", Map.class);
            HashMap<String, Object> invokparam = new HashMap<String, Object>();
            invokparam.put("ctx", this.ctx);
            invokparam.put("tempTable", this.tempTable);
            Object obj = this.clazz.newInstance();
            dropPoolTempTableMethod.invoke(obj, invokparam);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String getWEBUIPK() {
        return "com.kingdee.eas.fi.ap.virtualAgingRptUI";
    }
}

