/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.tool.engine.cas.CASRptBaseService;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CASCashJournalService
extends CASRptBaseService {
    private Logger logger = Logger.getLogger(this.getClass());

    @Override
    protected Set getAllData() {
        HashSet<JournalCollection> set = new HashSet<JournalCollection>();
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection filterItems = filter.getFilterItems();
            filterItems.add(new FilterItemInfo("accountView.id", (Object)this.accountSet, CompareType.INCLUDE));
            filterItems.add(new FilterItemInfo("period.id", (Object)this.periodSet, CompareType.INCLUDE));
            filterItems.add(new FilterItemInfo("type", (Object)1, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("accountBank.*"));
            sic.add(new SelectorItemInfo("accountView.*"));
            sic.add(new SelectorItemInfo("oppAccountView.*"));
            sic.add(new SelectorItemInfo("voucherType.name"));
            sic.add(new SelectorItemInfo("cashier.name"));
            view.setSelector(sic);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("accountView.id"));
            sorter.add(new SorterItemInfo("createDate"));
            sorter.add(new SorterItemInfo("createTime"));
            sorter.add(new SorterItemInfo("lineNo"));
            view.setSorter(sorter);
            JournalCollection coll = JournalFactory.getLocalInstance((Context)this.ctx).getJournalCollection(view);
            JournalCollection tempColl = new JournalCollection();
            for (int i = 0; i < coll.size(); ++i) {
                if (i == 0) {
                    tempColl.add(coll.get(i));
                }
                if (i > 0 && coll.get(i).getAccountView().getId().equals((Object)coll.get(i - 1).getAccountView().getId())) {
                    tempColl.add(coll.get(i));
                } else if (i > 0) {
                    JournalCollection realTempColl = (JournalCollection)tempColl.clone();
                    set.add(realTempColl);
                    tempColl.clear();
                    tempColl.add(coll.get(i));
                }
                if (i != coll.size() - 1) continue;
                set.add(tempColl);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return set;
    }

    @Override
    protected InputStream getPrint(Set data) {
        if (data == null || data.size() == 0) {
            return null;
        }
        String[] cashJournalHead = new String[]{"\u65e5\u671f", "\u4e1a\u52a1\u65e5\u671f", "\u51ed\u8bc1\u7c7b\u578b", "\u51ed\u8bc1\u53f7", "\u5bf9\u65b9\u79d1\u76ee", "\u5355\u636e\u7c7b\u578b", "\u5355\u636e\u53f7", "\u6458\u8981", "\u501f\u65b9(\u539f\u5e01)", "\u501f\u65b9(\u672c\u4f4d\u5e01)", "\u8d37\u65b9(\u539f\u5e01)", "\u8d37\u65b9(\u672c\u4f4d\u5e01)", "\u65b9\u5411", "\u4f59\u989d(\u539f\u5e01)", "\u4f59\u989d(\u672c\u4f4d\u5e01)", "\u6765\u6e90", "\u51fa\u7eb3"};
        Iterator it = data.iterator();
        int index = 0;
        XSSFRow xssfRow = null;
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = null;
        HashMap<String, Boolean> map005 = new HashMap<String, Boolean>();
        while (it.hasNext()) {
            JournalCollection coll = (JournalCollection)it.next();
            String accountbank = coll.get(0).getAccountView().getName();
            String number = coll.get(0).getAccountView().getNumber();
            if (index > 0) {
                this.currentSheet = this.workbook.createSheet(index + 1 + accountbank + number);
            } else {
                this.workbook = new XSSFWorkbook();
                this.currentSheet = this.workbook.createSheet(index + 1 + accountbank + number);
            }
            xssfRow = this.currentSheet.createRow(0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.CreateFirstRow(xssfRow, cashJournalHead);
            BigDecimal balance = new BigDecimal(0);
            BigDecimal debitAmount = new BigDecimal(0);
            BigDecimal creditAmount = new BigDecimal(0);
            BigDecimal dayDebitAmount = new BigDecimal(0);
            BigDecimal dayCreditAmount = new BigDecimal(0);
            BigDecimal countDebitAmount = new BigDecimal(0);
            BigDecimal countCreditAmount = new BigDecimal(0);
            BigDecimal rate = new BigDecimal(1);
            String dc = "\u501f";
            try {
                int rowIndex = 1;
                if (!coll.get(0).getCurrency().getId().equals((Object)this.company.getBaseCurrency().getId())) {
                    rate = this.getExchange(this.company, coll.get(0).getCurrency(), this.company.getBaseCurrency(), this.perCol.get(0).getBeginDate());
                    ExchangeRateInfo eInfo = this.getExRateInfo(coll.get(0).getCurrency(), this.company.getBaseCurrency(), this.company, this.perCol.get(0).getBeginDate());
                    if (eInfo != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)eInfo.getConvertMode())) {
                        rate = Constants.ONE.divide(rate, 20, 4);
                    }
                }
                BigDecimal startBalance = this.getBeginBalanceNew(this.company, coll.get(0).getCurrency(), this.perCol.get(0), coll.get(0).getAccountView(), coll.get(0).getAccountBank(), 1);
                String direction = coll.get(0).getAccountView().getDC().getAlias();
                boolean GL_005 = true;
                if (map005 != null && map005.containsKey(this.company.getId().toString())) {
                    GL_005 = (Boolean)map005.get(this.company.getId().toString());
                } else {
                    GL_005 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("GL_005", (IObjectPK)new ObjectUuidPK(this.company.getId()));
                    map005.put(this.company.getId().toString(), GL_005);
                }
                this.setGlDc(GL_005);
                for (int i = 0; i < coll.size(); ++i) {
                    JournalInfo info = coll.get(i);
                    if (i == 0) {
                        dc = this.getParamDc(direction, startBalance);
                        map.put("balance", this.getParamBalance(startBalance).toString());
                        map.put("date", this.perCol.get(0).getBeginDate());
                        map.put("description", "\u671f\u521d\u4f59\u989d");
                        map.put("debitAmount", " ");
                        map.put("creditAmount", " ");
                        map.put("isDebit", dc);
                        xssfRow = this.currentSheet.createRow(rowIndex++);
                        this.CreateCountRow(xssfRow, map, "CAS_CashJournal", rate);
                    }
                    debitAmount = info.getDebitAmount();
                    countDebitAmount = countDebitAmount.add(debitAmount).setScale(2, 4);
                    dayDebitAmount = dayDebitAmount.add(debitAmount).setScale(2, 4);
                    creditAmount = info.getCreditAmount();
                    countCreditAmount = countCreditAmount.add(creditAmount).setScale(2, 4);
                    dayCreditAmount = dayCreditAmount.add(creditAmount).setScale(2, 4);
                    balance = startBalance.add(countDebitAmount.subtract(countCreditAmount)).setScale(2, 4);
                    xssfRow = this.currentSheet.createRow(rowIndex++);
                    this.CreateRow(xssfRow, coll.get(i), null, balance, rate);
                    if (i < coll.size() - 1 && !coll.get(i).getCreateDate().equals(coll.get(i + 1).getCreateDate())) {
                        dc = this.getParamDc(direction, balance);
                        map.put("balance", this.getParamBalance(balance).toString());
                        map.put("date", coll.get(i).getCreateDate());
                        map.put("description", "\u672c\u65e5\u5408\u8ba1");
                        map.put("debitAmount", dayDebitAmount.toString());
                        map.put("creditAmount", dayCreditAmount.toString());
                        xssfRow = this.currentSheet.createRow(rowIndex++);
                        map.put("isDebit", dc);
                        this.CreateCountRow(xssfRow, map, "CAS_CashJournal", rate);
                        dayDebitAmount = new BigDecimal(0);
                        dayCreditAmount = new BigDecimal(0);
                    }
                    if (i != coll.size() - 1) continue;
                    dc = this.getParamDc(direction, balance);
                    map.put("balance", this.getParamBalance(balance).toString());
                    map.put("date", coll.get(i).getCreateDate());
                    map.put("description", "\u672c\u65e5\u5408\u8ba1");
                    map.put("debitAmount", dayDebitAmount.toString());
                    map.put("creditAmount", dayCreditAmount.toString());
                    map.put("isDebit", dc);
                    xssfRow = this.currentSheet.createRow(rowIndex++);
                    this.CreateCountRow(xssfRow, map, "CAS_CashJournal", rate);
                    map.put("date", this.perCol.get(0).getEndDate());
                    map.put("description", "\u672c\u671f\u5408\u8ba1");
                    map.put("debitAmount", countDebitAmount.toString());
                    map.put("creditAmount", countCreditAmount.toString());
                    xssfRow = this.currentSheet.createRow(rowIndex);
                    this.CreateCountRow(xssfRow, map, "CAS_CashJournal", rate);
                }
            }
            catch (EASBizException e) {
                this.logger.error((Object)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
            }
            ++index;
        }
        XSSFWorkbook workbook = this.currentSheet.getWorkbook();
        try {
            workbook.write((OutputStream)boas);
            inputStream = new ByteArrayInputStream(boas.toByteArray());
            boas.close();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return inputStream;
    }

    @Override
    protected Object getPdfPrint(Set data, String printTemplate) {
        return null;
    }
}

