/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.gl.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.tool.engine.gl.provider.AbstractGLRptPrintProvider;
import com.kingdee.eas.el.rec.tool.engine.gl.provider.GLRptGeneralLedgerPrintBFByAccount;
import com.kingdee.eas.el.rec.tool.engine.gl.setting.GLRptGeneralLedgerPrintSetting;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptGeneralLedgerPrintProvider
extends AbstractGLRptPrintProvider {
    private static final Logger logger = Logger.getLogger(GLRptGeneralLedgerPrintProvider.class);
    public static final String[][] col = new String[][]{{"sysDateNow", ""}, {"h_CurrentUser", ""}, {"h_period", ""}, {"h_currency", ""}, {"h_company", ""}, {"FPeriodYearHead", ""}, {"FPeriodYear", ""}, {"FPeriodMonth", ""}, {"FperiodDay", ""}, {"FPeriodChinese", ""}, {"FAccountNumber", "accountNumber"}, {"FAccountName", "accountName"}, {"FCompany", "companyName"}, {"FCurrencyID", "FCurrencyID"}, {"FCurrencyName", "currencyName"}, {"FCurrencyPre", "currencyPre"}, {"FPeriodRedundancy", ""}, {"FPeriod", "FPeriod"}, {"FDescOfVoucher", "FDescription"}, {"FDebitQty", "FDebitQty"}, {"FDebitFor", "FDebitFor"}, {"FDebitLocal", "FDebitLocal"}, {"FDebitRpt", "FDebitRpt"}, {"FCreditQty", "FCreditQty"}, {"FCreditFor", "FCreditFor"}, {"FCreditLocal", "FCreditLocal"}, {"FCreditRpt", "FCreditRpt"}, {"FQty", "FEndQty"}, {"FPrice", "FEndPrice"}, {"FBalanceOritention", "accountDC"}, {"FBalanceAmountFor", "FEndBalanceFor"}, {"FBalanceAmountLocal", "FEndBalanceLocal"}, {"FBalanceAmountRpt", "FEndBalanceRpt"}};
    protected boolean bBF = ((GLRptGeneralLedgerPrintSetting)this.config).isBF();
    protected boolean printByAccount = ((GLRptGeneralLedgerPrintSetting)this.config).isChkPrintByAccount();
    protected boolean isChkFillAccountNumberAndName = ((GLRptGeneralLedgerPrintSetting)this.config).isChkFillAccountNumberAndName();
    protected boolean isOptionNoDisplayZeroTotal = false;
    protected String RESOURCE_PATH = "com.kingdee.eas.fi.gl.TaoDaResource";

    public GLRptGeneralLedgerPrintProvider(Map<String, Object> params) {
        super(params);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        SimpleDateFormat format = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI"));
        int it = 0;
        int entryCount = 0;
        int icycleDegree = rowLineCount;
        int entryNumber = 0;
        int ir = 1;
        int flagBF = 0;
        boolean bearForwardPage = false;
        boolean overHypoPage = false;
        Object strYearMonthDay = null;
        String allCurrency = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"all_currency");
        String cell_yearInitAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_yearInitAmount");
        String cell_periodInitAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_periodInitAmount");
        String cell_periodAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_periodAmount");
        String cell_yearAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_yearAmount");
        int colCount = col.length;
        String strTempNumber = null;
        String strTempName = null;
        DynamicRowSet drs = null;
        HashMap hmParamValue = new HashMap();
        try {
            hmParamValue = this.getInitParam(this.curCompany);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        int qtyScale = 2;
        if (hmParamValue.get("GL_002") != null) {
            qtyScale = Integer.parseInt(hmParamValue.get("GL_002").toString());
        }
        boolean showQty = (Boolean)this.vars.get("showQty");
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i][0];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.vars.get("currencyId");
            CurrencyInfo currency = null;
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = baseCurrency;
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
            } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            boolean isBaseCurrency = currency != null && baseCurrency.getId().equals((Object)currency.getId());
            boolean isGBaseCy = currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC");
            boolean isGRptCy = currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC");
            it = this.rs.size();
            entryCount = 0;
            this.rs.beforeFirst();
            while (this.rs.next()) {
                drs.moveToInsertRow();
                GLRptGeneralLedgerPrintProvider.clearRow((IRowSet)drs);
                ++entryCount;
                drs.updateString("sysDateNow", GlUtils.formatDate((DateFormat)format, (Date)new Date()));
                UserInfo user = (UserInfo)this.ctx.get((Object)"UserInfo");
                drs.updateString("h_CurrentUser", user.getName());
                this.setHeadFieldOrgValue(drs);
                drs.updateObject("h_period", (Object)this.vars.get("mapPeriod").toString().split(":")[1]);
                drs.updateObject("h_currency", (Object)(currency == null ? allCurrency : currency.getName()));
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                String yearBegin = this.cond.getPeriodYearStart() + "";
                String yearEnd = this.cond.getPeriodYearEnd() + "";
                if (yearBegin != null && !StringUtils.isEmpty((String)yearBegin) && yearEnd != null && !StringUtils.isEmpty((String)yearEnd)) {
                    if (yearBegin.equals(yearEnd)) {
                        drs.updateString("FPeriodYearHead", yearBegin);
                    } else {
                        drs.updateString("FPeriodYearHead", yearBegin + "-" + yearEnd);
                    }
                }
                for (int i = 10; i < col.length; ++i) {
                    Object value;
                    if (this.rs.indexOf(col[i][1]) == -1 || (value = this.rs.getObject(col[i][1])) == null) continue;
                    if (!(value instanceof BigDecimal)) {
                        drs.updateString(col[i][0], value.toString());
                        if (col[i][1].equalsIgnoreCase(this.getOrgColumnName())) {
                            drs.updateString(col[i][0], value.toString());
                        }
                        if (col[i][1].equalsIgnoreCase("FPeriod")) {
                            // empty if block
                        }
                        if (!this.isChkFillAccountNumberAndName) continue;
                        if (col[i][1].equalsIgnoreCase("accountNumber") && !value.toString().equals("")) {
                            strTempNumber = value.toString();
                        }
                        if (col[i][1].equalsIgnoreCase("accountNumber") && value.toString().equals("")) {
                            drs.updateString(col[i][0], strTempNumber);
                        }
                        if (col[i][1].equalsIgnoreCase("accountName") && !value.toString().equals("")) {
                            strTempName = value.toString();
                        }
                        if (!col[i][1].equalsIgnoreCase("accountName") || !value.toString().equals("")) continue;
                        drs.updateString(col[i][0], strTempName);
                        continue;
                    }
                    if (((BigDecimal)value).compareTo(new BigDecimal("0")) == 0) {
                        if (col[i][0].endsWith("FBalanceAmountLocal")) {
                            if (drs.getString("FBalanceAmountLocal") != null && drs.getString("FBalanceAmountLocal").length() != 0) continue;
                            drs.updateString(col[i][0], "");
                            continue;
                        }
                        if (col[i][0].endsWith("FBalanceAmountRpt")) {
                            if (drs.getString("FBalanceAmountRpt") != null && drs.getString("FBalanceAmountRpt").length() != 0) continue;
                            drs.updateString(col[i][0], "");
                            continue;
                        }
                        drs.updateString(col[i][0], "");
                        continue;
                    }
                    value = ((BigDecimal)value).abs();
                    if (col[i][0].endsWith("FBalanceAmountLocal") || col[i][0].endsWith("FBalanceAmountRpt")) {
                        if (this.cond.isShowLocal() || this.cond.isShowRpt()) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)((BigDecimal)value), (int)precision));
                        }
                    } else {
                        drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)((BigDecimal)value), (int)precision));
                    }
                    if (col[i][0].endsWith("Local")) continue;
                    if (col[i][0].startsWith("FDebit") && drs.getString("FDebitLocal") == null) {
                        drs.updateString("FDebitLocal", GlUtils.withComma((BigDecimal)((BigDecimal)value), (int)precision));
                        continue;
                    }
                    if (col[i][0].startsWith("FCredit") && drs.getString("FCreditLocal") == null) {
                        drs.updateString("FCreditLocal", GlUtils.withComma((BigDecimal)((BigDecimal)value), (int)precision));
                        continue;
                    }
                    if (!col[i][0].startsWith("FBalance") || drs.getString("FBalanceAmountLocal") != null && drs.getString("FBalanceAmountLocal").length() != 0) continue;
                    drs.updateString("FBalanceAmountLocal", GlUtils.withComma((BigDecimal)((BigDecimal)value), (int)precision));
                }
                drs.insertRow();
                if (!this.bBF || this.printByAccount) continue;
                if (it - entryCount > icycleDegree) {
                    bearForwardPage = true;
                    overHypoPage = true;
                }
                if (it == entryCount + flagBF) {
                    bearForwardPage = false;
                    overHypoPage = false;
                    ir = 1;
                }
                if (++entryNumber != icycleDegree - ir) continue;
                if (overHypoPage) {
                    drs.moveToInsertRow();
                    ++flagBF;
                    ++it;
                    drs.updateString("FAccountNumber", "");
                    drs.updateString("FAccountName", "");
                    drs.updateString(this.getPrintOrgColumn(), "");
                    drs.updateString("FCurrencyName", "");
                    drs.updateString("FCurrencyPre", "");
                    drs.updateString("FPeriodRedundancy", "");
                    drs.updateString("FDebitQty", "");
                    drs.updateString("FCreditQty", "");
                    drs.updateString("FQty", "");
                    drs.updateString("FPrice", "");
                    drs.updateString("FPeriodYear", "");
                    drs.updateString("FPeriodMonth", "");
                    drs.updateString("FperiodDay", "");
                    String resFullName = "com.kingdee.eas.fi.gl.TaoDaResource";
                    String strOverHypoPage = EASResource.getString((String)resFullName, (String)"overHypoPage");
                    drs.updateString("FDescOfVoucher", strOverHypoPage);
                    drs.insertRow();
                }
                if (bearForwardPage) {
                    drs.moveToInsertRow();
                    ++flagBF;
                    ++it;
                    drs.updateString("FAccountNumber", "");
                    drs.updateString("FAccountName", "");
                    drs.updateString(this.getPrintOrgColumn(), "");
                    drs.updateString("FCurrencyName", "");
                    drs.updateString("FCurrencyPre", "");
                    drs.updateString("FPeriodRedundancy", "");
                    drs.updateString("FDebitQty", "");
                    drs.updateString("FCreditQty", "");
                    drs.updateString("FQty", "");
                    drs.updateString("FPrice", "");
                    drs.updateString("FPeriodYear", "");
                    drs.updateString("FPeriodMonth", "");
                    drs.updateString("FperiodDay", "");
                    String resFullName = "com.kingdee.eas.fi.gl.TaoDaResource";
                    String strBearForwardPage = EASResource.getString((String)resFullName, (String)"bearForwardPage");
                    drs.updateString("FDescOfVoucher", strBearForwardPage);
                    drs.insertRow();
                }
                entryNumber = 0;
                if (it - entryCount <= icycleDegree) continue;
                ir = 2;
            }
            if (this.bBF) {
                if (this.printByAccount) {
                    GLRptGeneralLedgerPrintBFByAccount addBf = this.getGeneralLedgerPrintBFByAccount();
                    addBf.addBf((IRowSet)drs, rowLineCount);
                } else {
                    drs.beforeFirst();
                    while (!drs.last()) {
                        String resFullName = "com.kingdee.eas.fi.gl.TaoDaResource";
                        String strBearForwardPage = EASResource.getString((String)resFullName, (String)"bearForwardPage");
                        if (drs.getString("FDescOfVoucher").equals(strBearForwardPage)) {
                            drs.next();
                            String accountName = drs.getString("FAccountName");
                            drs.previous();
                            drs.updateString("FAccountName", accountName);
                        }
                        drs.next();
                    }
                }
            }
            if (this.printByAccount) {
                drs.beforeFirst();
                drs.next();
                String curAccountNumber = drs.getString("FAccountNumber");
                int rowCount = 1;
                while (!drs.isLast()) {
                    try {
                        String nextRowAccountNumber = this.getValue((IRowSet)drs, 1, "FAccountNumber");
                        if (nextRowAccountNumber != null && nextRowAccountNumber.length() != 0 && !nextRowAccountNumber.equals(curAccountNumber)) {
                            for (int i = rowCount; i < rowLineCount; ++i) {
                                this.insertEmptyRow((IRowSet)drs);
                            }
                            curAccountNumber = nextRowAccountNumber;
                            rowCount = 1;
                        } else {
                            rowCount = rowCount < rowLineCount ? ++rowCount : 1;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    drs.next();
                }
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    protected void setHeadFieldOrgValue(DynamicRowSet drs) throws SQLException {
        drs.updateString("h_company", this.curCompany.getName().toString());
    }

    protected String getOrgColumnName() {
        return "companyName";
    }

    protected String getPrintOrgColumn() {
        return "FCompany";
    }

    protected GLRptGeneralLedgerPrintBFByAccount getGeneralLedgerPrintBFByAccount() {
        return new GLRptGeneralLedgerPrintBFByAccount();
    }

    private BigDecimal getBigDecimal(GLRptRowSet rs, String field) throws BOSException {
        BigDecimal amount = rs.getBigDecimal(field);
        if (amount == null) {
            return GlUtils.zero;
        }
        return amount;
    }

    private DynamicRowSet createDynamicRowSet(int colCount) throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 0; i < colCount; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = col[i][0];
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        drs.beforeFirst();
        return drs;
    }

    private String getFormatedValue(BigDecimal value, int scale) {
        if (value == null) {
            value = GlUtils.zero;
        }
        return GlUtils.withComma((BigDecimal)value, (int)scale);
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private HashMap getInitParam(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)String.valueOf(company.getId())));
        HashMap<String, ObjectUuidPK> sysParams = new HashMap<String, ObjectUuidPK>();
        sysParams.put("GL_059", comPK);
        sysParams.put("GL_002", comPK);
        return ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(sysParams);
    }

    private String getValue(IRowSet rowSet, int pace, String field) throws SQLException {
        String returnVal = "";
        int cp = rowSet.getRow();
        rowSet.absolute(cp + pace);
        returnVal = rowSet.getString(field);
        rowSet.absolute(cp);
        return returnVal;
    }

    private void insertEmptyRow(IRowSet rowSet) throws SQLException {
        int rowNum = rowSet.getRow();
        rowSet.moveToInsertRow();
        rowSet.updateString(this.getPrintOrgColumn(), "");
        rowSet.updateString("FPeriod", "");
        rowSet.updateString("FDebitQty", "");
        rowSet.updateString("FCreditQty", "");
        rowSet.updateString("FQty", "");
        rowSet.updateString("FPrice", "");
        rowSet.updateString("h_period", "");
        rowSet.updateString("FPeriodYear", "");
        rowSet.updateString("FPeriodMonth", "");
        rowSet.updateString("FperiodDay", "");
        rowSet.updateString("FPeriodRedundancy", "");
        rowSet.updateString("FPeriodMonth", "");
        rowSet.updateString("FperiodDay", "");
        rowSet.updateString("FAccountNumber", "");
        rowSet.updateString("FAccountName", "");
        rowSet.updateString("FPeriod", "");
        rowSet.updateString("FDescOfVoucher", "");
        rowSet.updateString("FBalanceOritention", "");
        rowSet.updateString("FDebitFor", "");
        rowSet.updateString("FDebitLocal", "");
        rowSet.updateString("FDebitRpt", "");
        rowSet.updateString("FCreditFor", "");
        rowSet.updateString("FCreditLocal", "");
        rowSet.updateString("FCreditRpt", "");
        rowSet.updateString("FBalanceAmountFor", "");
        rowSet.updateString("FBalanceAmountLocal", "");
        rowSet.updateString("FBalanceAmountRpt", "");
        rowSet.insertRow();
        rowSet.beforeFirst();
        rowSet.absolute(rowNum + 1);
    }

    protected String getPeriodTemp(String strPeriod) throws Exception {
        String sPeriod = null;
        try {
            String yearBegin = this.cond.getPeriodYearStart() + "";
            String numberBegin = this.cond.getPeriodNumberStart() + "";
            String yearEnd = this.cond.getPeriodYearEnd() + "";
            String numberEnd = this.cond.getPeriodNumberEnd() + "";
            sPeriod = yearBegin.equalsIgnoreCase(yearEnd) && numberBegin.equalsIgnoreCase(numberEnd) && strPeriod.indexOf(".") == -1 ? yearBegin + "." + strPeriod : (yearBegin.equalsIgnoreCase(yearEnd) && !numberBegin.equalsIgnoreCase(numberEnd) && strPeriod.indexOf(".") == -1 ? yearBegin + "." + strPeriod : strPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sPeriod;
    }

    protected String[] getCompoundingPeriodData(String strPeriod) throws Exception {
        Object sDate = null;
        Object obj = null;
        String[] strPeriodStartEnd = null;
        return strPeriodStartEnd;
    }

    protected String[] getYearMonthDay(String[] strPeriodStartEnd) throws Exception {
        String[] periodStart = strPeriodStartEnd[0].split("\\-");
        String[] periodEnd = strPeriodStartEnd[1].split("\\-");
        String[] yearMonthDay = new String[]{periodStart[0], periodStart[1], periodStart[2], periodEnd[0], periodEnd[1], periodEnd[2]};
        return yearMonthDay;
    }

    protected String getYearAndMonthChinese(String strPeriod) throws Exception {
        String sPeriod = null;
        String strdi = EASResource.getString((String)this.RESOURCE_PATH, (String)"di");
        String strqi = EASResource.getString((String)this.RESOURCE_PATH, (String)"qi");
        if (strPeriod.indexOf(".") != -1) {
            String[] sPeriods = strPeriod.split("\\.");
            Locale locale = this.ctx.getLocale();
            String strPq = GlUtils.getChineseFormat((int)Integer.parseInt(sPeriods[0]), (Locale)locale);
            String strPh = null;
            if (sPeriods.length > 1) {
                strPh = GlUtils.getChineseBig((int)Integer.parseInt(sPeriods[1]), (Locale)locale);
            }
            sPeriod = strPq + strdi + strPh + strqi;
        } else {
            sPeriod = strdi + strPeriod + strqi;
        }
        if (sPeriod == null) {
            String string = EASResource.getString((String)this.RESOURCE_PATH, (String)"lblDataError");
        }
        return sPeriod;
    }
}

