/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.industry.emm.lcm.CostEstimationBillEntryInfo;
import com.kingdee.eas.industry.emm.lcm.CostEstimationBillInfo;
import com.kingdee.eas.industry.emm.lcm.client.AbstractCostEstimationBillEditUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CostEstimationBillEditUI
extends AbstractCostEstimationBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CostEstimationBillEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.prmtFICompany, null, (KDBizPromptBox)this.prmtproject, (KDBizPromptBox)this.prmttrackNumber, (boolean)false);
        this.btnCoeff.setEnabled(true);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        SCMClientUtils.changeColumnPrecision((KDTable)this.kdtEntrys, (String[])new String[]{"qty"}, (int)6, (boolean)false);
        SCMClientUtils.changeColumnPrecision((KDTable)this.kdtEntrys, (String[])new String[]{"amount"}, (int)2, (boolean)false);
        this.kdtEntrys.getColumn("material").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("qty").getStyleAttributes().setLocked(true);
        this.kdtEntrys_detailPanel.getAddNewLineButton().setVisible(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setVisible(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setVisible(false);
    }

    @Override
    protected IObjectValue createNewData() {
        CostEstimationBillInfo objectValue = new CostEstimationBillInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")).getBoolean("isBizUnit")) {
            objectValue.put("FICompany", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBizDate(new Date());
        try {
            objectValue.setPeriod(SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, objectValue.getFICompany().getId().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
        return objectValue;
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((Object)this.prmtproject.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.mm.mo.MOSheduleResource", (String)"projectNumber")});
        }
        if (UIRuleUtil.isNull((Object)this.prmtperiod.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"term")});
        }
        if (UIRuleUtil.isNull((Object)this.prmttrackNumber.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.mm.planning.app.ReqCollectResource", (String)"ColTRNumber")});
        }
    }

    protected IObjectValue createNewDetailData(KDTable kdtable) {
        return new CostEstimationBillEntryInfo();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.SUBMITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0000"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBillBaseInfo)this.editData);
        this.editData = (CostEstimationBillInfo)this.getValue((IObjectPK)pk);
        if (this.editData.getStatus() == BillBaseStatusEnum.AUDITED) {
            this.setOprtState(OprtState.VIEW);
        } else {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0001"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).unpassAudit((IObjectPK)pk, (CoreBillBaseInfo)this.editData);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(true);
    }

    @Override
    public void actionCoeff_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == BillBaseStatusEnum.AUDITED) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0025"));
            return;
        }
        KDTextField text = new KDTextField(20);
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0026"), text};
        JOptionPane pane = new JOptionPane(message, 1);
        JDialog dialog = pane.createDialog(null, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0027"));
        dialog.setVisible(true);
        if (text.getText() == null || text.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0027"));
            return;
        }
        try {
            BigDecimal coeff = new BigDecimal(text.getText());
            if (coeff.compareTo(BigDecimal.ZERO) <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0028"));
                return;
            }
            for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                this.kdtEntrys.getRow(i).getCell("coeff").setValue((Object)coeff);
            }
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0029"));
            return;
        }
        super.actionCoeff_actionPerformed(e);
    }
}

