/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.lcm.CostEstimationBillFactory;
import com.kingdee.eas.industry.emm.lcm.CostEstimationBillInfo;
import com.kingdee.eas.industry.emm.lcm.ICostEstimationBill;
import com.kingdee.eas.industry.emm.lcm.client.AbstractCostEstimationBillListUI;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CostEstimationBillListUI
extends AbstractCostEstimationBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(CostEstimationBillListUI.class);
    protected boolean isSubmitting;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ItemAction[] actList = new ItemAction[]{this.actionCopyTo, this.actionCreateTo, this.actionLocate, this.actionAttachment, this.actionCancel, this.actionCancelCancel, this.actionVoucher, this.actionDelVoucher, this.actionAuditResult, this.actionMultiapprove, this.actionNextPerson, this.actionSignature, this.actionStartWorkFlow, this.actionWorkFlowG, this.actionWorkflowList, this.actionTraceUp, this.actionTraceDown};
        NCMClientUtils.setActionVisible((boolean)false, (ItemAction[])actList);
        this.btnSubmit.setEnabled(true);
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ICostEstimationBill ice = (ICostEstimationBill)this.getBizInterface();
        this.checkSelected();
        this.checkAction("submit");
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            CostEstimationBillInfo info = ice.getCostEstimationBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            this.getBizInterface().submit((CoreBaseInfo)info);
        }
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ICostEstimationBill ice = (ICostEstimationBill)this.getBizInterface();
        this.checkSelected();
        this.checkAction("audit");
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            ice.passAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), null);
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ICostEstimationBill ice = (ICostEstimationBill)this.getBizInterface();
        this.checkSelected();
        this.checkAction("unAudit");
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            ice.unpassAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), null);
        }
        this.refreshList();
    }

    protected void checkAction(String action) throws Exception {
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String billStatus = row.getCell("status").getValue().toString().trim();
                if ("audit".equals(action)) {
                    this.checkAudit(billStatus);
                    continue;
                }
                if ("edit".equals(action)) {
                    this.checkEdit(billStatus);
                    continue;
                }
                if ("remove".equals(action)) {
                    this.checkRemove(billStatus);
                    continue;
                }
                if ("unAudit".equals(action)) {
                    this.checkUnAudit(billStatus);
                    continue;
                }
                if (!"submit".equals(action)) continue;
                this.checkSubmit(billStatus);
            }
        }
    }

    private void checkAudit(String billStatus) {
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_AUDIT"));
            SysUtil.abort();
        }
    }

    private void checkSubmit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)"\u53ea\u80fd\u63d0\u4ea4\u4fdd\u5b58\u72b6\u6001\u6216\u8005\u63d0\u4ea4\u72b6\u6001\u5355\u636e!");
            SysUtil.abort();
        }
    }

    private void checkEdit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_EDIT"));
            SysUtil.abort();
        }
    }

    private void checkRemove(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_DELETE"));
            SysUtil.abort();
        }
    }

    private void checkUnAudit(String billStatus) {
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_UNAUDIT"));
            SysUtil.abort();
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CostEstimationBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        CostEstimationBillInfo objectValue = new CostEstimationBillInfo();
        return objectValue;
    }
}

