/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.industry.emm.lcm.CostReviseBillEntryInfo;
import com.kingdee.eas.industry.emm.lcm.CostReviseBillInfo;
import com.kingdee.eas.industry.emm.lcm.client.AbstractCostReviseBillEditUI;
import com.kingdee.eas.industry.emm.lcm.util.LcmUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CostReviseBillEditUI
extends AbstractCostReviseBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CostReviseBillEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAudit.setEnabled(true);
        this.actionUnAudit.setVisible(false);
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    CostReviseBillEditUI.this.kdtEntrys_editStopped(e);
                }
                catch (Exception e1) {
                    CostReviseBillEditUI.this.handleException(e1);
                }
            }
        });
        this.actionCopy.setVisible(false);
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) throws BOSException, SQLException {
        CostObjectInfo co;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntrys.getColumn("costObject").getColumnIndex() && (co = (CostObjectInfo)this.kdtEntrys.getCell(rowIndex, colIndex).getValue()) != null) {
            CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.prmtFICompany.getValue();
            PeriodInfo period = (PeriodInfo)this.prmtperiod.getValue();
            if (cou == null || period == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0033"));
                SysUtil.abort();
            }
            String[] dateStrArray = LcmUtils.dealPeriod(period);
            StringBuffer sql = new StringBuffer();
            sql.append(" /*dialect*/select en.fid as fid ");
            sql.append(" from t_im_materialreqbill bill ");
            sql.append(" inner join t_scm_transactiontype tti on bill.ftransactiontypeid=tti.fid ");
            sql.append(" inner join t_im_materialreqbillentry en on bill.fid=en.fparentid ");
            sql.append(" where bill.fbasestatus=4 ");
            sql.append(" and tti.fismanucostcalculate=1 ");
            sql.append(" and en.fcompanyorgunitid='" + cou.getId().toString() + "'");
            sql.append(" and en.fcostobjectid='" + co.getId().toString() + "'");
            sql.append(" and bill.fbizdate>=to_date('").append(dateStrArray[0]).append("','yyyy-MM-dd HH24:mi:ss')");
            sql.append(" and bill.fbizdate<=to_date('").append(dateStrArray[1]).append("','yyyy-MM-dd HH24:mi:ss')");
            sql.append(" and en.fbizdate>=to_date('").append(dateStrArray[0]).append("','yyyy-MM-dd HH24:mi:ss')");
            sql.append(" and en.fbizdate<=to_date('").append(dateStrArray[1]).append("','yyyy-MM-dd HH24:mi:ss')");
            IRowSet rs = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            ev.setFilter(filter);
            SelectorItemCollection sColl = new SelectorItemCollection();
            sColl.add(new SelectorItemInfo("parent.number"));
            sColl.add(new SelectorItemInfo("parent.costCenterOrgUnit.*"));
            sColl.add(new SelectorItemInfo("*"));
            sColl.add(new SelectorItemInfo("costObject.*"));
            sColl.add(new SelectorItemInfo("material.*"));
            ev.setSelector(sColl);
            SorterItemCollection siColl = new SorterItemCollection();
            siColl.add(new SorterItemInfo("parent.number"));
            siColl.add(new SorterItemInfo("seq"));
            ev.setSorter(siColl);
            MaterialReqBillEntryCollection mqColl = MaterialReqBillEntryFactory.getRemoteInstance().getMaterialReqBillEntryCollection(ev);
            if (mqColl != null && mqColl.size() > 0) {
                int count = rowIndex;
                for (int i = 0; i < mqColl.size(); ++i) {
                    MaterialReqBillEntryInfo entryInfo = mqColl.get(i);
                    IRow row = null;
                    row = this.kdtEntrys.getRowCount() > count ? this.kdtEntrys.getRow(count) : this.kdtEntrys.addRow();
                    ++count;
                    row.getCell("costObject").setValue((Object)entryInfo.getCostObject());
                    row.getCell("costObjectName").setValue((Object)entryInfo.getCostObject().getName());
                    row.getCell("toCostObject").setValue((Object)entryInfo.getCostObject());
                    row.getCell("toCostObjectName").setValue((Object)entryInfo.getCostObject().getName());
                    row.getCell("costCenter").setValue((Object)entryInfo.getParent().getCostCenterOrgUnit());
                    row.getCell("materialReqNumber").setValue((Object)entryInfo.getParent().getNumber());
                    row.getCell("materialReqEntrySeq").setValue((Object)entryInfo.getSeq());
                    row.getCell("material").setValue((Object)entryInfo.getMaterial());
                    row.getCell("materialNumber").setValue((Object)entryInfo.getMaterial().getName());
                    row.getCell("materialModel").setValue((Object)entryInfo.getMaterial().getModel());
                    row.getCell("materialReqQty").setValue((Object)entryInfo.getQty());
                    row.getCell("amount").setValue((Object)entryInfo.getActualCost());
                    row.getCell("materialReqEntryID").setValue((Object)entryInfo.getId().toString());
                }
            }
        }
    }

    @Override
    protected IObjectValue createNewData() {
        CostReviseBillInfo objectValue = new CostReviseBillInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")).getBoolean("isBizUnit")) {
            objectValue.put("FICompany", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBizDate(new Date());
        try {
            objectValue.setPeriod(SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, objectValue.getFICompany().getId().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable kdtable) {
        return new CostReviseBillEntryInfo();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.SUBMITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0000"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBillBaseInfo)this.editData);
        this.editData = (CostReviseBillInfo)this.getValue((IObjectPK)pk);
        if (this.editData.getStatus() == BillBaseStatusEnum.AUDITED) {
            this.setOprtState(OprtState.VIEW);
        } else {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0001"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).unpassAudit((IObjectPK)pk, (CoreBillBaseInfo)this.editData);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(true);
    }
}

