/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.common.client.IndustryClientUtils;
import com.kingdee.eas.industry.emm.lcm.ProjectExpenseAllocBillFactory;
import com.kingdee.eas.industry.emm.lcm.ProjectExpenseAllocBillInfo;
import com.kingdee.eas.industry.emm.lcm.client.AbstractProjectExpenseAllocBillListUI;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProjectExpenseAllocBillListUI
extends AbstractProjectExpenseAllocBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectExpenseAllocBillListUI.class);
    protected boolean isSubmitting;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ItemAction[] actList = new ItemAction[]{this.actionCopyTo, this.actionCreateTo, this.actionLocate, this.actionAttachment, this.actionCancel, this.actionCancelCancel, this.actionVoucher, this.actionDelVoucher, this.actionAuditResult, this.actionMultiapprove, this.actionNextPerson, this.actionSignature, this.actionStartWorkFlow, this.actionWorkFlowG, this.actionWorkflowList, this.actionTraceUp, this.actionTraceDown};
        NCMClientUtils.setActionVisible((boolean)false, (ItemAction[])actList);
        this.btnAutoFromGL.setVisible(true);
        this.actionFromGL.setVisible(true);
        this.btnAutoFromGL.setEnabled(true);
        this.btnAutoAlloc.setVisible(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void checkAction(String action) throws Exception {
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String billStatus = row.getCell("status").getValue().toString().trim();
                if ("audit".equals(action)) {
                    this.checkAudit(billStatus);
                    continue;
                }
                if ("edit".equals(action)) {
                    this.checkEdit(billStatus);
                    continue;
                }
                if ("remove".equals(action)) {
                    this.checkRemove(billStatus);
                    continue;
                }
                if ("unAudit".equals(action)) {
                    this.checkUnAudit(billStatus);
                    continue;
                }
                if (!"submit".equals(action)) continue;
                this.checkSubmit(billStatus);
            }
        }
    }

    private void checkAudit(String billStatus) {
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_AUDIT"));
            SysUtil.abort();
        }
    }

    private void checkSubmit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)"\u53ea\u80fd\u63d0\u4ea4\u4fdd\u5b58\u72b6\u6001\u6216\u8005\u63d0\u4ea4\u72b6\u6001\u5355\u636e!");
            SysUtil.abort();
        }
    }

    private void checkEdit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_EDIT"));
            SysUtil.abort();
        }
    }

    private void checkRemove(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_DELETE"));
            SysUtil.abort();
        }
    }

    private void checkUnAudit(String billStatus) {
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CHECK_CAN_UNAUDIT"));
            SysUtil.abort();
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProjectExpenseAllocBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ProjectExpenseAllocBillInfo objectValue = new ProjectExpenseAllocBillInfo();
        return objectValue;
    }

    @Override
    public void actionFromGL_actionPerformed(ActionEvent e) throws Exception {
        int retVal = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0038"));
        if (!MsgBox.isYes((int)retVal)) {
            return;
        }
        Map result = ProjectExpenseAllocBillFactory.getRemoteInstance().autoFromGL();
        IndustryClientUtils.showResult((Component)((Object)this), (Map)result);
    }
}

