/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.form.extend.menu.BillStatusEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.industry.emm.pcm.basedata.AssemblyConfigureDoneBillFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.AssemblyConfigureDoneBillInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.client.AbstractAssemblyConfigureDBHeadListUI;
import com.kingdee.eas.industry.emm.pcm.basedata.client.AssemblyConfigureDoneBillEditUI;
import com.kingdee.eas.industry.emm.pcm.util.ListUIKDTableUtil;
import com.kingdee.eas.industry.emm.pcm.util.PcmFormatHelper;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AssemblyConfigureDBHeadListUI
extends AbstractAssemblyConfigureDBHeadListUI {
    private static final Logger logger = CoreUIObject.getLogger(AssemblyConfigureDBHeadListUI.class);

    public void onLoad() throws Exception {
        this.getUIContext().put("checkLicense", "false");
        this.btnAddNew.setEnabled(false);
        this.btnaudit.setEnabled(true);
        this.btnunaudit.setEnabled(true);
        this.btnEdit.setEnabled(false);
        super.onLoad();
        ListUIKDTableUtil.moveColumnsAndFreezeLast((KDTable)this.tblMain, (String[])new String[]{"bizDate", "number", "projectNumber.number", "adminOrgUnit.name"});
        PcmFormatHelper.changeColumnPrecision(this.tblMain, new String[]{"standardPrice", "configurePrice"}, 2, true);
        PcmFormatHelper.columnAllRight(this.tblMain, new String[]{"standardPrice", "configurePrice", "configureQty"});
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnaudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnunaudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        if (list.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0125"));
            SysUtil.abort();
        }
        for (int i = 0; i < list.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(i))));
            AssemblyConfigureDoneBillInfo ai = AssemblyConfigureDoneBillFactory.getRemoteInstance().getAssemblyConfigureDoneBillInfo((IObjectPK)pk);
            if (ai.getBillStatus().getValue() != 2) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0003"));
                SysUtil.abort();
            }
            AssemblyConfigureDoneBillFactory.getRemoteInstance().passAudit((IObjectPK)new ObjectUuidPK(ai.getId()), ai);
        }
        this.refreshList();
    }

    @Override
    public void actionUnaudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        if (list.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0125"));
            SysUtil.abort();
        }
        for (int i = 0; i < list.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(i))));
            AssemblyConfigureDoneBillInfo ai = AssemblyConfigureDoneBillFactory.getRemoteInstance().getAssemblyConfigureDoneBillInfo((IObjectPK)pk);
            if (ai.getBillStatus().getValue() != 4) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0004"));
                SysUtil.abort();
            }
            AssemblyConfigureDoneBillFactory.getRemoteInstance().unpassAudit((IObjectPK)new ObjectUuidPK(ai.getId()), ai);
        }
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IRow fr = null;
        try {
            fr = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getBeginRow());
        }
        catch (NullPointerException e1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0123"));
            SysUtil.abort();
        }
        if (fr.getCell("billStatus").getValue() == BillStatusEnum.AUDITED) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0126"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AssemblyConfigureDoneBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        AssemblyConfigureDoneBillInfo objectValue = new AssemblyConfigureDoneBillInfo();
        return objectValue;
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.industry.emm.pcm.basedata.client", "AssemblyConfigureDBHeadListUI");
    }

    protected String getEditUIName() {
        return AssemblyConfigureDoneBillEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo otherFilter;
        FilterInfo filter = super.getDefaultFilterForQuery();
        if (filter == null) {
            filter = new FilterInfo();
        }
        if ((otherFilter = FrameWorkUtils.getF7FilterInfoByAuthorizedOrg((OrgType)OrgType.getEnum((String)"Admin"), (String)"adminOrgUnit.id", (boolean)true)) != null) {
            int n = otherFilter.getFilterItems().size();
            for (int i = 0; i < n; ++i) {
                FilterItemInfo curFilterItem = otherFilter.getFilterItems().get(i);
                if (curFilterItem.getCompareValue() == null || !(curFilterItem.getCompareValue() instanceof String) || !"*".equalsIgnoreCase((String)curFilterItem.getCompareValue())) continue;
                BOSUuid nullUuid = BOSUuid.create((String)"nullnull");
                curFilterItem.setCompareValue((Object)nullUuid.toString());
            }
            try {
                if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
                    filter.mergeFilter(otherFilter, "AND");
                } else {
                    filter = otherFilter;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        EntityViewInfo info = new EntityViewInfo();
        info.setSorter(this.getDefaultSorter());
        dialog.setDefalutEntityViewInfo(info);
        ListUIKDTableUtil.configTableSettingPanel((CommonQueryDialog)dialog, (String[])new String[]{"bizDate", "number", "projectNumber.number"});
        return dialog;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.mainQuery != null && this.mainQuery.getSorter().isEmpty()) {
            this.mainQuery.setSorter(this.getDefaultSorter());
        }
    }

    protected SorterItemCollection getDefaultSorter() {
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("bizDate"));
        sorters.add(new SorterItemInfo("number"));
        sorters.add(new SorterItemInfo("projectNumber.number"));
        return sorters;
    }
}

