/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.pcm.basedata.BatchChangeStatusFacadeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.EnabledStateEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.LargePartsQDPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.LargePartsQDPriceStorageInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.client.AbstractLargePartsQDPriceStorageEditUI;
import com.kingdee.eas.industry.emm.pcm.basedata.projecttypecategory.ProjectTypesCategoryFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.projecttypecategory.ProjectTypesCategoryInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.zjbom.util.ProjectF7Util;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LargePartsQDPriceStorageEditUI
extends AbstractLargePartsQDPriceStorageEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LargePartsQDPriceStorageEditUI.class);
    private DataChangeListener listener;
    private SelectorListener selectorListener;

    public void onLoad() throws Exception {
        this.getUIContext().put("checkLicense", "false");
        super.onLoad();
        this.txtqty.setHorizontalAlignment(4);
        this.txtprice.setHorizontalAlignment(4);
        this.txtamount.setHorizontalAlignment(4);
        FilterInfo filterInfo = new FilterInfo();
        CtrlUnitInfo ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)(ctrlInfo == null ? null : ctrlInfo.getId().toString()), CompareType.EQUALS));
        EntityViewInfo evInfo = new EntityViewInfo();
        evInfo.setFilter(filterInfo);
        this.prmtadminOrgUnit.setEntityViewInfo(evInfo);
        this.prmtadminOrgUnit.getQueryAgent().getRuntimeEntityView().resetValue();
        ProjectF7Util.register(null, (KDBizPromptBox)this.prmtproject);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnSave.setEnabled(false);
        this.status.setEnabled(false);
        this.prmtcategory.setEnabled(false);
        this.txtclassficationCodeName.setEditable(false);
        this.prmtclassificationCode.setRequired(true);
        this.prmtproject.setRequired(true);
        this.txtprice.setPrecision(2);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.status.setSelectedItem((Object)EnabledStateEnum.SAVE);
        } else if (this.getOprtState().equals(OprtState.VIEW) && this.editData.getStatus().getValue() == 2) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnCopy.setEnabled(false);
        }
    }

    private void addListener() {
        if (this.listener == null) {
            this.listener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent arg0) {
                    LargePartsQDPriceStorageEditUI.this.doValueChange(arg0);
                }
            };
        }
        if (this.selectorListener == null) {
            this.selectorListener = new SelectorListener(){

                public void willShow(SelectorEvent selectorevent) {
                }
            };
        }
        this.txtqty.addDataChangeListener(this.listener);
        this.txtprice.addDataChangeListener(this.listener);
        this.prmtclassificationCode.addDataChangeListener(this.listener);
    }

    private void removeListener() {
        if (this.listener != null) {
            this.txtqty.removeDataChangeListener(this.listener);
            this.txtprice.removeDataChangeListener(this.listener);
            this.prmtclassificationCode.removeDataChangeListener(this.listener);
        }
        if (this.selectorListener != null) {
            this.prmtclassificationCode.removeSelectorListener(this.selectorListener);
        }
    }

    private void doValueChange(DataChangeEvent arg0) {
        if (arg0.getNewValue() != null) {
            if (arg0.getSource() == this.txtqty) {
                BigDecimal qty = this.txtqty.getBigDecimalValue();
                BigDecimal price = this.txtprice.getBigDecimalValue() == null ? BigDecimal.ZERO : this.txtprice.getBigDecimalValue();
                this.txtamount.setValue((Object)qty.multiply(price).setScale(2, 4));
            } else if (arg0.getSource() == this.txtprice) {
                BigDecimal qty = this.txtqty.getBigDecimalValue() == null ? BigDecimal.ZERO : this.txtqty.getBigDecimalValue();
                BigDecimal price = this.txtprice.getBigDecimalValue();
                this.txtamount.setValue((Object)qty.multiply(price).setScale(2, 4));
            } else if (arg0.getSource() == this.prmtclassificationCode) {
                if (this.prmtclassificationCode.getValue() == null) {
                    this.prmtcategory.setValue(null);
                    this.txtclassficationCodeName.setText(null);
                } else {
                    ClassificationCodeInfo classificationCodeInfo = (ClassificationCodeInfo)this.prmtclassificationCode.getValue();
                    ProjectTypesCategoryInfo projectTypesCategoryInfo = null;
                    if (classificationCodeInfo.getProjectTypes() != null) {
                        try {
                            ProjectTypesInfo projectTypesInfo = ProjectTypesFactory.getRemoteInstance().getProjectTypesInfo((IObjectPK)new ObjectUuidPK(classificationCodeInfo.getProjectTypes().getId()));
                            if (projectTypesInfo != null && projectTypesInfo.getCategory() != null) {
                                projectTypesCategoryInfo = ProjectTypesCategoryFactory.getRemoteInstance().getProjectTypesCategoryInfo((IObjectPK)new ObjectUuidPK(projectTypesInfo.getCategory().getId()));
                            }
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                            this.handleException((Exception)((Object)e));
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                            this.handleException((Exception)((Object)e));
                        }
                    }
                    this.prmtcategory.setValue(projectTypesCategoryInfo);
                    this.editData.setCategory(projectTypesCategoryInfo);
                    this.txtclassficationCodeName.setText(classificationCodeInfo.getName());
                }
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Dimension getPreferredSize() {
        Dimension dm = new Dimension(700, 348);
        return dm;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().getValue() == 2) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0186"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            String id = this.editData.getId().toString();
            ids.add(id);
            BatchChangeStatusFacadeFactory.getRemoteInstance().batchCancel("CT_PCM_LargePQDPS", ids);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0170"));
            this.editData.setStatus(EnabledStateEnum.SAVE);
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnCopy.setEnabled(true);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            String id = this.editData.getId().toString();
            ids.add(id);
            BatchChangeStatusFacadeFactory.getRemoteInstance().batchCancelCancel("CT_PCM_LargePQDPS", ids);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0171"));
            this.editData.setStatus(EnabledStateEnum.ENABLED);
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionRemove_actionPerformed(arg0);
        this.destroyWindow();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LargePartsQDPriceStorageFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        LargePartsQDPriceStorageInfo objectValue = new LargePartsQDPriceStorageInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")).getBoolean("isBizUnit")) {
            objectValue.put("ctrlUnit", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }
}

