/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basework.markcost.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.BudgetItemModifyFactory;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.BudgetItemModifyInfo;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.client.AbstractBudgetItemModifyEditUI;
import com.kingdee.eas.industry.emm.pcm.util.BudgetBillHelper;
import com.kingdee.eas.industry.emm.pcm.util.PcmFormatHelper;
import com.kingdee.eas.industry.emm.pcm.util.SubmitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class BudgetItemModifyEditUI
extends AbstractBudgetItemModifyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BudgetItemModifyEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BudgetItemModifyEditUI.this.kdtEntrys_Changed(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    BudgetItemModifyEditUI.this.handUIException(exc);
                }
            }
        });
        PcmFormatHelper.changeColumnPrecision(this.kdtEntrys, new String[]{"purAmount", "checkedAmount"}, 2, true);
        PcmFormatHelper.columnAllRight(this.kdtEntrys, new String[]{"purAmount", "checkedAmount"});
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((String)this.txtNumber.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.cp.bc.BizCollResource", (String)"BillNumber")});
        }
        if (UIRuleUtil.isNull((Object)this.pkBizDate.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.fm.fs.RptTransUpAndDownResource", (String)"BIZDATE")});
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0074"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        if (this.status.getSelectedItem() != BillBaseStatusEnum.SUBMITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0003"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBillBaseInfo)this.editData);
        this.editData = (BudgetItemModifyInfo)this.getValue((IObjectPK)pk);
        if (this.editData.getStatus() == BillBaseStatusEnum.AUDITED) {
            this.setOprtState(OprtState.VIEW);
        } else {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0004"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).unpassAudit((IObjectPK)pk, (CoreBillBaseInfo)this.editData);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(true);
    }

    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        if ("expenseType".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            this.kdtEntrys.getCell(rowIndex, "expenseTypeName").setValue((Object)UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "expenseType").getValue()), (String)"name")));
            this.kdtEntrys.getCell(rowIndex, "expenseTypeDetail").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "expenseType").getValue()), (String)"isDetailed"));
        }
        if ("checkedAmount".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "purAmount".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            BudgetBillHelper.setTableToSumField(new String[]{"purAmount", "checkedAmount"}, this.kdtEntrys);
        }
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue objectValue) {
        BudgetItemModifyInfo billInfo = (BudgetItemModifyInfo)objectValue;
        billInfo.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditDate(null);
        billInfo.setNumber(null);
        this.txtNumber.setText(null);
        this.getNumberByCodingRule((IObjectValue)billInfo, billInfo.getAdminOrgUnit().getId().toString());
        billInfo.setCreateTime(null);
        billInfo.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        billInfo.setBizDate(new Date());
    }

    @Override
    protected void setTableToSumField() {
        BudgetBillHelper.setTableToSumField(new String[]{"purAmount", "checkedAmount"}, this.kdtEntrys);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            boolean isTotalRow;
            boolean bl = isTotalRow = this.kdtEntrys.getRow(i).getCell("isTotalRow").getValue() == null ? false : Boolean.parseBoolean(this.kdtEntrys.getRow(i).getCell("isTotalRow").getValue().toString());
            if (!isTotalRow) continue;
            this.kdtEntrys.getRow(i).getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isModifySave() {
        return false;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BudgetItemModifyFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        BudgetItemModifyInfo objectValue = new BudgetItemModifyInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Admin")) != null) {
            objectValue.put("adminOrgUnit", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Admin")));
        }
        objectValue.setBizDate(new Date());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (SubmitUtil.submitIsif((Component)((Object)this))) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }
}

