/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basework.markcost.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.BudgetItemPurFactory;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.BudgetItemPurInfo;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.ExpenseTypeInfo;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.MakeCostDataCollection;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.MakeCostDataFactory;
import com.kingdee.eas.industry.emm.pcm.basework.markcost.client.AbstractBudgetItemPurEditUI;
import com.kingdee.eas.industry.emm.pcm.util.BudgetBillHelper;
import com.kingdee.eas.industry.emm.pcm.util.PcmFormatHelper;
import com.kingdee.eas.industry.emm.pcm.util.SubmitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class BudgetItemPurEditUI
extends AbstractBudgetItemPurEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BudgetItemPurEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        PcmFormatHelper.changeColumnPrecision(this.kdtEntrys, new String[]{"yearDownTarget", "yearCost", "purAmount", "checkedAmount"}, 2, true);
        PcmFormatHelper.columnAllRight(this.kdtEntrys, new String[]{"yearDownTarget", "yearCost", "purAmount", "checkedAmount"});
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((String)this.txtNumber.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.cp.bc.BizCollResource", (String)"BillNumber")});
        }
        if (UIRuleUtil.isNull((Object)this.pkBizDate.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.fs.RptTransUpAndDownResource", (String)"BIZDATE")});
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showInfo((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0074"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        if (this.status.getSelectedItem() != BillBaseStatusEnum.SUBMITED) {
            MsgBox.showInfo((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0003"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBillBaseInfo)this.editData);
        this.editData = (BudgetItemPurInfo)this.getValue((IObjectPK)pk);
        if (this.editData.getStatus() == BillBaseStatusEnum.AUDITED) {
            this.setOprtState(OprtState.VIEW);
        } else {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0004"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).unpassAudit((IObjectPK)pk, (CoreBillBaseInfo)this.editData);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(true);
    }

    @Override
    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        super.kdtEntrys_Changed(rowIndex, colIndex);
        if ("yearDownTarget".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "yearCost".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "purAmount".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "checkedAmount".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            BudgetBillHelper.setTableToSumField(new String[]{"yearDownTarget", "yearCost", "purAmount", "checkedAmount"}, this.kdtEntrys);
        }
        if ("expenseType".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            if (this.editData.getBizDate() == null || this.editData.getAdminOrgUnit() == null || this.kdtEntrys.getCell(rowIndex, "expenseType").getValue() == null) {
                return;
            }
            AdminOrgUnitInfo adminOrgUnitInfo = this.editData.getAdminOrgUnit();
            Date date = this.editData.getBizDate();
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy");
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");
            Date sdate = sdf2.parse(Integer.parseInt(sdf1.format(date)) - 1 + "0101");
            ExpenseTypeInfo expenseTypeInfo = (ExpenseTypeInfo)this.kdtEntrys.getCell(rowIndex, "expenseType").getValue();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(new SelectorItemInfo("proAmount"));
            evi.getSelector().add(new SelectorItemInfo("actualCost"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("expenseType.number", (Object)expenseTypeInfo.getNumber(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("unit.number", (Object)adminOrgUnitInfo.getNumber(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)sdate, CompareType.EQUALS));
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo = new SorterItemInfo("year");
            itemInfo.setSortType(SortType.DESCEND);
            evi.getSorter().add(itemInfo);
            MakeCostDataCollection pmpCollection = MakeCostDataFactory.getRemoteInstance().getMakeCostDataCollection(evi);
            BigDecimal actualCost = BigDecimal.ZERO;
            BigDecimal proAmount = BigDecimal.ZERO;
            if (pmpCollection.size() != 0) {
                actualCost = pmpCollection.get(0).getActualCost();
                proAmount = pmpCollection.get(0).getProAmount();
            }
            this.kdtEntrys.getCell(rowIndex, "yearDownTarget").setValue((Object)proAmount);
            this.kdtEntrys.getCell(rowIndex, "yearCost").setValue((Object)actualCost);
        }
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue objectValue) {
        BudgetItemPurInfo billInfo = (BudgetItemPurInfo)objectValue;
        billInfo.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditDate(null);
        billInfo.setNumber(null);
        this.txtNumber.setText(null);
        this.getNumberByCodingRule((IObjectValue)billInfo, billInfo.getAdminOrgUnit().getId().toString());
        billInfo.setCreateTime(null);
        billInfo.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        billInfo.setBizDate(new Date());
    }

    @Override
    protected void setTableToSumField() {
        BudgetBillHelper.setTableToSumField(new String[]{"yearDownTarget", "yearCost", "purAmount", "checkedAmount"}, this.kdtEntrys);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            boolean isTotalRow;
            boolean bl = isTotalRow = this.kdtEntrys.getRow(i).getCell("isTotalRow").getValue() == null ? false : Boolean.parseBoolean(this.kdtEntrys.getRow(i).getCell("isTotalRow").getValue().toString());
            if (!isTotalRow) continue;
            this.kdtEntrys.getRow(i).getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isModifySave() {
        return false;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BudgetItemPurFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        BudgetItemPurInfo objectValue = new BudgetItemPurInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Admin")) != null) {
            objectValue.put("adminOrgUnit", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Admin")));
        }
        objectValue.setBizDate(new Date());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (SubmitUtil.submitIsif((Component)((Object)this))) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }
}

