/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costcalculate.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.costcalculate.report.client.AbstractActualPurCostRptFilterUI;
import com.kingdee.eas.industry.emm.pcm.costcalculate.report.client.ActualPurCostRptBakFilterUI;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import org.apache.log4j.Logger;

public class ActualPurCostRptFilterUI
extends AbstractActualPurCostRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ActualPurCostRptBakFilterUI.class);
    private ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getRemoteInstance();

    public ActualPurCostRptFilterUI() throws Exception {
        this.prmtProjectNumber.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    ActualPurCostRptFilterUI.this.projectChange();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        });
        this.prmtStartTrackNumber.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                ActualPurCostRptFilterUI.this.trackChange(arg0);
            }
        });
        this.prmtEndTrackNumber.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                ActualPurCostRptFilterUI.this.trackChange(arg0);
            }
        });
        this.initElementInfo();
    }

    private void projectChange() throws BOSException {
        this.prmtProjectType.setValue(null);
        if (this.prmtProjectNumber.getValue() != null) {
            ProjectInfo pis = (ProjectInfo)this.prmtProjectNumber.getValue();
            ProjectTypesInfo pti = (ProjectTypesInfo)pis.get("projectTypes");
            if (pti != null) {
                try {
                    pti = ProjectTypesFactory.getRemoteInstance().getProjectTypesInfo((IObjectPK)new ObjectUuidPK(pti.getId().toString()));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            this.prmtProjectType.setValue((Object)pti);
        }
    }

    private void trackChange(DataChangeEvent arg0) {
        if (this.prmtStartTrackNumber.getValue() != null && this.prmtEndTrackNumber.getValue() != null) {
            try {
                String trackNumberB = ((TrackNumberInfo)this.prmtStartTrackNumber.getValue()).getNumber();
                String trackNumberE = ((TrackNumberInfo)this.prmtEndTrackNumber.getValue()).getNumber();
                int trackQty = Integer.parseInt(trackNumberE.substring(trackNumberE.length() - 4, trackNumberE.length())) - Integer.parseInt(trackNumberB.substring(trackNumberB.length() - 4, trackNumberB.length())) + 1;
                this.txtTrackQty.setValue((Object)trackQty);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtProjectNumber.setQueryInfo(null);
        this.prmtProjectNumber.setDisplayFormat("$number$");
        this.prmtProjectNumber.setEditFormat("$number$");
        this.prmtProjectNumber.setCommitFormat("$number$");
        this.prmtProjectNumber.setRequired(true);
        this.prmtProjectType.setRequired(true);
        this.prmtStartTrackNumber.setRequired(true);
        this.txtTrackQty.setRequired(true);
        this.prmtEndTrackNumber.setRequired(true);
        this.prmtProjectNumber.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                if (arg0.getNewValue() != null) {
                    ActualPurCostRptFilterUI.this.prmtStartTrackNumber.setValue(null);
                    ActualPurCostRptFilterUI.this.prmtEndTrackNumber.setValue(null);
                }
            }
        });
        try {
            UIHelper.registerProjectF7ForFilter(null, (KDBizPromptBox)this.prmtProjectNumber, (boolean)false);
            UIHelper.registerTrackNumberF7ForFilter(null, (KDBizPromptBox)this.prmtProjectNumber, (KDBizPromptBox)this.prmtStartTrackNumber, (boolean)false);
            UIHelper.registerTrackNumberF7ForFilter(null, (KDBizPromptBox)this.prmtProjectNumber, (KDBizPromptBox)this.prmtEndTrackNumber, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        super.clear();
    }

    private void initElementInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement prmtProjectNumber = new SingleFilterElement("ProjectNumber", (Component)this.prmtProjectNumber);
        SingleFilterElement prmtStartTrackNumber = new SingleFilterElement("starttrackNumber", (Component)this.prmtStartTrackNumber);
        SingleFilterElement prmtEndTrackNumber = new SingleFilterElement("endtrackNumber", (Component)this.prmtEndTrackNumber);
        SingleFilterElement projectType = new SingleFilterElement("projectType", (Component)this.prmtProjectType);
        SingleFilterElement trackQty = new SingleFilterElement("TrackQty", (Component)this.txtTrackQty);
        elements.add((FilterElement)prmtProjectNumber);
        elements.add((FilterElement)prmtStartTrackNumber);
        elements.add((FilterElement)prmtEndTrackNumber);
        elements.add((FilterElement)projectType);
        elements.add((FilterElement)trackQty);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public boolean verify() {
        if (this.prmtProjectNumber.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0071"));
            this.prmtProjectNumber.requestFocus();
            return false;
        }
        if (this.prmtProjectType.getData() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0167"));
            this.prmtProjectType.requestFocus();
            return false;
        }
        if (this.prmtStartTrackNumber.getValue() == null || this.prmtEndTrackNumber.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0168"));
            this.prmtStartTrackNumber.requestFocus();
            return false;
        }
        if (this.txtTrackQty.getText().trim() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0169"));
            this.txtTrackQty.requestFocus();
            return false;
        }
        if (this.txtTrackQty.getIntegerValue() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0170"));
            this.txtTrackQty.requestFocus();
            return false;
        }
        return true;
    }
}

