/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costmanagement.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.industry.emm.common.util.StringUtil;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.costmanagement.MarketingPartEstimateEntryCollection;
import com.kingdee.eas.industry.emm.pcm.costmanagement.MarketingPartEstimateEntryInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.MarketingPartEstimateFactory;
import com.kingdee.eas.industry.emm.pcm.costmanagement.MarketingPartEstimateInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.client.AbstractMarketingPartEstimateEditUI;
import com.kingdee.eas.industry.emm.pcm.util.PcmFormatHelper;
import com.kingdee.eas.industry.emm.pcm.util.SubmitUtil;
import com.kingdee.eas.industry.util.ReflectUtil;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class MarketingPartEstimateEditUI
extends AbstractMarketingPartEstimateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MarketingPartEstimateEditUI.class);
    ItemAction fromBom;

    public MarketingPartEstimateEditUI() throws Exception {
        this.btnInsertLine.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.btnInsertLine.setVisible(false);
        this.btnInsertLine.setEnabled(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        PcmFormatHelper.changeColumnPrecision(this.kdtEntrys, new String[]{"estimatePrice", "inquiryPrice", "refEstimate", "newPurPrice", "highPurPrice", "price", "targetCost"}, 2, true);
        PcmFormatHelper.columnAllRight(this.kdtEntrys, new String[]{"demandQty", "estimatePrice", "inquiryPrice", "refEstimate", "newPurPrice", "highPurPrice", "price", "targetCost"});
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("checkLicense", "false");
        super.onLoad();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        this.btnAudit.setEnabled(true);
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setEnabled(true);
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unauditing"));
        UIHelper.registerProjectF7ForEdit(null, null, (KDBizPromptBox)this.prmtProject);
        UIHelper.registerTrackNumberF7ForEdit(null, null, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTrackNum, (boolean)false);
    }

    public void initLayout() {
        super.initLayout();
        KDContainer kdConTitle = new KDContainer();
        kdConTitle.setName("kdDetailCon1");
        kdConTitle.setBounds(0, 5, 100, 24);
        kdConTitle.setContainerType(2);
        kdConTitle.setTitleStyle(1);
        KDContainer materialTabCon = (KDContainer)ReflectUtil.getFieldObject(DetailPanel.class, (String)"kdConTitle", (Object)this.kdtEntrys_detailPanel);
        materialTabCon.setVisible(false);
        KDPanel controlPanel = (KDPanel)ReflectUtil.getFieldObject(DetailPanel.class, (String)"controlPanel", (Object)this.kdtEntrys_detailPanel);
        controlPanel.add((Component)kdConTitle, (Object)new KDLayout.Constraints(0, 5, 300, 19, 5));
        this.fromBom = new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MarketingPartEstimateEditUI.this.actionfromBom(e);
                }
                catch (Exception e1) {
                    MarketingPartEstimateEditUI.this.handleException(e1);
                }
            }
        };
        this.fromBom.putValue("ShortDescription", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0046"));
        this.fromBom.putValue("LongDescription", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0046"));
        this.fromBom.putValue("Name", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0047"));
        kdConTitle.add((Action)this.fromBom);
        this.fromBom.setEnabled(true);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kdtEntrys_detailPanel.getInsertLineButton().setVisible(false);
        this.kdtEntrys_detailPanel.addAddListener(new IDetailPanelListener(){

            public void beforeEvent(DetailPanelEvent event) throws Exception {
                IObjectValue vo = event.getObjectValue();
                int count = MarketingPartEstimateEditUI.this.getTagRows(MarketingPartEstimateEditUI.this.kdtEntrys);
                vo.put("showSeq", (Object)(count + 1));
            }

            public void afterEvent(DetailPanelEvent event) throws Exception {
            }
        });
    }

    protected int getTagRows(KDTable kdtEntrys) {
        int rsize = kdtEntrys.getRowCount();
        boolean rowCount = false;
        ArrayList arrList = new ArrayList();
        String str = "";
        for (int i = 0; i < rsize; ++i) {
            IRow irow = kdtEntrys.getRow(i);
            if (Integer.parseInt(irow.getCell("tag").getValue().toString()) == 2) continue;
            str = irow.getCell("seqShow").getValue().toString();
        }
        return StringUtil.isEmpty((String)str) ? 0 : Integer.parseInt(str);
    }

    private void actionfromBom(ActionEvent e) throws EASBizException, BOSException {
        if (!this.getOprtState().equals(OprtState.EDIT) && !this.getOprtState().equals(OprtState.ADDNEW)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0048"));
            SysUtil.abort();
        }
        int size = this.kdtEntrys.getSelectManager().size();
        MarketingPartEstimateEntryCollection maEntryColl = null;
        if (size == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0049"));
            SysUtil.abort();
        } else {
            IRow iRow = null;
            maEntryColl = new MarketingPartEstimateEntryCollection();
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.kdtEntrys.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    iRow = this.kdtEntrys.getRow(j);
                    if (iRow == null) continue;
                    MarketingPartEstimateEntryInfo maEntryInfo = null;
                    maEntryInfo = (MarketingPartEstimateEntryInfo)iRow.getUserObject();
                    if (maEntryInfo.getTag() != 0 || maEntryInfo.getMaterial() == null) continue;
                    maEntryColl.add(maEntryInfo);
                }
            }
            if (maEntryColl.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0050"));
                SysUtil.abort();
            }
        }
        ProjectInfo project = (ProjectInfo)this.prmtProject.getData();
        TrackNumberInfo trackNumber = (TrackNumberInfo)this.prmtTrackNum.getData();
        if (project == null || trackNumber == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0051"));
            SysUtil.abort();
        }
        this.dataBinder.storeHeader();
        this.dataBinder.bindTableToData(this.kdtEntrys, (IObjectCollection)this.editData.getEntrys());
        final HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("project", project);
        map.put("trackNumber", trackNumber);
        map.put("billInfo", this.editData);
        map.put("maEntryColl", (Object)maEntryColl);
        final MonitorInfo info = new MonitorInfo(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0052"), null, (Object)this, true);
        final HashMap ex = new HashMap();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    Map re = MarketingPartEstimateFactory.getRemoteInstance().exBom(map);
                    MarketingPartEstimateEditUI.this.editData = (MarketingPartEstimateInfo)re.get("billInfo");
                    MarketingPartEstimateEditUI.this.dataBinder.bindDataToTable(MarketingPartEstimateEditUI.this.kdtEntrys, (IObjectCollection)MarketingPartEstimateEditUI.this.editData.getEntrys());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ex.put("faild", "faild");
                    MarketingPartEstimateEditUI.this.handUIException(e);
                }
                return info.getUi();
            }

            public void finished() {
                ThreadPool.destroyMonitor((MonitorInfo)info);
                if (ex.get("faild") == null) {
                    // empty if block
                }
            }
        };
        info.setWorker(worker);
        ThreadPool.addActionThread((MonitorInfo)info);
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0053"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.baseStatus.getSelectedItem() != BillBaseStatusEnum.SUBMITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0001"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBillBaseInfo)this.editData);
        this.editData = (MarketingPartEstimateInfo)this.getValue((IObjectPK)pk);
        if (this.editData.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            this.setOprtState(OprtState.VIEW);
        } else {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject((IObjectValue)this.editData);
        for (int i = 0; this.editData.getEntrys() != null && i > this.editData.getEntrys().size(); ++i) {
            MarketingPartEstimateEntryInfo entryInfo = this.editData.getEntrys().get(i);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)entryInfo.getMaterial(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo1 = new SorterItemInfo("updateTime");
            itemInfo1.setSortType(SortType.DESCEND);
            evi.getSorter().add(itemInfo1);
            MarketFitPriceStorageCollection pmpCollection = MarketFitPriceStorageFactory.getRemoteInstance().getMarketFitPriceStorageCollection(evi);
            pmpCollection.get(0).setTargetPrice(entryInfo.getTargetCost());
            this.setDataObject((IObjectValue)pmpCollection.get(0));
        }
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.baseStatus.getSelectedItem() != BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0002"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).unpassAudit((IObjectPK)pk, (CoreBillBaseInfo)this.editData);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(true);
    }

    @Override
    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        super.kdtEntrys_Changed(rowIndex, colIndex);
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            this.kdtEntrys.getCell(rowIndex, "measureUnit").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "material").getValue()), (String)"baseunit"));
        }
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            MaterialInfo materialInfo = (MaterialInfo)this.kdtEntrys.getCell(rowIndex, colIndex).getValue();
            if (materialInfo == null) {
                return;
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(new SelectorItemInfo("estimatePrice"));
            evi.getSelector().add(new SelectorItemInfo("targetPrice"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo = new SorterItemInfo("updateDate");
            itemInfo.setSortType(SortType.DESCEND);
            evi.getSorter().add(itemInfo);
            MarketFitPriceStorageCollection collection = MarketFitPriceStorageFactory.getRemoteInstance().getMarketFitPriceStorageCollection(evi);
            BigDecimal estimatePrice = null;
            BigDecimal targetCost = null;
            if (collection.size() != 0) {
                estimatePrice = collection.get(0).getEstimatePrice();
                targetCost = collection.get(0).getTargetPrice();
            }
            this.kdtEntrys.getCell(rowIndex, "refEstimate").setValue((Object)estimatePrice);
            this.kdtEntrys.getCell(rowIndex, "targetCost").setValue((Object)targetCost);
            evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(new SelectorItemInfo("latestPurPrice"));
            evi.getSelector().add(new SelectorItemInfo("maxPurPrice"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo1 = new SorterItemInfo("updateTime");
            itemInfo1.setSortType(SortType.DESCEND);
            evi.getSorter().add(itemInfo1);
            PurMaterialPriceStorageCollection pmpCollection = PurMaterialPriceStorageFactory.getRemoteInstance().getPurMaterialPriceStorageCollection(evi);
            BigDecimal latestPurPrice = null;
            BigDecimal maxPurPrice = null;
            if (pmpCollection.size() != 0) {
                latestPurPrice = pmpCollection.get(0).getLatestPurPrice();
                maxPurPrice = pmpCollection.get(0).getMaxPurPrice();
            }
            this.kdtEntrys.getCell(rowIndex, "newPurPrice").setValue((Object)latestPurPrice);
            this.kdtEntrys.getCell(rowIndex, "highPurPrice").setValue((Object)maxPurPrice);
        }
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "refEstimate".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "newPurPrice".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "highPurPrice".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "inquiryPrice".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "estimatePrice".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "riskCoefficient".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            BigDecimal estimatePrice = this.kdtEntrys.getCell(rowIndex, "refEstimate").getValue() == null ? BigDecimal.ZERO : new BigDecimal(this.kdtEntrys.getCell(rowIndex, "refEstimate").getValue().toString());
            BigDecimal newPurPrice = this.kdtEntrys.getCell(rowIndex, "newPurPrice").getValue() == null ? BigDecimal.ZERO : new BigDecimal(this.kdtEntrys.getCell(rowIndex, "newPurPrice").getValue().toString());
            BigDecimal highPurPrice = this.kdtEntrys.getCell(rowIndex, "highPurPrice").getValue() == null ? BigDecimal.ZERO : new BigDecimal(this.kdtEntrys.getCell(rowIndex, "highPurPrice").getValue().toString());
            BigDecimal inquiryPrice = this.kdtEntrys.getCell(rowIndex, "inquiryPrice").getValue() == null ? BigDecimal.ZERO : new BigDecimal(this.kdtEntrys.getCell(rowIndex, "inquiryPrice").getValue().toString());
            BigDecimal estPrice = this.kdtEntrys.getCell(rowIndex, "estimatePrice").getValue() == null ? BigDecimal.ZERO : new BigDecimal(this.kdtEntrys.getCell(rowIndex, "estimatePrice").getValue().toString());
            BigDecimal riskCoefficient = this.kdtEntrys.getCell(rowIndex, "riskCoefficient").getValue() == null ? BigDecimal.ZERO : new BigDecimal(this.kdtEntrys.getCell(rowIndex, "riskCoefficient").getValue().toString());
            BigDecimal price = null;
            String priceSource = "";
            if (estimatePrice != BigDecimal.ZERO && estimatePrice != null) {
                price = estimatePrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0009");
            }
            if (highPurPrice != BigDecimal.ZERO && highPurPrice != null) {
                price = highPurPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0010");
            }
            if (newPurPrice != BigDecimal.ZERO && newPurPrice != null) {
                price = newPurPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0011");
            }
            if (inquiryPrice != BigDecimal.ZERO && inquiryPrice != null) {
                price = inquiryPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0012");
            }
            if (estPrice != BigDecimal.ZERO && estPrice != null) {
                price = estPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0013");
            }
            this.kdtEntrys.getCell(rowIndex, "priceSource").setValue((Object)priceSource);
            if (price != null) {
                this.kdtEntrys.getCell(rowIndex, "price").setValue((Object)price.multiply(riskCoefficient));
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MarketingPartEstimateFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        MarketingPartEstimateInfo objectValue = new MarketingPartEstimateInfo();
        objectValue.setBizDate(new Date());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setAdminOrgUnit(SysContext.getSysContext().getCurrentAdminUnit());
        return objectValue;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (SubmitUtil.submitIsif((Component)((Object)this))) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!UIRuleUtil.isNull((Object)this.kdtEntrys.getCell(i, "materialName").getValue())) continue;
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0054")});
        }
        if (UIRuleUtil.isNull((String)this.txtNumber.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0055")});
        }
        if (UIRuleUtil.isNull((Object)this.pkBizDate.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0056")});
        }
        if (UIRuleUtil.isNull((Object)this.baseStatus.getSelectedItem())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0057")});
        }
        if (UIRuleUtil.isNull((Object)this.prmtadminOrgUnit.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0058")});
        }
        super.beforeStoreFields(arg0);
    }
}

