/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.industry.emm.pcm.BudgetBillInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.TargetCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.basework.designcost.ProActualCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.basework.designcost.ProTargetCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PcmTreeBillHelper {
    static Comparator materialEntryComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            IObjectValue io1 = (IObjectValue)o1;
            IObjectValue io2 = (IObjectValue)o2;
            ClassificationCodeInfo cci1 = (ClassificationCodeInfo)io1.getObjectValue("classCode");
            ClassificationCodeInfo cci2 = (ClassificationCodeInfo)io2.getObjectValue("classCode");
            if (cci2 == null) {
                return -1;
            }
            if (cci1 == null) {
                return 1;
            }
            int result = cci1.compareTo(cci2);
            if (result != 0) {
                return result;
            }
            if (io1.getBoolean("isTotalRow")) {
                return -1;
            }
            if (io2.getBoolean("isTotalRow")) {
                return 1;
            }
            if (io1.getBoolean("isPackageRow")) {
                return -1;
            }
            if (io2.getBoolean("isPackageRow")) {
                return 1;
            }
            if (io1.getBoolean("isMainRow")) {
                return -1;
            }
            if (io2.getBoolean("isMainRow")) {
                return 1;
            }
            MaterialInfo material1 = (MaterialInfo)io1.getObjectValue("material");
            MaterialInfo material2 = (MaterialInfo)io2.getObjectValue("material");
            if (material1 == null && material2 == null) {
                String materialName1 = io1.getString("materialName");
                String materialName2 = io2.getString("materialName");
                if (materialName2 == null) {
                    return -1;
                }
                if (materialName1 == null) {
                    return 1;
                }
                return materialName1.compareTo(materialName2);
            }
            if (material2 == null) {
                return -1;
            }
            if (material1 == null) {
                return 1;
            }
            return material1.compareTo((Object)material2);
        }
    };

    public static void sortMaterialEntryColl(IObjectCollection coll) {
        Object[] a = coll.toArray();
        Arrays.sort(a, materialEntryComparator);
        coll.clear();
        for (int j = 0; j < a.length; ++j) {
            coll.addObject((IObjectValue)a[j]);
        }
    }

    public static void insertTotalRowByClassCode(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        ClassificationCodeInfo cci;
        CoreBillEntryBaseInfo iov;
        int i;
        IObjectCollection coll = (IObjectCollection)model.get("entrys");
        String costKey = "trolleyRealCost";
        if (model instanceof EstimateTemplateInfo || model instanceof TargetCostBillInfo) {
            costKey = "trolleyCost";
        }
        ProjectTypesInfo pti = (ProjectTypesInfo)model.get("projectType");
        ArrayList<ClassificationCodeInfo> cciSet = new ArrayList<ClassificationCodeInfo>();
        CoreBillEntryBaseInfo cloneer = null;
        HashSet<String> editTotalRowSetForClassCodeID = new HashSet<String>();
        HashMap<ClassificationCodeInfo, Integer> dupMap = new HashMap<ClassificationCodeInfo, Integer>();
        for (i = 0; i < coll.size(); ++i) {
            iov = (CoreBillEntryBaseInfo)coll.getObject(i);
            if (cloneer == null) {
                cloneer = (CoreBillEntryBaseInfo)iov.clone();
            }
            if (!cciSet.contains(cci = (ClassificationCodeInfo)iov.get("classCode"))) {
                cciSet.add(cci);
            }
            if (iov.getBoolean("isTotalRow") || iov.getBoolean("isPackageRow")) {
                if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(iov.get("estimateUnitPrice"))) {
                    editTotalRowSetForClassCodeID.add(((ClassificationCodeInfo)iov.get("classCode")).getId().toString());
                }
                if (model instanceof TargetCostBillInfo && !PcmTreeBillHelper.isBigDecimalEmptyAndZero(iov.get("trolleyPrice"))) {
                    editTotalRowSetForClassCodeID.add(((ClassificationCodeInfo)iov.get("classCode")).getId().toString());
                }
                iov.put("isPackageRow", (Object)true);
            }
            if (dupMap.get(cci) != null) {
                int count = (Integer)dupMap.get(cci);
                dupMap.put(cci, ++count);
                continue;
            }
            dupMap.put(cci, 1);
        }
        if (model instanceof ProjectTargetCostBillInfo) {
            for (i = 0; i < coll.size(); ++i) {
                iov = (CoreBillEntryBaseInfo)coll.getObject(i);
                cci = (ClassificationCodeInfo)iov.get("classCode");
                if (dupMap.get(cci) == null || Integer.parseInt(dupMap.get(cci) + "") != 1) continue;
                iov.put("isPackageRow", (Object)true);
                if (iov.get("material") != null || iov.get("materialName") != null) continue;
                iov.put("materialName", (Object)cci.getName());
            }
        }
        Collections.sort(cciSet);
        if (cloneer != null) {
            cloneer.clear();
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)pti.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("*"));
        selColl.add(new SelectorItemInfo("parent.*"));
        ev.setSelector(selColl);
        ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeCollection(ev);
        HashMap<ClassificationCodeInfo, ClassificationCodeInfo> allClassCode = new HashMap<ClassificationCodeInfo, ClassificationCodeInfo>();
        for (int i2 = 0; i2 < classCodeColl.size(); ++i2) {
            allClassCode.put(classCodeColl.get(i2), classCodeColl.get(i2));
        }
        HashMap<ClassificationCodeInfo, CoreBillEntryBaseInfo> classCodeTotalRowMap = new HashMap<ClassificationCodeInfo, CoreBillEntryBaseInfo>();
        HashSet<CoreBillEntryBaseInfo> leafTotalRow = new HashSet<CoreBillEntryBaseInfo>();
        for (int i3 = cciSet.size() - 1; i3 >= 0; --i3) {
            ClassificationCodeInfo cci2 = (ClassificationCodeInfo)cciSet.get(i3);
            CoreBillEntryBaseInfo newClone = null;
            BigDecimal totalTrolleyCost = BigDecimal.ZERO;
            BigDecimal totalRiskAmount = BigDecimal.ZERO;
            BigDecimal totalTrolleyCostPurchase = BigDecimal.ZERO;
            int tmp_count = 0;
            for (int j = 0; j < coll.size(); ++j) {
                BigDecimal trolleyCostPurchase;
                BigDecimal riskAmount;
                CoreBillEntryBaseInfo iov2 = (CoreBillEntryBaseInfo)coll.getObject(j);
                ClassificationCodeInfo cciChild = (ClassificationCodeInfo)iov2.get("classCode");
                if (cciChild.getId().toString().equals(cci2.getId().toString())) {
                    if (iov2.getBoolean("isTotalRow") || iov2.getBoolean("isPackageRow")) {
                        newClone = iov2;
                    } else {
                        BigDecimal trolleyCost = iov2.getBigDecimal(costKey) == null ? BigDecimal.ZERO : iov2.getBigDecimal(costKey);
                        totalTrolleyCost = totalTrolleyCost.add(trolleyCost);
                        BigDecimal riskAmount2 = iov2.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : iov2.getBigDecimal("riskAmount");
                        totalRiskAmount = totalRiskAmount.add(riskAmount2);
                        BigDecimal trolleyCostPurchase2 = iov2.getBigDecimal("trolleyCostPurchase") == null ? BigDecimal.ZERO : iov2.getBigDecimal("trolleyCostPurchase");
                        totalTrolleyCostPurchase = totalTrolleyCostPurchase.add(trolleyCostPurchase2);
                        ++tmp_count;
                    }
                }
                if (!PcmTreeBillHelper.isLeafOfParent(cciChild, cci2) || PcmTreeBillHelper.isLeafOfEditParent(allClassCode, editTotalRowSetForClassCodeID, cci2, cciChild)) continue;
                if (editTotalRowSetForClassCodeID.contains(cciChild.getId().toString())) {
                    totalTrolleyCost = totalTrolleyCost.add(iov2.getBigDecimal(costKey));
                    riskAmount = iov2.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : iov2.getBigDecimal("riskAmount");
                    totalRiskAmount = totalRiskAmount.add(riskAmount);
                    trolleyCostPurchase = iov2.getBigDecimal("trolleyCostPurchase") == null ? BigDecimal.ZERO : iov2.getBigDecimal("trolleyCostPurchase");
                    totalTrolleyCostPurchase = totalTrolleyCostPurchase.add(trolleyCostPurchase);
                    continue;
                }
                if (!iov2.getBoolean("isTotalRow") && !iov2.getBoolean("isPackageRow")) {
                    totalTrolleyCost = totalTrolleyCost.add(iov2.getBigDecimal(costKey));
                    riskAmount = iov2.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : iov2.getBigDecimal("riskAmount");
                    totalRiskAmount = totalRiskAmount.add(riskAmount);
                    trolleyCostPurchase = iov2.getBigDecimal("trolleyCostPurchase") == null ? BigDecimal.ZERO : iov2.getBigDecimal("trolleyCostPurchase");
                    totalTrolleyCostPurchase = totalTrolleyCostPurchase.add(trolleyCostPurchase);
                }
                if (!(model instanceof TargetCostBillInfo) || iov2.getBoolean("isTotalRow") || !iov2.getBoolean("isMainRow")) continue;
                totalTrolleyCost = totalTrolleyCost.add(iov2.getBigDecimal(costKey));
                riskAmount = iov2.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : iov2.getBigDecimal("riskAmount");
                totalRiskAmount = totalRiskAmount.add(riskAmount);
                trolleyCostPurchase = iov2.getBigDecimal("trolleyCostPurchase") == null ? BigDecimal.ZERO : iov2.getBigDecimal("trolleyCostPurchase");
                totalTrolleyCostPurchase = totalTrolleyCostPurchase.add(trolleyCostPurchase);
            }
            if (newClone == null) {
                newClone = (CoreBillEntryBaseInfo)cloneer.clone();
                newClone.put("classCode", (Object)cci2);
                coll.addObject((IObjectValue)newClone);
            }
            newClone.put("tmp_count", (Object)tmp_count);
            leafTotalRow.add(newClone);
            if (model instanceof TargetCostBillInfo) {
                if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(newClone.get("trolleyPrice"))) {
                    newClone.put("techTrolleyQty", null);
                    newClone.put(costKey, (Object)totalTrolleyCost);
                }
            } else if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(newClone.get("estimateUnitPrice"))) {
                newClone.put("techTrolleyQty", null);
                newClone.put(costKey, (Object)totalTrolleyCost);
            }
            newClone.put("trolleyCostPurchase", (Object)totalTrolleyCostPurchase);
            if (!newClone.getBoolean("isPackageRow")) {
                newClone.put("isTotalRow", (Object)true);
            }
            classCodeTotalRowMap.put(cci2, newClone);
        }
        for (CoreBillEntryBaseInfo cbe : leafTotalRow) {
            if (cbe.get("tmp_count") == null || cbe.getInt("tmp_count") != 1) continue;
            coll.removeObject((IObjectValue)cbe);
        }
        HashSet reCalSet = new HashSet(allClassCode.keySet());
        Set classTotalSet = classCodeTotalRowMap.keySet();
        reCalSet.removeAll(classTotalSet);
        ArrayList reCalList = new ArrayList(reCalSet);
        Collections.sort(reCalList);
        for (int i4 = reCalList.size() - 1; i4 >= 0; --i4) {
            ClassificationCodeInfo cci3 = (ClassificationCodeInfo)reCalList.get(i4);
            BigDecimal totalTrolleyCost = BigDecimal.ZERO;
            BigDecimal totalRiskAmount = BigDecimal.ZERO;
            boolean isExists = false;
            Iterator<Object> it = classTotalSet.iterator();
            while (it.hasNext()) {
                ClassificationCodeInfo totalCci = (ClassificationCodeInfo)allClassCode.get((ClassificationCodeInfo)it.next());
                if (totalCci == null || totalCci.getParent() == null || !totalCci.getParent().getId().toString().equals(cci3.getId().toString())) continue;
                isExists = true;
                CoreBillEntryBaseInfo iov3 = (CoreBillEntryBaseInfo)classCodeTotalRowMap.get(totalCci);
                totalTrolleyCost = totalTrolleyCost.add(iov3.getBigDecimal(costKey));
                totalRiskAmount = totalRiskAmount.add(iov3.getBigDecimal("riskAmount"));
            }
            if (isExists) {
                CoreBillEntryBaseInfo newClone = (CoreBillEntryBaseInfo)cloneer.clone();
                newClone.put("classCode", (Object)cci3);
                newClone.put(costKey, (Object)totalTrolleyCost);
                newClone.put("riskAmount", (Object)totalRiskAmount);
                newClone.put("isTotalRow", (Object)true);
                coll.addObject((IObjectValue)newClone);
                classCodeTotalRowMap.put(cci3, newClone);
            }
            PcmTreeBillHelper.addAmountLoopForTotal(allClassCode, classCodeTotalRowMap, (ClassificationCodeInfo)allClassCode.get(cci3.getParent()), totalTrolleyCost, totalRiskAmount, costKey);
        }
        if (model instanceof TargetCostBillInfo) {
            return;
        }
        PcmTreeBillHelper.calTotal(ctx, (CoreBillBaseInfo)model);
    }

    private static boolean isLeafOfEditParent(Map allClassCode, Set editTotalRowSetForClassCodeID, ClassificationCodeInfo cci, ClassificationCodeInfo cciChild) {
        boolean isParentIn = false;
        ClassificationCodeInfo temp = cciChild;
        for (int i = 0; i < cciChild.getLevel(); ++i) {
            if (temp == null || temp.getParent() == null || (temp = (ClassificationCodeInfo)allClassCode.get(temp.getParent())) == null || !editTotalRowSetForClassCodeID.contains(temp.getId().toString()) || !PcmTreeBillHelper.isLeafOfParent(temp, cci)) continue;
            isParentIn = true;
        }
        return isParentIn;
    }

    public static void addAmountLoopForTotal(Map allClassCode, Map classCodeTotalRowMap, ClassificationCodeInfo classCode, BigDecimal totalTrolleyCost, BigDecimal totalRiskAmount, String costKey) {
        if (classCode == null) {
            return;
        }
        if (classCodeTotalRowMap.get(classCode) != null) {
            CoreBillEntryBaseInfo newClone = (CoreBillEntryBaseInfo)classCodeTotalRowMap.get(classCode);
            newClone.put(costKey, (Object)totalTrolleyCost.add(newClone.getBigDecimal(costKey)));
            newClone.put("riskAmount", (Object)totalRiskAmount.add(newClone.getBigDecimal("riskAmount")));
        }
        if (classCode.getLevel() > 1) {
            PcmTreeBillHelper.addAmountLoopForTotal(allClassCode, classCodeTotalRowMap, (ClassificationCodeInfo)allClassCode.get(classCode.getParent()), totalTrolleyCost, totalRiskAmount, costKey);
        }
    }

    public static void calTotal(Context ctx, CoreBillBaseInfo billInfo) throws BOSException {
        BigDecimal projectQty;
        int i;
        if (billInfo instanceof EstimateTemplateInfo) {
            return;
        }
        BigDecimal totalLabourExpense = billInfo.get("trolleyLabourExpense") == null ? BigDecimal.ZERO : billInfo.getBigDecimal("trolleyLabourExpense");
        BigDecimal trolleyPeriodExpense = billInfo.get("trolleyPeriodExpense") == null ? BigDecimal.ZERO : billInfo.getBigDecimal("trolleyPeriodExpense");
        BigDecimal trolleyMaterialExpense = BigDecimal.ZERO;
        BigDecimal trolleyRiskAmount = BigDecimal.ZERO;
        IObjectCollection entrysColl = (IObjectCollection)billInfo.get("entrys");
        ProjectTypesInfo pti = (ProjectTypesInfo)billInfo.get("projectType");
        ClassificationCodeCollection cciColl = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeCollection("select id where projectTypes.id='" + pti.getId().toString() + "' and level=1");
        HashSet<String> topCciSet = new HashSet<String>();
        for (i = 0; i < cciColl.size(); ++i) {
            topCciSet.add(cciColl.get(i).getId().toString());
        }
        for (i = 0; i < entrysColl.size(); ++i) {
            String cciId;
            IObjectValue materialEntry = entrysColl.getObject(i);
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            if (!isTotalRow || !topCciSet.contains(cciId = ((ClassificationCodeInfo)materialEntry.get("classCode")).getId().toString())) continue;
            trolleyMaterialExpense = trolleyMaterialExpense.add(materialEntry.getBigDecimal("trolleyRealCost"));
            trolleyRiskAmount = trolleyRiskAmount.add(materialEntry.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : materialEntry.getBigDecimal("riskAmount"));
        }
        billInfo.put("trolleyMaterialExpense", (Object)trolleyMaterialExpense);
        BigDecimal totalTorlleyCost = trolleyMaterialExpense.add(totalLabourExpense).add(trolleyPeriodExpense);
        billInfo.put("trolleyCost", (Object)totalTorlleyCost);
        billInfo.put("trolleyRiskAmount", (Object)trolleyRiskAmount);
        if (billInfo instanceof BudgetBillInfo || billInfo instanceof ProjectTargetCostBillInfo) {
            projectQty = new BigDecimal(billInfo.get("projectQty").toString());
            billInfo.put("projectMaterialExpense", (Object)trolleyMaterialExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
            billInfo.put("projectLabourExpense", (Object)totalLabourExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
            billInfo.put("projectPeriodExpense", (Object)trolleyPeriodExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
            billInfo.put("projectCost", (Object)totalTorlleyCost.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
        }
        if (billInfo instanceof TargetCostBillInfo) {
            projectQty = new BigDecimal(billInfo.get("projectQty").toString());
            billInfo.put("projectMatetialExpense", (Object)trolleyMaterialExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
        }
        if (billInfo instanceof ProTargetCostBillInfo || billInfo instanceof ProActualCostBillInfo) {
            projectQty = new BigDecimal(billInfo.get("projectQty").toString());
            billInfo.put("proMaterialCost", (Object)trolleyMaterialExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
        }
    }

    public static String commCheckForEntrys(Context ctx, CoreBillBaseInfo billInfo) {
        IObjectCollection projectRiskEntrysColl;
        IObjectCollection otherDeliverablesEntryColl;
        IObjectCollection otherExpenseEntryColl;
        IObjectCollection entrysColl = (IObjectCollection)billInfo.get("entrys");
        BigDecimal totalLabourExpense = BigDecimal.ZERO;
        BigDecimal totalOtherExpense = BigDecimal.ZERO;
        HashSet<String> classCodeMaterialSet = new HashSet<String>();
        for (int i = 0; i < entrysColl.size(); ++i) {
            StringBuffer tmpStr = new StringBuffer();
            IObjectValue materialEntry = entrysColl.getObject(i);
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            if (materialEntry.get("classCode") == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0008", (Locale)ctx.getLocale()));
            }
            if (isTotalRow) {
                materialEntry.put("priceSource", null);
            }
            if (!isTotalRow) {
                if (materialEntry.get("unit") == null) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0009", (Locale)ctx.getLocale()));
                }
                if (materialEntry.get("materialName") == null) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0010", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(materialEntry.get("techTrolleyQty"))) {
                    materialEntry.put("techTrolleyQty", (Object)BigDecimal.ZERO);
                }
                if (materialEntry.get("material") != null && materialEntry.get("classCode") != null) {
                    ClassificationCodeInfo cci = (ClassificationCodeInfo)materialEntry.get("classCode");
                    MaterialInfo materialInfo = (MaterialInfo)materialEntry.get("material");
                    String key = cci.getId().toString() + materialInfo.getId().toString();
                    if (classCodeMaterialSet.contains(key)) {
                        tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0011", (Locale)ctx.getLocale()));
                    } else {
                        classCodeMaterialSet.add(key);
                    }
                }
            }
            if (billInfo instanceof EstimateTemplateInfo || billInfo instanceof TargetCostBillInfo) {
                if (tmpStr.length() == 0 && !isTotalRow) {
                    BigDecimal trolleyQty = materialEntry.get("trolleyQty") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("trolleyQty").toString());
                    BigDecimal trolleyPrice = materialEntry.get("trolleyPrice") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("trolleyPrice").toString());
                    BigDecimal trolleyCost = trolleyQty.multiply(trolleyPrice).setScale(2, RoundingMode.HALF_UP);
                    materialEntry.put("trolleyCost", (Object)trolleyCost);
                }
            } else {
                ProjectTypesInfo pti = (ProjectTypesInfo)billInfo.get("projectType");
                if (pti != null) {
                    ProjectInfo project;
                    BigDecimal basePrice;
                    BigDecimal configurePrice = materialEntry.getBigDecimal("configurePrice");
                    BigDecimal inquiryPrice = materialEntry.getBigDecimal("inquiryPrice");
                    BigDecimal referProjectPrice = materialEntry.getBigDecimal("referProjectPrice");
                    BigDecimal estimatePrice = materialEntry.getBigDecimal("estimatePrice");
                    BigDecimal actualPrice = materialEntry.getBigDecimal("actualPrice");
                    BigDecimal bigDecimal = basePrice = materialEntry.getBigDecimal("trolleyPrice") == null ? BigDecimal.ZERO : materialEntry.getBigDecimal("trolleyPrice");
                    if (billInfo instanceof ProjectTargetCostBillInfo) {
                        if (estimatePrice != null && estimatePrice.compareTo(BigDecimal.ZERO) > 0) {
                            materialEntry.put("estimateUnitPrice", (Object)estimatePrice);
                            materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0012", (Locale)ctx.getLocale()));
                        } else if (configurePrice != null && configurePrice.compareTo(BigDecimal.ZERO) > 0) {
                            materialEntry.put("estimateUnitPrice", (Object)configurePrice);
                            materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0013", (Locale)ctx.getLocale()));
                        } else if (referProjectPrice != null && referProjectPrice.compareTo(BigDecimal.ZERO) > 0) {
                            materialEntry.put("estimateUnitPrice", (Object)referProjectPrice);
                            project = (ProjectInfo)materialEntry.get("referProject");
                            if (project != null) {
                                materialEntry.put("priceSource", (Object)(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0014", (Locale)ctx.getLocale()) + project.getName()));
                            }
                        } else if (inquiryPrice != null && inquiryPrice.compareTo(BigDecimal.ZERO) > 0) {
                            materialEntry.put("estimateUnitPrice", (Object)inquiryPrice);
                            materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0015", (Locale)ctx.getLocale()));
                        } else if (basePrice.compareTo(BigDecimal.ZERO) != 0) {
                            materialEntry.put("estimateUnitPrice", (Object)basePrice);
                            materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0016", (Locale)ctx.getLocale()));
                        } else {
                            materialEntry.put("estimateUnitPrice", (Object)BigDecimal.ZERO);
                            materialEntry.put("priceSource", null);
                        }
                        BigDecimal targetCoeff = materialEntry.get("targetCoeff") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("targetCoeff").toString());
                        BigDecimal estimateUnitPrice = materialEntry.get("estimateUnitPrice") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("estimateUnitPrice").toString());
                        materialEntry.put("estimateUnitPrice", (Object)estimateUnitPrice.multiply(targetCoeff).setScale(2, RoundingMode.HALF_UP));
                    } else if (estimatePrice != null && estimatePrice.compareTo(BigDecimal.ZERO) > 0) {
                        materialEntry.put("estimateUnitPrice", (Object)estimatePrice);
                        materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0012", (Locale)ctx.getLocale()));
                    } else if (actualPrice != null && actualPrice.compareTo(BigDecimal.ZERO) > 0) {
                        materialEntry.put("estimateUnitPrice", (Object)actualPrice);
                        materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0017", (Locale)ctx.getLocale()));
                    } else if (inquiryPrice != null && inquiryPrice.compareTo(BigDecimal.ZERO) > 0) {
                        materialEntry.put("estimateUnitPrice", (Object)inquiryPrice);
                        materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0015", (Locale)ctx.getLocale()));
                    } else if (configurePrice != null && configurePrice.compareTo(BigDecimal.ZERO) > 0) {
                        materialEntry.put("estimateUnitPrice", (Object)configurePrice);
                        materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0013", (Locale)ctx.getLocale()));
                    } else if (referProjectPrice != null && referProjectPrice.compareTo(BigDecimal.ZERO) > 0) {
                        materialEntry.put("estimateUnitPrice", (Object)referProjectPrice);
                        project = (ProjectInfo)materialEntry.get("referProject");
                        if (project != null) {
                            materialEntry.put("priceSource", (Object)(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0014", (Locale)ctx.getLocale()) + project.getName()));
                        }
                    } else if (basePrice.compareTo(BigDecimal.ZERO) != 0) {
                        materialEntry.put("estimateUnitPrice", (Object)basePrice);
                        materialEntry.put("priceSource", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0016", (Locale)ctx.getLocale()));
                    } else {
                        materialEntry.put("estimateUnitPrice", (Object)BigDecimal.ZERO);
                        materialEntry.put("priceSource", null);
                    }
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(materialEntry.get("estimateUnitPrice"))) {
                    materialEntry.put("estimateUnitPrice", (Object)BigDecimal.ZERO);
                } else {
                    BigDecimal riskCoeff;
                    if (billInfo instanceof TargetCostBillInfo) {
                        BigDecimal destCoeff = BigDecimal.ONE;
                        if (materialEntry.get("targetCoeff") != null) {
                            destCoeff = new BigDecimal(materialEntry.get("targetCoeff").toString());
                        }
                        BigDecimal price = new BigDecimal(materialEntry.get("estimateUnitPrice").toString());
                        materialEntry.put("estimateUnitPrice", (Object)price.multiply(destCoeff).setScale(2, RoundingMode.HALF_UP));
                    }
                    if ((riskCoeff = materialEntry.getBigDecimal("riskCoeff")) != null && riskCoeff.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal riskAmount = riskCoeff.multiply(materialEntry.getBigDecimal("estimateUnitPrice")).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal trolleyQty = new BigDecimal(materialEntry.get("techTrolleyQty").toString());
                        materialEntry.put("riskAmount", (Object)riskAmount.multiply(trolleyQty).setScale(2, RoundingMode.HALF_UP));
                    }
                    if (tmpStr.length() == 0) {
                        BigDecimal trolleyQty = materialEntry.get("techTrolleyQty") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("techTrolleyQty").toString());
                        BigDecimal trolleyPrice = materialEntry.get("estimateUnitPrice") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("estimateUnitPrice").toString());
                        BigDecimal riskAmount = materialEntry.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : materialEntry.getBigDecimal("riskAmount");
                        BigDecimal trolleyCost = trolleyQty.multiply(trolleyPrice).setScale(2, RoundingMode.HALF_UP).add(riskAmount);
                        if (billInfo instanceof ProTargetCostBillInfo || billInfo instanceof ProActualCostBillInfo) {
                            BigDecimal coefficient = materialEntry.get("coefficient") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("coefficient").toString());
                            trolleyCost = trolleyQty.multiply(coefficient).multiply(trolleyPrice).setScale(2, RoundingMode.HALF_UP);
                        }
                        materialEntry.put("trolleyRealCost", (Object)trolleyCost);
                        if (billInfo instanceof ProjectTargetCostBillInfo) {
                            BigDecimal trolleyCostPur = materialEntry.get("trolleycostpurchase") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("trolleycostpurchase").toString());
                            BigDecimal trolleyRealCost = materialEntry.get("trolleyRealCost") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("trolleyRealCost").toString());
                            BigDecimal overAmount = trolleyCostPur.subtract(trolleyRealCost).setScale(2, RoundingMode.HALF_UP);
                            materialEntry.put("overAmount", (Object)overAmount);
                            if (trolleyRealCost.compareTo(BigDecimal.ZERO) != 0) {
                                BigDecimal overRate = overAmount.divide(trolleyRealCost, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                                materialEntry.put("overRate", (Object)overRate);
                            } else {
                                materialEntry.put("overRate", (Object)BigDecimal.ZERO);
                            }
                        }
                        if (billInfo instanceof ProjectTargetCostBillInfo || billInfo instanceof BudgetBillInfo) {
                            BigDecimal qtyPur = materialEntry.get("trolleyQtyPurchase") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("trolleyQtyPurchase").toString());
                            BigDecimal pricePur = materialEntry.get("trolleyPricePurchase") == null ? BigDecimal.ZERO : new BigDecimal(materialEntry.get("trolleyPricePurchase").toString());
                            BigDecimal costPur = qtyPur.multiply(pricePur).setScale(2, RoundingMode.HALF_UP);
                            materialEntry.put("trolleyCostPurchase", (Object)costPur);
                        }
                    }
                }
            }
            if (tmpStr.length() <= 0) continue;
            return EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.LcmResourceTwo", (String)"CLF", (Locale)ctx.getLocale()) + EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.processresource", (String)"from", (Locale)ctx.getLocale()) + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.standby.StandbyResource", (String)"ROW", (Locale)ctx.getLocale()) + tmpStr.toString();
        }
        IObjectCollection labourColl = (IObjectCollection)billInfo.get("labourEntry");
        if (labourColl != null) {
            for (int i = 0; i < labourColl.size(); ++i) {
                StringBuffer tmpStr = new StringBuffer();
                IObjectValue labourEntry = labourColl.getObject(i);
                if (labourEntry.get("expenseDept") == null && labourEntry.get("outsideDept") == null) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0018", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(labourEntry.get("projectQty"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0019", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(labourEntry.get("whQuota"))) {
                    labourEntry.put("whQuota", (Object)BigDecimal.ZERO);
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(labourEntry.get("whRateEnd"))) {
                    labourEntry.put("whRateEnd", (Object)BigDecimal.ZERO);
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(labourEntry.get("manuExpenseRateEnd"))) {
                    labourEntry.put("manuExpenseRateEnd", (Object)BigDecimal.ZERO);
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(labourEntry.get("engExpenseRateEnd"))) {
                    labourEntry.put("engExpenseRateEnd", (Object)BigDecimal.ZERO);
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(labourEntry.get("proSpecialExpense"))) {
                    labourEntry.put("proSpecialExpense", (Object)BigDecimal.ZERO);
                }
                if (tmpStr.length() == 0) {
                    BigDecimal projectQty = new BigDecimal(labourEntry.get("projectQty").toString());
                    BigDecimal whQuota = new BigDecimal(labourEntry.get("whQuota").toString());
                    BigDecimal whRate = new BigDecimal(labourEntry.get("whRateEnd").toString());
                    BigDecimal manuExpenseRate = new BigDecimal(labourEntry.get("manuExpenseRateEnd").toString());
                    BigDecimal engExpenseRate = new BigDecimal(labourEntry.get("engExpenseRateEnd").toString());
                    BigDecimal proWorkerExpense = projectQty.multiply(whQuota).setScale(2, RoundingMode.HALF_UP).multiply(whRate).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal proManuExpense = projectQty.multiply(whQuota).setScale(2, RoundingMode.HALF_UP).multiply(manuExpenseRate).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal proEngExpense = projectQty.multiply(whQuota).setScale(2, RoundingMode.HALF_UP).multiply(engExpenseRate).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal proSpecialExpense = new BigDecimal(labourEntry.get("proSpecialExpense").toString());
                    BigDecimal totalExpense = proWorkerExpense.add(proManuExpense).add(proEngExpense).add(proSpecialExpense);
                    labourEntry.put("proWorkerExpense", (Object)proWorkerExpense);
                    labourEntry.put("proManuExpense", (Object)proManuExpense);
                    labourEntry.put("proEngExpense", (Object)proEngExpense);
                    labourEntry.put("totalExpense", (Object)totalExpense);
                    totalLabourExpense = totalLabourExpense.add(totalExpense);
                }
                if (tmpStr.length() <= 0) continue;
                return ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"GFFLDH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, tmpStr.toString()});
            }
        }
        if ((otherExpenseEntryColl = (IObjectCollection)billInfo.get("otherExpenseEntry")) != null) {
            for (int i = 0; i < otherExpenseEntryColl.size(); ++i) {
                StringBuffer tmpStr = new StringBuffer();
                IObjectValue otherExpenseEntry = otherExpenseEntryColl.getObject(i);
                if (otherExpenseEntry.get("costItem") == null) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0020", (Locale)ctx.getLocale()));
                }
                if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(otherExpenseEntry.get("costExpense"))) {
                    totalOtherExpense = totalOtherExpense.add(otherExpenseEntry.getBigDecimal("costExpense"));
                }
                if (tmpStr.length() <= 0) continue;
                return ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"QTFYFLDH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, tmpStr.toString()});
            }
        }
        if ((otherDeliverablesEntryColl = (IObjectCollection)billInfo.get("otherDeliverablesEntry")) != null) {
            for (int i = 0; i < otherDeliverablesEntryColl.size(); ++i) {
                StringBuffer tmpStr = new StringBuffer();
                IObjectValue otherDeliverablesEntry = otherDeliverablesEntryColl.getObject(i);
                if (PcmTreeBillHelper.isStringEmpty(otherDeliverablesEntry.get("otherDeliverable"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0021", (Locale)ctx.getLocale()));
                }
                if (otherDeliverablesEntry.get("unit") == null) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0009", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(otherDeliverablesEntry.get("qty"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0022", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(otherDeliverablesEntry.get("price"))) {
                    otherDeliverablesEntry.put("price", (Object)BigDecimal.ZERO);
                }
                if (tmpStr.length() == 0) {
                    BigDecimal qty = (BigDecimal)otherDeliverablesEntry.get("qty");
                    BigDecimal price = (BigDecimal)otherDeliverablesEntry.get("price");
                    BigDecimal cost = qty.multiply(price).setScale(2, RoundingMode.HALF_UP);
                    otherDeliverablesEntry.put("amount", (Object)cost);
                    BigDecimal taxPrice = price.multiply(new BigDecimal("1.17").setScale(2, RoundingMode.HALF_UP));
                    otherDeliverablesEntry.put("taxPrice", (Object)taxPrice);
                }
                if (tmpStr.length() <= 0) continue;
                return ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"QTKJHCGFL", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, tmpStr.toString()});
            }
        }
        if ((projectRiskEntrysColl = (IObjectCollection)billInfo.get("projectRiskEntrys")) != null) {
            for (int i = 0; i < projectRiskEntrysColl.size(); ++i) {
                StringBuffer tmpStr = new StringBuffer();
                IObjectValue projectRiskEntry = projectRiskEntrysColl.getObject(i);
                if (PcmTreeBillHelper.isStringEmpty(projectRiskEntry.get("riskItem"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0023", (Locale)ctx.getLocale()));
                }
                if (projectRiskEntry.get("riskType") == null) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0024", (Locale)ctx.getLocale()));
                }
                if (projectRiskEntry.get("unit") == null) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0009", (Locale)ctx.getLocale()));
                }
                if (!PcmTreeBillHelper.isBigDecimalOverZero(projectRiskEntry.get("qty"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmUtilResource", (String)"0EMMPCPcmUtil-0025", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(projectRiskEntry.get("price"))) {
                    projectRiskEntry.put("price", (Object)BigDecimal.ZERO);
                }
                if (tmpStr.length() == 0) {
                    BigDecimal qty = (BigDecimal)projectRiskEntry.get("qty");
                    BigDecimal price = (BigDecimal)projectRiskEntry.get("price");
                    BigDecimal cost = qty.multiply(price).setScale(2, RoundingMode.HALF_UP);
                    projectRiskEntry.put("amount", (Object)cost);
                    BigDecimal taxPrice = price.multiply(new BigDecimal("1.17").setScale(2, RoundingMode.HALF_UP));
                    projectRiskEntry.put("taxPrice", (Object)taxPrice);
                }
                if (tmpStr.length() <= 0) continue;
                return ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"XHFXFL", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, tmpStr.toString()});
            }
        }
        if (billInfo instanceof EstimateTemplateInfo) {
            return null;
        }
        BigDecimal projectQty = BigDecimal.ZERO;
        if (billInfo.get("projectQty") != null) {
            projectQty = new BigDecimal(billInfo.get("projectQty").toString());
        }
        if (projectQty.compareTo(BigDecimal.ZERO) == 0) {
            return "\u9879\u76ee\u6570\u91cf\u4e0d\u80fd\u4e3a0";
        }
        billInfo.put("trolleyLabourExpense", (Object)totalLabourExpense.divide(projectQty, 2));
        billInfo.put("trolleyPeriodExpense", (Object)totalOtherExpense);
        if (billInfo instanceof BudgetBillInfo || billInfo instanceof ProjectTargetCostBillInfo) {
            projectQty = new BigDecimal(billInfo.get("projectQty").toString());
            billInfo.put("projectLabourExpense", (Object)totalLabourExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
            billInfo.put("projectPeriodExpense", (Object)totalOtherExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
        }
        if (billInfo instanceof TargetCostBillInfo) {
            projectQty = new BigDecimal(billInfo.get("projectQty").toString());
        }
        return null;
    }

    public static boolean isStringEmpty(Object o) {
        if (o == null) {
            return true;
        }
        return "".equals(o.toString().trim());
    }

    public static boolean isBigDecimalEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if ("".equals(o.toString().trim())) {
            return true;
        }
        try {
            new BigDecimal(o.toString());
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static boolean isBigDecimalEmptyAndZero(Object o) {
        if (o == null) {
            return true;
        }
        if ("".equals(o.toString().trim())) {
            return true;
        }
        try {
            new BigDecimal(o.toString());
        }
        catch (Exception e) {
            return true;
        }
        return BigDecimal.ZERO.compareTo(new BigDecimal(o.toString())) >= 0;
    }

    public static boolean isBigDecimalUnderZero(Object o) {
        if (o == null) {
            return false;
        }
        if ("".equals(o.toString().trim())) {
            return false;
        }
        try {
            new BigDecimal(o.toString());
        }
        catch (Exception e) {
            return false;
        }
        return BigDecimal.ZERO.compareTo(new BigDecimal(o.toString())) > 0;
    }

    public static boolean isBigDecimalOverZero(Object o) {
        if (o == null) {
            return false;
        }
        if ("".equals(o.toString().trim())) {
            return false;
        }
        try {
            new BigDecimal(o.toString());
        }
        catch (Exception e) {
            return false;
        }
        return BigDecimal.ZERO.compareTo(new BigDecimal(o.toString())) < 0;
    }

    private static boolean isLeafOfParent(ClassificationCodeInfo children, ClassificationCodeInfo parent) {
        if (children == null || children.getLongNumber() == null || parent == null || parent.getLongNumber() == null) {
            return false;
        }
        if (children.getLongNumber().equals(parent.getLongNumber())) {
            return false;
        }
        String childrenLongNumber = children.getLongNumber();
        String parentNumber = parent.getNumber();
        String[] parentStrs = childrenLongNumber.split("!");
        for (int i = 0; i < parentStrs.length - 1; ++i) {
            if (!parentStrs[i].equals(parentNumber)) continue;
            return true;
        }
        return false;
    }
}

