/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.imm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.industry.emm.imm.IProjectCharter;
import com.kingdee.eas.industry.emm.imm.ProjectCharterFactory;
import com.kingdee.eas.industry.emm.imm.ProjectCharterInfo;
import com.kingdee.eas.industry.emm.imm.client.AbstractProjectCharterListUI;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ProjectCharterListUI
extends AbstractProjectCharterListUI {
    private static final long serialVersionUID = -2258467204489680457L;
    private String Resource_Name = "com.kingdee.eas.industry.emm.imm.EMMPROJECTImmResource";
    private String PROJECT_BSTJBNSH = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_BSTJBNSH");
    private String PROJECT_QXZYTJLZXG = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_QXZYTJLZXG");
    private String PROJECT_YSHDBNXG = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_YSHDBNXG");
    private String PROJECT_WSHBNDY = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_WSHBNDY");
    private String PROJECT_WSHBNDYYL = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_WSHBNDYYL");
    private String PROJECT_DJBSFSH = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_DJBSFSH");
    private String PROJECT_YJRGZL = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_YJRGZL");
    private String PROJECT_SHZTBNSC = EASResource.getString((String)this.Resource_Name, (String)"PROJECT_SHZTBNSC");

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IProjectCharter ipc = ProjectCharterFactory.getRemoteInstance();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int n = selectedRows.length;
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(selectedRows[i]);
            String selectId = (String)row.getCell("id").getValue();
            String auditorNumber = (String)row.getCell("auditor.number").getValue();
            String dhState = row.getCell("billstatus").getValue().toString();
            if (auditorNumber != null || !dhState.equals(BillBaseStatusEnum.SUBMITED.getAlias())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.PROJECT_BSTJBNSH);
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(selectId);
            this.checkSelectedWfState((Component)((Object)this), selectId);
            ProjectCharterInfo charterInfo = ipc.getProjectCharterInfo((IObjectPK)pk);
            ipc.audit((IObjectValue)charterInfo);
        }
        FMClientHelper.showSuccessInfo((CoreUI)this, (ItemAction)this.actionAudit);
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectedRows.length != 1) {
            MsgBox.showInfo((Component)((Object)this), (String)this.PROJECT_QXZYTJLZXG);
            return;
        }
        IRow row = this.tblMain.getRow(selectedRows[0]);
        if (row.getCell("auditor.name").getValue() != null && !row.getCell("auditor.name").getValue().equals("") && !row.getCell("auditor.name").getValue().equals("null")) {
            MsgBox.showInfo((Component)((Object)this), (String)this.PROJECT_YSHDBNXG);
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        ObjectStringPK pk = new ObjectStringPK(list.get(0).toString());
        ProjectCharterInfo info = ((IProjectCharter)this.getBizInterface()).getProjectCharterInfo((IObjectPK)pk, this.getSelectors());
        if (!info.getBillstatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.PROJECT_WSHBNDY);
            SysUtil.abort();
        }
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        ObjectStringPK pk = new ObjectStringPK(list.get(0).toString());
        ProjectCharterInfo info = ((IProjectCharter)this.getBizInterface()).getProjectCharterInfo((IObjectPK)pk, this.getSelectors());
        if (!info.getBillstatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.PROJECT_WSHBNDYYL);
            SysUtil.abort();
        }
        this.invokePrintFunction(false);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkRemove();
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionUnAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IProjectCharter ipc = ProjectCharterFactory.getRemoteInstance();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int n = selectedRows.length;
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(selectedRows[i]);
            String selectId = (String)row.getCell("id").getValue();
            String auditorNumber = (String)row.getCell("auditor.number").getValue();
            String dhState = row.getCell("billstatus").getValue().toString();
            if (auditorNumber == null || !dhState.equals(BillBaseStatusEnum.AUDITED.getAlias())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.PROJECT_DJBSFSH);
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(selectId);
            this.checkSelectedWfState((Component)((Object)this), selectId);
            ProjectCharterInfo charterInfo = ipc.getProjectCharterInfo((IObjectPK)pk);
            ipc.unaudit((IObjectValue)charterInfo);
        }
        FMClientHelper.showSuccessInfo((CoreUI)this, (ItemAction)this.actionUnAction);
        this.refreshList();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnaudit.setVisible(true);
        this.btnunaudit.setVisible(true);
        this.actionAudit.setEnabled(true);
        this.actionUnAction.setEnabled(true);
        this.enableTableCommonMenus(this.tblMain);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void checkSelectedWfState(Component comp, String id) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(id);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo != null) {
            MsgBox.showInfo((Component)comp, (String)this.PROJECT_YJRGZL);
            SysUtil.abort();
        }
    }

    protected void checkRemove() throws Exception {
        ArrayList set = this.getSelectedIdValues();
        IProjectCharter requestBill = (IProjectCharter)this.getBizInterface();
        for (int i = 0; i < set.size(); ++i) {
            String id = (String)set.get(i);
            if (id == null || "".equals(id)) continue;
            ProjectCharterInfo charterInfo = requestBill.getProjectCharterInfo((IObjectPK)new ObjectUuidPK(id));
            if (!BillBaseStatusEnum.AUDITED.getAlias().equalsIgnoreCase(charterInfo.getBillstatus().getAlias())) continue;
            MsgBox.showInfo((String)this.PROJECT_SHZTBNSC);
            SysUtil.abort();
            return;
        }
    }

    @Override
    protected IObjectValue createNewData() {
        ProjectCharterInfo objectValue = new ProjectCharterInfo();
        return objectValue;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProjectCharterFactory.getRemoteInstance();
    }

    @Override
    protected String getTDFileName() {
        return "/mm/pm/imm/ProjectCharter";
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.industry.emm.imm.app.ProjectCharterPrintR1Query");
    }

    protected void invokePrintFunction(boolean isPrint) {
        List idList = new ArrayList();
        idList = this.getSelectedIdForPrint();
        if (idList == null || idList.size() == 0 || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }
}

