/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.AbstractPMRPPlannerWorkPlatformMaterialQueryUI;
import com.kingdee.eas.mm.basedata.PlanVersionSetCollection;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.MMSpecialLicenseAdapter;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;

public class PMRPPlannerWorkPlatformMaterialQueryUI
extends AbstractPMRPPlannerWorkPlatformMaterialQueryUI {
    private static final long serialVersionUID = 1L;
    private DataChangeListener storageOrgDataChangeListener = null;
    private DataChangeListener materialDataChangeListener = null;
    private MMSpecialLicenseAdapter licenseAdapter = null;
    private CustomerParams cp = null;

    public PMRPPlannerWorkPlatformMaterialQueryUI() throws Exception {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit", (Component)this.prmtstorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, PMRPPlannerWorkPlatformMaterialQueryUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement materialElement = new SingleFilterElement("materialNum", (Component)this.prmtmaterialNum);
        materialElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, PMRPPlannerWorkPlatformMaterialQueryUI.getResource("MATERIALNUM_ISNULL")));
        elements.add((FilterElement)materialElement);
        SingleFilterElement planNum = new SingleFilterElement("planNum", (Component)this.prmtplanNum);
        planNum.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, PMRPPlannerWorkPlatformMaterialQueryUI.getResource("PLANNUM_ISNULL")));
        elements.add((FilterElement)new SingleFilterElement("materialName", (Component)this.txtmaterialName));
        elements.add((FilterElement)planNum);
        elements.add((FilterElement)new SingleFilterElement("planName", (Component)this.txtplanName));
        elements.add((FilterElement)new SingleFilterElement("isSimulantResult", (Component)this.chkSimulantResult));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtmaterialNum, false, queryInfo);
        this.f7Manager.registerContextChangeF7(this.prmtplanNum, "storageOrgUnit.id");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtmaterialNum, this.prmtplanNum});
        this.prmtplanNum.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PMRPPlannerWorkPlatformMaterialQueryUI.this.checkMainOrg(e);
            }
        });
        this.prmtmaterialNum.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PMRPPlannerWorkPlatformMaterialQueryUI.this.checkMainOrg(e);
                PMRPPlannerWorkPlatformMaterialQueryUI.this.setMaterialF7();
            }
        });
        this.setSize(200, 200);
    }

    private void setMaterialF7() {
        EntityViewInfo view = this.prmtmaterialNum.getEntityViewInfo();
        view.getFilter().getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
    }

    private void checkMainOrg(SelectorEvent e) {
        if (this.prmtstorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)PMRPPlannerWorkPlatformMaterialQueryUI.getResource("INPUT_STORAGOR"));
            e.setCanceled(true);
        }
    }

    private void checkSpecialLicense(String planMode) {
        String fullName = "com.kingdee.eas.mm.report.client.PlannerWorkPlatformUI";
        if (planMode != null) {
            if (planMode.equalsIgnoreCase("ypaAzjDRT6PgQwEAAH9oBM5PzmM=")) {
                fullName = fullName + "_MRP";
            } else if (planMode.equalsIgnoreCase("VY6l/mhnQuJvgQABEDWARDs5PzmA=")) {
                fullName = fullName + "_MPS";
            }
            this.licenseAdapter = new MMSpecialLicenseAdapter(fullName, EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"87_PlannerWorkPlatformUI"));
            try {
                this.licenseAdapter.checkLicence();
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        this.checkSpecialLicense(uiParam);
        super.onLoad();
        this.prmtstorageOrgUnit.getQueryAgent().setEnabledMultiSelection(false);
        this.prmtmaterialNum.getQueryAgent().setEnabledMultiSelection(false);
        this.prmtplanNum.getQueryAgent().setEnabledMultiSelection(false);
        this.addListeners();
    }

    public void clear() {
        super.clear();
        OrgUnitInfo storageOrgUnitInfos = (OrgUnitInfo)this.prmtstorageOrgUnit.getData();
        if (storageOrgUnitInfos != null) {
            try {
                PlanVersionSetCollection pvsCollection = PlanVersionSetFactory.getRemoteInstance().getPlanVersionSetCollection(" where storageOrgUnit.id='" + storageOrgUnitInfos.getId().toString() + "' and number='900'");
                if (pvsCollection != null && pvsCollection.size() > 0) {
                    this.prmtplanNum.setValue((Object)pvsCollection.get(0));
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    protected void prmtstorageOrgUnit_dataChange(DataChangeEvent e) {
        this.prmtmaterialNum.setValue(null);
        this.prmtplanNum.setValue(null);
        this.txtmaterialName.setText(null);
        this.txtplanName.setText(null);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_plannerworkQurey_single";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.PlannerResource", (String)strKey);
    }

    @Override
    protected void prmtplanNum_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtplanNum.getData() instanceof PlanVersionSetInfo) {
            PlanVersionSetInfo plan = (PlanVersionSetInfo)this.prmtplanNum.getData();
            this.txtplanName.setText(plan.getName());
        } else {
            this.txtplanName.setText(null);
        }
    }

    @Override
    protected void prmtmaterialNum_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtmaterialNum.getData() instanceof MaterialInfo) {
            MaterialInfo material = (MaterialInfo)this.prmtmaterialNum.getData();
            this.txtmaterialName.setText(material.getName());
        } else {
            this.txtmaterialName.setText(null);
        }
    }

    public boolean isReport() {
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListeners();
        this.chkSimulantResult.setSelected(false);
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("isSimulantResult") != null && this.cp.getCustomerParam("isSimulantResult").length() > 0) {
            this.chkSimulantResult.setSelected(true);
        }
        this.addListeners();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = super.getCustomerParams();
        if (this.chkSimulantResult.isSelected()) {
            customerParams.addCustomerParam("isSimulantResult", "1");
        }
        return customerParams;
    }

    private void addListeners() {
        if (this.storageOrgDataChangeListener == null) {
            this.storageOrgDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    PMRPPlannerWorkPlatformMaterialQueryUI.this.prmtstorageOrgUnit_dataChange(e);
                }
            };
        }
        this.prmtstorageOrgUnit.addDataChangeListener(this.storageOrgDataChangeListener);
        if (this.materialDataChangeListener == null) {
            this.materialDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        PMRPPlannerWorkPlatformMaterialQueryUI.this.prmtmaterialNum_dataChanged(e);
                    }
                    catch (Exception exc) {
                        PMRPPlannerWorkPlatformMaterialQueryUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtmaterialNum.addDataChangeListener(this.materialDataChangeListener);
    }

    private void removeListeners() {
        this.prmtstorageOrgUnit.removeDataChangeListener(this.storageOrgDataChangeListener);
        this.prmtmaterialNum.removeDataChangeListener(this.materialDataChangeListener);
    }
}

