/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.impl;

import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.IPMRPBatchPolicy;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyResult;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyVO;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import java.math.BigDecimal;

public class PMRPDirectBatchPolicy
implements IPMRPBatchPolicy {
    private static BigDecimal zero = new BigDecimal("0.00");
    private PMRPCalcParam runParam;

    public PMRPCalcParam getRunParam() {
        return this.runParam;
    }

    public void setRunParam(PMRPCalcParam runParam) {
        this.runParam = runParam;
    }

    @Override
    public void initRunParam(PMRPCalcParam runParam) {
        this.setRunParam(runParam);
    }

    @Override
    public PMRPBatchPolicyResult[] batchComputing(PMRPBatchPolicyVO batchPolocyVO) throws PMRPException {
        int partition;
        BigDecimal batchIncQty;
        BigDecimal zero = new BigDecimal("0");
        if (batchPolocyVO.getNetRequirementQty() == null || batchPolocyVO.getNetRequirementQty().compareTo(zero) >= 0) {
            return null;
        }
        PMRPBatchPolicyResult[] results = null;
        BigDecimal reqQty = batchPolocyVO.getNetRequirementQty().abs();
        BigDecimal yieldRate = batchPolocyVO.getYield();
        if (yieldRate == null) {
            yieldRate = new BigDecimal("100.00");
        }
        if ((yieldRate = yieldRate.divide(new BigDecimal("100.00"), 4, 2)).compareTo(MRPConstant.ZERO) > 0 && batchPolocyVO.getMaterialAttriBute() == 10030) {
            reqQty = reqQty.divide(yieldRate, batchPolocyVO.getQtyPrc(), 2);
        }
        if ((batchIncQty = batchPolocyVO.getBatchIncQty()) == null) {
            batchIncQty = zero;
        }
        BigDecimal roundUpMultiple = batchPolocyVO.getRoundUpMultipleQty();
        reqQty = reqQty.add(batchIncQty);
        if (roundUpMultiple != null && roundUpMultiple.compareTo(zero) != 0) {
            reqQty = reqQty.divide(roundUpMultiple, 0, 0).multiply(roundUpMultiple).setScale(batchPolocyVO.getQtyPrc(), 0);
        }
        results = (partition = batchPolocyVO.getPartitionQty()) == 0 ? this.calNoSplitSetting(batchPolocyVO, reqQty) : this.calSplitSetting(batchPolocyVO, reqQty);
        return results;
    }

    private PMRPBatchPolicyResult[] calNoSplitSetting(PMRPBatchPolicyVO batchPolocyVO, BigDecimal reqQty) throws PMRPException {
        BigDecimal maxBatchQty = batchPolocyVO.getMaxBatchQty();
        BigDecimal minBatchQty = batchPolocyVO.getMinBatchQty();
        BigDecimal zero = new BigDecimal("0");
        if (maxBatchQty == null || maxBatchQty.compareTo(zero) == 0) {
            maxBatchQty = new BigDecimal(Integer.MAX_VALUE);
        }
        if (minBatchQty == null || minBatchQty.compareTo(zero) == 0) {
            minBatchQty = zero;
        }
        PMRPBatchPolicyResult[] results = null;
        int peroid = batchPolocyVO.getCurrentPeriod();
        if (reqQty.compareTo(minBatchQty) <= 0) {
            results = new PMRPBatchPolicyResult[]{new PMRPBatchPolicyResult()};
            results[0].setPeriod(peroid);
            results[0].setQty(minBatchQty);
            results[0].setOrderLine(batchPolocyVO.getOrderLine());
        } else if (reqQty.compareTo(maxBatchQty) >= 0) {
            if (maxBatchQty == null || maxBatchQty.compareTo(zero) == 0) {
                maxBatchQty = reqQty;
            }
            int num = reqQty.divide(maxBatchQty, 0, 0).intValue();
            this.throwMaxBatchException(num, batchPolocyVO);
            results = new PMRPBatchPolicyResult[num];
            for (int i = 0; i < num; ++i) {
                results[i] = new PMRPBatchPolicyResult();
                results[i].setPeriod(peroid);
                results[i].setOrderLine(batchPolocyVO.getOrderLine());
                if (num == i + 1) {
                    results[i].setQty(reqQty.subtract(maxBatchQty.multiply(new BigDecimal(i))));
                    continue;
                }
                results[i].setQty(maxBatchQty);
            }
        } else {
            results = new PMRPBatchPolicyResult[]{new PMRPBatchPolicyResult()};
            results[0].setPeriod(peroid);
            results[0].setQty(reqQty);
            results[0].setOrderLine(batchPolocyVO.getOrderLine());
        }
        return results;
    }

    private PMRPBatchPolicyResult[] calSplitSetting(PMRPBatchPolicyVO batchPolocyVO, BigDecimal reqQty) throws PMRPException {
        BigDecimal minBatchQty = batchPolocyVO.getMinBatchQty();
        if (minBatchQty == null || minBatchQty.compareTo(zero) == 0) {
            minBatchQty = reqQty;
        }
        int num = reqQty.divide(minBatchQty, 0, 0).intValue();
        this.throwMaxBatchException(num, batchPolocyVO);
        PMRPBatchPolicyResult[] results = null;
        results = new PMRPBatchPolicyResult[num];
        int peroid = batchPolocyVO.getCurrentPeriod();
        int peroidOffset = 0;
        boolean isLastDay = false;
        for (int i = 0; i < num; ++i) {
            results[i] = new PMRPBatchPolicyResult();
            results[i].setPeriod(peroid);
            results[i].setPeriodOffset(peroidOffset);
            results[i].setOrderLine(batchPolocyVO.getOrderLine());
            if (i != 0) {
                results[i].setException(63);
            }
            if (batchPolocyVO.getPartitionQty() > 0) {
                isLastDay = num == i + 1 && i != 0;
            } else {
                boolean bl = isLastDay = i == 0 && reqQty.compareTo(minBatchQty) > 0;
            }
            if (isLastDay) {
                results[i].setQty(reqQty.subtract(minBatchQty.multiply(new BigDecimal(num - 1))));
            } else {
                results[i].setQty(minBatchQty);
            }
            peroid += batchPolocyVO.getPartitionQty();
            peroidOffset += batchPolocyVO.getPartitionQty();
        }
        return results;
    }

    private void throwMaxBatchException(int num, PMRPBatchPolicyVO batchPolocyVO) throws PMRPException {
        if (num > 100) {
            throw new PMRPException(PMRPException.BATCH_OUT, new Object[]{batchPolocyVO.getMaterialNumber()});
        }
    }
}

