/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPStepStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class PMRPStep
implements IPMRPStep {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep");
    protected PMRPCalcParam runParam;
    protected Date beginTime;
    protected Date endTime;
    protected int dataAmount = 0;
    protected String stepNum;
    protected int progressPercent = 1;
    protected PMRPRunLogEntryInfo logInfo;

    protected abstract boolean isNeedUpdateProgress();

    protected abstract Object innerExecute(PMRPCalcParam var1) throws BOSException, PMRPException;

    public final void mrpCalcFinished() {
        this.innerMrpCalcFinished();
        List<? extends PMRPStep> subs = this.getSubSteps();
        if (subs == null) {
            return;
        }
        for (PMRPStep pMRPStep : subs) {
            pMRPStep.mrpCalcFinished();
        }
    }

    protected void innerMrpCalcFinished() {
    }

    public final Object execute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        this.runParam = runParam;
        Object ret = null;
        if (this.isRunStep(runParam)) {
            this.logBegin();
            ret = this.innerExecute(runParam);
            this.logEnd();
        }
        this.executeExtendStep(runParam);
        return ret;
    }

    private boolean isRunStep(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        boolean isRun = true;
        sql.append("SELECT FISRunStep FROM ").append(Constants.TableName.STEP_EXTEND_TABLE).append(" WHERE FEXTENDEDCLASS = ?");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{this.getClass().getName()});
        try {
            if (rs.next()) {
                isRun = rs.getBoolean("FISRunStep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isRun;
    }

    private void executeExtendStep(PMRPCalcParam runParam) throws BOSException, PMRPException {
        block4: {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FisMergeTransaction,FExtendClass FROM ");
            sql.append(Constants.TableName.STEP_EXTEND_TABLE).append(" WHERE FEXTENDEDCLASS = ?");
            IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{this.getClass().getName()});
            try {
                if (!rs.next()) break block4;
                logger.info((Object)(this.getClass().getName() + " extendStep start runnning"));
                try {
                    Class<?> theClass = Class.forName(rs.getString("FExtendClass"));
                    Method m = theClass.getMethod("execute", PMRPCalcParam.class);
                    m.invoke(theClass.newInstance(), runParam);
                    logger.info((Object)(this.getClass().getName() + " extendStep finish runnning"));
                }
                catch (Exception e) {
                    throw new PMRPException(PMRPException.CUST_DEP_ERROR, new Object[]{rs.getString("FExtendClass")});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void logBegin() throws BOSException, PMRPException {
        this.beginTime = new Date();
        if (logger.isInfoEnabled()) {
            this.beginTime = new Date();
        }
        if (this.logInfo != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("update ");
            sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
            sql.append(" set FBeginTime = ? ,FStatus = ? where FID = ?");
            SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new Timestamp(this.beginTime.getTime()), new Integer(40), this.logInfo.getId().toString()});
        }
    }

    protected void logEnd() throws BOSException, PMRPException {
        this.endTime = new Date();
        BigDecimal e = new BigDecimal(String.valueOf(this.endTime.getTime()));
        BigDecimal b = new BigDecimal(String.valueOf(this.beginTime.getTime()));
        BigDecimal runSecs = e.subtract(b).divide(new BigDecimal("1000"), 2, 4);
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this.runParam.getRunLog().getNumber() + ":" + this.getStepNum() + ":" + this.getStepDesc(this.runParam.getEasCtx().getLocale()) + "," + PMRPResource.getString(this.runParam.getEasCtx().getLocale(), "SYM_RUNTIMES") + "\uff1a" + String.valueOf(runSecs) + "s"));
        }
        if (this.logInfo != null) {
            BigDecimal min = runSecs.divide(new BigDecimal("60"), 2, 4);
            StringBuffer sql = new StringBuffer();
            sql.append("update ");
            sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
            sql.append(" set FEndTime = ?,FStatus = ?,FTime = ?,FName =?,");
            sql.append(" FDataAmount=? where FID = ?");
            SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new Timestamp(this.endTime.getTime()), new Integer(20), min, this.getStepDesc(this.runParam.getEasCtx().getLocale()), new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
        }
        if (this.isNeedUpdateProgress()) {
            this.runParam.getCounter().updateProgress(this.getProgressPercent());
        }
    }

    public List<? extends PMRPStep> getSubSteps() {
        return new ArrayList();
    }

    public PMRPRunLogEntryInfo createLogInfo(PMRPCalcParam runParam, PMRPRunLogEntryInfo parent, int numSeq) throws PMRPException, BOSException {
        if (numSeq > Constants.MRP_STEP_LENTH) {
            throw new PMRPException(PMRPException.SEQ_OVERFLOW);
        }
        this.runParam = runParam;
        this.logInfo = new PMRPRunLogEntryInfo();
        this.logInfo.setId(BOSUuid.create((BOSObjectType)this.logInfo.getBOSType()));
        this.logInfo.setSeq(numSeq);
        this.logInfo.setParent(runParam.getRunLog());
        this.logInfo.setName(this.getStepDesc(runParam.getEasCtx().getLocale()));
        if (parent != null) {
            this.stepNum = parent.getStepNum() + "." + String.valueOf(numSeq);
            this.logInfo.setStepNum(this.stepNum);
            PMRPRunLogEntryInfo tmp = parent.getStepParent();
            int namespace = Constants.MRP_STEP_NAMESPACE / Constants.MRP_CHILD_STEP_NAMESPACE;
            int depth = 1;
            while (tmp != null) {
                tmp = tmp.getStepParent();
                if (++depth > 4) {
                    throw new PMRPException(PMRPException.DEPTH_OVERFLOW);
                }
                namespace /= Constants.MRP_CHILD_STEP_NAMESPACE;
            }
            this.logInfo.setSeq(parent.getSeq() + numSeq * namespace);
        } else {
            this.logInfo.setSeq(numSeq * Constants.MRP_STEP_NAMESPACE);
            this.logInfo.setStepNum(String.valueOf(numSeq));
        }
        this.logInfo.setStatus(PMRPStepStatusEnum.NULL);
        this.insertStepLog(runParam, this.logInfo);
        List<? extends PMRPStep> subStepList = this.getSubSteps();
        if (subStepList != null) {
            for (int i = 0; i < subStepList.size(); ++i) {
                subStepList.get(i).createLogInfo(runParam, this.logInfo, i + 1);
            }
        }
        return this.logInfo;
    }

    private void insertStepLog(PMRPCalcParam runParam, PMRPRunLogEntryInfo stepLog) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
        sql.append(" (FID,FName,FParentID,FStepParentID,FStatus,FStepNum,FSeq) ");
        sql.append("values (?, ?, ?, ?, ?, ?, ?)");
        Object[] param = new Object[7];
        int index = 0;
        param[index++] = stepLog.getId().toString();
        param[index++] = stepLog.getName();
        param[index++] = stepLog.getParent().getId().toString();
        param[index++] = stepLog.getStepParent() != null ? stepLog.getStepParent().getId().toString() : "";
        param[index++] = new Integer(stepLog.getStatus().getValue());
        param[index++] = stepLog.getStepNum();
        param[index++] = new Integer(stepLog.getSeq());
        SQLUtils.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])param);
    }

    public void setProgressPercent(int progressPercent) {
        this.progressPercent = progressPercent;
    }

    protected int getProgressPercent() {
        return this.progressPercent;
    }

    protected String getStepNum() {
        return this.stepNum;
    }

    public int getDataAmount() {
        return this.dataAmount;
    }

    public boolean isLogRequired() {
        return true;
    }

    public PMRPRunLogEntryInfo getLogInfo() {
        return this.logInfo;
    }

    public BigDecimal getDiffTimeLong(long startDate, long endDate) {
        BigDecimal excuteTime = new BigDecimal(endDate - startDate).divide(new BigDecimal(1000));
        return excuteTime;
    }
}

