/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPDate;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPDateManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.FactoryCalendarDateHelperTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.FactoryCalendarTableDefine;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class PMRPCalculateDateRange
extends PMRPStep
implements IConfigurableStep {
    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        IPMRPTableDefine tableDefine = runParam.getTableManager().getTempTableDefine(FactoryCalendarDateHelperTableDefine.class);
        tableDefine.createTable(runParam.getEasCtx());
        String sql = "INSERT INTO " + tableDefine.getTableName() + "(" + tableDefine.getTableCols() + ")";
        sql = sql + "VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Set<String> prodOrgs = runParam.getUtilManager().getProductOrgs();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        PMRPDateManager manager = runParam.getDateManager();
        for (String productStorageOrgUnitID : prodOrgs) {
            HashMap<String, Object> has;
            try {
                has = this.calcFactoryDate(productStorageOrgUnitID);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new PMRPException(PMRPException.FACTORYCALENDAR_ERROR, e);
            }
            this.setMRPDate_DQ_OutLook(productStorageOrgUnitID, has);
            this.setMRPBeginDate(productStorageOrgUnitID, has);
            this.setMRPEndDate(productStorageOrgUnitID, has);
            this.getCalendarTable(productStorageOrgUnitID);
            paramsList.add(new Object[]{productStorageOrgUnitID, new Timestamp(manager.getPlanDate(productStorageOrgUnitID).getDate().getTime().getTime()), new Timestamp(manager.getBeginDate(productStorageOrgUnitID).getDate().getTime().getTime()), new Timestamp(manager.getEndDate(productStorageOrgUnitID).getDate().getTime().getTime()), new Timestamp(manager.getBeginDate4Require(productStorageOrgUnitID).getDate().getTime().getTime()), new Timestamp(manager.getBeginDate4Supply(productStorageOrgUnitID).getDate().getTime().getTime()), new Timestamp(manager.getBeginDateRequire(productStorageOrgUnitID).getDate().getTime().getTime()), new Timestamp(manager.getBeginDateSupply(productStorageOrgUnitID).getDate().getTime().getTime()), new Timestamp(manager.getEndDateOutLook(productStorageOrgUnitID).getDate().getTime().getTime())});
        }
        DbUtil.executeBatch((Context)runParam.getEasCtx(), (String)sql, paramsList);
        return null;
    }

    protected HashMap<String, Object> calcFactoryDate(String productStorageOrgUnitID) throws BOSException, PMRPException, SQLException {
        PMRPRunLogInfo runLog = this.runParam.getRunLog();
        Context ctx = this.runParam.getEasCtx();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.runParam.getDateManager().getPlanDate(productStorageOrgUnitID).getDate().getTime());
        cal.add(5, Integer.parseInt(runLog.getPlanDefined().getPlanOutlook()) - 1);
        java.util.Date endDate = cal.getTime();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        cal.add(5, 1);
        java.util.Date toDate = cal.getTime();
        String toTime = df.format(toDate);
        StringBuilder strSql = new StringBuilder();
        strSql.append("select ce.fworkdate, ce.fid, ce.FWorkDateSeq from T_MM_FactoryCalendar c ");
        strSql.append("inner join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid where ce.FDateType=1 and c.fstorageorgunitid='");
        strSql.append(productStorageOrgUnitID);
        strSql.append("' and c.FIsDefault = 1 ");
        strSql.append("and ce.fworkdate<{d'");
        strSql.append(toTime);
        strSql.append("'} ");
        strSql.append("order by ce.fworkdate");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        Date initDate = null;
        String startDateId = null;
        int startDateSeq = 0;
        if (!rs.next()) {
            throw new PMRPException(PMRPException.FACTORYCALENDAR_ERROR);
        }
        initDate = rs.getDate("fWorkDate");
        startDateId = rs.getString("fid");
        startDateSeq = rs.getInt("FWorkDateSeq");
        HashMap<String, Object> has = new HashMap<String, Object>();
        has.put("StartDate", initDate);
        has.put("StartDateID", startDateId);
        has.put("StartDateSeq", new Integer(startDateSeq));
        SQLUtils.cleanup((ResultSet)rs);
        strSql.setLength(0);
        strSql.append("select ce.fworkdate, ce.fid, ce.FWorkDateSeq from T_MM_FactoryCalendar c ");
        strSql.append("inner join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid where ce.FDateType=1 and c.fstorageorgunitid='");
        strSql.append(productStorageOrgUnitID);
        strSql.append("' and c.FIsDefault = 1 ");
        strSql.append(" and ce.fworkdate<{d'");
        strSql.append(toTime);
        strSql.append("'}  ");
        strSql.append(" order by ce.fworkdate desc ");
        rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        String endDateId = null;
        int endDateSeq = 0;
        if (!rs.next()) {
            throw new PMRPException(PMRPException.FACTORYCALENDAR_ERROR);
        }
        endDate = rs.getDate("fWorkDate");
        endDateId = rs.getString("fid");
        endDateSeq = rs.getInt("FWorkDateSeq");
        has.put("EndDate", endDate);
        has.put("EndDateID", endDateId);
        has.put("EndDateSeq", new Integer(endDateSeq));
        SQLUtils.cleanup((ResultSet)rs);
        return has;
    }

    protected void setMRPBeginDate(String productStorageOrgUnitID, HashMap<String, Object> has) throws BOSException, PMRPException {
        this.setBeginDate4Require(productStorageOrgUnitID, has);
        this.setBeginDate4Supply(productStorageOrgUnitID, has);
        PMRPDateManager manager = this.runParam.getDateManager();
        if (manager.getBeginDate4Require(productStorageOrgUnitID).getWorkDaySeqID() <= manager.getBeginDate4Supply(productStorageOrgUnitID).getWorkDaySeqID()) {
            manager.setBeginDate(productStorageOrgUnitID, manager.getBeginDate4Require(productStorageOrgUnitID));
        } else {
            manager.setBeginDate(productStorageOrgUnitID, manager.getBeginDate4Supply(productStorageOrgUnitID));
        }
    }

    protected void setMRPEndDate(String productStorageOrgUnitID, HashMap<String, Object> has) {
        Calendar endDate = Calendar.getInstance();
        endDate.setTime((java.util.Date)has.get("EndDate"));
        PMRPDate endMRPDate = new PMRPDate();
        endMRPDate.setDate(endDate);
        endMRPDate.setCalendarID((String)has.get("EndDateID"));
        endMRPDate.setWorkDaySeqID((Integer)has.get("EndDateSeq"));
        this.runParam.getDateManager().setEndDate(productStorageOrgUnitID, endMRPDate);
    }

    protected void getCalendarTable(String productStorageOrgUnitID) throws PMRPException, BOSException {
        Context ctx = this.runParam.getEasCtx();
        IPMRPTableDefine tableDefine = this.runParam.getTableManager().getTempTableDefine(FactoryCalendarTableDefine.class);
        if (tableDefine.getTableName() == null) {
            tableDefine.createTable(ctx);
        }
        String tmpFCTable = tableDefine.getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(tmpFCTable).append("(FID,FRWorkDate,FRWorkDateSeq,FRWeekSeq,FRMonthSeq,").append("FSWorkDate,FSWorkDateSeq ,FSWeekSeq,FSMonthSeq,").append("FWorkDate,FWorkDateSeq ,FWeekSeq,FMonthSeq,").append("FNextWorkDaySeq,FPreWorkDaySeq,FRealDate, FStorageOrgUnitID)\r\n");
        sql.append("select e.FID,").append("e.FWorkDate ,e.FWorkDateSeq,e.FWeekSeq,e.FMonthSeq,").append("e.FWorkDate ,e.FWorkDateSeq,e.FWeekSeq,e.FMonthSeq,").append("e.FWorkDate ,e.FWorkDateSeq,e.FWeekSeq,e.FMonthSeq,").append("e.FNextWorkDaySeq,e.FPreWorkDaySeq,e.FWorkDate,").append("'").append(productStorageOrgUnitID).append("'").append(" from  T_MM_FactoryCalendarEntry e ").append(" inner join  T_MM_FactoryCalendar c on c.FID = e.FParentID").append(" where c.FStorageOrgUnitID='").append(productStorageOrgUnitID).append("' and c.fisdefault = 1 ");
        int execCount = MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
        if (execCount <= 0) {
            try {
                StorageOrgUnitInfo orgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(productStorageOrgUnitID));
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"QXWHKCZZXMUGZRL", (Locale)ctx.getLocale(), (Object[])new Object[]{orgUnitInfo.getNumber(), orgUnitInfo.getName()}));
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
        sql.setLength(0);
        sql.append("update ").append(tmpFCTable).append(" t ").append(" set (FRWorkDate,FRWorkDateSeq,FRWeekSeq,FRMonthSeq)").append(" = ( select top 1 t1.FWorkDate,t1.FWorkDateSeq ,t1.FWeekSeq,t1.FMonthSeq from ").append(tmpFCTable).append(" t1 ").append("  where t1.FWorkDateSeq = t.FPreWorkDaySeq  and t1.FStorageOrgUnitID='").append(productStorageOrgUnitID).append("')").append(" where t.FStorageOrgUnitID ='").append(productStorageOrgUnitID).append("' and t.FRWorkDateSeq <=0  and t.FPreWorkDaySeq>0 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tmpFCTable).append(" t ").append(" set (FRWorkDate,FRWorkDateSeq,FRWeekSeq,FRMonthSeq)").append(" = ( select top 1 t1.FWorkDate,t1.FWorkDateSeq ,t1.FWeekSeq,t1.FMonthSeq from ").append(tmpFCTable).append(" t1 ").append("  where t1.FWorkDateSeq = t.FNextWorkDaySeq ").append(" and  t1.FStorageOrgUnitID='").append(productStorageOrgUnitID).append("')").append(" where t.FStorageOrgUnitID ='").append(productStorageOrgUnitID).append("' and t.FRWorkDateSeq <=0  and t.FNextWorkDaySeq > 0 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tmpFCTable).append(" t ").append(" set (FSWorkDate,FSWorkDateSeq,FSWeekSeq,FSMonthSeq)").append(" = ( select top 1 t1.FWorkDate,t1.FWorkDateSeq ,t1.FWeekSeq,t1.FMonthSeq from ").append(tmpFCTable).append(" t1 ").append("  where t1.FWorkDateSeq = t.FNextWorkDaySeq ").append(" and  t1.FStorageOrgUnitID='").append(productStorageOrgUnitID).append("')").append(" where t.FStorageOrgUnitID ='").append(productStorageOrgUnitID).append("' and t.FSWorkDateSeq <=0  and t.FNextWorkDaySeq>0 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
    }

    protected void setBeginDate4Require(String productStorageOrgUnitID, HashMap<String, Object> has) throws BOSException, PMRPException {
        PMRPDateManager manager = this.runParam.getDateManager();
        Calendar beginDate = Calendar.getInstance();
        PMRPDate beginMRPDate = new PMRPDate();
        beginDate.setTime((java.util.Date)has.get("StartDate"));
        beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
        beginMRPDate.setCalendarID((String)has.get("StartDateID"));
        beginMRPDate.setDate(beginDate);
        beginMRPDate.setPeriod(beginMRPDate.getWorkDaySeqID());
        manager.setBeginDate4Require(productStorageOrgUnitID, beginMRPDate);
    }

    protected void setBeginDate4Supply(String productStorageOrgUnitID, HashMap<String, Object> has) throws BOSException, PMRPException {
        PMRPDateManager manager = this.runParam.getDateManager();
        Calendar beginDate = Calendar.getInstance();
        PMRPDate beginMRPDate = new PMRPDate();
        beginDate.setTime((java.util.Date)has.get("StartDate"));
        beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
        beginMRPDate.setCalendarID((String)has.get("StartDateID"));
        beginMRPDate.setDate(beginDate);
        beginMRPDate.setPeriod(beginMRPDate.getWorkDaySeqID());
        manager.setBeginDate4Supply(productStorageOrgUnitID, beginMRPDate);
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_CALCDATERANGE");
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    protected void setMRPDate_DQ_OutLook(String productStorageOrgUnitID, HashMap<String, Object> has) throws BOSException, PMRPException {
        Calendar beginDateRequirecal;
        PMRPDateManager manager = this.runParam.getDateManager();
        PMRPRunLogInfo PMRPRunLogInfo2 = this.runParam.getRunLog();
        if (PMRPRunLogInfo2 == null) {
            return;
        }
        PlanDefinedInfo planDefinedInfo = PMRPRunLogInfo2.getPlanDefined();
        if (planDefinedInfo == null) {
            return;
        }
        String planOutLook = planDefinedInfo.getPlanOutlook();
        int dpRequire = planDefinedInfo.getDpRequire();
        int dpSupply = planDefinedInfo.getDpSupply();
        Calendar planBegincal = Calendar.getInstance();
        planBegincal.setTime(this.runParam.getDateManager().getPlanDate(productStorageOrgUnitID).getDate().getTime());
        if (planOutLook == null) {
            planOutLook = "0";
        }
        planBegincal.add(5, Integer.parseInt(planOutLook));
        PMRPDate endDateOutLook = new PMRPDate();
        endDateOutLook.setDate(planBegincal);
        manager.setEndDateOutLook(productStorageOrgUnitID, endDateOutLook);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Date beginTime2001 = null;
        try {
            beginTime2001 = sdf.parse("2001-01-01 00:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new PMRPException(PMRPException.STRINGTODATE, e);
        }
        PMRPDate beginDateRequire = new PMRPDate();
        beginDateRequire.setDate(null);
        if (dpRequire == 0) {
            beginDateRequire = manager.getPlanDate(productStorageOrgUnitID);
        } else if (dpRequire > 0) {
            beginDateRequirecal = Calendar.getInstance();
            beginDateRequirecal.setTime(manager.getPlanDate(productStorageOrgUnitID).getDate().getTime());
            beginDateRequirecal.add(5, dpRequire * -1);
            beginDateRequire.setDate(beginDateRequirecal);
        } else {
            beginDateRequirecal = Calendar.getInstance();
            beginDateRequirecal.setTime(beginTime2001);
            beginDateRequire.setDate(beginDateRequirecal);
        }
        manager.setBeginDateRequire(productStorageOrgUnitID, beginDateRequire);
        PMRPDate beginDateSupply = new PMRPDate();
        beginDateSupply.setDate(null);
        if (dpSupply == 0) {
            beginDateSupply = manager.getPlanDate(productStorageOrgUnitID);
        } else if (dpSupply > 0) {
            Calendar beginDateSupplycal = Calendar.getInstance();
            beginDateSupplycal.setTime(manager.getPlanDate(productStorageOrgUnitID).getDate().getTime());
            beginDateSupplycal.add(5, dpSupply * -1);
            beginDateSupply.setDate(beginDateSupplycal);
        } else {
            Calendar beginDateSupplycal = Calendar.getInstance();
            beginDateSupplycal.setTime(beginTime2001);
            beginDateSupply.setDate(beginDateSupplycal);
        }
        manager.setBeginDateSupply(productStorageOrgUnitID, beginDateSupply);
    }
}

