/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.industry.emm.project.biz.basedata.BOMTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.basedata.CalculateProp;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.require.GetBomPurRequestRequire;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.require.GetOutSourcingMarketingFittingRollingPlanRequire;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.require.GetProjectCollaborationPlanRequire;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.require.GetSelfProductMarketingFittingRollingPlanRequire;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.require.GetStandarPurDemOrderRequire;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.IndependentRequireTableDefine;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PMRPGetIndependentRequirementData
extends PMRPStep
implements IConfigurableStep {
    private List<PMRPStep> subSteps;

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "GET_INDEPENDENTREQUIRE");
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        List<? extends PMRPStep> steps = this.getSubSteps();
        for (PMRPStep pMRPStep : steps) {
            pMRPStep.execute(runParam);
            this.dataAmount += pMRPStep.getDataAmount();
        }
        if (this.dataAmount > 0) {
            this.updateIndependSuppOrgUnit(runParam);
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE ").append(runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class).getTableName()).append("\r\n");
            sql.append("WHERE FMaterialAttr = 10020");
            this.dataAmount -= MRPUtil.executeUpdate((Context)runParam.getEasCtx(), (String)sql.toString());
        }
        return null;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public List<? extends PMRPStep> getSubSteps() {
        if (this.subSteps != null) {
            return this.subSteps;
        }
        this.subSteps = new ArrayList<PMRPStep>();
        CalculateProp cProp = this.runParam.getRunLog().getPlanDefined().getCalculateProp();
        if (CalculateProp.SelfProduct.equals((Object)cProp)) {
            this.subSteps.add(new GetProjectCollaborationPlanRequire());
            this.subSteps.add(new GetSelfProductMarketingFittingRollingPlanRequire());
        } else if (CalculateProp.OutSourcing.equals((Object)cProp)) {
            this.subSteps.add(new GetBomPurRequestRequire());
            this.subSteps.add(new GetOutSourcingMarketingFittingRollingPlanRequire());
            this.subSteps.add(new GetStandarPurDemOrderRequire());
        } else {
            this.subSteps.add(new GetProjectCollaborationPlanRequire());
            this.subSteps.add(new GetSelfProductMarketingFittingRollingPlanRequire());
            this.subSteps.add(new GetOutSourcingMarketingFittingRollingPlanRequire());
            this.subSteps.add(new GetStandarPurDemOrderRequire());
        }
        return this.subSteps;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    protected void updateIndependSuppOrgUnit(PMRPCalcParam runParam) throws BOSException, PMRPException {
        IPMRPTableDefine irt = runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class);
        if (irt.getTableName() == null) {
            return;
        }
        Context ctx = runParam.getEasCtx();
        PlanDefinedInfo pdInfo = runParam.getRunLog().getPlanDefined();
        PurRelationshipDefinitionInfo info = pdInfo.getPurchaseRelation();
        BOMTypeEnum bomType = pdInfo.getBomType();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" update ").append(irt.getTableName()).append(" t1 \r\n");
        sql.append(" Set FOrgUnitID = FSupplyOrgUnitID ");
        sql.append(" Where t1.FOrgUnitID Is Null");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
    }

    protected void updateIndependMaterialAttr(PMRPCalcParam runParam) throws BOSException, PMRPException {
        IPMRPTableDefine irt = runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class);
        if (irt.getTableName() == null) {
            return;
        }
        Context ctx = runParam.getEasCtx();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(irt.getTableName()).append(" t1 ");
        sql.append(" Set FMaterialAttr = (Select FMaterialAttr from t_bd_materialplan t2 where t2.fmaterialid = t1.FMaterialID and t2.forgunit = t1.fsupplyorgunitid  ) ");
        sql.append(" Where FMaterialAttr = -1 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
    }

    private void checkIndependentMaterialBOMOrgUnit(PMRPCalcParam runParam) throws BOSException, SQLException, PMRPException {
        PlanDefinedInfo pdInfo = runParam.getRunLog().getPlanDefined();
        PurRelationshipDefinitionInfo info = pdInfo.getPurchaseRelation();
        StringBuilder sb = new StringBuilder();
        StringBuilder errorstr = new StringBuilder();
        sb.append("SELECT DISTINCT m.fnumber as fmaterialNumber  ");
        sb.append(",m.fname_l2 as fmaterialname  ");
        sb.append(",isnull(pj.fname_l2,'null') as fprojectname  ");
        sb.append(",isnull(t.fnumber,'null') as ftrackNumber FROM ");
        sb.append(runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class).getTableName());
        sb.append(" t1 ");
        sb.append(" left outer join t_bd_material m on m.fid = t1.FMaterialID");
        sb.append(" left outer join t_mm_project pj on pj.fid = t1.FProjectID");
        sb.append(" left outer join t_mm_trackNumber t on t.fid = t1.FTrackNumberID");
        sb.append(" WHERE t1.FSupplyOrgUnitID IS NULL");
        sb.append(" And t1.FBosType = 'CFFE2CB6' ");
        if (pdInfo.getBomType().equals((Object)BOMTypeEnum.ProcessBOM)) {
            sb.append(" and ( Select count(distinct bom.cfstorageorgunitid) from ct_zjb_processbombill bom \r\n");
            sb.append(" left outer join t_mm_tracknumber bt on bt.fid = bom.cfbegincarnoid \r\n");
            sb.append(" left outer join t_mm_tracknumber et on et.fid = bom.cfendcarnoid \r\n");
            sb.append(" where bom.cfparentid = t1.FMaterialID \r\n");
            sb.append(" and isnull(bom.cfprojectid,'*') = isnull(t1.FProjectID,'*') \r\n");
            sb.append(" and isnull(bt.fnumber,'*') <= isnull(t1.FTrackNumber,'*') \r\n");
            sb.append(" and isnull(et.fnumber,'*') >= isnull(t1.FTrackNumber,'*') \r\n");
            sb.append(" and bom.cfstate = 4 \r\n");
            sb.append(" and bom.cfration > 0 \r\n");
            sb.append(" and bom.cfstorageorgunitid in(Select a.cfproductorgunitid from CT_BAS_PurRDE a where a.fparentid = '").append(info.getId()).append("' \r\n");
            sb.append(" union Select a.cfcensupplyorgunit from CT_BAS_PurRDE a where a.fparentid = '").append(info.getId()).append("')) ");
            sb.append("  > 1 ");
        } else {
            sb.append(" and ( Select count(distinct bom.fstorageorgunitid) from t_mm_bom bom \r\n");
            sb.append(" inner join t_mm_bomentry bomentry on bomentry.fparentid = bom.fid \r\n");
            sb.append(" left outer join t_mm_tracknumber bt on bt.fid = bomentry.fbegincarnoid \r\n");
            sb.append(" left outer join t_mm_tracknumber et on et.fid = bomentry.fendcarnoid \r\n");
            sb.append(" where bom.fmaterialid = t1.FMaterialID \r\n");
            sb.append(" and isnull(bom.fprojectid,'*') = isnull(t1.FProjectID,'*') \r\n");
            sb.append(" and isnull(bt.fnumber,'*') <= isnull(t1.FTrackNumber,'*') \r\n");
            sb.append(" and isnull(et.fnumber,'*') >= isnull(t1.FTrackNumber,'*') \r\n");
            sb.append(" and bom.fbasestatus = 4 \r\n");
            sb.append(" and bomentry.fconsumefixqty > 0 \r\n");
            sb.append(" and bom.fstorageorgunitid in(Select a.cfproductorgunitid from CT_BAS_PurRDE a where a.fparentid = '").append(info.getId()).append("' \r\n");
            sb.append(" union Select a.cfcensupplyorgunit from CT_BAS_PurRDE a where a.fparentid = '").append(info.getId()).append("')) ");
            sb.append("  > 1 ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sb.toString());
        while (rs.next()) {
            if (errorstr == null || errorstr.length() < 1) {
                if (pdInfo.getBomType().equals((Object)BOMTypeEnum.ProcessBOM)) {
                    errorstr.append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0130"));
                } else {
                    errorstr.append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0131"));
                }
            }
            errorstr.append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0106")).append(" :[" + rs.getString("fmaterialNumber") + "] " + rs.getString("fmaterialname"));
            errorstr.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0107")).append("[" + rs.getString("fprojectname") + "]");
            errorstr.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0108")).append("[" + rs.getString("ftrackNumber") + "]\r\n");
        }
        if (errorstr.length() > 0) {
            logger.info((Object)(" materialbom Data check,err result = " + errorstr));
            PMRPException exp = new PMRPException(new NumericExceptionSubItem("", errorstr.toString()));
            throw exp;
        }
    }

    private static void checkMaterialPlan(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlerrtext = new StringBuilder();
        sql.append("SELECT DISTINCT ");
        sql.append(" m.fnumber as fmaterialNumber");
        sql.append(" ,m.fname_l2 as fmaterialName");
        sql.append(" ,mpc.fnumber as fpurchaseUnitNumber");
        sql.append(" ,mpc.fname_l2 as fpurchaseUnitName");
        sql.append(" ,ms.fnumber as fStorageOrgUnitNumber");
        sql.append(" ,ms.fname_l2 as fStorageOrgUnitame");
        sql.append(" ,mp.fid as fmpid");
        sql.append(" ,mp.fstatus as fmpstatus");
        sql.append(" ,a.FMaterialAttr as FMaterialAttr");
        sql.append(" FROM ");
        sql.append(runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class).getTableName());
        sql.append(" a left outer join t_bd_material m on m.fid = a.FMaterialID ");
        sql.append(" left outer join t_org_purchase mpc on mpc.fid = a.FPurChaseOrgUnitID ");
        sql.append(" left outer join t_org_storage ms on ms.fid = a.FSupplyOrgUnitID ");
        sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = m.fid and mp.Forgunit = a.FSupplyOrgUnitID ");
        sql.append(" where (a.FSupplyOrgUnitID is null or ");
        sql.append(" mp.fid is null or ");
        sql.append(" mp.fstatus <> 1 )");
        sql.append(" and a.FMRPItem<>").append(110);
        sql.append(" and a.FMRPItem<>").append(120);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString());
        logger.info((Object)(" materialPlan Data check,data rows = " + rs.size()));
        try {
            while (rs.next()) {
                String fmaterialNumber = rs.getString("fmaterialNumber");
                String fmaterialName = rs.getString("fmaterialName");
                String fpurchaseUnitNumber = rs.getString("fpurchaseUnitNumber");
                String fpurchaseUnitName = rs.getString("fpurchaseUnitName");
                String fStorageOrgUnitNumber = rs.getString("fStorageOrgUnitNumber");
                String fStorageOrgUnitame = rs.getString("fStorageOrgUnitame");
                String fmpid = rs.getString("fmpid");
                String fmpstatus = rs.getString("fmpstatus");
                if (sqlerrtext == null || sqlerrtext.length() < 1) {
                    sqlerrtext.append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                } else {
                    sqlerrtext.append("\r\n").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                }
                if (fStorageOrgUnitNumber == null || "".equals(fStorageOrgUnitNumber)) {
                    if (fpurchaseUnitNumber != null && !"".equals(fpurchaseUnitNumber)) {
                        sqlerrtext.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0126")).append("[" + fpurchaseUnitNumber + "]" + fpurchaseUnitName + "");
                    }
                    sqlerrtext.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0127"));
                    continue;
                }
                if (fmpid == null || "".equals(fmpid)) {
                    sqlerrtext.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                    sqlerrtext.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0100"));
                    continue;
                }
                if (fmpstatus != null && "1".equals(fmpstatus)) continue;
                sqlerrtext.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                sqlerrtext.append(",").append(PMRPGetIndependentRequirementData.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0101"));
            }
            if (sqlerrtext != null && sqlerrtext.length() > 0) {
                logger.info((Object)(" materialPlan Data check,err result = " + sqlerrtext));
                PMRPException exp = new PMRPException(new NumericExceptionSubItem("", sqlerrtext.toString()));
                throw exp;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

