/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.InventoryDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrpex.mrpExUtil;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class PMRPGetMaterialOnHand
extends PMRPStep
implements IConfigurableStep {
    private int level = -1;

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_GETMATERIALONHAND");
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        Context ctx = runParam.getEasCtx();
        PMRPRunTableManager manager = runParam.getTableManager();
        IPMRPTableDefine tableDefine = manager.getTempTableDefine(InventoryDetailTableDefine.class);
        String tableName = tableDefine.createTable(ctx).getTableName();
        StringBuffer sql = new StringBuffer();
        String def_ProjectID = "'EgkAAABc3Xza3gXu'";
        String def_TrackID = "'EgkAAABc3X0Ibpg9'";
        String def_LocationID = "'EgkAAABc3XMgX/hq'";
        String def_WarehouseID = "'EgkAAABc3XG76fiu'";
        sql.append("insert into ").append(tableName).append("(FID,FMaterialID,FStorageOrgUnitID,FBaseQty,FProjectID,FTrackID,FProjectNumber,FTrackNumber,FLowsetCode,FWAREHOUSEID,FLOCATIONID,FSTORETYPEID,FSTORESTATUSID)").append("\r\n").append("Select newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("'),").append("inv.FMaterialID,inv.fstorageorgunitid,sum(inv.FBaseQty) as FBaseQty,").append("case when inv.FProjectID = ").append(def_ProjectID).append(" then null else TO_CHAR(inv.FProjectID) end,").append("case when inv.FTrackNumberID = ").append(def_TrackID).append(" then null else TO_CHAR(inv.FTrackNumberID) end,").append("case when inv.FProjectID = ").append(def_ProjectID).append(" then null else TO_CHAR(P.FNumber) end,").append("case when inv.FTrackNumberID = ").append(def_TrackID).append(" then null else TO_CHAR(T.FNumber) end,").append(this.level).append(",").append("case when inv.FWAREHOUSEID = ").append(def_WarehouseID).append(" then Null else TO_CHAR(inv.FWAREHOUSEID) end,").append("case when inv.FLOCATIONID = ").append(def_LocationID).append(" then Null else TO_CHAR(inv.FLOCATIONID) end,").append("inv.FSTORETYPEID,").append("inv.FSTORESTATUSID");
        sql.append(this.getFromPart(true));
        sql.append(this.getWherePart(true));
        sql.append("group by inv.FMaterialID,inv.fstorageorgunitid,inv.FProjectID,inv.FTrackNumberID,P.FNumber,T.FNumber,inv.FWAREHOUSEID,inv.FLOCATIONID,inv.FSTORETYPEID,inv.FSTORESTATUSID");
        this.dataAmount += MRPUtil.executeUpdate((Context)ctx, (String)sql.toString()) + this.dataAmount;
        PMRPGetMaterialOnHand.checkMaterialPlan(runParam, tableName);
        mrpExUtil.dealInvXTChangeQty(runParam, tableName);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("Insert Into ").append(manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName()).append("(FID,FPlanVersionID,FRunLogID,FMRPClassify,FMRPItem,FMaterialID,FAvaliable,").append("FProjectID,FTrackID,FProjectNumber,FTrackNumber,").append("FBProjectNumber,FBTrackNumber,FIsDefaultTNO").append(",FPeriod").append(",FBILLDATE").append(",FMrpSeq,FOrgUnitID,FSupplyOrgUnitID,").append(mrpExUtil.insertCalDetailTableExFields()).append(" FMaterialAttr )").append("\r\n");
        insertSql.append(" select newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("'),").append("'").append(runParam.getRunLog().getPlanDefined().getId()).append("',").append("'").append(runParam.getRunLog().getId()).append("',").append(10).append(",").append(110).append(",").append("mm.FMaterialId,Sum(mm.FBaseQty) As FBaseQty,mm.FProjectID,mm.FTrackID,mm.FProjectNumber,mm.FTrackNumber,mm.FProjectNumber,mm.FTrackNumber,").append(2).append(" ,").append(runParam.getDateManager().getPlanDate(runParam.getStorageOrgUnitID()).getPeriod()).append(",").append(" TO_DATE('").append(new SimpleDateFormat("yyyy-MM-dd").format(runParam.getDateManager().getPlanDate(runParam.getStorageOrgUnitID()).getDate().getTime())).append("'), ").append("'").append(MRPSeqUtil.INV_SEQ).append("',").append("mm.FStorageOrgUnitID,mm.FStorageOrgUnitID,").append(mrpExUtil.insertInventoryDetailTableDefineExFields()).append(" mp.fmaterialattr").append(" from ").append(tableName).append(" mm  ").append(" left outer join t_bd_materialplan mp on mp.fmaterialid = mm.FMaterialId and mp.forgunit = mm.FStorageOrgUnitID  ").append(" where 1=1 ").append(" Group By mm.FMaterialId,mm.FProjectID,mm.FTrackID,mm.FProjectNumber,mm.FTrackNumber,mm.FStorageOrgUnitID,mp.fmaterialattr");
        MRPUtil.executeUpdate((Context)ctx, (String)insertSql.toString());
        return null;
    }

    protected StringBuffer getFromPart(boolean isolation) {
        StringBuffer sqlFromPart = new StringBuffer();
        sqlFromPart.append("\r\n").append(" from T_IM_Inventory inv ");
        sqlFromPart.append(" left join t_db_warehouse w on inv.Fwarehouseid = w.FID").append("\r\n").append(" ");
        if (isolation) {
            sqlFromPart.append(" Left join T_MM_TrackNumber T on inv.FTrackNumberID = T.FID").append("\r\n").append(" Left join T_MM_Project P on inv.FProjectID = P.FID");
        }
        return sqlFromPart;
    }

    protected StringBuffer getWherePart(boolean isolation) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        PMRPRunTableManager manager = this.runParam.getTableManager();
        PlanDefinedInfo pdInfo = this.runParam.getRunLog().getPlanDefined();
        SupplyRelationshipDefinitionInfo info = pdInfo.getSupplyRelation();
        sql.append(" where  exists (");
        sql.append(" select 1 from t_bd_materialplan mp where mp.fmaterialid=inv.FMaterialID and inv.fstorageorgunitid=mp.forgunit  and mp.fstatus = 1 ");
        sql.append(this.runParam.getMaterialWhereSql("mp"));
        sql.append(" ) ");
        sql.append(" and inv.FBaseQty > 0 ");
        sql.append(" and inv.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5'");
        if (info.getWsRange() == 1) {
            sql.append(" and inv.Fwarehouseid in(select Fwarehouseid from T_BAS_SupplyRDWE where fparentid = '").append(info.getId()).append("' ) ");
        } else if (info.getWsRange() == 2) {
            sql.append(" and inv.Fwarehouseid not in(select Fwarehouseid from T_BAS_SupplyRDWE where fparentid = '").append(info.getId()).append("' ) ");
        }
        sql.append(" and Exists(Select 1 from CT_BAS_SupplyRDE s where s.FParentID='").append(info.getId()).append("' ");
        sql.append(" and inv.fstorageorgunitid = s.Cfsupplyorgunitid  ");
        sql.append(" and inv.fwarehouseid = Isnull(s.Cfwarehouseid,inv.fwarehouseid) ");
        sql.append(" and Isnull(inv.flocationid,'EgkAAABc3XMgX/hq') = Isnull(s.Cflocationid,Isnull(inv.flocationid,'EgkAAABc3XMgX/hq')) ");
        sql.append(" ) ");
        return sql;
    }

    protected void groupByPart(StringBuffer sql, boolean isolation) {
        sql.append(" group by inv.FMaterialID,inv.FStorageorgunitid");
        if (isolation) {
            sql.append(",inv.FProjectID,inv.FTrackNumberID,P.FNumber,T.FNumber");
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    private static void checkMaterialPlan(PMRPCalcParam runParam, String tableName) throws BOSException, PMRPException {
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlerrtext = new StringBuilder();
        sql.append("SELECT DISTINCT ");
        sql.append(" m.fnumber as fmaterialNumber");
        sql.append(" ,m.fname_l2 as fmaterialName");
        sql.append(" ,ms.fnumber as fStorageOrgUnitNumber");
        sql.append(" ,ms.fname_l2 as fStorageOrgUnitame");
        sql.append(" ,mp.fid as fmpid");
        sql.append(" ,mp.fstatus as fmpstatus");
        sql.append(" FROM ");
        sql.append(tableName);
        sql.append(" a left outer join t_bd_material m on m.fid = a.FMaterialID ");
        sql.append(" left outer join t_org_storage ms on ms.fid = a.FStorageOrgUnitID ");
        sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = m.fid and mp.Forgunit = a.FStorageOrgUnitID ");
        sql.append(" where (");
        sql.append(" mp.fid is null or ");
        sql.append(" mp.fstatus <> 1 )");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString());
        logger.info((Object)(" materialPlan Data check,data rows = " + rs.size()));
        try {
            while (rs.next()) {
                String fmaterialNumber = rs.getString("fmaterialNumber");
                String fmaterialName = rs.getString("fmaterialName");
                String fStorageOrgUnitNumber = rs.getString("fStorageOrgUnitNumber");
                String fStorageOrgUnitame = rs.getString("fStorageOrgUnitame");
                String fmpid = rs.getString("fmpid");
                String fmpstatus = rs.getString("fmpstatus");
                if (sqlerrtext == null || sqlerrtext.length() < 1) {
                    sqlerrtext.append(PMRPGetMaterialOnHand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                } else {
                    sqlerrtext.append("\r\n").append(PMRPGetMaterialOnHand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                }
                if (fmpid == null || "".equals(fmpid)) {
                    sqlerrtext.append(",").append(PMRPGetMaterialOnHand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0088") + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                    sqlerrtext.append(",").append(PMRPGetMaterialOnHand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0100"));
                    continue;
                }
                if (fmpstatus != null && "1".equals(fmpstatus)) continue;
                sqlerrtext.append(",").append(PMRPGetMaterialOnHand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                sqlerrtext.append(",").append(PMRPGetMaterialOnHand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0101"));
            }
            if (sqlerrtext != null && sqlerrtext.length() > 0) {
                logger.info((Object)(" materialPlan Data check,err result = " + sqlerrtext));
                PMRPException exp = new PMRPException(new NumericExceptionSubItem("", sqlerrtext.toString()));
                throw exp;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

