/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.IndependentRequireTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.MaterialDetailTableDefine;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PMRPGetMaterials
extends PMRPStep
implements IConfigurableStep {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPGetAllMaterials");

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_GETALLMATERIAL");
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        StringBuffer sql_getAllMaterials = new StringBuffer();
        sql_getAllMaterials.setLength(0);
        sql_getAllMaterials.append(this.getInsertPart(runParam));
        sql_getAllMaterials.append(this.getSelectPart(runParam));
        sql_getAllMaterials.append(this.getFromPart(runParam));
        sql_getAllMaterials.append(this.getWherePart());
        this.dataAmount += MRPUtil.executeUpdate((Context)runParam.getEasCtx(), (String)sql_getAllMaterials.toString());
        runParam.getCounter().setMaterialCalcCount(this.dataAmount);
        return null;
    }

    protected StringBuffer getInsertPart(PMRPCalcParam runParam) {
        StringBuffer sql = new StringBuffer();
        IPMRPTableDefine tableDefine = runParam.getTableManager().getTempTableDefine(MaterialDetailTableDefine.class);
        sql.append("insert into ").append(tableDefine.getTableName());
        sql.append(" ( ").append("\r\n");
        sql.append(tableDefine.getTableCols()).append(")");
        return sql;
    }

    protected StringBuffer getSelectPart(PMRPCalcParam runParam) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append("newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("')").append(",'").append(runParam.getRunLog().getPlanDefined().getId()).append("'").append(",'").append(runParam.getRunLog().getId()).append("'");
        sql.append(",id,number,bu from (select ").append(" m.FID as id").append(",m.FNumber as number").append(",m.FBaseUnit as bu");
        return sql;
    }

    protected StringBuffer getFromPart(PMRPCalcParam runParam) {
        StringBuffer sql = new StringBuffer();
        String tblName = runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class).getTableName();
        sql.append(" From t_bd_material m ");
        sql.append(" inner join ").append(tblName).append(" ir on ir.fmaterialID=m.fid");
        sql.append(" left join t_bd_materialplan mp on ir.fsupplyorgunitid=mp.forgunit and mp.fmaterialid=m.fid");
        return sql;
    }

    protected StringBuffer getWherePart() {
        String llcTbl = this.runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append(" where ").append("\r\n");
        sql.append(" m.FStatus<>2 and m.FStatus<>3 ").append("\r\n");
        sql.append(" And Exists(Select 1 From ").append(llcTbl).append(" lc  Where m.FID = lc.CFMaterialID )  ");
        sql.append(")");
        return sql;
    }

    @Override
    public int getDataAmount() {
        return this.dataAmount;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }
}

