/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPStepStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPDate;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;

public class PMRPRunCrush
extends PMRPStep {
    private Exception crushDownException;

    public PMRPRunCrush(Exception crushDownException) {
        this.crushDownException = crushDownException;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_RUNCRUSH");
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        PMRPStepStatusEnum runLogStatus;
        String err;
        block3: {
            Throwable exception;
            PMRPException ex;
            block2: {
                runParam.getTableManager().printUsedTables();
                PMRPDate beginDate = runParam.getDateManager().getBeginDate(runParam.getStorageOrgUnitID());
                Date date = this.beginTime = beginDate == null ? new Date() : beginDate.getDate().getTime();
                if (runParam.getUtilManager().getPoUtil() != null) {
                    runParam.getUtilManager().getPoUtil().recycleNumbers();
                }
                err = this.getExceptionMsg(this.crushDownException);
                runLogStatus = PMRPStepStatusEnum.ERROR_STOP;
                ex = null;
                exception = null;
                if (!(this.crushDownException instanceof PMRPException)) break block2;
                ex = (PMRPException)((Object)this.crushDownException);
                if (!PMRPException.STOP_MRP.getCode().equals(ex.getSubCode())) break block3;
                runLogStatus = PMRPStepStatusEnum.MANU_STOP;
                break block3;
            }
            for (exception = this.crushDownException.getCause(); exception != null; exception = exception.getCause()) {
                if (!(exception instanceof PMRPException)) continue;
                ex = (PMRPException)((Object)exception);
                if (!PMRPException.STOP_MRP.getCode().equals(ex.getSubCode())) break;
                runLogStatus = PMRPStepStatusEnum.MANU_STOP;
                break;
            }
        }
        this.updateStepLogError(err, runLogStatus);
        runParam.getTableManager().release(runParam, true, false);
        return null;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    private String getExceptionMsg(Throwable t) throws PMRPException, BOSException {
        if (t != null) {
            if (t instanceof PMRPException || t instanceof BomException || t instanceof CodingRuleException || t instanceof EASBizException) {
                return t.getMessage();
            }
            if (t instanceof SQLException) {
                SQLException sqlExp = (SQLException)t;
                Exception exp = JDBCExceptionHandler.convertException((SQLException)sqlExp);
                if (exp instanceof DataLimitExceedException) {
                    return PMRPResource.getString(this.runParam.getEasCtx().getLocale(), "RUNDATA_OUTOFRANG");
                }
                String errMsg = sqlExp.getMessage();
                int index = errMsg.indexOf("source sql is :");
                if (index > 0) {
                    errMsg = errMsg.substring(index + 15);
                }
                return "SQL Error:" + errMsg;
            }
            if (t.getCause() != null) {
                return this.getExceptionMsg(t.getCause());
            }
        }
        return PMRPResource.getString(this.runParam.getEasCtx().getLocale(), "MRP_ERROR");
    }

    private void logTrace(Throwable t) {
        if (t != null && t.getStackTrace() != null) {
            StringBuffer msg = new StringBuffer();
            msg.append(t.getClass().toString() + " : " + t.getMessage()).append("\r\n");
            StackTraceElement[] elements = t.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                msg.append(elements[i].toString()).append("\r\n");
            }
            logger.info((Object)msg.toString());
            this.logTrace(t.getCause());
        }
    }

    @Override
    protected void logEnd() throws BOSException, PMRPException {
        super.logEnd();
        this.logTrace(this.crushDownException);
        String updateSql = "UPDATE T_MRP_PMRPRunLogEntry E0 set FSeq = (SELECT COUNT(1) FROM T_MRP_PMRPRunLogEntry E1 WHERE E1.FParentID = E0.FParentID AND E1.FSeq <= E0.FSeq ) WHERE FParentID = ?";
        SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)updateSql, (Object[])new Object[]{this.runParam.getRunLog().getId().toString()});
        updateSql = "update T_MRP_PMRPRunLog set FLastUpdateTime = ? where fid = ?";
        SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)updateSql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), this.runParam.getRunLog().getId().toString()});
    }

    private void updateStepLogError(String msg, PMRPStepStatusEnum runLogStatus) throws BOSException, PMRPException {
        if (msg != null && msg.length() > 1000) {
            msg = msg.substring(0, 999);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MRP_PMRPRunLogEntry set FStatus = ? where FID in ");
        sql.append("(select FID from T_MRP_PMRPRunLogEntry where FStatus = 40 and FParentID = ?)");
        MRPUtil.executeUpdate((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(runLogStatus.getValue()), this.runParam.getRunLog().getId().toString()});
        sql.setLength(0);
        sql.append("update T_MRP_PMRPRunLog set FStatus = ?, FLastUpdateTime = ? where FID = ? ");
        MRPUtil.executeUpdate((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(runLogStatus.getValue()), new Timestamp(System.currentTimeMillis()), this.runParam.getRunLog().getId().toString()});
    }
}

