/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.IPMRPRunLog;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPExceptionsEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunExceptionCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunExceptionFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPStepStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalendarUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPDate;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPDateManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPExceptionUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPPONumberUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.MaterialDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.PlanOrderEntryTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.PlanOrderTableDefine;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class PMRPRunStart
extends PMRPStep
implements IConfigurableStep {
    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        this.saveLog();
        this.adjustPlanDate();
        this.setMRPTableName();
        this.setMRPException();
        this.setMRPRuntimeParams();
        this.setDefaultTransType();
        this.setMRPPlanOrderTable();
        this.setAdditionalInfo();
        return runParam;
    }

    protected void setMRPTrack() throws BOSException, PMRPException {
    }

    protected void setMRPRuntimeParams() throws BOSException, PMRPException {
        IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getLocalInstance((Context)this.runParam.getEasCtx());
        try {
            this.runParam.setAdvanceType(calcFacade.getParamValueOfPlanAdjust(this.runParam.getStorageOrgUnitID()));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void setMRPException() throws BOSException, PMRPException {
        PMRPRunExceptionCollection collection;
        block6: {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("mrpRunExceptionGroup.number"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo storageItemInfo = new FilterItemInfo("storageOrgUnit.id", (Object)this.runParam.getStorageOrgUnitID(), CompareType.EQUALS);
            filter.getFilterItems().add(storageItemInfo);
            view.setFilter(filter);
            view.setSelector(sic);
            EntityViewInfo viewInfo = (EntityViewInfo)view.clone();
            collection = PMRPRunExceptionFactory.getLocalInstance(this.runParam.getEasCtx()).getPMRPRunExceptionCollection(viewInfo);
            if (collection != null && collection.size() != 0) break block6;
            Object[][] params = new Object[][]{{"5C3Wa1D0Q6mklCcYle5arZgW/Kw=", 1, 1, "10", "01"}, {"5C3Wa1D0Q6mklCcYle5arZgW/Kw=", 1, 2, "11", "02"}, {"dYvogG3dQ2q3v3rbs2gOcZgW/Kw=", 1, 3, "20", "03"}, {"dYvogG3dQ2q3v3rbs2gOcZgW/Kw=", 1, 4, "21", "04"}, {"eHwEVVpHQwmvFc7i+MQZG5gW/Kw=", 1, 5, "32", "05"}, {"eHwEVVpHQwmvFc7i+MQZG5gW/Kw=", 1, 6, "33", "06"}, {"pq9q8zCDTn+kbeehoXyq9JgW/Kw=", 2, 7, "40", "07"}, {"pq9q8zCDTn+kbeehoXyq9JgW/Kw=", 2, 8, "41", "08"}, {"7b3yjpEvS5yHEFab4qzvJJgW/Kw=", 2, 9, "60", "09"}, {"7b3yjpEvS5yHEFab4qzvJJgW/Kw=", 2, 10, "61", "10"}, {"7b3yjpEvS5yHEFab4qzvJJgW/Kw=", 2, 11, "62", "11"}, {"7b3yjpEvS5yHEFab4qzvJJgW/Kw=", 3, 12, "63", "12"}, {"7b3yjpEvS5yHEFab4qzvJJgW/Kw=", 2, 13, "64", "13"}, {"LILyVjzISQyP6e/v4ZugOJgW/Kw=", 3, 14, "70", "14"}};
            Connection conn = null;
            PreparedStatement pm = null;
            StringBuffer insertMRPRunExceSql = new StringBuffer("");
            insertMRPRunExceSql.append("insert into T_MRP_PMRPRunException (FStorageOrgUnitID,").append("FMrpRunExceptionGroupID,FColor,FPriority,FIsShow,FName_l2,FName_l3,FNumber,").append("FDescription_l2,FDescription_l3,FControlUnitID,FID,FSimpleName) ").append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            try {
                conn = EJBFactory.getConnection((Context)this.runParam.getEasCtx());
                pm = conn.prepareStatement(insertMRPRunExceSql.toString());
                String fid = null;
                CtrlUnitInfo cu = null;
                cu = ContextUtil.getCurrentCtrlUnit((Context)this.runParam.getEasCtx());
                String cuId = cu.getId().toString();
                for (int i = 0; i < params.length; ++i) {
                    fid = BOSUuid.create((String)"E38F8D93").toString();
                    PMRPExceptionsEnum e = PMRPExceptionsEnum.getEnum(Integer.parseInt((String)params[i][3]));
                    String el2 = e.getAlias(new Locale("L2"));
                    String el3 = e.getAlias(new Locale("L3"));
                    pm.setString(1, this.runParam.getStorageOrgUnitID());
                    pm.setString(2, (String)params[i][0]);
                    pm.setInt(3, (Integer)params[i][1]);
                    pm.setInt(4, (Integer)params[i][2]);
                    pm.setInt(5, 1);
                    pm.setString(6, el2);
                    pm.setString(7, el3);
                    pm.setString(8, (String)params[i][3]);
                    pm.setString(9, el2);
                    pm.setString(10, el3);
                    pm.setString(11, cuId);
                    pm.setString(12, fid);
                    pm.setString(13, (String)params[i][4]);
                    pm.execute();
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pm, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pm, (Connection)conn);
            collection = PMRPRunExceptionFactory.getLocalInstance(this.runParam.getEasCtx()).getPMRPRunExceptionCollection(viewInfo);
        }
        int size = collection.size();
        HashMap<String, Boolean> exception = new HashMap<String, Boolean>();
        for (int i = 0; i < size; ++i) {
            exception.put(collection.get(i).getNumber(), collection.get(i).isIsShow());
        }
        this.runParam.getUtilManager().setExceptions(exception);
        this.runParam.getUtilManager().setExceptionUtil(new PMRPExceptionUtil(collection));
    }

    protected void setMRPTableName() throws BOSException, PMRPException {
        Context ctx = this.runParam.getEasCtx();
        PMRPRunTableManager manager = this.runParam.getTableManager();
        PMRPRunLogInfo logValue = this.runParam.getRunLog();
        logValue.setMrpMaterialTbl(manager.getTempTableDefine(MaterialDetailTableDefine.class).createTable(ctx).getTableName());
        logValue.setMrpCalcDetailTbl(manager.getTempTableDefine(CalcDetailTableDefine.class).createTable(ctx).getTableName());
        IPMRPRunLog mrpRunLog = PMRPRunLogFactory.getLocalInstance(this.runParam.getEasCtx());
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("mrpMaterialTbl"));
        selectors.add(new SelectorItemInfo("mrpCalcDetailTbl"));
        try {
            mrpRunLog.updatePartial((CoreBaseInfo)logValue, selectors);
        }
        catch (EASBizException e) {
            throw new PMRPException(PMRPException.PARAM_ERROR, e);
        }
    }

    protected void setDefaultTransType() throws BOSException, PMRPException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)this.runParam.getStorageOrgUnitID()));
        items.add(new FilterItemInfo("bizType.id", (Object)"vGXRx5fFSsCYz9Zv7CzzgyQHQ1w="));
        items.add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        items.add(new FilterItemInfo("status", (Object)new Integer(20)));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        IProductTransactionType ptType = ProductTransactionTypeFactory.getLocalInstance((Context)this.runParam.getEasCtx());
        ProductTransactionTypeCollection prodCol = ptType.getProductTransactionTypeCollection(viewInfo);
        if (prodCol.size() > 0) {
            this.runParam.setProductTranTypeID(prodCol.get(0).getId().toString());
        }
    }

    protected void adjustPlanDate() throws PMRPException, BOSException {
        SupplyRelationshipDefinitionEntryCollection c = this.runParam.getSupplyModel();
        HashSet<String> orgs = new HashSet<String>();
        for (int i = 0; i < c.size(); ++i) {
            orgs.add(c.get(i).getProductOrgUnit().getId().toString());
            orgs.add(c.get(i).getSupplyOrgUnit().getId().toString());
        }
        for (String id : orgs) {
            this.adjustPlanDateImpl(id);
        }
        this.adjustPlanDateImpl(this.runParam.getStorageOrgUnitID());
    }

    protected void adjustPlanDateImpl(String productStorageOrgUnitID) throws PMRPException, BOSException {
        PMRPDate planDate;
        block9: {
            Calendar theDate = MRPUtil.createCalendar();
            theDate.setTime(this.runParam.getRunLog().getBizDate());
            theDate.set(11, 0);
            theDate.set(12, 0);
            theDate.set(13, 0);
            theDate.set(14, 0);
            planDate = new PMRPDate();
            int workDaySeqID = 0;
            StringBuffer sql = new StringBuffer();
            sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq, \r\n");
            sql.append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq,t0.fworkdate  \r\n");
            sql.append("from t_mm_factorycalendarentry t0 inner join t_mm_factorycalendar t1 on t0.fparentid = t1.fid \r\n");
            sql.append("where t1.FIsDefault = 1  \r\n");
            sql.append("and t0.fworkdate = to_date('").append(MRPUtil.dateToString((java.util.Date)theDate.getTime(), (String)"yyyy-MM-dd")).append("')");
            sql.append("and t1.fstorageorgunitid = ? ");
            IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{productStorageOrgUnitID});
            try {
                StorageOrgUnitInfo s;
                if (rs.next()) {
                    workDaySeqID = rs.getInt("fworkDateSeq");
                    Date workDate = rs.getDate("fworkdate");
                    if (workDaySeqID == 0) {
                        StorageOrgUnitInfo s2;
                        workDaySeqID = rs.getInt("FNextWorkDaySeq");
                        sql.setLength(0);
                        sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq \r\n");
                        sql.append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 \r\n");
                        sql.append("where t0.fparentid = t1.fid and t1.FIsDefault = 1  \r\n");
                        sql.append("and t0.fworkDateSeq = ? \r\n");
                        sql.append("and t1.fstorageorgunitid = ?");
                        rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), productStorageOrgUnitID});
                        if (rs.next()) {
                            rs.getDate("fworkdate", theDate);
                            planDate.setCalendarID(rs.getString("fid"));
                            planDate.setDate(theDate);
                            planDate.setWorkDaySeqID(workDaySeqID);
                            planDate.setPeriod(workDaySeqID);
                            planDate.setWeekSeqID(rs.getInt("fweekSeq"));
                            planDate.setMonthSeqID(rs.getInt("fmonthSeq"));
                            break block9;
                        }
                        try {
                            s2 = StorageOrgUnitFactory.getLocalInstance((Context)this.runParam.getEasCtx()).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(productStorageOrgUnitID));
                        }
                        catch (EASBizException e) {
                            throw new PMRPException(PMRPException.FACTORYCALENDAR_ERROR, e);
                        }
                        throw new PMRPException(new NumericExceptionSubItem("", this.getResourceString(this.runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0135") + "[" + s2.getName() + "(" + s2.getNumber() + ")]" + this.getResourceString(this.runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0136") + "[" + new SimpleDateFormat("yyyy-MM-dd").format(workDate) + "]" + this.getResourceString(this.runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0137")));
                    }
                    planDate.setCalendarID(rs.getString("fid"));
                    planDate.setDate(theDate);
                    planDate.setWorkDaySeqID(workDaySeqID);
                    planDate.setPeriod(workDaySeqID);
                    planDate.setWeekSeqID(rs.getInt("fweekSeq"));
                    planDate.setMonthSeqID(rs.getInt("fmonthSeq"));
                    break block9;
                }
                try {
                    s = StorageOrgUnitFactory.getLocalInstance((Context)this.runParam.getEasCtx()).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(productStorageOrgUnitID));
                }
                catch (EASBizException e) {
                    throw new PMRPException(PMRPException.FACTORYCALENDAR_ERROR, e);
                }
                throw new PMRPException(new NumericExceptionSubItem("", this.getResourceString(this.runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0135") + "[" + s.getName() + "(" + s.getNumber() + ")]" + this.getResourceString(this.runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0138")));
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        PMRPDateManager manager = this.runParam.getDateManager();
        manager.setPlanDate(productStorageOrgUnitID, planDate);
    }

    protected void saveLog() throws PMRPException, BOSException {
        IPMRPRunLog mrpRunLog = PMRPRunLogFactory.getLocalInstance(this.runParam.getEasCtx());
        PMRPRunLogInfo logValue = this.runParam.getRunLog();
        logValue.setPercent(0);
        logValue.setCreateTime(new Timestamp(System.currentTimeMillis()));
        logValue.setStatus(PMRPStepStatusEnum.RUNNING);
        logValue.setDescription(PMRPResource.getString(this.runParam.getEasCtx().getLocale(), "SP_START"));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("status"));
        selectors.add(new SelectorItemInfo("description"));
        selectors.add(new SelectorItemInfo("percent"));
        selectors.add(new SelectorItemInfo("createTime"));
        try {
            mrpRunLog.updatePartial((CoreBaseInfo)logValue, selectors);
        }
        catch (EASBizException e) {
            throw new PMRPException(PMRPException.PARAM_ERROR, e);
        }
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_START");
    }

    protected void setMRPPlanOrderTable() throws BOSException, PMRPException {
        Context ctx = this.runParam.getEasCtx();
        PMRPRunTableManager manager = this.runParam.getTableManager();
        manager.getTempTableDefine(PlanOrderTableDefine.class).createTable(ctx);
        manager.getTempTableDefine(PlanOrderEntryTableDefine.class).createTable(ctx);
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    protected void setAdditionalInfo() throws PMRPException, BOSException {
        SupplyRelationshipDefinitionEntryCollection c = this.runParam.getSupplyModel();
        HashSet<String> orgs = new HashSet<String>();
        this.runParam.setProductOrgUnitIDStr(null);
        String ProductOrgUnitIDStr = "";
        for (int i = 0; i < c.size(); ++i) {
            orgs.add(c.get(i).getProductOrgUnit().getId().toString());
            orgs.add(c.get(i).getSupplyOrgUnit().getId().toString());
            ProductOrgUnitIDStr = i == 0 ? "'" + c.get(i).getProductOrgUnit().getId().toString() + "'" : ProductOrgUnitIDStr + ",'" + c.get(i).getProductOrgUnit().getId().toString() + "'";
        }
        if (ProductOrgUnitIDStr == null || "".equals(ProductOrgUnitIDStr)) {
            ProductOrgUnitIDStr = "'null'";
        }
        this.runParam.setProductOrgUnitIDStr(ProductOrgUnitIDStr);
        for (String id : orgs) {
            StorageOrgUnitInfo s;
            PMRPCalendarUtil cUtil = new PMRPCalendarUtil(this.runParam.getEasCtx(), id);
            if (!cUtil.isEmpty()) {
                this.runParam.getUtilManager().setCalendarUtil(id, cUtil);
                continue;
            }
            try {
                s = StorageOrgUnitFactory.getLocalInstance((Context)this.runParam.getEasCtx()).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (EASBizException e) {
                throw new PMRPException(PMRPException.FACTORYCALENDAR_ERROR, e);
            }
            logger.warn((Object)("-------------------no FC for productOrg[" + s.getNumber() + ",(" + id + ")]-------------------"));
        }
        this.runParam.getUtilManager().setCalendarUtil(this.runParam.getStorageOrgUnitID(), new PMRPCalendarUtil(this.runParam.getEasCtx(), this.runParam.getStorageOrgUnitID()));
        this.runParam.getUtilManager().setPoUtil(new PMRPPONumberUtil(this.runParam));
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

