/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.mergeDateUnit;
import com.kingdee.eas.industry.emm.project.biz.psp.mergeType;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PSPMergeDatas
extends PMRPStep
implements IConfigurableStep {
    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        PspMergingRulesInfo rulesInfo = runParam.getRunLog().getPspOperationScheme().getMergerRules();
        if (rulesInfo == null) {
            return null;
        }
        if (rulesInfo.getEntry() == null || rulesInfo.getEntry().size() < 1) {
            return null;
        }
        List<String> materialIDList = this.getAllMaterialIDList(runParam);
        if (materialIDList == null || materialIDList.size() < 1) {
            return null;
        }
        int splitCount = 200;
        int times = materialIDList.size() / splitCount;
        if (materialIDList.size() % splitCount > 0) {
            ++times;
        }
        List<Object> subList = new ArrayList();
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)runParam.getService());
        for (int i = 1; i <= times; ++i) {
            subList = i < times ? materialIDList.subList(splitCount * (i - 1), splitCount * i) : materialIDList.subList(splitCount * (i - 1), materialIDList.size());
            UpdateWorker worker = new UpdateWorker(runParam, subList);
            try {
                ecs.submit((Callable)worker);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        try {
            for (int i = 1; i <= times; ++i) {
                this.dataAmount += ((Integer)ecs.take().get()).intValue();
                if (this.logInfo == null) continue;
                sql.setLength(0);
                sql.append("update ");
                sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
                sql.append(" set FDataAmount=? where FID = ?");
                DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        return null;
    }

    protected List<String> getAllMaterialIDList(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fmaterialid  \n");
        sql.append(" from t_psp_pspstockingdemand   \n");
        sql.append(" where fpurorgid = ? \n");
        sql.append(" group by fmaterialid   \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        ArrayList<String> aList = new ArrayList<String>();
        try {
            while (irs.next()) {
                aList.add(irs.getString("fmaterialid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return aList;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_PSP_MERGEDATA");
    }

    private static class UpdateWorker
    implements Callable {
        private List<String> materialIDList;
        private PMRPCalcParam runParam;
        private int dataAmount;

        public UpdateWorker(PMRPCalcParam runParam, List<String> materialidList) {
            this.runParam = runParam;
            this.materialIDList = materialidList;
        }

        public Object call() throws Exception {
            if (this.materialIDList.size() > 0) {
                PspMergingRulesInfo rulesInfo = this.runParam.getRunLog().getPspOperationScheme().getMergerRules();
                UserInfo userInfo = (UserInfo)this.runParam.getEasCtx().get((Object)"UserInfo");
                StringBuffer sql = new StringBuffer();
                ArrayList<String> paramList = new ArrayList<String>();
                sql.setLength(0);
                sql.append(" insert into T_PSP_StockingPlan ( ");
                sql.append(" Fid,FPurChaseOrgUnitID,FStorageOrgUnitID,FsupplyStorageOrgUnitID,fsupplierid,fbasestatus,FProjectID,FTraceNoID,FMaterialID,FIssolateRule,");
                sql.append(" FCreatorID,FLastUpdateUserID,FControlUnitID,FMergeDimension,");
                sql.append(" FQty,FRequirementDate,FPurOrderQty,FWayQty,FInStorageQty,CFStockingPlanType ,CFPurPersonID,CFPurchaseGroupID,CFPlanStartTime, \r\n");
                sql.append(" fmode,funit) \r\n");
                sql.append(" select newbosid('F3C21C47') As Fid \r\n");
                sql.append(" ,aa.FPurChaseOrgUnitID   \r\n");
                sql.append(" ,aa.FStorageOrgUnitID \r\n");
                sql.append(" ,aa.FsupplyStorageOrgUnitID \r\n");
                sql.append(" ,aa.fsupplierid \r\n");
                sql.append(" ,Max(aa.fbasestatus) \r\n");
                sql.append(" ,aa.FProjectID \r\n");
                sql.append(" ,aa.FTraceNoID \r\n");
                sql.append(" ,aa.FMaterialID \r\n");
                sql.append(" ,aa.FIssolateRule \r\n");
                sql.append(" ,Max(aa.FCreatorID) \r\n");
                sql.append(" ,Max(aa.FLastUpdateUserID) \r\n");
                sql.append(" ,Max(aa.FControlUnitID) \r\n");
                sql.append(" ,Max(aa.FMergeDimension) \r\n");
                sql.append(" ,sum(aa.FQty) As FQty \r\n");
                sql.append(" ,min(aa.FRequirementDate) As FRequirementDate \r\n");
                sql.append(" ,sum(aa.FPurOrderQty) As FPurOrderQty \r\n");
                sql.append(" ,sum(aa.FWayQty) As FWayQty \r\n");
                sql.append(" ,sum(aa.FInStorageQty) As FInStorageQty \r\n");
                sql.append(" ,Max(aa.CFStockingPlanType) \r\n");
                sql.append(" ,max(aa.CFPurPersonID) As CFPurPersonID \r\n");
                sql.append(" ,max(aa.CFPurchaseGroupID) As CFPurchaseGroupID \r\n");
                sql.append(" ,DateAdd((-1)*(isnull(mp.fproduceleadtime,0) + isnull(mp.frecevingleadtime,0)),min(aa.finitDate)) As CFPlanStartTime \r\n");
                sql.append(" ,Max(m.fmodel) As fmode \r\n");
                sql.append(" ,Max(bm.fname_l2) As funit \r\n");
                sql.append(" from ( \r\n");
                sql.append(" select a.FPurchaseOrgID As FPurChaseOrgUnitID \r\n");
                sql.append(" ,a.FProductOrgUnitID As FStorageOrgUnitID \r\n");
                sql.append(" ,a.FSupplyOrgUnitID As FsupplyStorageOrgUnitID \r\n");
                sql.append(" ,a.fsupplierid As fsupplierid \r\n");
                sql.append(" ,0 As fbasestatus \r\n");
                sql.append(" ,(case b.Fmergetype  when '1' then null when '2' then a.FProjectID when '3' then a.FProjectID end ) As FProjectID \r\n");
                sql.append(" ,(case b.Fmergetype  when '1' then null when '2' then null when '3' then a.FTrackNoID end ) As FTraceNoID \r\n");
                sql.append(" ,a.FMaterialID As FMaterialID \r\n");
                sql.append(" ,a.FIsolationRules As FIssolateRule \r\n");
                sql.append(" ,'" + userInfo.getId().toString() + "' As FCreatorID \r\n");
                sql.append(" ,'" + userInfo.getId().toString() + "' As FLastUpdateUserID \r\n");
                sql.append(" ,a.FControlUnitID As FControlUnitID \r\n");
                sql.append(" ,'111' As  FMergeDimension \r\n");
                sql.append(" ,a.FSpQty As FQty \r\n");
                sql.append(" ,a.FSpTime As FRequirementDate \r\n");
                sql.append(" ,isnull(a.fbizDate,a.FSpTime) As finitDate \r\n");
                sql.append(" ,a.FPurQty As FPurOrderQty \r\n");
                sql.append(" ,a.FPurQty As FWayQty \r\n");
                sql.append(" ,0 As FInStorageQty \r\n");
                sql.append(" ,'10' As CFStockingPlanType \r\n");
                sql.append(" ,a.CFPurPersonID As CFPurPersonID \r\n");
                sql.append(" ,a.CFPurchaseGroupID As CFPurchaseGroupID \r\n");
                sql.append(" ,(case b.Fmergedateunit when '1' then left(to_char(a.FSpTime,'YYYY-MM-DD'),7) when '2' then left(to_char(a.FSpTime,'YYYY-MM-DD'),4) else to_char(a.FSpTime,'YYYY-MM-DD') end ) As FmergeDateStr \r\n");
                sql.append(" from T_PSP_StockingPlanDetail a  \r\n");
                sql.append(" , T_PSP_PspMergingRulesEntry b  \r\n");
                sql.append(" where b.fparentid = ?   \r\n ");
                sql.append(" And  a.FIsolationRules = b.Fisolationrules   \r\n ");
                sql.append(" and  a.Fproductorgunitid = b.Fproductionorgid ");
                sql.append(" and  a.FPurchaseOrgID = ? ");
                sql.append(" and  a.FBaseStatus = '0' ");
                sql.append(" and  ( ");
                for (int i = 0; i < this.materialIDList.size(); ++i) {
                    sql.append(" a.FMaterialID = ? ");
                    if (i == this.materialIDList.size() - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" )) aa ");
                sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = aa.FMaterialID And mp.forgunit = aa.FsupplyStorageOrgUnitID ");
                sql.append(" left outer join t_bd_material m on m.fid = aa.FMaterialID  ");
                sql.append(" left outer join t_bd_measureunit bm on m.FBASEUNIT = bm.fid  ");
                sql.append(" Group By aa.FPurChaseOrgUnitID   \r\n");
                sql.append(" ,aa.FStorageOrgUnitID \r\n");
                sql.append(" ,aa.FsupplyStorageOrgUnitID \r\n");
                sql.append(" ,aa.fsupplierid \r\n");
                sql.append(" ,aa.FProjectID \r\n");
                sql.append(" ,aa.FTraceNoID \r\n");
                sql.append(" ,aa.FMaterialID \r\n");
                sql.append(" ,aa.FIssolateRule \r\n");
                sql.append(" ,aa.FmergeDateStr \r\n");
                sql.append(" ,mp.frecevingleadtime \r\n");
                sql.append(" ,mp.fproduceleadtime \r\n");
                paramList.add(rulesInfo.getId().toString());
                paramList.add(this.runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
                paramList.addAll(this.materialIDList);
                this.dataAmount = MRPUtil.executeUpdate((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
                for (int iloop = 0; iloop < rulesInfo.getEntry().size(); ++iloop) {
                    PspMergingRulesEntryInfo ruleEntryInfo = rulesInfo.getEntry().get(iloop);
                    paramList = new ArrayList();
                    sql.setLength(0);
                    sql.append(" update T_PSP_StockingPlanDetail a ");
                    sql.append(" set FStockingPlanID = (  ");
                    sql.append(" Select top 1 b.fid from  T_PSP_StockingPlan b ");
                    sql.append(" where b.FMaterialID = a.FMaterialID ");
                    sql.append(" And b.FPurChaseOrgUnitID = a.Fpurchaseorgid ");
                    sql.append(" And b.FStorageOrgUnitID = a.FProductOrgUnitID ");
                    sql.append(" And b.FsupplyStorageOrgUnitID = a.FSupplyOrgUnitID ");
                    sql.append(" And isnull(b.fsupplierid,'*') = isnull(a.fsupplierid,'*') ");
                    sql.append(" And b.FIssolateRule = a.FIsolationRules ");
                    sql.append(" And b.fbasestatus = '0' ");
                    if (ruleEntryInfo.getMergeType().equals((Object)mergeType.TIME)) {
                        sql.append(" And b.FProjectID is null And b.FTraceNoID is null ");
                    } else if (ruleEntryInfo.getMergeType().equals((Object)mergeType.PRJ)) {
                        sql.append(" And isnull(b.FProjectID,'*') = isnull(a.FProjectID,'*') And b.FTraceNoID is null ");
                    } else {
                        sql.append(" And isnull(b.FProjectID,'*') = isnull(a.FProjectID,'*') And isnull(b.FTraceNoID,'*') = isnull(a.FTrackNoID,'*') ");
                    }
                    if (mergeDateUnit.MOUTH.equals((Object)ruleEntryInfo.getMergeDateUnit())) {
                        sql.append(" and left(to_char (b.FRequirementDate ,'YYYY-MM-DD'),7) =left(to_char (a.FSpTime ,'YYYY-MM-DD'),7)  ");
                    } else if (mergeDateUnit.YEAR.equals((Object)ruleEntryInfo.getMergeDateUnit())) {
                        sql.append(" and  left(to_char (b.FRequirementDate ,'YYYY-MM-DD'),4) = left(to_char (a.FSpTime ,'YYYY-MM-DD'),4) ");
                    } else {
                        sql.append(" and  to_char (b.FRequirementDate ,'YYYY-MM-DD') = to_char (a.FSpTime ,'YYYY-MM-DD') ");
                    }
                    sql.append(" )  ");
                    sql.append(" where a.FPurchaseOrgID = ? ");
                    paramList.add(this.runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
                    sql.append(" and a.Fproductorgunitid = ? ");
                    paramList.add(ruleEntryInfo.getProductionOrg().getId().toString());
                    sql.append(" and  a.FBaseStatus = '0' ");
                    sql.append(" and  a.Fisolationrules = ? ");
                    paramList.add(ruleEntryInfo.getIsolationrules().getValue());
                    sql.append(" and  a.CFStockingPlanType = '10' ");
                    sql.append(" and  a.FStockingPlanID is null ");
                    sql.append(" and  ( ");
                    for (int i = 0; i < this.materialIDList.size(); ++i) {
                        sql.append(" a.FMaterialID = ? ");
                        if (i == this.materialIDList.size() - 1) continue;
                        sql.append(" OR ");
                    }
                    sql.append(" ) ");
                    paramList.addAll(this.materialIDList);
                    MRPUtil.executeUpdate((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
                }
                paramList = new ArrayList();
                int days = this.runParam.getRunLog().getPspOperationScheme().getPlanTime();
                sql.setLength(0);
                sql.append(" insert into T_PSP_StockingPlan ");
                sql.append("(Fid,FPurChaseOrgUnitID,FStorageOrgUnitID,FsupplyStorageOrgUnitID,fsupplierid,fbasestatus,FProjectID,FTraceNoID,FMaterialID,FIssolateRule,");
                sql.append(" FCreatorID,FLastUpdateUserID,FControlUnitID,FMergeDimension,");
                sql.append(" FQty,FRequirementDate,FPurOrderQty,FWayQty,FInStorageQty,CFStockingPlanType ,CFPurPersonID,fmode,funit,CFPlanStartTime,cfsourcebillid , CFPurchaseGroupID )");
                sql.append(" select  newbosid('F3C21C47') As Fid  \n");
                sql.append(" ,po.fpurchaseorgunitid As FPurChaseOrgUnitID \n");
                sql.append(" ,poe.frequestorgunitid As FStorageOrgUnitID \n");
                sql.append(" ,poe.fstorageorgunitid As FsupplyStorageOrgUnitID \n");
                sql.append(" ,po.fsupplierid As fsupplierid \n");
                sql.append(" ,0 As fbasestatus \n");
                sql.append(" ,poe.fprojectid As FProjectID \n");
                sql.append(" ,poe.ftracknoid As FTraceNoID \n");
                sql.append(" ,poe.fmaterialid As FMaterialID \n");
                sql.append(" ,isnull(mp.FIsolatedRule,'NONE') As FIssolateRule \n");
                sql.append(" ,'" + userInfo.getId().toString() + "' As FCreatorID \r\n");
                sql.append(" ,'" + userInfo.getId().toString() + "' As FLastUpdateUserID \r\n");
                sql.append(" ,po.FControlUnitID As FControlUnitID \r\n");
                sql.append(" ,'' As FMergeDimension \n");
                sql.append(" ,isnull( poe.fqty ,0) - isnull(poe.ftotalreceiptqty,0) As FQty \n");
                sql.append(" ,poe.fdeliverydate As FRequirementDate \n");
                sql.append(" ,isnull( poe.fqty ,0) - isnull(poe.ftotalreceiptqty,0) As FPurOrderQty \n");
                sql.append(" ,isnull( poe.fqty ,0) - isnull(poe.ftotalreceiptqty,0) As FWayQty \n");
                sql.append(" ,0 As FInStorageQty \n");
                sql.append(" ,'20' As CFStockingPlanType \n");
                sql.append(" ,po.fpurchasepersonid As CFPurPersonID \n");
                sql.append(" ,tm.fmodel As fmode \n");
                sql.append(" ,bm.fname_l2 As funit \n");
                sql.append(" ,DateAdd((-1)*(isnull(mp.fproduceleadtime,0) + isnull(mp.frecevingleadtime,0)),poe.fdeliverydate) As CFPlanStartTime \r\n");
                sql.append(" ,poe.fid As cfsourcebillid \n");
                sql.append(" ,po.fpurchasegroupid As CFPurchaseGroupID \n");
                sql.append(" from t_sm_purorderentry poe \n");
                sql.append(" inner join t_sm_purorder po on po.fid = poe.fparentid \n");
                sql.append(" left join t_bd_material tm on tm.fid = poe.fmaterialid \n");
                sql.append(" left join T_BD_MaterialPlan mp on mp.fmaterialid = poe.fmaterialid and mp.forgunit = poe.fstorageorgunitid \n");
                sql.append(" left join t_bd_measureunit bm on tm.FBASEUNIT = bm.fid \n");
                sql.append(" where 1=1 \n");
                sql.append(" and po.fbasestatus = 4 \n");
                sql.append(" and  ( ");
                for (int i = 0; i < this.materialIDList.size(); ++i) {
                    sql.append(" poe.FMaterialID = ? ");
                    if (i == this.materialIDList.size() - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" )  ");
                sql.append(" and po.fsupplierid is not null \n");
                sql.append(" and (isnull( poe.fqty ,0) - isnull(poe.ftotalreceiptqty,0)) > 0 \n");
                sql.append(" and po.fpurchaseorgunitid = ?  \n");
                sql.append(" and poe.fdeliverydate > DATEADD( -1 , now()) \n");
                sql.append(" and poe.fdeliverydate <= DATEADD( ").append(days).append(" , now()) \n");
                paramList.addAll(this.materialIDList);
                paramList.add(this.runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
                this.dataAmount += MRPUtil.executeUpdate((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
            }
            return this.dataAmount;
        }
    }
}

