/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.basedata.BOMTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.ComputeTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPAdjustStrategyEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPBillParamInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPClassifyEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPElementEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalendarUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPDate;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.IPMRPBatchPolicy;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.PMRPBatchPolicyFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.impl.PMRPFixedPeriodicbatchPolicy;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPAjustResult;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPFetchDetailDataUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPFetchMaterialDataUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPNetReqSaver;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyResult;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyVO;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialDataInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialStatisticsInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPStockDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.FactoryCalendarTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.InventoryDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.OrgUnitStatisticsTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.StatisticsTableDefine;
import com.kingdee.eas.mm.basedata.AdjustStrategyEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ExpandInfo;
import com.kingdee.eas.mm.basedata.ExpandInfoCollection;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPPlanStrategyUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PMRPAjustMent
extends PMRPStep
implements Callable {
    public static final String INV_SEQ = "00" + String.valueOf(110);
    public static final String SAFESTOCK_SEQ = "00133";
    public static final String DivertInv_SEQ = "00" + String.valueOf(140);
    public static final String UNDISTRIBUTE_INV_SEQ = "00" + String.valueOf(131);
    public static final String DISTRIBUTE_INV_SEQ = "00" + String.valueOf(132);
    protected List<String> materialIDLst;
    protected PMRPNetReqSaver dataSaver;
    protected PMRPFetchMaterialDataUtil materiaDataUtil;
    protected PMRPFetchDetailDataUtil detailDataUtil;
    protected List<PMRPDetailInfo> adetail = null;
    protected HashMap<String, BigDecimal> preQty = new HashMap();
    protected String key = null;
    protected Set<String> materialException = new HashSet<String>();
    protected Set<String> underSafeStockIds = new HashSet<String>();
    protected PMRPMaterialDataInfo materialDataInfo4Stock = null;
    protected PMRPAjustResult result = new PMRPAjustResult();

    public PMRPAjustMent(List<String> materialIDLst, PMRPCalcParam runParam) throws PMRPException, BOSException {
        this.materialIDLst = materialIDLst;
        this.runParam = runParam;
        this.dataSaver = new PMRPNetReqSaver(runParam);
        this.detailDataUtil = new PMRPFetchDetailDataUtil();
        this.materiaDataUtil = new PMRPFetchMaterialDataUtil(runParam);
        this.materiaDataUtil.setPreQty(this.preQty);
        this.materiaDataUtil.setDataSaver(this.dataSaver);
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_CALCMATERIALS");
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        System.out.println("--------------------------------PMRP Material Calc Thread:begin-----------------------------------");
        System.out.println("--------------------------------start time:" + System.currentTimeMillis() + "-----------------------------------");
        this.cycCalc();
        this.result.setDataAmount(this.dataAmount);
        System.out.println("--------------------------------dataAmount:" + this.dataAmount + "-----------------------------------");
        System.out.println("--------------------------------PMRP Material Calc Thread:end-----------------------------------");
        return this.result;
    }

    protected void cycCalc() throws BOSException, PMRPException {
        int times = this.materialIDLst.size() / 500;
        if (this.materialIDLst.size() % 500 > 0) {
            ++times;
        }
        List<String> subList = null;
        int[] periods = null;
        PMRPMaterialDataInfo materialDataInfo = null;
        for (int i = 1; i <= times; ++i) {
            int period;
            int j;
            subList = i < times ? this.materialIDLst.subList(500 * (i - 1), 500 * i) : this.materialIDLst.subList(500 * (i - 1), this.materialIDLst.size());
            periods = this.materiaDataUtil.setMaterialIdList(subList);
            HashMap unMaterials = (HashMap)this.materiaDataUtil.getMaterials().clone();
            this.detailDataUtil.setMaterialIds(subList, this.materiaDataUtil);
            if (this.runParam.getRunLog().getComputeType() == null || this.runParam.getRunLog().getComputeType().equals((Object)ComputeTypeEnum.PMRP)) {
                for (j = 0; j < periods.length; ++j) {
                    period = periods[j];
                    while (this.materiaDataUtil.hasNextMaterial(period)) {
                        materialDataInfo = this.materiaDataUtil.getNextMaterial(period);
                        if (materialDataInfo == null || materialDataInfo.getPlanStrategy() == null || materialDataInfo.getSupplyStorageOrgUnitID() == null || materialDataInfo.getMaterialID() == null) {
                            System.out.println("----materialDataInfo\u6570\u636e\u4fe1\u606f\u9519\u8bef1\uff1a-----\u8ba1\u7b97\u4f4e\u4f4d\u7801:" + this.runParam.getLevel());
                            System.out.println("----materialDataInfo\u6570\u636e\u4fe1\u606f\u9519\u8bef1\uff1a-----period:" + period);
                            if (materialDataInfo != null) {
                                System.out.println("----materialDataInfo\u6570\u636e\u4fe1\u606f\u9519\u8bef1\uff1a-----" + materialDataInfo.toString());
                            }
                        }
                        this.createMaterialDataInfo(materialDataInfo);
                        this.oneDayStockCalc(materialDataInfo, period);
                    }
                    this.dataSaver.execute(true);
                }
                this.materiaDataUtil.setMaterialIdList(subList);
            }
            this.detailDataUtil.clear();
            for (j = 0; j < periods.length; ++j) {
                period = periods[j];
                while (this.materiaDataUtil.hasNextMaterial(period)) {
                    materialDataInfo = this.materiaDataUtil.getNextMaterial(period);
                    if (materialDataInfo == null || materialDataInfo.getPlanStrategy() == null || materialDataInfo.getSupplyStorageOrgUnitID() == null || materialDataInfo.getMaterialID() == null) {
                        System.out.println("----materialDataInfo\u6570\u636e\u4fe1\u606f\u9519\u8bef2\uff1a-----\u8ba1\u7b97\u4f4e\u4f4d\u7801:" + this.runParam.getLevel());
                        if (materialDataInfo != null) {
                            System.out.println("----materialDataInfo\u6570\u636e\u4fe1\u606f\u9519\u8bef2\uff1a-----" + materialDataInfo.toString());
                        }
                    }
                    this.oneDayCalc(materialDataInfo, period);
                }
                this.dataSaver.execute(true);
            }
            this.afterCalcLoopHook();
            this.dataAmount += this.detailDataUtil.getDetailCount();
            this.detailDataUtil.clear();
            HashMap<String, PMRPMaterialDataInfo> materials = this.materiaDataUtil.getMaterials();
            Iterator<Map.Entry<String, PMRPMaterialDataInfo>> itMaterials = materials.entrySet().iterator();
            while (itMaterials.hasNext()) {
                PMRPFixedPeriodicbatchPolicy periodPolicy;
                materialDataInfo = itMaterials.next().getValue();
                if (materialDataInfo == null || materialDataInfo.getPlanStrategy() == null || materialDataInfo.getSupplyStorageOrgUnitID() == null || materialDataInfo.getMaterialID() == null) {
                    System.out.println("----materialDataInfo\u6570\u636e\u4fe1\u606f\u9519\u8bef3\uff1a-----\u8ba1\u7b97\u4f4e\u4f4d\u7801:" + this.runParam.getLevel());
                    if (materialDataInfo != null) {
                        System.out.println("----materialDataInfo\u6570\u636e\u4fe1\u606f\u9519\u8bef3\uff1a-----" + materialDataInfo.toString());
                    }
                }
                if (materialDataInfo.getBatchPolicy() != 4 && materialDataInfo.getBatchPolicy() != 3 || (periodPolicy = (PMRPFixedPeriodicbatchPolicy)this.getBatchPolicy(materialDataInfo)).isCaculated()) continue;
                logger.debug((Object)"end cycle create planOder. ");
                this.batchCal(materialDataInfo, 0, MRPConstant.ZERO, MRPConstant.ZERO, true, MRPConstant.ZERO, null, true);
            }
            this.dataSaver.execute(true);
            for (int k = 0; k < subList.size(); ++k) {
                this.runParam.getCounter().logMaterialCalcFinished();
            }
            this.preQty.clear();
            HashMap<String, PMRPMaterialDataInfo> map = this.materiaDataUtil.getMaterials();
            Iterator<Map.Entry<String, PMRPMaterialDataInfo>> materialMaps = map.entrySet().iterator();
            while (materialMaps.hasNext()) {
                materialDataInfo = materialMaps.next().getValue();
                for (int j2 = 0; j2 < subList.size(); ++j2) {
                    if (!subList.get(j2).toString().equals(materialDataInfo.getMaterialID()) || materialDataInfo.getIsNewOrder() < 1 && materialDataInfo.getHasExceptions() < 1 && materialDataInfo.getHasStockExp() < 1) continue;
                    this.dataSaver.addUpdateMaterialList(materialDataInfo);
                }
            }
            this.createPlanedorderForStock(subList, unMaterials);
        }
        this.materialException.clear();
        this.underSafeStockIds.clear();
        this.dataSaver.executeUpdateMaterial();
        this.detailDataUtil.releaseTemptable(this.runParam);
    }

    protected void afterCalcLoopHook() throws PMRPException, BOSException {
    }

    protected void oneDayStockCalc(PMRPMaterialDataInfo materialDataInfo, int period) throws BOSException, PMRPException {
        PMRPMaterialStatisticsInfo materialStatisticsInfo = null;
        List<PMRPDetailInfo> detailDatas = null;
        BigDecimal onHand = null;
        while (this.materiaDataUtil.hasNextStatisticData(materialDataInfo.getMaterialID(), materialDataInfo.getSupplyStorageOrgUnitID(), period)) {
            materialStatisticsInfo = this.materiaDataUtil.getNextStatisticData(materialDataInfo.getMaterialID(), materialDataInfo.getSupplyStorageOrgUnitID(), period);
            if (materialStatisticsInfo.getRQty().compareTo(MRPConstant.ZERO) == 0 && materialStatisticsInfo.getSQty().compareTo(MRPConstant.ZERO) == 0) continue;
            detailDatas = this.detailDataUtil.getOneMaterialDetialData(this.runParam, period, materialDataInfo.getMaterialID(), materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber(), materialStatisticsInfo.getSeq(), materialStatisticsInfo.getSupplyOrgUnitID());
            if (detailDatas == null || detailDatas.size() == 0) {
                if (materialStatisticsInfo.getRQty().compareTo(MRPConstant.ZERO) == 0 && materialStatisticsInfo.getSQty().compareTo(MRPConstant.ZERO) == 0) continue;
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"28_MRPAjustMent", (Locale)this.runParam.getEasCtx().getLocale()));
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"29_MRPAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + materialStatisticsInfo.toString()));
                continue;
            }
            List<HashMap<String, Object>> orgUnitIDList = this.getOrgUnitIDList(materialStatisticsInfo);
            this.setException4Stock(materialStatisticsInfo);
            if ("NUnM+gEcEADgAA3ewKgL09g0uEU=".equals(materialDataInfo.getPlanStrategy())) continue;
            String projectNumber = materialStatisticsInfo.getProjectNumber();
            String trackNumber = materialStatisticsInfo.getTrackNumber();
            if (materialStatisticsInfo.getOnHand() == null) {
                materialStatisticsInfo.setOnHand(new BigDecimal(0));
            }
            if (orgUnitIDList != null && orgUnitIDList.size() > 0) {
                for (int i = 0; i < orgUnitIDList.size(); ++i) {
                    HashMap<String, Object> dataMap = orgUnitIDList.get(i);
                    if (dataMap == null || dataMap.get("FOrgUnitID") == null) continue;
                    String forgUnitID = dataMap.get("FOrgUnitID").toString();
                    BigDecimal FRQty = new BigDecimal(dataMap.get("FRQty").toString());
                    BigDecimal FRQty2 = FRQty.multiply(new BigDecimal(-1));
                    BigDecimal FthisUpdateQty = new BigDecimal(0);
                    onHand = materialDataInfo.getOnHandQty(this.runParam, materialStatisticsInfo.getMaterialID(), forgUnitID, projectNumber, trackNumber, FRQty2, this.runParam.getSupplyModel(), false, "2");
                    if (onHand.compareTo(MRPConstant.ZERO) <= 0 || FRQty.compareTo(MRPConstant.ZERO) >= 0) continue;
                    FthisUpdateQty = onHand.subtract(FRQty2).compareTo(MRPConstant.ZERO) > 0 ? FRQty2.abs() : onHand;
                    materialStatisticsInfo.setOnHand(materialStatisticsInfo.getOnHand().add(FthisUpdateQty));
                    materialDataInfo.getOnHandQty(this.runParam, materialStatisticsInfo.getMaterialID(), forgUnitID, projectNumber, trackNumber, FthisUpdateQty, this.runParam.getSupplyModel(), true, "2");
                }
            }
            this.dataSaver.addDUpdateList(materialStatisticsInfo);
            List<Object> infos = new ArrayList();
            String planStrategy = materialDataInfo.getPlanStrategy();
            IsolatedRuleEnum isolatedRule = materialDataInfo.getIsolatedRule();
            Map<String, List<PMRPStockDetailInfo>> onHandQtyMap = materialDataInfo.getOnHandQtyMap();
            if (IsolatedRuleEnum.ITEM.equals((Object)isolatedRule) && "qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(planStrategy)) {
                for (String key : onHandQtyMap.keySet()) {
                    if (!key.startsWith(projectNumber)) continue;
                    infos.addAll(onHandQtyMap.get(key));
                }
            } else if (IsolatedRuleEnum.ITEM_TRACKNO.equals((Object)isolatedRule) && "qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(planStrategy)) {
                String key = projectNumber + trackNumber;
                infos = onHandQtyMap.get(key);
            } else {
                Iterator<String> iter = onHandQtyMap.keySet().iterator();
                while (iter.hasNext()) {
                    infos.addAll(onHandQtyMap.get(iter.next()));
                }
            }
            if (infos == null || infos.size() <= 0) continue;
            for (PMRPStockDetailInfo info : infos) {
                if (!info.isNeedUpdate()) continue;
                info.setNeedUpdate(false);
                this.dataSaver.addUpdateInventoryList(info);
            }
        }
    }

    protected void oneDayCalc(PMRPMaterialDataInfo materialDataInfo, int period) throws BOSException, PMRPException {
        PMRPMaterialStatisticsInfo materialStatisticsInfo = null;
        List<PMRPDetailInfo> detailDatas = null;
        BigDecimal pab_t_1 = null;
        BigDecimal dayNet_qty = null;
        while (this.materiaDataUtil.hasNextStatisticData(materialDataInfo.getMaterialID(), materialDataInfo.getSupplyStorageOrgUnitID(), period)) {
            materialStatisticsInfo = this.materiaDataUtil.getNextStatisticData(materialDataInfo.getMaterialID(), materialDataInfo.getSupplyStorageOrgUnitID(), period);
            if (materialStatisticsInfo.getRQty().compareTo(MRPConstant.ZERO) == 0 && materialStatisticsInfo.getSQty().compareTo(MRPConstant.ZERO) == 0) continue;
            detailDatas = this.detailDataUtil.getOneMaterialDetialData(this.runParam, period, materialDataInfo.getMaterialID(), materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber(), materialStatisticsInfo.getSeq(), materialStatisticsInfo.getSupplyOrgUnitID());
            if (detailDatas == null || detailDatas.size() == 0) {
                if (materialStatisticsInfo.getRQty().compareTo(MRPConstant.ZERO) == 0 && materialStatisticsInfo.getSQty().compareTo(MRPConstant.ZERO) == 0) continue;
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"28_MRPAjustMent", (Locale)this.runParam.getEasCtx().getLocale()));
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"29_MRPAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + materialStatisticsInfo.toString()));
                continue;
            }
            this.key = materialDataInfo.getMaterialID();
            this.key = materialStatisticsInfo.getProjectNumber() == null || "".equals(materialStatisticsInfo.getProjectNumber()) ? this.key + "*" : this.key + materialStatisticsInfo.getProjectNumber();
            this.key = materialStatisticsInfo.getTrackNumber() == null || "".equals(materialStatisticsInfo.getTrackNumber()) ? this.key + "*" : this.key + materialStatisticsInfo.getTrackNumber();
            this.key = this.key + materialStatisticsInfo.getSupplyOrgUnitID();
            if (this.preQty.get(this.key) == null) {
                this.preQty.put(this.key, BigDecimal.ZERO);
            }
            BigDecimal preAvailableQty = this.preQty.get(this.key);
            if (materialDataInfo.getBatchPolicy() == 3 && period > this.runParam.getDateManager().getPlanDate(materialDataInfo.getOrgUnitId()).getPeriod()) {
                preAvailableQty = this.createPO4LastCycle(materialDataInfo, preAvailableQty, period, this.isMerge(materialDataInfo));
                this.preQty.put(this.key, preAvailableQty);
            }
            if ((pab_t_1 = (dayNet_qty = materialStatisticsInfo.getRQty().add(materialStatisticsInfo.getSQty()).add(materialStatisticsInfo.getOnHand()).add(materialStatisticsInfo.getPreQty())).add(preAvailableQty)).compareTo(MRPConstant.ZERO) < 0) {
                materialDataInfo.setHasExceptions(1);
                this.advance(materialDataInfo, materialStatisticsInfo, detailDatas, period);
                this.adetail = null;
                continue;
            }
            if (pab_t_1.compareTo(MRPConstant.ZERO) > 0) {
                this.delayCancle(materialDataInfo, materialStatisticsInfo, detailDatas, period);
                if (materialDataInfo.getBatchPolicy() != 4 && materialDataInfo.getBatchPolicy() != 3) continue;
                BigDecimal tempPreQty = this.batchCal(materialDataInfo, period, dayNet_qty, materialStatisticsInfo.getRQty(), false, this.preQty.get(this.key), detailDatas.get(0), this.isMerge(materialDataInfo));
                this.preQty.put(this.key, tempPreQty);
                continue;
            }
            if (pab_t_1.compareTo(MRPConstant.ZERO) != 0) continue;
            PMRPDetailInfo detailInfo = detailDatas.get(0);
            this.batchGenExceptions(materialDataInfo, materialStatisticsInfo, detailDatas);
            if (materialDataInfo.getBatchPolicy() == 4 || materialDataInfo.getBatchPolicy() == 3) {
                this.batchCal(materialDataInfo, period, dayNet_qty, materialStatisticsInfo.getRQty(), false, pab_t_1, detailInfo, this.isMerge(materialDataInfo));
            }
            this.preQty.put(this.key, MRPConstant.ZERO);
        }
    }

    protected boolean isMerge(PMRPMaterialDataInfo materialDataInfo) {
        return true;
    }

    protected void setSafeStock(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo materialStatisticsInfo, BigDecimal safeStockQty) {
        if (MRPPlanStrategyUtil.isInvPlanStrategy((String)materialDataInfo.getPlanStrategy())) {
            if (this.isDefaultProjectAndTrackNumber(materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber())) {
                materialDataInfo.setSafeStockQty(safeStockQty);
            }
        } else {
            materialDataInfo.setSafeStockQty(safeStockQty);
        }
    }

    protected void delayCancle(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, List<PMRPDetailInfo> detailDatas, int period) throws BOSException, PMRPException {
        PMRPDetailInfo detailInfo = null;
        BigDecimal delayQty = null;
        BigDecimal totaldelayQty = new BigDecimal("0.0");
        BigDecimal surplusQty = null;
        List<PMRPMaterialStatisticsInfo> delayStatisticsInfos = null;
        delayStatisticsInfos = this.materiaDataUtil.getDeLayPerid(this.runParam, statisticsInfo.getMaterialID(), statisticsInfo.getProjectNumber(), statisticsInfo.getTrackNumber(), period, 0, statisticsInfo.getSupplyOrgUnitID());
        BigDecimal rQty = statisticsInfo.getRQty().add(statisticsInfo.getOnHand()).add(this.preQty.get(this.key)).add(statisticsInfo.getPreQty());
        BigDecimal sQty = this.preQty.get(this.key).add(statisticsInfo.getPreQty());
        for (int i = 0; i < detailDatas.size(); ++i) {
            detailInfo = detailDatas.get(i);
            surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
            sQty = sQty.add(surplusQty);
            if (detailInfo.getMrpItem().equals((Object)PMRPElementEnum.S_SUBSTITUTE) || detailInfo.getSID() != null || detailInfo.isNewOrder()) {
                rQty = rQty.add(surplusQty);
                continue;
            }
            if (PMRPClassifyEnum.Requirement.equals((Object)detailInfo.getMrpClassify()) || PMRPClassifyEnum.Inventory.equals((Object)detailInfo.getMrpClassify())) {
                sQty = sQty.add(detailInfo.getIndependentQty()).add(detailInfo.getDependentQty());
                continue;
            }
            if ((rQty = rQty.add(surplusQty)).compareTo(MRPConstant.ZERO) > 0) {
                delayQty = rQty.compareTo(surplusQty) < 0 ? rQty : surplusQty;
                delayQty = this.afterDelayCancle(materialDataInfo, delayStatisticsInfos, detailInfo, delayQty);
                totaldelayQty = totaldelayQty.add(delayQty);
                sQty = sQty.subtract(delayQty);
                this.genExceptions(materialDataInfo, detailInfo, sQty);
                continue;
            }
            if (detailInfo.getAjustFlag() > 0) {
                this.genExceptions(materialDataInfo, detailInfo, sQty);
                continue;
            }
            this.genExceptions(materialDataInfo, detailInfo, MRPConstant.ZERO);
        }
        BigDecimal pab = statisticsInfo.getSQty().subtract(totaldelayQty).add(statisticsInfo.getOnHand()).add(this.preQty.get(this.key)).add(statisticsInfo.getRQty()).add(statisticsInfo.getPreQty());
        this.preQty.put(this.key, pab);
    }

    protected void advance(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, List<PMRPDetailInfo> detailDatas, int period) throws BOSException, PMRPException {
        PMRPDetailInfo detailInfo = detailDatas.get(0);
        int index = 0;
        BigDecimal pab_t_1 = statisticsInfo.getRQty().add(statisticsInfo.getSQty()).add(statisticsInfo.getOnHand()).add(statisticsInfo.getPreQty());
        if (this.preQty.get(this.key) != null) {
            pab_t_1 = pab_t_1.add(this.preQty.get(this.key));
        }
        index = this.batchGenExceptions(materialDataInfo, statisticsInfo, detailDatas);
        int size = detailDatas.size();
        if (size == 0) {
            this.preQty.put(this.key, MRPConstant.ZERO);
            this.advanceForStock(materialDataInfo, statisticsInfo, period);
        } else if (materialDataInfo.getBatchPolicy() == 1 || materialDataInfo.getBatchPolicy() == 2) {
            if (this.isMerge(materialDataInfo)) {
                pab_t_1 = pab_t_1.subtract(statisticsInfo.getRQty());
                while (detailDatas.size() > 0) {
                    detailInfo = this.getNextMergeRequire(materialDataInfo.getPlanStrategy(), detailDatas, materialDataInfo.getIsolatedRule());
                    pab_t_1 = pab_t_1.add(detailInfo.getNetReqQty());
                    this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                    pab_t_1 = detailInfo.getNetReqQty();
                    if (this.isHasNetReq(pab_t_1)) {
                        pab_t_1 = this.batchCal(materialDataInfo, period, statisticsInfo.getRQty().add(statisticsInfo.getSQty()), statisticsInfo.getRQty(), false, pab_t_1, detailInfo, true);
                    }
                    this.preQty.put(this.key, pab_t_1);
                }
            } else {
                pab_t_1 = statisticsInfo.getSQty().add(statisticsInfo.getOnHand()).add(statisticsInfo.getPreQty());
                if (this.preQty.get(this.key) != null) {
                    pab_t_1 = pab_t_1.add(this.preQty.get(this.key));
                }
                for (int i = index; i < size; ++i) {
                    detailInfo = detailDatas.get(i);
                    pab_t_1 = pab_t_1.add(detailInfo.getIndependentQty().add(detailInfo.getDependentQty()));
                    detailInfo.setNetReqQty(pab_t_1);
                    if (pab_t_1.compareTo(MRPConstant.ZERO) >= 0) continue;
                    this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                    pab_t_1 = detailInfo.getNetReqQty();
                    if (!this.isHasNetReq(pab_t_1)) continue;
                    pab_t_1 = this.batchCal(materialDataInfo, period, statisticsInfo.getRQty().add(statisticsInfo.getSQty()), statisticsInfo.getRQty(), false, pab_t_1, detailInfo, false);
                }
                this.preQty.put(this.key, pab_t_1);
            }
        } else {
            pab_t_1 = statisticsInfo.getSQty().add(statisticsInfo.getOnHand()).add(statisticsInfo.getPreQty());
            if (this.preQty.get(this.key) != null) {
                pab_t_1 = pab_t_1.add(this.preQty.get(this.key));
            }
            for (int i = index; i < size; ++i) {
                detailInfo = detailDatas.get(i);
                pab_t_1 = pab_t_1.add(detailInfo.getIndependentQty().add(detailInfo.getDependentQty()));
                detailInfo.setNetReqQty(pab_t_1);
                if (pab_t_1.compareTo(MRPConstant.ZERO) >= 0) continue;
                this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                pab_t_1 = detailInfo.getNetReqQty();
            }
            if (this.isHasNetReq(pab_t_1)) {
                pab_t_1 = this.batchCal(materialDataInfo, period, statisticsInfo.getRQty().add(statisticsInfo.getSQty()), statisticsInfo.getRQty(), false, pab_t_1, detailInfo, true);
            }
            this.preQty.put(this.key, pab_t_1);
        }
    }

    protected boolean doAdvance(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, PMRPDetailInfo detailInfo, BigDecimal pab_t_1, int period, boolean isMergeSign) throws BOSException, PMRPException {
        if (!this.isNeedAjust(period, materialDataInfo.getOrgUnitId())) {
            detailInfo.setNetReqQty(pab_t_1);
            return false;
        }
        PMRPDetailInfo detailInfoTmp = null;
        PMRPAdjustStrategyEnum strategyEnum = null;
        if (this.adetail == null) {
            this.adetail = this.detailDataUtil.getAdvanceDetailsData(this.runParam, materialDataInfo.getMaterialID(), statisticsInfo.getProjectNumber(), statisticsInfo.getTrackNumber(), period, materialDataInfo.getSupplyStorageOrgUnitID());
        }
        detailInfo.setNetReqQty(pab_t_1);
        if (this.adetail.size() == 0) {
            detailInfo.setNetReqQty(pab_t_1);
            return false;
        }
        BigDecimal aQty = null;
        int ajut_period = 0;
        PMRPMaterialStatisticsInfo materialStatisticsInfo = null;
        Iterator<PMRPDetailInfo> advancedDetails = this.adetail.iterator();
        while (advancedDetails.hasNext()) {
            detailInfoTmp = advancedDetails.next();
            if (ajut_period != detailInfoTmp.getPeriod() || ajut_period == 0) {
                materialStatisticsInfo = this.materiaDataUtil.getStatisticsInfo(detailInfoTmp);
                ajut_period = detailInfoTmp.getPeriod();
            }
            if ((strategyEnum = this.runParam.getAdjustStrategy(detailInfoTmp.getBillType())) == null || (aQty = this.calcAjustQty(materialDataInfo, detailInfo, detailInfoTmp, pab_t_1, strategyEnum)) == null) continue;
            if (materialStatisticsInfo != null) {
                materialStatisticsInfo.setSQty(materialStatisticsInfo.getSQty().subtract(aQty));
            }
            if (pab_t_1.add(aQty).compareTo(MRPConstant.ZERO) < 0) {
                this.afterAjust(materialStatisticsInfo, detailInfo, detailInfoTmp, aQty);
                pab_t_1 = pab_t_1.add(aQty);
                if (detailInfoTmp.getSurplusQty().compareTo(MRPConstant.ZERO) <= 0) {
                    advancedDetails.remove();
                }
                this.genExceptions(materialDataInfo, detailInfoTmp, pab_t_1);
                continue;
            }
            pab_t_1 = pab_t_1.add(aQty);
            detailInfo.setNetReqQty(pab_t_1);
            this.afterAjust(materialStatisticsInfo, detailInfo, detailInfoTmp, aQty);
            this.dataSaver.addAUpdateList(materialStatisticsInfo);
            if (detailInfoTmp.getSurplusQty().compareTo(MRPConstant.ZERO) <= 0) {
                advancedDetails.remove();
            }
            this.genExceptions(materialDataInfo, detailInfoTmp, pab_t_1);
            return true;
        }
        detailInfo.setNetReqQty(pab_t_1);
        this.dataSaver.addAUpdateList(materialStatisticsInfo);
        return false;
    }

    protected BigDecimal calcAjustQty(PMRPMaterialDataInfo materialDataInfo, PMRPDetailInfo rdetailInfo, PMRPDetailInfo adetailInfo, BigDecimal pab_t_1, PMRPAdjustStrategyEnum strategyEnum) {
        BigDecimal aQty = null;
        BigDecimal surplusQty = adetailInfo.getSurplusQty();
        if (adetailInfo.getPeriod() - rdetailInfo.getPeriod() > this.runParam.getRunLog().getPlanDefined().getTolerOfForward()) {
            adetailInfo.setNextajustFlag(2);
            if (pab_t_1.add(surplusQty).compareTo(MRPConstant.ZERO) < 0) {
                if (strategyEnum.getValue() == 20) {
                    aQty = Constants.MRPConfig.ISCONSIDERBATCH && surplusQty.compareTo(adetailInfo.getScheduledReceiptQty()) < 0 ? this.getBatchAjustQty(materialDataInfo, adetailInfo, pab_t_1) : surplusQty;
                } else {
                    if (adetailInfo.getAjustQty().compareTo(MRPConstant.ZERO) > 0 || adetailInfo.getScheduledReceiptQty().compareTo(surplusQty) > 0) {
                        return null;
                    }
                    aQty = surplusQty;
                }
            } else if (strategyEnum.getValue() == 20) {
                if (Constants.MRPConfig.ISCONSIDERBATCH) {
                    aQty = this.getBatchAjustQty(materialDataInfo, adetailInfo, pab_t_1);
                    if (aQty == null || surplusQty.compareTo(adetailInfo.getScheduledReceiptQty()) == 0 && surplusQty.compareTo(aQty) < 0) {
                        aQty = surplusQty;
                    }
                } else {
                    aQty = pab_t_1.multiply(new BigDecimal("-1.0"));
                }
            } else {
                if (adetailInfo.getAjustQty().compareTo(MRPConstant.ZERO) > 0 || adetailInfo.getScheduledReceiptQty().compareTo(surplusQty) > 0) {
                    return null;
                }
                aQty = surplusQty;
            }
        } else {
            adetailInfo.setNextajustFlag(1);
            aQty = pab_t_1.add(surplusQty).compareTo(MRPConstant.ZERO) < 0 ? surplusQty : pab_t_1.multiply(new BigDecimal("-1.0"));
        }
        return aQty;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal calcDelayQty(PMRPMaterialDataInfo materialDataInfo, PMRPDetailInfo delaydetailInfo, BigDecimal surplusQty, PMRPAdjustStrategyEnum strategyEnum, int delayPeriod) {
        void var6_14;
        Object var6_6 = null;
        int period = delaydetailInfo.getSperiod();
        if (period <= 0) {
            period = delaydetailInfo.getPeriod();
        }
        if (strategyEnum == null || delaydetailInfo.getIsAjust() < 1) {
            return null;
        }
        if (surplusQty.compareTo(delaydetailInfo.getScheduledReceiptQty()) < 0) {
            if (delayPeriod - period <= this.runParam.getRunLog().getPlanDefined().getTolerOfDisplacemt()) {
                BigDecimal bigDecimal = surplusQty;
                delaydetailInfo.setNextajustFlag(5);
                return var6_14;
            } else {
                BigDecimal bigDecimal;
                if (strategyEnum.getValue() != 20) return null;
                if (delaydetailInfo.getAjustFlag() == 5) {
                    BigDecimal bigDecimal2 = surplusQty;
                    delaydetailInfo.setNextajustFlag(3);
                    return bigDecimal2;
                }
                if (delaydetailInfo.getAjustFlag() > 0) {
                    surplusQty = delaydetailInfo.getScheduledReceiptQty().subtract(delaydetailInfo.getAjustQty()).subtract(surplusQty);
                }
                if ((bigDecimal = this.getBatchAjustQty(materialDataInfo, delaydetailInfo, surplusQty)) == null) {
                    return null;
                }
                if (delaydetailInfo.getAjustFlag() > 0) {
                    if (bigDecimal.compareTo(delaydetailInfo.getScheduledReceiptQty().subtract(delaydetailInfo.getAjustQty())) > 0) {
                        Object var6_10 = null;
                    } else {
                        BigDecimal bigDecimal3 = delaydetailInfo.getScheduledReceiptQty().subtract(delaydetailInfo.getAjustQty()).subtract(bigDecimal);
                    }
                }
                delaydetailInfo.setNextajustFlag(3);
            }
            return var6_14;
        } else {
            BigDecimal bigDecimal = surplusQty;
            if (delayPeriod - period <= this.runParam.getRunLog().getPlanDefined().getTolerOfDisplacemt()) {
                delaydetailInfo.setNextajustFlag(5);
                return var6_14;
            } else {
                delaydetailInfo.setNextajustFlag(3);
            }
        }
        return var6_14;
    }

    protected void afterAjust(PMRPMaterialStatisticsInfo materialStatisticsInfo, PMRPDetailInfo rdetailInfo, PMRPDetailInfo adetailInfo, BigDecimal aQty) throws PMRPException, BOSException {
        if (aQty.add(adetailInfo.getAjustQty()).compareTo(adetailInfo.getScheduledReceiptQty()) < 0) {
            PMRPDetailInfo info = (PMRPDetailInfo)adetailInfo.clone();
            info.setID(BOSUuid.create((String)"F94043EF").toString());
            info.setPeriod(rdetailInfo.getPeriod());
            info.setSperiod(adetailInfo.getPeriod());
            info.setRePlanDATE(rdetailInfo.getBillDate());
            info.setSID(adetailInfo.getID());
            info.setScheduledReceiptQty(aQty);
            info.setAjustQty(MRPConstant.ZERO);
            info.setAjustFlag(adetailInfo.getNextajustFlag());
            info.setPriority(99999);
            adetailInfo.setAjustQty(adetailInfo.getAjustQty().add(aQty));
            adetailInfo.setSurplusQty(adetailInfo.getSurplusQty().subtract(aQty));
            if (info.getAjustFlag() == 2 && this.runParam.getUtilManager().getExceptionUtil().setException(info, 60)) {
                this.statisticException(info);
            }
            if (adetailInfo.getSID() == null) {
                adetailInfo.setAjustFlag(0);
            }
            this.dataSaver.addInsertList(info);
        } else {
            adetailInfo.setSID(adetailInfo.getID());
            adetailInfo.setAjustFlag(adetailInfo.getNextajustFlag());
            adetailInfo.setSperiod(adetailInfo.getPeriod());
            adetailInfo.setPeriod(rdetailInfo.getPeriod());
            adetailInfo.setRePlanDATE(rdetailInfo.getBillDate());
            adetailInfo.setSurplusQty(MRPConstant.ZERO);
            if (adetailInfo.getAjustFlag() == 2 && this.runParam.getUtilManager().getExceptionUtil().setException(adetailInfo, 60)) {
                this.statisticException(adetailInfo);
            }
            this.detailDataUtil.clearDetailInMemory(adetailInfo);
        }
        ArrayList<PMRPDetailInfo> updateDatas = new ArrayList<PMRPDetailInfo>();
        updateDatas.add(adetailInfo);
        this.dataSaver.executeUpdate(updateDatas);
    }

    private BigDecimal afterDelayCancle(PMRPMaterialDataInfo materialDataInfo, List<PMRPMaterialStatisticsInfo> delayPeriods, PMRPDetailInfo detailInfo, BigDecimal delayQty) throws BOSException, PMRPException {
        BigDecimal actualDelayQtySum = MRPConstant.ZERO;
        PMRPMaterialStatisticsInfo delayS = null;
        int size = delayPeriods.size();
        Iterator<PMRPMaterialStatisticsInfo> delayPeriodIter = delayPeriods.iterator();
        while (delayPeriodIter.hasNext()) {
            delayS = delayPeriodIter.next();
            BigDecimal pab = delayS.getSQty().add(delayS.getRQty()).add(delayS.getOnHand());
            BigDecimal canDelayQty = this.calcDelayQty(materialDataInfo, detailInfo, delayQty, this.runParam.getAdjustStrategy(detailInfo.getBillType()), delayS.getPeriod());
            if (canDelayQty == null) {
                return actualDelayQtySum;
            }
            BigDecimal reqNeedQty = this.getBatchAjustQty4Cancel(materialDataInfo, detailInfo, pab.abs());
            BigDecimal minQty = MRPConstant.ZERO;
            if (this.runParam.getAdjustStrategy(detailInfo.getBillType()).getValue() == 10 && canDelayQty.compareTo(detailInfo.getScheduledReceiptQty()) == 0 && detailInfo.getNextajustFlag() != 5) {
                minQty = canDelayQty;
                reqNeedQty = canDelayQty;
                if (detailInfo.getNextajustFlag() == 3 && this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 61)) {
                    this.statisticException(materialDataInfo);
                }
                if (detailInfo.getSperiod() <= 0) {
                    detailInfo.setSperiod(detailInfo.getPeriod());
                }
                detailInfo.setPeriod(delayS.getPeriod());
                detailInfo.setRePlanDATE(null);
                detailInfo.setSID(detailInfo.getID());
                detailInfo.setAjustFlag(detailInfo.getNextajustFlag());
                detailInfo.setAjustQty(MRPConstant.ZERO);
            } else {
                minQty = detailInfo.getNextajustFlag() == 5 ? (pab.abs().compareTo(canDelayQty) > 0 ? canDelayQty : pab.abs()) : (reqNeedQty.compareTo(canDelayQty) > 0 ? canDelayQty : reqNeedQty);
                PMRPDetailInfo info = (PMRPDetailInfo)detailInfo.clone();
                info.setID(BOSUuid.create((String)"F94043EF").toString());
                if (info.getSperiod() <= 0) {
                    info.setSperiod(info.getPeriod());
                }
                info.setPeriod(delayS.getPeriod());
                info.setRePlanDATE(null);
                info.setSID(detailInfo.getID());
                info.setScheduledReceiptQty(minQty);
                info.setAjustQty(MRPConstant.ZERO);
                if (detailInfo.getNextajustFlag() == 3 && this.runParam.getUtilManager().getExceptionUtil().setException(info, 61)) {
                    this.statisticException(materialDataInfo);
                }
                info.setPriority(99999);
                info.setAjustFlag(detailInfo.getNextajustFlag());
                if (detailInfo.getSID() == null) {
                    detailInfo.setAjustFlag(0);
                }
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(minQty));
                this.dataSaver.addInsertList(info);
            }
            delayS.setSQty(delayS.getSQty().add(minQty));
            this.dataSaver.addUpdateList(detailInfo);
            this.dataSaver.addDUpdateList(delayS);
            actualDelayQtySum = actualDelayQtySum.add(minQty);
            BigDecimal periodAvailableQty = delayS.getRQty().add(delayS.getSQty()).add(delayS.getOnHand());
            if (periodAvailableQty.compareTo(MRPConstant.ZERO) >= 0) {
                delayPeriodIter.remove();
            }
            if ((delayQty = delayQty.subtract(minQty)).compareTo(MRPConstant.ZERO) > 0) continue;
            return actualDelayQtySum;
        }
        if (delayQty.compareTo(MRPConstant.ZERO) > 0 || size == 0) {
            actualDelayQtySum = actualDelayQtySum.add(this.cancelBill(materialDataInfo, detailInfo, delayQty));
        }
        return actualDelayQtySum;
    }

    protected BigDecimal cancelBill(PMRPMaterialDataInfo materialDataInfo, PMRPDetailInfo detailInfo, BigDecimal delayQty) throws BOSException, PMRPException {
        BigDecimal actualDelayQtySum = MRPConstant.ZERO;
        BigDecimal needDelayQty = this.calcCancelQty(materialDataInfo, detailInfo, delayQty);
        if (!(needDelayQty.compareTo(MRPConstant.ZERO) <= 0 || this.runParam.getAdjustStrategy(detailInfo.getBillType()).equals(AdjustStrategyEnum.WHOLE_ADJUST) && needDelayQty.compareTo(detailInfo.getScheduledReceiptQty()) < 0)) {
            if (detailInfo.getAjustQty().compareTo(MRPConstant.ZERO) > 0) {
                PMRPDetailInfo info = (PMRPDetailInfo)detailInfo.clone();
                info.setID(BOSUuid.create((String)"F94043EF").toString());
                if (info.getSperiod() <= 0) {
                    info.setSperiod(info.getPeriod());
                }
                info.setPeriod(this.runParam.getDateManager().getEndDate(detailInfo.getOrgUnitID()).getWorkDaySeqID());
                if (this.runParam.getUtilManager().getExceptionUtil().setException(info, 62)) {
                    this.statisticException(materialDataInfo);
                }
                info.setRePlanDATE(null);
                info.setSID(detailInfo.getID());
                info.setAjustQty(MRPConstant.ZERO);
                info.setScheduledReceiptQty(MRPConstant.ZERO);
                info.setNetReqQty(needDelayQty);
                info.setAjustFlag(4);
                info.setPriority(99999);
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(needDelayQty));
                this.dataSaver.addInsertList(info);
            } else {
                detailInfo.setAjustFlag(4);
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(needDelayQty));
                detailInfo.setNetReqQty(needDelayQty);
                if (this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 62)) {
                    this.statisticException(materialDataInfo);
                }
                if (detailInfo.getSperiod() <= 0) {
                    detailInfo.setSperiod(detailInfo.getPeriod());
                }
                detailInfo.setPeriod(this.runParam.getDateManager().getEndDate(detailInfo.getOrgUnitID()).getWorkDaySeqID());
                detailInfo.setSID(detailInfo.getID());
            }
            actualDelayQtySum = actualDelayQtySum.add(needDelayQty);
            this.dataSaver.addUpdateList(detailInfo);
        }
        return actualDelayQtySum;
    }

    protected BigDecimal calcCancelQty(PMRPMaterialDataInfo materialDataInfo, PMRPDetailInfo detailInfo, BigDecimal delayQty) {
        BigDecimal remainQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
        delayQty = this.getBatchAjustQty4Cancel(materialDataInfo, detailInfo, remainQty.subtract(delayQty));
        delayQty = remainQty.subtract(delayQty);
        return delayQty;
    }

    protected PMRPDetailInfo createPlanOrder(PMRPMaterialDataInfo materialDataInfo, BigDecimal pab_t_1, BigDecimal avaliableSupply, PMRPDate orderDate, PMRPDate replanDate, PMRPDetailInfo theLineInfo, boolean isMergeSign) throws PMRPException, BOSException {
        PMRPDetailInfo orderLineInfo = new PMRPDetailInfo();
        materialDataInfo.setIsNewOrder(1);
        orderLineInfo.setID(BOSUuid.create((String)"F94043EF").toString());
        orderLineInfo.setMaterialID(materialDataInfo.getMaterialID());
        orderLineInfo.setPlanningMode(materialDataInfo.getPlanningMode());
        orderLineInfo.setMrpClassify(PMRPClassifyEnum.Supply);
        orderLineInfo.setMrpItem(PMRPElementEnum.S_PlannedOrder);
        orderLineInfo.setBillSeqNo(250);
        orderLineInfo.setParentBomID(theLineInfo.getParentBomID());
        orderLineInfo.setBillType(Constants.PRMPPlannedOrderBizTypeID);
        PMRPBillParamInfo info = this.runParam.getBillParamMap().get(Constants.PRMPPlannedOrderBizTypeID);
        orderLineInfo.setPriority(info.getPriority());
        orderLineInfo.setBillID(BOSUuid.create((String)Constants.BosType.MRP_PLAN_ORDER).toString());
        orderLineInfo.setRePlanDATE(replanDate);
        orderLineInfo.setNewOrder(true);
        orderLineInfo.setBaseStatus(2);
        String orderNumber = this.getOrderNumber(theLineInfo.getSupplyStorageOrgUnitID());
        orderLineInfo.setBillNumber(orderNumber == null ? orderLineInfo.getBillID() : orderNumber);
        orderLineInfo.setAvaliableQty(avaliableSupply);
        orderLineInfo.setNetReqQty(avaliableSupply);
        orderLineInfo.setCanNotThrow(theLineInfo.isCanNotThrow());
        orderLineInfo.setPlannedQty(theLineInfo.getPlannedQty());
        orderLineInfo.setDirectTransport(theLineInfo.isDirectTransport());
        orderLineInfo.setMaterialAttr(materialDataInfo.getMaterialAttr());
        orderLineInfo.setBaseUnitID(materialDataInfo.getBaseUnitID());
        orderLineInfo.setProdUnitID(materialDataInfo.getProdUnitID());
        orderLineInfo.setManufactureDepartmentId(materialDataInfo.getManufactureDepartmentId());
        orderLineInfo.setPlanOrgUnitId(this.runParam.getRunLog().getPlanDefined().getPlanOrgUnit().getId().toString());
        orderLineInfo.setProductTranTypeID(materialDataInfo.getProductTranTypeID());
        orderLineInfo.setConvertRate(materialDataInfo.getConvertRate());
        orderLineInfo.setPlanner(materialDataInfo.getPlanner());
        orderLineInfo.setLowsetCode(materialDataInfo.getLowsetCode());
        orderLineInfo.setPeriod(theLineInfo.getPeriod());
        PMRPDate endDate = null;
        PMRPDate beginDate = null;
        materialDataInfo.setIsNewOrder(1);
        if (materialDataInfo.getMaterialNumber().equals("YCX_D")) {
            // empty if block
        }
        int recvleadTime = 0;
        recvleadTime = -1 * materialDataInfo.getReceiveLeadTime();
        int mAttr = theLineInfo.getMaterialAttr();
        String orgId = mAttr == 10030 ? theLineInfo.getSupplyStorageOrgUnitID() : (mAttr == 10040 ? theLineInfo.getSupplyStorageOrgUnitID() : theLineInfo.getOrgUnitID());
        PMRPCalendarUtil cUtil = this.runParam.getUtilManager().getCalendarUtil(orgId);
        if (theLineInfo.getNeedBeginDate() != null) {
            int seqID = cUtil.getWorkDaySeq(theLineInfo.getBillDate().getDate().getTime(), false);
            theLineInfo.getBillDate().setWorkDaySeqID(seqID);
            orderDate = cUtil.getDate(theLineInfo.getBillDate().add(this.runParam, materialDataInfo.getReceiveLeadTime()).getWorkDaySeqID());
            endDate = cUtil.getDate(theLineInfo.getBillDate().add(this.runParam, 0).getWorkDaySeqID());
            beginDate = theLineInfo.getNeedBeginDate();
        } else {
            endDate = orderDate.add(this.runParam, recvleadTime);
            endDate = cUtil.getDate(endDate.getWorkDaySeqID());
            endDate = cUtil.getDate(endDate.getDate().getTime(), true);
            int prodleadTime = -1 * materialDataInfo.getProdLeadTime();
            prodleadTime = this.leadTimeTypeHandle(materialDataInfo, orderLineInfo, prodleadTime);
            beginDate = endDate.add(this.runParam, prodleadTime);
            beginDate = cUtil.getDate(beginDate.getWorkDaySeqID());
            beginDate = cUtil.getDate(beginDate.getDate().getTime(), true);
        }
        orderLineInfo.setBillDate(orderDate);
        orderLineInfo.setPlanEndDate(endDate);
        orderLineInfo.setPlanBeginDate(beginDate);
        orderLineInfo.setTotalLine(isMergeSign);
        String supplyStorageOrgUnitID = materialDataInfo.getSupplyStorageOrgUnitID();
        String OrgUnitID = materialDataInfo.getSupplyStorageOrgUnitID();
        orderLineInfo.setIsDeaultTNO(theLineInfo.getIsDeaultTNO());
        orderLineInfo.setBProjectID(theLineInfo.getBProjectID());
        orderLineInfo.setBTrackID(theLineInfo.getBTrackID());
        orderLineInfo.setProjectID(theLineInfo.getProjectID());
        orderLineInfo.setTrackID(theLineInfo.getTrackID());
        orderLineInfo.setProjectNumber(theLineInfo.getProjectNumber());
        orderLineInfo.setTrackNumber(theLineInfo.getTrackNumber());
        orderLineInfo.setBProjectNumber(theLineInfo.getBProjectNumber());
        orderLineInfo.setBTrackNumber(theLineInfo.getBTrackNumber());
        orderLineInfo.setBomID(theLineInfo.getBomID());
        orderLineInfo.setYield(theLineInfo.getYield());
        orderLineInfo.setYield4PlanOrder(theLineInfo.getYield4PlanOrder());
        BigDecimal qty = orderLineInfo.getPlannedQty().divide(materialDataInfo.getConvertRate(), materialDataInfo.getProdQtyPrc(), 2);
        orderLineInfo.setPlanOrderQty(qty);
        BigDecimal yield4PlanOrder = orderLineInfo.getYield4PlanOrder().divide(new BigDecimal("100.00"), 4, 3);
        BigDecimal finalProductsQty = qty.multiply(yield4PlanOrder);
        orderLineInfo.setFinalProductsQty(finalProductsQty.setScale(materialDataInfo.getProdQtyPrc(), 3));
        orderLineInfo.setBomType(theLineInfo.getBomType());
        if (!isMergeSign) {
            orderLineInfo.setSaleOrderID(theLineInfo.getSaleOrderID());
            orderLineInfo.setSaleOrderEntryID(theLineInfo.getSaleOrderEntryID());
            orderLineInfo.setSaleOrderNumber(theLineInfo.getSaleOrderNumber());
            orderLineInfo.setSaleOrderEntryNum(theLineInfo.getSaleOrderEntryNum());
            if (theLineInfo.getMrpItem().equals((Object)PMRPElementEnum.R_SID) || theLineInfo.getMrpItem().equals((Object)PMRPElementEnum.R_SID)) {
                orderLineInfo.setSrcBillID(theLineInfo.getSrcBillID());
                orderLineInfo.setSrcBillType(theLineInfo.getSrcBillType());
                orderLineInfo.setSrcBillEntryID(theLineInfo.getSrcBillEntryID());
                orderLineInfo.setSrcBillNumber(theLineInfo.getSrcBillNumber());
                orderLineInfo.setSrcBillRowSeq(theLineInfo.getBillRowSeq());
            } else {
                orderLineInfo.setSrcBillID(theLineInfo.getBillID());
                orderLineInfo.setSrcBillType(theLineInfo.getBillType());
                orderLineInfo.setSrcBillNumber(theLineInfo.getBillNumber());
                orderLineInfo.setSrcBillEntryID(theLineInfo.getBillEntryID());
            }
            orderLineInfo.setRequireMentID(theLineInfo.getRequireMentID());
            if (theLineInfo.getSupplyStorageOrgUnitID() != null && theLineInfo.getMrpItem().equals((Object)PMRPElementEnum.R_PlannedOrder)) {
                supplyStorageOrgUnitID = theLineInfo.getSupplyStorageOrgUnitID();
            }
            if (theLineInfo.getOrgUnitID() != null && theLineInfo.getMrpItem().equals((Object)PMRPElementEnum.R_PlannedOrder)) {
                OrgUnitID = theLineInfo.getOrgUnitID();
            }
        }
        orderLineInfo.setSupplyStorageOrgUnitID(supplyStorageOrgUnitID);
        orderLineInfo.setOrgUnitID(OrgUnitID);
        orderLineInfo.setScheduledReceiptQty(avaliableSupply);
        orderLineInfo.setSsrQty(avaliableSupply);
        if (theLineInfo.getException6() == 63 && this.runParam.getUtilManager().getExceptionUtil().setException(orderLineInfo, theLineInfo.getException6())) {
            this.statisticException(materialDataInfo);
        }
        orderLineInfo.setBaseQtyPrc(materialDataInfo.getBaseQtyPrc());
        orderLineInfo.setProdQtyPrc(materialDataInfo.getProdQtyPrc());
        this.genExceptions(materialDataInfo, orderLineInfo, pab_t_1.add(orderLineInfo.getScheduledReceiptQty()));
        this.handleException64(orderLineInfo);
        orderLineInfo.setMrpSeq(PMRPAjustMent.getMRPSeq(orderLineInfo));
        orderLineInfo.setSourceRemark(EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0099") + this.runParam.getLevel());
        orderLineInfo.setProjectplanmodelid(theLineInfo.getProjectplanmodelid());
        this.dealDetailPUBProjTrack(orderLineInfo, materialDataInfo);
        this.dataSaver.addInsertList(orderLineInfo);
        this.dataSaver.addMrpPlanOrder(orderLineInfo);
        this.runParam.getCounter().generateOrder();
        return orderLineInfo;
    }

    public static String getMRPSeq(PMRPDetailInfo info) {
        if (info.getMrpItem().equals((Object)PMRPElementEnum.I_CurInv)) {
            return INV_SEQ;
        }
        if (info.getMrpItem().equals((Object)PMRPElementEnum.I_SafeInv)) {
            return SAFESTOCK_SEQ;
        }
        if (info.getMrpItem().equals((Object)PMRPElementEnum.I_DivertInv)) {
            return DivertInv_SEQ;
        }
        if (info.getMrpItem().equals((Object)PMRPElementEnum.UNDISTRIBUTE_INV)) {
            return UNDISTRIBUTE_INV_SEQ;
        }
        if (info.getMrpItem().equals((Object)PMRPElementEnum.DISTRIBUTE_INV)) {
            return DISTRIBUTE_INV_SEQ;
        }
        StringBuffer str = new StringBuffer();
        if (info.getBillDate() != null && info.getBillDate().getDate() != null) {
            str.append(info.getPeriod() + 10000);
            int classify = info.getMrpClassify().getValue();
            str.append(classify);
            if (classify == 30) {
                str.append(info.isCanNotThrow() ? 1 : 0);
            }
            str.append(info.getPriority());
            str.append(info.getBillNumber());
            if (classify == 20) {
                str.append(info.getBillRowSeq() + 10000);
            }
        }
        return str.toString();
    }

    protected void handleException64(PMRPDetailInfo orderLineInfo) throws BOSException, PMRPException {
        PMRPDate billDate = orderLineInfo.getBillDate();
        PMRPDate beginDate = orderLineInfo.getPlanBeginDate();
        PMRPDate endDate = orderLineInfo.getPlanEndDate();
        boolean hasExe64 = false;
        StringBuffer msg = new StringBuffer();
        String suggestMsg = null;
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        if (beginDate.getInCalendar() != 0) {
            if (suggestMsg == null) {
                suggestMsg = MRPResource.getString((Context)this.runParam.getEasCtx(), (String)"SUGGEST_CHANGED");
            }
            msg.append(MRPResource.getString((Context)this.runParam.getEasCtx(), (String)"SUGGEST_CHANGED_BEGINDATE"));
            msg.append(dtformat.format(beginDate.getSourceDate()));
            hasExe64 = true;
        }
        if (endDate.getInCalendar() != 0) {
            msg.append(" ");
            if (suggestMsg == null) {
                suggestMsg = MRPResource.getString((Context)this.runParam.getEasCtx(), (String)"SUGGEST_CHANGED");
            }
            msg.append(MRPResource.getString((Context)this.runParam.getEasCtx(), (String)"SUGGEST_CHANGED_ENDDATE"));
            msg.append(dtformat.format(endDate.getSourceDate()));
            hasExe64 = true;
        }
        if (billDate.getInCalendar() != 0) {
            msg.append(" ");
            if (suggestMsg == null) {
                suggestMsg = MRPResource.getString((Context)this.runParam.getEasCtx(), (String)"SUGGEST_CHANGED");
            }
            msg.append(MRPResource.getString((Context)this.runParam.getEasCtx(), (String)"SUGGEST_CHANGED_BILLDATE"));
            msg.append(dtformat.format(billDate.getSourceDate()));
            hasExe64 = true;
        }
        if (hasExe64) {
            PMRPDetailInfo supplyDetailInfoCopy = this.splitBill(orderLineInfo);
            if (this.runParam.getUtilManager().getExceptionUtil().setException(supplyDetailInfoCopy, 64)) {
                this.statisticException(orderLineInfo);
            }
            orderLineInfo.setDescription64(MessageFormat.format(suggestMsg, msg));
        }
    }

    private PMRPDetailInfo splitBill(PMRPDetailInfo splitedOrderInfo) throws PMRPException, BOSException {
        PMRPDetailInfo supplyDetailInfoCopy = (PMRPDetailInfo)splitedOrderInfo.clone();
        supplyDetailInfoCopy.setID(BOSUuid.create((String)"F94043EF").toString());
        supplyDetailInfoCopy.setRePlanDATE(null);
        supplyDetailInfoCopy.setSID(splitedOrderInfo.getID());
        supplyDetailInfoCopy.setMrpSeq(PMRPAjustMent.getMRPSeq(supplyDetailInfoCopy));
        supplyDetailInfoCopy.setNewOrder(false);
        supplyDetailInfoCopy.setAjustFlag(-1);
        supplyDetailInfoCopy.clearException();
        this.dataSaver.addInsertList(supplyDetailInfoCopy);
        return supplyDetailInfoCopy;
    }

    private int leadTimeTypeHandle(PMRPMaterialDataInfo materialDataInfo, PMRPDetailInfo orderLineInfo, int leadTime) {
        if (MaterialLeadTimeTypeEnum.CHANGEBATCHTYPE.equals((Object)materialDataInfo.getLeadTimeType())) {
            BigDecimal plannedQty = orderLineInfo.getPlannedQty().divide(materialDataInfo.getConvertRate(), materialDataInfo.getBaseQtyPrc(), 2);
            int changeBatch = materialDataInfo.getChangeBatch();
            if (changeBatch == 0) {
                changeBatch = 1;
            }
            leadTime -= plannedQty.multiply(new BigDecimal(materialDataInfo.getChangeLeadTime())).divide(new BigDecimal(changeBatch), 0, 2).intValue();
        }
        leadTime = leadTime - materialDataInfo.getForwardProcessTime() - materialDataInfo.getBackwardProcessTime();
        return leadTime;
    }

    protected String getOrderNumber(String orgUnitID) throws PMRPException, BOSException {
        return this.runParam.getUtilManager().getPoUtil().getNumber(orgUnitID);
    }

    protected PMRPDate getMRPDate(Calendar theDate, String productOrgUnitID) throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        PMRPDate PMRPDate2 = new PMRPDate();
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.FID,t0.FWeekSeq,t0.FMonthSeq,t0.FWorkDate,t0.FWorkDateSeq ").append(" from ").append(manager.getTempTableDefine(FactoryCalendarTableDefine.class).getTableName()).append(" t0").append(" where t0.FSWorkDate =  '").append(MRPUtil.dateToString((java.util.Date)theDate.getTime(), (String)"yyyy-MM-dd")).append("' and t0.FstorageOrgUnitID = '").append(productOrgUnitID).append("'");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString());
        try {
            if (rs != null && rs.next()) {
                PMRPDate2.setCalendarID(rs.getString("FID"));
                Date wDate = rs.getDate("FWorkDate");
                Calendar calDate = Calendar.getInstance();
                calDate.setTimeInMillis(wDate.getTime());
                PMRPDate2.setDate(calDate);
                PMRPDate2.setWorkDaySeqID(rs.getInt("FWorkDateSeq"));
                PMRPDate2.setWeekSeqID(rs.getInt("FWeekSeq"));
                PMRPDate2.setMonthSeqID(rs.getInt("FMonthSeq"));
            } else {
                PMRPDate2 = this.runParam.getDateManager().getBeginDate(productOrgUnitID);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return PMRPDate2;
    }

    private BigDecimal getBatchAjustQty(PMRPMaterialDataInfo materialdataInfo, PMRPDetailInfo detailInfo, BigDecimal aQty) {
        boolean isDelay = true;
        BigDecimal surplusQty = null;
        if (aQty.compareTo(MRPConstant.ZERO) < 0) {
            isDelay = false;
            surplusQty = detailInfo.getSurplusQty();
        } else {
            surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
        }
        BigDecimal batchQty = aQty.abs();
        if (batchQty.compareTo(surplusQty) > 0) {
            batchQty = surplusQty;
        }
        switch (materialdataInfo.getBatchPolicy()) {
            case 1: {
                if (materialdataInfo.getFixationBatchQty() == null || materialdataInfo.getFixationBatchQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batch = batchQty.divide(materialdataInfo.getFixationBatchQty(), 0, 2);
                batchQty = batch.multiply(materialdataInfo.getFixationBatchQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                if (isDelay) {
                    if (batchQty.compareTo(aQty) <= 0 || detailInfo.getAjustFlag() > 0) break;
                    batchQty = batchQty.subtract(materialdataInfo.getFixationBatchQty());
                    break;
                }
                if (batchQty.compareTo(surplusQty) <= 0) break;
                batchQty = batchQty.subtract(materialdataInfo.getFixationBatchQty());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (materialdataInfo.getMinBatchQty() != null && batchQty.compareTo(materialdataInfo.getMinBatchQty()) < 0) {
                    batchQty = materialdataInfo.getMinBatchQty();
                    if (isDelay) {
                        if (batchQty.compareTo(aQty) > 0 && detailInfo.getAjustFlag() <= 0) {
                            batchQty = batchQty.subtract(materialdataInfo.getMinBatchQty());
                        }
                    } else if (batchQty.compareTo(surplusQty) > 0) {
                        batchQty = batchQty.subtract(materialdataInfo.getMinBatchQty());
                    }
                }
                if (materialdataInfo.getRoundUpMultipleQty() == null || materialdataInfo.getRoundUpMultipleQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batchM = batchQty.divide(materialdataInfo.getRoundUpMultipleQty(), 0, 2);
                batchQty = batchM.multiply(materialdataInfo.getRoundUpMultipleQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                if (isDelay) {
                    if (batchQty.compareTo(aQty) <= 0 || detailInfo.getAjustFlag() > 0) break;
                    batchQty = batchQty.subtract(materialdataInfo.getRoundUpMultipleQty());
                    break;
                }
                if (batchQty.compareTo(surplusQty) <= 0) break;
                batchQty = batchQty.subtract(materialdataInfo.getRoundUpMultipleQty());
            }
        }
        if (batchQty.compareTo(MRPConstant.ZERO) <= 0) {
            batchQty = null;
        }
        return batchQty;
    }

    private BigDecimal getBatchAjustQty4Cancel(PMRPMaterialDataInfo materialdataInfo, PMRPDetailInfo detailInfo, BigDecimal aQty) {
        if (aQty.compareTo(MRPConstant.ZERO) <= 0) {
            return MRPConstant.ZERO;
        }
        BigDecimal surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
        BigDecimal batchQty = aQty.abs();
        if (batchQty.compareTo(surplusQty) > 0) {
            batchQty = surplusQty;
        }
        if (!Constants.MRPConfig.ISCONSIDERBATCH) {
            return batchQty;
        }
        switch (materialdataInfo.getBatchPolicy()) {
            case 1: {
                if (materialdataInfo.getFixationBatchQty() == null || materialdataInfo.getFixationBatchQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batch = batchQty.divide(materialdataInfo.getFixationBatchQty(), 0, 2);
                batchQty = batch.multiply(materialdataInfo.getFixationBatchQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (materialdataInfo.getMinBatchQty() != null && batchQty.compareTo(materialdataInfo.getMinBatchQty()) < 0) {
                    batchQty = materialdataInfo.getMinBatchQty();
                }
                if (materialdataInfo.getRoundUpMultipleQty() == null || materialdataInfo.getRoundUpMultipleQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batchM = batchQty.divide(materialdataInfo.getRoundUpMultipleQty(), 0, 2);
                batchQty = batchM.multiply(materialdataInfo.getRoundUpMultipleQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
            }
        }
        return batchQty;
    }

    protected void calcProjectAvailableBalance(boolean isYieldproduct, PMRPDetailInfo detailInfo, PMRPMaterialDataInfo materialDataInfo) {
        BigDecimal plannedQty = detailInfo.getPlannedQty();
        if (isYieldproduct && plannedQty.compareTo(MRPConstant.ZERO) > 0) {
            BigDecimal yieldRate = detailInfo.getYield();
            if (yieldRate == null) {
                yieldRate = materialDataInfo.getYield();
            }
            if ((yieldRate = yieldRate.divide(new BigDecimal(100), 4, 2)).compareTo(MRPConstant.ZERO) > 0) {
                plannedQty = plannedQty.multiply(yieldRate).setScale(materialDataInfo.getBaseQtyPrc(), 2);
            }
        }
        detailInfo.setScheduledReceiptQty(plannedQty);
        detailInfo.setSsrQty(plannedQty);
    }

    private int batchGenExceptions(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo materialStatisticsInfo, List<PMRPDetailInfo> datas) throws PMRPException, BOSException {
        PMRPDetailInfo detailInfo = null;
        BigDecimal pab_t_1 = materialStatisticsInfo.getOnHand();
        if (this.preQty.get(this.key) != null) {
            pab_t_1 = pab_t_1.add(this.preQty.get(this.key));
        }
        Iterator<PMRPDetailInfo> iterator = datas.iterator();
        while (iterator.hasNext()) {
            detailInfo = iterator.next();
            if (!PMRPClassifyEnum.Supply.equals((Object)detailInfo.getMrpClassify())) {
                return 0;
            }
            iterator.remove();
            pab_t_1 = pab_t_1.add(detailInfo.getScheduledReceiptQty()).subtract(detailInfo.getAjustQty());
            if (detailInfo.getAjustFlag() == 5 && detailInfo.getAjustFlag() == 3) continue;
            this.genExceptions(materialDataInfo, detailInfo, pab_t_1);
            if (detailInfo.getAjustFlag() > 0) continue;
            this.dataSaver.addUpdateList(detailInfo);
        }
        return 0;
    }

    protected void genExceptions(PMRPMaterialDataInfo materialDataInfo, PMRPDetailInfo detailInfo, BigDecimal pab_t_1) throws PMRPException, BOSException {
        boolean is10020;
        boolean hasException = false;
        PMRPDate planDate = new PMRPDate();
        Calendar curDate = MRPUtil.createCalendar();
        curDate.setTime(this.runParam.getDateManager().getPlanDate(detailInfo.getOrgUnitID()).getDate().getTime());
        curDate.set(11, 0);
        curDate.set(12, 0);
        curDate.set(13, 0);
        curDate.set(14, 0);
        planDate.setDate(curDate);
        if (detailInfo.getBillDate() != null) {
            detailInfo.setDelay(detailInfo.getBillDate().before(this.runParam.getDateManager().getPlanDate(detailInfo.getOrgUnitID())));
        }
        PMRPDate theDate = null;
        switch (detailInfo.getMrpItem().getValue()) {
            case 200: 
            case 205: 
            case 250: {
                theDate = detailInfo.getPlanBeginDate();
                break;
            }
            case 210: 
            case 220: 
            case 240: 
            case 270: {
                theDate = detailInfo.getBillDate();
            }
        }
        if (theDate != null && theDate.before(planDate)) {
            if (this.runParam.getUtilManager().getExceptions().get(String.valueOf(11)).booleanValue() && !detailInfo.isNewOrder() && this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 11)) {
                hasException = true;
            }
            if (detailInfo.isNewOrder() && this.runParam.getUtilManager().getExceptions().get(String.valueOf(10)).booleanValue() && this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 10)) {
                hasException = true;
            }
        }
        theDate = null;
        switch (detailInfo.getMrpItem().getValue()) {
            case 200: 
            case 205: 
            case 250: {
                theDate = detailInfo.getPlanEndDate();
                break;
            }
            case 210: 
            case 220: 
            case 270: {
                theDate = detailInfo.getBillDate();
            }
        }
        if (theDate != null && theDate.before(planDate)) {
            if (this.runParam.getUtilManager().getExceptions().get(String.valueOf(21)).booleanValue() && !detailInfo.isNewOrder() && this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 21)) {
                hasException = true;
            }
            if (detailInfo.isNewOrder() && this.runParam.getUtilManager().getExceptions().get(String.valueOf(20)).booleanValue() && this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 20)) {
                hasException = true;
            }
        }
        String planStrategy = materialDataInfo.getPlanStrategy();
        if (materialDataInfo.getQtyMax().compareTo(MRPConstant.ZERO) >= 0) {
            BigDecimal p = pab_t_1;
            if (planStrategy != null && ("NUnM+gEcEADgAA3cwKgL09g0uEU=".equals(planStrategy) || "NUnM+gEcEADgAA3gwKgL09g0uEU=".equals(planStrategy) || "qAYfaBzUrmLgQKjAYj0f3dg0uEU=".equals(planStrategy))) {
                p = p.add(materialDataInfo.getSafeStockQty());
            }
            if (p.compareTo(materialDataInfo.getQtyMax()) > 0 && this.runParam.getUtilManager().getExceptions().get(String.valueOf(40)).booleanValue() && detailInfo.getAjustFlag() == 0) {
                PMRPDetailInfo stockDetailInfo = new PMRPDetailInfo();
                stockDetailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, detailInfo.getProjectNumber(), detailInfo.getTrackNumber()));
                if (this.runParam.getUtilManager().getExceptionUtil().setException(stockDetailInfo, 40)) {
                    hasException = true;
                }
                this.dataSaver.addUpdateStockException(stockDetailInfo);
            }
        }
        boolean is10030 = materialDataInfo.getMaterialAttr() == 10030;
        boolean bl = is10020 = materialDataInfo.getMaterialAttr() == 10020;
        if ((is10030 || is10020) && detailInfo.isNewOrder() && detailInfo.getBomID() == null) {
            if (this.runParam.getRunLog().getPlanDefined().getBomType() == BOMTypeEnum.MfgBOM) {
                if (this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 32)) {
                    hasException = true;
                }
            } else if (this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 33)) {
                hasException = true;
            }
        }
        if (detailInfo.isNewOrder() && this.runParam.getUtilManager().getExceptions().get(String.valueOf(70)).booleanValue() && this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 70)) {
            hasException = true;
        }
        if (detailInfo.isNewOrder() && detailInfo.getException6() == 63) {
            hasException = true;
        }
        if (hasException && !detailInfo.isNewOrder()) {
            this.dataSaver.addUpdateList(detailInfo);
        }
        if (hasException) {
            this.statisticException(materialDataInfo);
        }
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    public Object call() throws Exception {
        return this.execute(this.runParam);
    }

    private void advanceForStock(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, int period) throws PMRPException, BOSException {
        PMRPMaterialStatisticsInfo info = (PMRPMaterialStatisticsInfo)statisticsInfo.clone();
        info.setPeriod(this.runParam.getDateManager().getPlanDate(materialDataInfo.getOrgUnitId()).getPeriod());
        info.setSQty(MRPConstant.ZERO);
        info.setRQty(MRPConstant.ZERO);
        info.setPreQty(MRPConstant.ZERO);
        info.setOnHand(MRPConstant.ZERO);
        info.setProjectNumber(statisticsInfo.getProjectNumber());
        info.setTrackNumber(statisticsInfo.getTrackNumber());
        PMRPDetailInfo detailInfo = this.createStockReqDataInfo(materialDataInfo, info);
        if (period >= this.runParam.getDateManager().getPlanDate(materialDataInfo.getOrgUnitId()).getPeriod()) {
            detailInfo.setBillDate(this.runParam.getDateManager().getPlanDate(materialDataInfo.getOrgUnitId()));
        }
        detailInfo.setPeriod(period);
        info.setRQty(detailInfo.getDependentQty());
        BomInfo bom = null;
        try {
            PlanDefinedInfo pd = this.runParam.getRunLog().getPlanDefined();
            BOMTypeEnum bomType = pd.getBomType();
            if (BOMTypeEnum.ProcessBOM.equals((Object)bomType)) {
                String bomfid = PMRPRunFacadeFactory.getLocalInstance(this.runParam.getEasCtx()).getBomByTrcAndPrjID(materialDataInfo.getMaterialID(), statisticsInfo.getProjectId(), statisticsInfo.getTrackNumberId(), statisticsInfo.getSupplyOrgUnitID(), 1);
                if (bomfid != null && !"".equals(bomfid)) {
                    detailInfo.setBomID(bomfid);
                    detailInfo.setYield(new BigDecimal(100));
                    detailInfo.setBomType(0);
                } else {
                    detailInfo.setBomID(null);
                }
            } else {
                String bomfid = PMRPRunFacadeFactory.getLocalInstance(this.runParam.getEasCtx()).getBomByTrcAndPrjID(materialDataInfo.getMaterialID(), statisticsInfo.getProjectId(), statisticsInfo.getTrackNumberId(), statisticsInfo.getSupplyOrgUnitID(), 2);
                if (bomfid != null && !"".equals(bomfid)) {
                    bom = BomFactory.getLocalInstance((Context)this.runParam.getEasCtx()).getBomInfo((IObjectPK)new ObjectUuidPK(bomfid));
                    detailInfo.setBomID(bom.getId().toString());
                    detailInfo.setYield(bom.getYield());
                    detailInfo.setBomType(bom.getBomType().getValue());
                } else {
                    detailInfo.setBomID(null);
                }
            }
        }
        catch (EASBizException e) {
            throw new PMRPException(PMRPException.FIND_BOM_ERROR, e);
        }
        ArrayList<PMRPDetailInfo> detailDatas = new ArrayList<PMRPDetailInfo>();
        detailDatas.add(detailInfo);
        this.advance(materialDataInfo, info, detailDatas, period);
        this.adetail = null;
    }

    private BigDecimal subtractSafeStockQty(PMRPMaterialDataInfo info, PMRPMaterialStatisticsInfo materialStatisticsInfo) throws PMRPException, BOSException {
        String orgUnitID = materialStatisticsInfo.getSupplyOrgUnitID();
        String projectNumber = materialStatisticsInfo.getProjectNumber();
        String trackNumber = materialStatisticsInfo.getTrackNumber();
        BigDecimal toBeUsed = materialStatisticsInfo.getRQty().multiply(new BigDecimal(-1));
        return info.getOnHandQty(this.runParam, materialStatisticsInfo.getMaterialID(), orgUnitID, projectNumber, trackNumber, toBeUsed, this.runParam.getSupplyModel(), false, "1").subtract(info.getSafeStockQty());
    }

    protected void createPlanedorderForStock(List<String> materialList, Map<String, PMRPMaterialDataInfo> unMaterials) throws PMRPException, BOSException {
        List<PMRPMaterialStatisticsInfo> materialDataInfos = PMRPAjustMent.getNoDataProjectNumberAndTrackNumber(this.runParam, materialList);
        if (materialDataInfos.size() == 0) {
            return;
        }
        PMRPDetailInfo theLineInfo = new PMRPDetailInfo();
        theLineInfo.setProjectNumber(null);
        theLineInfo.setProjectID(null);
        theLineInfo.setBProjectNumber(null);
        theLineInfo.setBProjectID(null);
        theLineInfo.setTrackNumber(null);
        theLineInfo.setTrackID(null);
        theLineInfo.setBTrackNumber(null);
        theLineInfo.setBTrackID(null);
        theLineInfo.setMrpItem(PMRPElementEnum.I_CurInv);
        theLineInfo.setMrpClassify(PMRPClassifyEnum.Inventory);
        theLineInfo.setIsDeaultTNO(1);
        BomInfo bom = null;
        boolean hasstockEXP = this.runParam.getUtilManager().getExceptions().get(String.valueOf(41));
        PMRPMaterialStatisticsInfo info = null;
        ExpandInfoCollection expandInfoCollection = new ExpandInfoCollection();
        ArrayList<String> supplyOrgList = new ArrayList<String>();
        for (int i = 0; i < materialDataInfos.size(); ++i) {
            info = materialDataInfos.get(i);
            if (supplyOrgList != null && supplyOrgList.contains(info.getSupplyOrgUnitID())) continue;
            supplyOrgList.add(info.getSupplyOrgUnitID());
        }
        HashMap<String, BomInfo> bomInfoMap = new HashMap<String, BomInfo>();
        PlanDefinedInfo pdInfo = this.runParam.getRunLog().getPlanDefined();
        SelectorItemCollection bomsic = new SelectorItemCollection();
        bomsic.add(new SelectorItemInfo("id"));
        bomsic.add(new SelectorItemInfo("bomType"));
        bomsic.add(new SelectorItemInfo("yield"));
        for (int k = 0; k < supplyOrgList.size(); ++k) {
            String fsupplyOrgUnitID = ((String)supplyOrgList.get(k)).toString();
            expandInfoCollection = new ExpandInfoCollection();
            for (int i = 0; i < materialDataInfos.size(); ++i) {
                info = materialDataInfos.get(i);
                if (!info.getSupplyOrgUnitID().equals(fsupplyOrgUnitID)) continue;
                ExpandInfo expandInfo = new ExpandInfo("MATERIAL");
                expandInfo.setExpandTraceId(info.getId());
                expandInfo.setId(info.getMaterialID());
                expandInfo.setProjectId(info.getProjectId());
                expandInfo.setTrackId(info.getTrackNumberId());
                expandInfoCollection.add(expandInfo);
                try {
                    if (pdInfo.getBomType().equals((Object)BOMTypeEnum.ProcessBOM)) continue;
                    String fbomid = PMRPRunFacadeFactory.getLocalInstance(this.runParam.getEasCtx()).getBomByTrcAndPrjID(expandInfo.getId(), expandInfo.getProjectId(), expandInfo.getTrackId(), fsupplyOrgUnitID, 2);
                    BomInfo bomInfo = BomFactory.getLocalInstance((Context)this.runParam.getEasCtx()).getBomInfo((IObjectPK)new ObjectUuidPK(fbomid), bomsic);
                    bomInfoMap.put(expandInfo.getExpandTraceId(), bomInfo);
                    continue;
                }
                catch (EASBizException e) {
                    throw new PMRPException(PMRPException.FIND_BOM_ERROR, e);
                }
            }
        }
        PMRPMaterialDataInfo materialDataInfo = null;
        for (int i = 0; i < materialDataInfos.size(); ++i) {
            PMRPDetailInfo stockDetailInfo;
            info = materialDataInfos.get(i);
            materialDataInfo = unMaterials.get(info.getMaterialID() + info.getSupplyOrgUnitID());
            String orgUnitID = info.getSupplyOrgUnitID();
            String projectNumber = info.getProjectNumber();
            String trackNumber = info.getTrackNumber();
            BigDecimal toBeUsed = info.getRQty().multiply(new BigDecimal(-1));
            BigDecimal onHandQty = materialDataInfo.getOnHandQty(this.runParam, info.getMaterialID(), orgUnitID, projectNumber, trackNumber, toBeUsed, this.runParam.getSupplyModel(), false, "1");
            BigDecimal safeStockQty = materialDataInfo.getSafeStockQty();
            bom = (BomInfo)bomInfoMap.get(info.getId());
            if (bom != null) {
                theLineInfo.setBomID(bom.getId().toString());
                theLineInfo.setBomType(bom.getBomType().getValue());
                theLineInfo.setYield(bom.getYield());
            }
            theLineInfo.setMaterialID(info.getMaterialID());
            theLineInfo.setProjectNumber(info.getProjectNumber());
            theLineInfo.setProjectID(info.getProjectId());
            theLineInfo.setBProjectNumber(info.getProjectNumber());
            theLineInfo.setBProjectID(info.getProjectId());
            theLineInfo.setTrackNumber(info.getTrackNumber());
            theLineInfo.setTrackID(info.getTrackNumberId());
            theLineInfo.setBTrackNumber(info.getTrackNumber());
            theLineInfo.setBTrackID(info.getTrackNumberId());
            theLineInfo.setPeriod(this.runParam.getDateManager().getPlanDate(info.getSupplyOrgUnitID()).getPeriod());
            theLineInfo.setBillDate(this.runParam.getDateManager().getPlanDate(info.getSupplyOrgUnitID()));
            if (!this.isDefaultProjectAndTrackNumber(info.getProjectNumber(), info.getTrackNumber())) {
                theLineInfo.setIsDeaultTNO(2);
            }
            theLineInfo.setSupplyStorageOrgUnitID(info.getSupplyOrgUnitID());
            if (onHandQty.compareTo(MRPConstant.ZERO) >= 0) {
                if (materialDataInfo.getQtyMax().compareTo(MRPConstant.ZERO) < 0 || onHandQty.compareTo(materialDataInfo.getQtyMax()) <= 0 || !this.runParam.getUtilManager().getExceptions().get(String.valueOf(40)).booleanValue()) continue;
                stockDetailInfo = new PMRPDetailInfo();
                stockDetailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, theLineInfo.getProjectNumber(), theLineInfo.getTrackNumber()));
                if (this.runParam.getUtilManager().getExceptionUtil().setException(stockDetailInfo, 40)) {
                    this.statisticException(materialDataInfo);
                }
                this.dataSaver.addUpdateStockException(stockDetailInfo);
                continue;
            }
            if (hasstockEXP && this.runParam.getRunLog().getPlanDefined().isIsCalcSafeInv() && Constants.MRPConfig.ISAVAIABLESTOCK) {
                if (!this.underSafeStockIds.contains(materialDataInfo.getMaterialID())) {
                    this.underSafeStockIds.add(materialDataInfo.getMaterialID());
                    if (this.isContainMaterial(materialDataInfo)) {
                        logger.debug((Object)("under safeStock material Number: " + materialDataInfo.getMaterialNumber()));
                        this.runParam.getCounter().underSafeQty();
                    }
                }
                stockDetailInfo = new PMRPDetailInfo();
                stockDetailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, theLineInfo.getProjectNumber(), theLineInfo.getTrackNumber()));
                if (this.runParam.getUtilManager().getExceptionUtil().setException(stockDetailInfo, 41)) {
                    this.statisticException(materialDataInfo);
                }
                stockDetailInfo.setDescription64(String.valueOf(41));
                this.dataSaver.addUpdateStockException(stockDetailInfo);
            }
            Log.info((Object)("nodata material number " + materialDataInfo.getMaterialNumber() + " level :" + this.runParam.getLevel()));
            theLineInfo.setPlannedQty(safeStockQty.subtract(onHandQty));
            if (materialDataInfo.getBatchPolicy() == 4 || materialDataInfo.getBatchPolicy() == 3) {
                materialDataInfo.setiBatchPolicy(PMRPBatchPolicyFactory.createInstance(2, this.runParam));
                materialDataInfo.setPartitionQty(0);
            }
            this.batchCal(materialDataInfo, theLineInfo.getPeriod(), onHandQty, onHandQty, true, onHandQty, theLineInfo, this.isMerge(materialDataInfo));
        }
        this.dataSaver.execute(true);
    }

    private static List<PMRPMaterialStatisticsInfo> getNoDataProjectNumberAndTrackNumber(PMRPCalcParam runParam, List<String> idList) throws PMRPException, BOSException {
        ArrayList<PMRPMaterialStatisticsInfo> materialDatas = new ArrayList<PMRPMaterialStatisticsInfo>();
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        PMRPRunTableManager manager = runParam.getTableManager();
        String materialTbl = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        String inventoryTbl = manager.getTempTableDefine(InventoryDetailTableDefine.class).getTableName();
        if (inventoryTbl == null || "".equals(inventoryTbl)) {
            return materialDatas;
        }
        StringBuffer filterMask = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            filterMask.append(" m.FMaterialID = ?");
            if (i == idList.size() - 1) continue;
            filterMask.append(" OR ");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(idList);
        params.add(110);
        params.add(runParam.getLevel());
        StringBuffer sb = new StringBuffer();
        sb.append("select m.FID FID, m.FMaterialId FMaterialID,m.FSupplyOrgUnitID,m.FOrgUnitID from  ").append(materialTbl).append(" m ").append("left join ").append(statisticsTbl).append(" s on m.FMaterialid = s.FMaterialid").append(" where s.FMaterialid is null").append(" and (").append(filterMask.toString()).append(" ) and (m.FPlanStrategy in (").append(MRPPlanStrategyUtil.getInvPlanStrategyStr((boolean)false)).append(")").append(" or m.FIsSurplusDivert = 1)").append(" and m.FMRPItem = ?").append(" and m.FLowsetCode = ?");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sb.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                statisticsInfo = new PMRPMaterialStatisticsInfo();
                statisticsInfo.setId(rs.getString("FID"));
                statisticsInfo.setMaterialID(rs.getString("FmaterialId"));
                statisticsInfo.setProjectNumber(null);
                statisticsInfo.setTrackNumber(null);
                statisticsInfo.setProjectId(null);
                statisticsInfo.setTrackNumberId(null);
                statisticsInfo.setSupplyOrgUnitID(rs.getString("FSupplyOrgUnitID"));
                materialDatas.add(statisticsInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        sb.setLength(0);
        sb.append("select m.FID FID, m.FMaterialId FMaterialID, inv.FProjectNumber FProjectNumber, ").append("inv.FTrackNumber FtrackNumber, inv.FProjectID FProjectID, inv.FTrackID FTrackID,m.FSupplyOrgUnitID,m.FOrgUnitID   from  ").append(materialTbl).append(" m ").append("left outer join ").append(inventoryTbl).append(" inv ").append("on m.FMaterialId=inv.FMaterialId  ").append("left join ").append(statisticsTbl).append(" s").append(" on m.FMaterialid = s.FMaterialid and isnull(s.FProjectNumber,'*')=isnull(inv.FProjectNumber,'*') and isnull(s.FTrackNumber,'*')=isnull(inv.FTrackNumber,'*') ").append(" where s.FMaterialid is null").append(" and (").append(filterMask.toString()).append(" ) and m.FPlanStrategy in (").append(MRPPlanStrategyUtil.getInvPlanStrategyStr((boolean)true)).append(")").append(" and m.FIsSurplusDivert = 0 ").append(" and m.FMRPItem = ?").append(" and m.FLowsetCode = ?");
        rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sb.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                statisticsInfo = new PMRPMaterialStatisticsInfo();
                statisticsInfo.setId(rs.getString("FID"));
                statisticsInfo.setMaterialID(rs.getString("FMaterialId"));
                statisticsInfo.setProjectNumber(rs.getString("FProjectNumber"));
                statisticsInfo.setTrackNumber(rs.getString("FTrackNumber"));
                statisticsInfo.setProjectId(rs.getString("FProjectID"));
                statisticsInfo.setTrackNumberId(rs.getString("FTrackID"));
                statisticsInfo.setSupplyOrgUnitID(rs.getString("FSupplyOrgUnitID"));
                materialDatas.add(statisticsInfo);
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialDatas;
    }

    protected PMRPDetailInfo getNextMergeRequire(String planStrategy, List<PMRPDetailInfo> detailDatas, IsolatedRuleEnum isolateRule) {
        PMRPDetailInfo newDetailInfo;
        PMRPDetailInfo detailInfo;
        PMRPDetailInfo lastDetailInfo = detailInfo = detailDatas.get(0);
        boolean isDirectTransport = detailInfo.isDirectTransport();
        BigDecimal rqty = MRPConstant.ZERO;
        int group = detailInfo.getPriority();
        Iterator<PMRPDetailInfo> iterator = detailDatas.iterator();
        if (planStrategy != null && ("qAYbemEdG9ngQKjAYj0V1dg0uEU=".equals(planStrategy) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(planStrategy) || "qAYfaBzUrmLgQKjAYj0f3dg0uEU=".equals(planStrategy))) {
            boolean isCanNotThrow = detailInfo.isCanNotThrow();
            while (iterator.hasNext()) {
                detailInfo = iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority() && isCanNotThrow == detailInfo.isCanNotThrow()) {
                    rqty = rqty.add(detailInfo.getDependentQty()).add(detailInfo.getIndependentQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        } else {
            while (iterator.hasNext()) {
                detailInfo = iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority()) {
                    rqty = rqty.add(detailInfo.getDependentQty()).add(detailInfo.getIndependentQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        }
        if (this.isNotProjectNoIsolation(planStrategy, newDetailInfo = (PMRPDetailInfo)lastDetailInfo.clone())) {
            newDetailInfo.setBProjectID(null);
            newDetailInfo.setBProjectNumber(null);
        }
        if (this.isNotTrackNoIsolation(planStrategy, isolateRule, newDetailInfo)) {
            newDetailInfo.setBTrackID(null);
            newDetailInfo.setBTrackNumber(null);
        }
        newDetailInfo.setDirectTransport(isDirectTransport);
        newDetailInfo.setDependentQty(rqty);
        newDetailInfo.setIndependentQty(MRPConstant.ZERO);
        newDetailInfo.setNetReqQty(rqty);
        return newDetailInfo;
    }

    protected boolean isNotTrackNoIsolation(String planStrategy, IsolatedRuleEnum isolationRule, PMRPDetailInfo newDetailInfo) {
        if (planStrategy == null) {
            return true;
        }
        return !MRPPlanStrategyUtil.isTrackNoIsolation((String)planStrategy, (IsolatedRuleEnum)isolationRule);
    }

    protected boolean isNotProjectNoIsolation(String planStrategy, PMRPDetailInfo newDetailInfo) {
        if (planStrategy == null) {
            return true;
        }
        return !MRPPlanStrategyUtil.isProjectNoIsolation((String)planStrategy);
    }

    protected PMRPBatchPolicyVO createBatchPolicyVO(PMRPMaterialDataInfo materialDataInfo, int peroid, BigDecimal dayNetReqQty, BigDecimal dayReqQty, boolean isEndDay, BigDecimal netRequirementQty, PMRPDetailInfo theLineInfo) {
        PMRPBatchPolicyVO data = new PMRPBatchPolicyVO();
        data.setMaterialNumber(materialDataInfo.getMaterialNumber());
        data.setCurrentPeriod(peroid);
        data.setSurPlusQty(dayNetReqQty);
        data.setDayReqQty(dayReqQty);
        data.setEndDay(isEndDay);
        data.setNetRequirementQty(netRequirementQty);
        data.setOrderLine(theLineInfo);
        data.setBatchIncQty(materialDataInfo.getBatchIncQty());
        data.setCycle(materialDataInfo.getCycle());
        data.setFixationBatchQty(materialDataInfo.getFixationBatchQty());
        data.setMaxBatchQty(materialDataInfo.getMaxBatchQty());
        data.setMinBatchQty(materialDataInfo.getMinBatchQty());
        data.setRoundUpMultipleQty(materialDataInfo.getRoundUpMultipleQty());
        if (theLineInfo != null) {
            if (10030 == materialDataInfo.getMaterialAttr()) {
                BigDecimal yield = theLineInfo.getYield();
                if (yield == null) {
                    yield = new BigDecimal("100.00");
                }
                theLineInfo.setYield4PlanOrder(yield);
                if (Constants.MRPConfig.ISYIELDPRODUCT) {
                    theLineInfo.setYield(yield);
                } else {
                    theLineInfo.setYield(new BigDecimal("100.00"));
                }
            } else {
                theLineInfo.setYield4PlanOrder(new BigDecimal("100.00"));
                theLineInfo.setYield(new BigDecimal("100.00"));
            }
        }
        data.setQtyPrc(materialDataInfo.getBaseQtyPrc());
        data.setPartitionQty(materialDataInfo.getPartitionQty());
        data.setStartPeroid(this.runParam.getDateManager().getPlanDate(materialDataInfo.getOrgUnitId()).getPeriod());
        data.setMaterialAttriBute(materialDataInfo.getMaterialAttr());
        return data;
    }

    private BigDecimal createPO4LastCycle(PMRPMaterialDataInfo materialDataInfo, BigDecimal netReqQty, int period, boolean isMergeSign) throws PMRPException, BOSException {
        PMRPBatchPolicyVO PMRPBatchPolicyVO2 = this.createBatchPolicyVO(materialDataInfo, period, netReqQty, netReqQty, false, netReqQty, null);
        PMRPFixedPeriodicbatchPolicy fixPeriodPilocy = (PMRPFixedPeriodicbatchPolicy)this.getBatchPolicy(materialDataInfo);
        PMRPBatchPolicyResult[] results = fixPeriodPilocy.createPO4LastCycle(PMRPBatchPolicyVO2);
        return this.getAvailQtyOnCreatePO(PMRPBatchPolicyVO2, materialDataInfo, netReqQty, results, null, isMergeSign);
    }

    protected IPMRPBatchPolicy getBatchPolicy(PMRPMaterialDataInfo materialDataInfo) {
        if (materialDataInfo.getiBatchPolicy() == null) {
            int policy = materialDataInfo.getBatchPolicy();
            materialDataInfo.setiBatchPolicy(PMRPBatchPolicyFactory.createInstance(policy, this.runParam));
        }
        return materialDataInfo.getiBatchPolicy();
    }

    private BigDecimal getAvailQtyOnCreatePO(PMRPBatchPolicyVO PMRPBatchPolicyVO2, PMRPMaterialDataInfo materialDataInfo, BigDecimal netReqQty, PMRPBatchPolicyResult[] results, PMRPDetailInfo theLineInfo, boolean isMergeSign) throws PMRPException, BOSException {
        if (results == null) {
            return netReqQty;
        }
        BigDecimal availableQty = netReqQty;
        PMRPDetailInfo orderLine = null;
        PMRPDate replanDate = null;
        BigDecimal yield = PMRPBatchPolicyVO2.getYield();
        BigDecimal avaliableSupply = null;
        int sPeroid = -1;
        for (int i = 0; i < results.length; ++i) {
            int mAttr;
            orderLine = (PMRPDetailInfo)results[i].getOrderLine();
            if (orderLine == null) {
                orderLine = theLineInfo;
            }
            orderLine.setPeriod(results[i].getPeriod());
            orderLine.setPlannedQty(results[i].getQty());
            if (results[i].getException() != -1 && this.runParam.getUtilManager().getExceptionUtil().setException(orderLine, results[i].getException())) {
                this.statisticException(materialDataInfo);
            }
            String orgId = (mAttr = orderLine.getMaterialAttr()) == 10030 ? orderLine.getSupplyStorageOrgUnitID() : (mAttr == 10040 ? orderLine.getSupplyStorageOrgUnitID() : orderLine.getOrgUnitID());
            PMRPCalendarUtil cUtil = this.runParam.getUtilManager().getCalendarUtil(orgId);
            PMRPDate date = cUtil.getDate(orderLine.getPeriod());
            if (i == 0) {
                replanDate = date;
            }
            if (sPeroid == -1) {
                sPeroid = date.getPeriod();
            }
            if ((Constants.MRPConfig.ISCOOPERATEPLAN || materialDataInfo.getMaterialAttr() == 10040) && replanDate != null) {
                Calendar tDate = MRPUtil.copyDate((Calendar)replanDate.getDate());
                tDate.add(5, results[i].getPeriodOffset());
                date = this.runParam.getUtilManager().getCalendarUtil(materialDataInfo.getSupplyStorageOrgUnitID()).getDate(tDate.getTime(), true);
                date.setWorkDaySeqID(date.getPeriod());
            }
            yield = PMRPBatchPolicyVO2.getYield();
            if (!Constants.MRPConfig.ISCOOPERATEPLAN && Constants.MRPConfig.ISYIELDPRODUCT && yield != null) {
                yield = yield.divide(new BigDecimal("100.00"), 4, 3);
                BigDecimal temp = results[i].getQty();
                if (PMRPBatchPolicyVO2.getMaterialAttriBute() == 10030) {
                    temp = results[i].getQty().multiply(yield).setScale(8, 3);
                }
                avaliableSupply = temp.setScale(PMRPBatchPolicyVO2.getQtyPrc(), 3);
            } else {
                avaliableSupply = results[i].getQty().setScale(PMRPBatchPolicyVO2.getQtyPrc(), 3);
            }
            orderLine.setSperiod(orderLine.getPeriod());
            orderLine.setPeriod(sPeroid);
            this.createPlanOrder(materialDataInfo, netReqQty, avaliableSupply, date, replanDate, orderLine, isMergeSign);
            availableQty = availableQty.add(avaliableSupply);
        }
        return availableQty;
    }

    protected BigDecimal batchCal(PMRPMaterialDataInfo materialDataInfo, int peroid, BigDecimal dayNetReqQty, BigDecimal dayReqQty, boolean isEndDay, BigDecimal netRequirementQty, PMRPDetailInfo theLineInfo, boolean isMergeSign) throws PMRPException, BOSException {
        PMRPBatchPolicyVO PMRPBatchPolicyVO2 = this.createBatchPolicyVO(materialDataInfo, peroid, dayNetReqQty, dayReqQty, isEndDay, netRequirementQty, theLineInfo);
        PMRPBatchPolicyResult[] results = this.getBatchPolicy(materialDataInfo).batchComputing(PMRPBatchPolicyVO2);
        return this.getAvailQtyOnCreatePO(PMRPBatchPolicyVO2, materialDataInfo, netRequirementQty, results, theLineInfo, isMergeSign);
    }

    private boolean isNeedAjust(int period, String producetOrgUnitID) {
        boolean isNeedAjust = true;
        int periodAdjust = this.runParam.getDateManager().getPlanDate(producetOrgUnitID).getPeriod() + this.runParam.getRunLog().getPlanDefined().getAdjustPeriod();
        if (period > periodAdjust) {
            isNeedAjust = false;
        }
        return isNeedAjust;
    }

    private PMRPDetailInfo createStockReqDataInfo(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo materialStatisticsInfo) throws PMRPException, BOSException {
        PMRPDetailInfo stockReqDetailInfo = new PMRPDetailInfo();
        stockReqDetailInfo.setBillDate(this.runParam.getDateManager().getPlanDate(materialDataInfo.getOrgUnitId()));
        stockReqDetailInfo.setPeriod(this.runParam.getDateManager().getPlanDate(materialDataInfo.getOrgUnitId()).getPeriod());
        stockReqDetailInfo.setScheduledReceiptQty(MRPConstant.ZERO);
        stockReqDetailInfo.setMrpClassify(PMRPClassifyEnum.Requirement);
        stockReqDetailInfo.setMrpItem(PMRPElementEnum.I_CurInv);
        stockReqDetailInfo.setBillNumber("");
        stockReqDetailInfo.setScheduledReceiptQty(MRPConstant.ZERO);
        stockReqDetailInfo.setIndependentQty(MRPConstant.ZERO);
        String orgUnitID = materialStatisticsInfo.getSupplyOrgUnitID();
        String projectNumber = null;
        String trackNumber = null;
        BigDecimal toBeUsed = materialStatisticsInfo.getRQty().multiply(new BigDecimal(-1));
        BigDecimal onHandQty = materialDataInfo.getOnHandQty(this.runParam, materialStatisticsInfo.getMaterialID(), orgUnitID, projectNumber, trackNumber, toBeUsed, this.runParam.getSupplyModel(), false, "1");
        stockReqDetailInfo.setDependentQty(onHandQty);
        stockReqDetailInfo.setProjectNumber(null);
        stockReqDetailInfo.setTrackNumber(null);
        stockReqDetailInfo.setProjectID(null);
        stockReqDetailInfo.setTrackID(null);
        stockReqDetailInfo.setIsDeaultTNO(1);
        stockReqDetailInfo.setBProjectNumber(null);
        stockReqDetailInfo.setBTrackNumber(null);
        stockReqDetailInfo.setBProjectID(null);
        stockReqDetailInfo.setBTrackID(null);
        stockReqDetailInfo.setSupplyStorageOrgUnitID(materialStatisticsInfo.getSupplyOrgUnitID());
        stockReqDetailInfo.setMaterialAttr(materialDataInfo.getMaterialAttr());
        return stockReqDetailInfo;
    }

    private void setException4Stock(PMRPMaterialStatisticsInfo materialStatisticsInfo) throws PMRPException, BOSException {
        PMRPMaterialDataInfo materialDataInfo = this.materialDataInfo4Stock;
        if (materialDataInfo.getQtyMax().compareTo(MRPConstant.ZERO) >= 0) {
            String supplyOrgUnitID = materialStatisticsInfo.getSupplyOrgUnitID();
            String projectNumber = materialStatisticsInfo.getProjectNumber();
            String trackNumber = materialStatisticsInfo.getTrackNumber();
            BigDecimal toBeUsed = materialStatisticsInfo.getRQty().multiply(new BigDecimal(-1));
            BigDecimal p = materialDataInfo.getOnHandQty(this.runParam, materialStatisticsInfo.getMaterialID(), supplyOrgUnitID, projectNumber, trackNumber, toBeUsed, this.runParam.getSupplyModel(), false, "1");
            if (p.compareTo(materialDataInfo.getQtyMax()) > 0 && this.runParam.getUtilManager().getExceptions().get(String.valueOf(40)).booleanValue()) {
                PMRPDetailInfo detailInfo = new PMRPDetailInfo();
                detailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber()));
                if (this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 40)) {
                    this.statisticException(materialDataInfo);
                }
                this.dataSaver.addUpdateStockException(detailInfo);
            }
        }
        if (this.subtractSafeStockQty(materialDataInfo, materialStatisticsInfo).compareTo(MRPConstant.ZERO) < 0 && this.runParam.getRunLog().getPlanDefined().isIsCalcSafeInv() && Constants.MRPConfig.ISAVAIABLESTOCK) {
            if (!this.underSafeStockIds.contains(materialDataInfo.getMaterialID())) {
                this.underSafeStockIds.add(materialDataInfo.getMaterialID());
                if (this.isContainMaterial(materialDataInfo)) {
                    logger.debug((Object)("under safeStock material Number: " + materialDataInfo.getMaterialNumber()));
                    this.runParam.getCounter().underSafeQty();
                }
            }
            if (this.runParam.getUtilManager().getExceptions().get(String.valueOf(41)).booleanValue()) {
                PMRPDetailInfo detailInfo = new PMRPDetailInfo();
                detailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber()));
                if (this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 41)) {
                    this.statisticException(materialDataInfo);
                }
                detailInfo.setDescription64(String.valueOf(41));
                this.dataSaver.addUpdateStockException(detailInfo);
            }
        }
    }

    private boolean isDefaultProjectAndTrackNumber(String projectNumber, String trackNumber) {
        return projectNumber == null && trackNumber == null;
    }

    protected void createMaterialDataInfo(PMRPMaterialDataInfo materialDataInfo) {
        if (this.materialDataInfo4Stock == null || !this.materialDataInfo4Stock.getMaterialID().equals(materialDataInfo.getMaterialID()) || !this.materialDataInfo4Stock.getSupplyStorageOrgUnitID().equals(materialDataInfo.getSupplyStorageOrgUnitID())) {
            this.materialDataInfo4Stock = (PMRPMaterialDataInfo)materialDataInfo.clone();
        }
    }

    private boolean isHasNetReq(BigDecimal reqQty) {
        return reqQty.compareTo(MRPConstant.ZERO) < 0;
    }

    protected boolean isContainMaterial(PMRPMaterialDataInfo materialDataInfo) {
        boolean isContainMaterial = false;
        if (materialDataInfo.getPlanningMode() == 3) {
            return true;
        }
        return isContainMaterial;
    }

    protected void statisticException(PMRPMaterialDataInfo materialDataInfo) {
        if (this.isContainMaterial(materialDataInfo) && !this.materialException.contains(materialDataInfo.getMaterialID())) {
            this.materialException.add(materialDataInfo.getMaterialID());
            materialDataInfo.setHasExceptions(1);
            this.runParam.getCounter().generateException();
        }
    }

    private void statisticException(PMRPDetailInfo detailInfo) {
        this.statisticException(this.materiaDataUtil.getMaterialInfo(detailInfo.getMaterialID() + detailInfo.getSupplyStorageOrgUnitID()));
    }

    private void dealDetailPUBProjTrack(PMRPDetailInfo detailInfo, PMRPMaterialDataInfo materialDataInfo) {
        if (materialDataInfo.getPlanStrategy() != null && (materialDataInfo.getPlanStrategy().equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || materialDataInfo.getPlanStrategy().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU="))) {
            if (materialDataInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.ITEM)) {
                detailInfo.setTrackID(null);
                detailInfo.setTrackNumber(null);
                detailInfo.setBTrackID(null);
                detailInfo.setBTrackNumber(null);
            } else if (!materialDataInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.ITEM_TRACKNO)) {
                detailInfo.setProjectID(null);
                detailInfo.setProjectNumber(null);
                detailInfo.setBProjectID(null);
                detailInfo.setBProjectNumber(null);
                detailInfo.setTrackID(null);
                detailInfo.setTrackNumber(null);
                detailInfo.setBTrackID(null);
                detailInfo.setBTrackNumber(null);
            }
        } else {
            detailInfo.setProjectID(null);
            detailInfo.setProjectNumber(null);
            detailInfo.setBProjectID(null);
            detailInfo.setBProjectNumber(null);
            detailInfo.setTrackID(null);
            detailInfo.setTrackNumber(null);
            detailInfo.setBTrackID(null);
            detailInfo.setBTrackNumber(null);
        }
    }

    private List<HashMap<String, Object>> getOrgUnitIDList(PMRPMaterialStatisticsInfo staticInfo) throws BOSException, PMRPException {
        if (staticInfo == null || staticInfo.getId() == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        PMRPRunTableManager manager = this.runParam.getTableManager();
        IPMRPTableDefine OrgUnittableDefine = manager.getTempTableDefine(OrgUnitStatisticsTableDefine.class);
        String OrgUnittableName = OrgUnittableDefine.getTableName();
        ArrayList<HashMap<String, Object>> orgUnitIDList = new ArrayList<HashMap<String, Object>>();
        sql.append(" Select FID").append(",FOrgUnitID").append(",FSQty").append(",FRQty").append(" from ").append(OrgUnittableName).append(" where Fpid =  ? ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{staticInfo.getId()});
            while (rs.next()) {
                String fid = rs.getString("FID");
                String FOrgUnitID = rs.getString("FOrgUnitID");
                BigDecimal FSQty = rs.getBigDecimal("FSQty");
                BigDecimal FRQty = rs.getBigDecimal("FRQty");
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("fid", fid);
                dataMap.put("FOrgUnitID", FOrgUnitID);
                dataMap.put("FSQty", FSQty);
                dataMap.put("FRQty", FRQty);
                orgUnitIDList.add(dataMap);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        return orgUnitIDList;
    }
}

