/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.FeedBackStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeState;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanChangeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanChangeInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.client.AbstractStockingPlanChangeListUI;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class StockingPlanChangeListUI
extends AbstractStockingPlanChangeListUI {
    private static final Logger logger = CoreUIObject.getLogger(StockingPlanChangeListUI.class);
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.project.biz.psp.PSPGenrateResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDBAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.kDBAudit.setText("");
        this.kDBUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.kDBSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.kDBSubmit.setText("");
        this.kDBUnAudit.setVisible(false);
        this.kDBAudit.setEnabled(true);
        this.kDBUnAudit.setEnabled(true);
        this.kDBSubmit.setEnabled(true);
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Action", "Submit");
        params.put("Event", e);
        this.batchExecute(params);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Action", "Audit");
        params.put("Event", e);
        this.batchExecute(params);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Action", "UnAudit");
        params.put("Event", e);
        this.batchExecute(params);
    }

    public String beforeAction(List idList, Map params) {
        StringBuffer errstr = new StringBuffer();
        errstr.setLength(0);
        for (int i = 0; i < idList.size(); ++i) {
            try {
                StockingPlanChangeInfo info = StockingPlanChangeFactory.getRemoteInstance().getStockingPlanChangeInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
                if ("Submit".equals(params.get("Action"))) {
                    if (PspChangeState.ADDNEW.equals((Object)info.getChangeStatus()) || PspChangeState.EDIT.equals((Object)info.getChangeStatus())) continue;
                    errstr.append(EASResource.getString((String)this.RESOURCE_NAME, (String)"label84", (Object[])new String[]{info.getNumber()})).append("\n");
                    continue;
                }
                if ("Audit".equals(params.get("Action"))) {
                    if (PspChangeState.SUBMIT.equals((Object)info.getChangeStatus())) continue;
                    errstr.append(EASResource.getString((String)this.RESOURCE_NAME, (String)"label85", (Object[])new String[]{info.getNumber()})).append("\n");
                    continue;
                }
                if (!"UnAudit".equals(params.get("Action")) || PspChangeState.CHANGED.equals((Object)info.getChangeStatus())) continue;
                errstr.append(EASResource.getString((String)this.RESOURCE_NAME, (String)"label86", (Object[])new String[]{info.getNumber()})).append("\n");
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label87"));
                SysUtil.abort();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label87"));
                SysUtil.abort();
            }
        }
        return errstr.toString();
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow ir = this.tblMain.getRow(i);
            if (ir.getCell("supplierFBStatus").getValue() != null && ir.getCell("supplierFBStatus").getValue().toString().equals(FeedBackStatusEnum.EXCEPTION.getAlias())) {
                ir.getStyleAttributes().setBackground(Color.red);
                continue;
            }
            ir.getStyleAttributes().setBackground(Color.white);
        }
    }

    protected void batchExecute(final Map params) throws Exception {
        int msgResult;
        AbstractButton eSource;
        Object eSourceObject;
        if (IndustryUtils.isEmptyMap((Map)params)) {
            return;
        }
        String action = IndustryUtils.getMapStringData((Map)params, (Object)"Action");
        Object eObject = IndustryUtils.getMapData((Map)params, (Object)"Event");
        if (IndustryUtils.isEmptyString((String)action) || eObject == null) {
            return;
        }
        ActionEvent e = eObject == null ? null : (eObject instanceof ActionEvent ? (ActionEvent)eObject : null);
        Object object = eSourceObject = e == null ? null : e.getSource();
        AbstractButton abstractButton = eSourceObject == null ? null : (eSource = eSourceObject instanceof AbstractButton ? (AbstractButton)eSourceObject : null);
        String actionAlias = eSource == null ? EASResource.getString((String)this.RESOURCE_NAME, (String)"label21") : (IndustryUtils.isEmptyString((String)eSource.getText()) ? EASResource.getString((String)this.RESOURCE_NAME, (String)"label21") : eSource.getText());
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (!IndustryUtils.isEmptyList((List)idList) && (MsgBox.isCancel((int)(msgResult = MsgBox.showConfirm2((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label30", (Object[])new String[]{actionAlias})))) || MsgBox.isNo((int)msgResult))) {
            return;
        }
        if (action.equals("Audit")) {
            StringBuffer sql = new StringBuffer();
            StringBuffer idListStr = new StringBuffer();
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                idListStr.append("'").append(id).append("'");
                if (i == idList.size() - 1) continue;
                idListStr.append(",");
            }
            sql.append(" select spc.fnumber,sup.fname_l2 from T_PSP_StockingPlanChange spc");
            sql.append(" inner join t_Psp_Stockingplan sp on spc.fstockingplanid = sp.fid");
            sql.append(" inner join t_bd_supplier sup on sup.fid = sp.fsupplierid");
            sql.append(" where sup.Cfpersonid is null and sup.fusedstatus = 1 ");
            sql.append(" \tand spc.fid in (").append(idListStr).append(")");
            sql.append(" order by sup.fname_l2,spc.fnumber desc ");
            IRowSet rowSet = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
            StringBuffer detail = new StringBuffer();
            while (rowSet.next()) {
                String billno = rowSet.getString("fnumber");
                String supName = rowSet.getString("fname_l2");
                detail.append("").append(supName).append("\uff1a").append(billno).append(",\n");
            }
            int msgResult2 = MsgBox.showConfirm3a((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label88"), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label89", (Object[])new String[]{detail.toString()}));
            if (MsgBox.isCancel((int)msgResult2) || MsgBox.isNo((int)msgResult2)) {
                return;
            }
        }
        params.put("IDList", idList);
        String errstr = this.beforeAction(idList, params);
        if (!IndustryUtils.isEmptyString((String)errstr)) {
            MsgBox.showConfirm3a((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label22"), (String)errstr);
            SysUtil.abort();
        }
        final MonitorInfo mi = new MonitorInfo(EASResource.getString((String)this.RESOURCE_NAME, (String)"label25"), null, (Object)this, true);
        SwingWorker sw = new SwingWorker(){

            public Object construct() {
                try {
                    StockingPlanChangeFactory.getRemoteInstance().batchExecute(params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            public void finished() {
                ThreadPool.destroyMonitor((MonitorInfo)mi);
            }
        };
        mi.setWorker(sw);
        ThreadPool.addActionThread((MonitorInfo)mi);
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockingPlanChangeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StockingPlanChangeInfo objectValue = new StockingPlanChangeInfo();
        return objectValue;
    }
}

