/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFeedbackFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanStatus;
import com.kingdee.eas.industry.emm.project.biz.psp.client.AbstractStockingPlanListUI;
import com.kingdee.eas.industry.emm.project.biz.psp.client.StockingPlanFilterUI;
import com.kingdee.eas.industry.emm.project.biz.psp.util.StockingPlanUtil;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class StockingPlanListUI
extends AbstractStockingPlanListUI {
    private static final Logger logger = CoreUIObject.getLogger(StockingPlanListUI.class);
    private static final String Col_id = "id";
    private static final String Col_QTY = "Qty";
    private static final String Col_purOrderQty = "purOrderQty";
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.project.biz.psp.PSPGenrateResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSubmit.setEnabled(true);
        this.btnAudit.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.btnShowPur.setVisible(true);
        this.btnShowPur.setEnabled(true);
        this.menuItemAddNew.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("number").getStyleAttributes().setHided(true);
        this.refreshTable();
    }

    private void refreshTable() {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockingPlanFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StockingPlanInfo objectValue = new StockingPlanInfo();
        return objectValue;
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.refreshTable();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshTable();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        try {
            CommonQueryDialog dialog = super.initCommonQueryDialog();
            dialog.setShowFilter(true);
            dialog.setShowSorter(true);
            StockingPlanFilterUI fiterUi = new StockingPlanFilterUI();
            dialog.addUserPanel((KDPanel)fiterUi);
            dialog.setWidth(420);
            dialog.setHeight(350);
            dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            return dialog;
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return null;
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Action", "Audit");
        params.put("Event", e);
        this.batchExecute(params);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Action", "Submit");
        params.put("Event", e);
        this.batchExecute(params);
    }

    private void batchExecute(final Map params) {
        AbstractButton eSource;
        Object eSourceObject;
        if (IndustryUtils.isEmptyMap((Map)params)) {
            return;
        }
        String action = IndustryUtils.getMapStringData((Map)params, (Object)"Action");
        Object eObject = IndustryUtils.getMapData((Map)params, (Object)"Event");
        if (IndustryUtils.isEmptyString((String)action) || eObject == null) {
            return;
        }
        ActionEvent e = eObject == null ? null : (eObject instanceof ActionEvent ? (ActionEvent)eObject : null);
        Object object = eSourceObject = e == null ? null : e.getSource();
        AbstractButton abstractButton = eSourceObject == null ? null : (eSource = eSourceObject instanceof AbstractButton ? (AbstractButton)eSourceObject : null);
        final String actionAlias = eSource == null ? EASResource.getString((String)this.RESOURCE_NAME, (String)"label21") : (IndustryUtils.isEmptyString((String)eSource.getText()) ? EASResource.getString((String)this.RESOURCE_NAME, (String)"label21") : eSource.getText());
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        params.put("IDList", idList);
        String errstr = this.beforeAction(idList, params);
        if (!IndustryUtils.isEmptyString((String)errstr)) {
            MsgBox.showConfirm3a((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label22"), (String)errstr);
            SysUtil.abort();
        }
        final MonitorInfo mi = new MonitorInfo(EASResource.getString((String)this.RESOURCE_NAME, (String)"label25"), null, (Object)this, true);
        SwingWorker sw = new SwingWorker(){
            String msg = null;

            public Object construct() {
                try {
                    this.msg = StockingPlanFactory.getRemoteInstance().bacthHandle(params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            public void finished() {
                ThreadPool.destroyMonitor((MonitorInfo)mi);
                try {
                    StockingPlanListUI.this.refreshList();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.msg.indexOf(EASResource.getString((String)StockingPlanListUI.this.RESOURCE_NAME, (String)"label01")) != -1) {
                    MsgBox.showConfirm3a((String)EASResource.getString((String)StockingPlanListUI.this.RESOURCE_NAME, (String)"label02"), (String)this.msg);
                    SysUtil.abort();
                }
                if (!IndustryUtils.isEmptyString((String)this.msg)) {
                    MsgBox.showConfirm3a((String)(actionAlias + EASResource.getString((String)StockingPlanListUI.this.RESOURCE_NAME, (String)"label03")), (String)this.msg);
                    SysUtil.abort();
                }
            }
        };
        mi.setWorker(sw);
        ThreadPool.addActionThread((MonitorInfo)mi);
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
    }

    public String beforeAction(List idList, Map params) {
        StringBuffer errstr = new StringBuffer();
        errstr.setLength(0);
        for (int i = 0; i < idList.size(); ++i) {
            try {
                StockingPlanInfo info = StockingPlanFactory.getRemoteInstance().getStockingPlanInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
                if ("Submit".equals(params.get("Action"))) {
                    if (StockingPlanStatus.SAVE.equals((Object)info.getBaseStatus())) continue;
                    errstr.append(EASResource.getString((String)this.RESOURCE_NAME, (String)"label84", (Object[])new String[]{info.getNumber()})).append("\n");
                    continue;
                }
                if (!"Audit".equals(params.get("Action")) || StockingPlanStatus.SUBMIT.equals((Object)info.getBaseStatus())) continue;
                errstr.append(EASResource.getString((String)this.RESOURCE_NAME, (String)"label85", (Object[])new String[]{info.getNumber()})).append("\n");
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label104"));
                SysUtil.abort();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label104"));
                SysUtil.abort();
            }
        }
        return errstr.toString();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label105"));
            SysUtil.abort();
        }
        this.checkStatus(idList);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Supplier.*"));
        selector.add(new SelectorItemInfo("Material.*"));
        selector.add(new SelectorItemInfo("Material.baseUnit.*"));
        selector.add(new SelectorItemInfo("Project.*"));
        selector.add(new SelectorItemInfo("TrackNo.*"));
        selector.add(new SelectorItemInfo("storageOrgUnit.*"));
        selector.add(new SelectorItemInfo("purChaseOrgUnit.*"));
        selector.add(new SelectorItemInfo("supplyStorageOrgUnit.*"));
        StockingPlanInfo info = StockingPlanFactory.getRemoteInstance().getStockingPlanInfo((IObjectPK)new ObjectUuidPK(idList.get(0).toString()), selector);
        UIContext uicontext = new UIContext();
        IUIWindow uiwindow = null;
        String uiclass = "com.kingdee.eas.industry.emm.project.biz.psp.client.StockingPlanFBdetailEditUI";
        uicontext.put((Object)"info", (Object)info);
        uiwindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.industry.emm.project.biz.psp.client.StockingPlanFBdetailEditUI", (Map)uicontext, null, OprtState.ADDNEW);
        uiwindow.show();
        this.refreshList();
    }

    private void checkStatus(List idList) throws EASBizException, BOSException, SQLException {
        if (idList.size() > 1000) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label106"));
            SysUtil.abort();
        }
        StringBuffer idListStr = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            String id = (String)idList.get(i);
            idListStr.append("'").append(id).append("'");
            if (i == idList.size() - 1) continue;
            idListStr.append(",");
        }
        HashMap supMap = StockingPlanUtil.getIsSupplier(idListStr.toString());
        StringBuffer msg = new StringBuffer();
        StringBuffer supmsg = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            String id = (String)idList.get(i);
            StockingPlanInfo info = StockingPlanFactory.getRemoteInstance().getStockingPlanInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getSupplier() != null) {
                if (!supMap.containsKey(info.getSupplier().getId())) continue;
                supmsg.append(EASResource.getString((String)this.RESOURCE_NAME, (String)"label107", (Object[])new String[]{info.getNumber()})).append("\n");
                continue;
            }
            msg.append(EASResource.getString((String)this.RESOURCE_NAME, (String)"label107", (Object[])new String[]{info.getNumber()})).append("\n");
        }
        if (msg.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label108"), (String)msg.toString(), (int)2);
            SysUtil.abort();
        }
        if (supmsg.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label109"), (String)supmsg.toString(), (int)2);
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.refreshTable();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String errStr = "";
        for (int i = 0; i < idList.size(); ++i) {
            StockingPlanInfo info = StockingPlanFactory.getRemoteInstance().getStockingPlanInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
            if (!StockingPlanStatus.AUDIT.equals((Object)info.getBaseStatus())) continue;
            errStr = errStr + info.getNumber();
            errStr = errStr + "\n";
        }
        if (errStr.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label110"), (String)errStr, (int)2);
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionQueryPur_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashMap map = new HashMap();
        HashMap mapR = StockingPlanFeedbackFacadeFactory.getRemoteInstance().getPurList(map);
        if (!IndustryUtils.isEmptyMap((Map)mapR) && mapR.get("list") != null && ((List)mapR.get("list")).size() != 0) {
            List list = (List)mapR.get("list");
            UIContext uicontext = new UIContext();
            IUIWindow uiwindow = null;
            String uiclass = "com.kingdee.eas.industry.emm.project.biz.psp.client.PspPurListUI";
            uicontext.put((Object)"list", (Object)list);
            uiwindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.industry.emm.project.biz.psp.client.PspPurListUI", (Map)uicontext, null, OprtState.VIEW);
            uiwindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"label111"));
            SysUtil.abort();
        }
        super.actionQueryPur_actionPerformed(e);
    }
}

