/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgStructureException;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.mm.project.ProjectGroupConstructEntryCollection;
import com.kingdee.eas.mm.project.ProjectGroupConstructEntryFactory;
import com.kingdee.eas.mm.project.ProjectGroupConstructEntryInfo;
import com.kingdee.eas.mm.project.ProjectGroupConstructInfo;
import com.kingdee.eas.mm.project.client.AbstractProjectGroupConstructChartUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;

public class ProjectGroupConstructChartUI
extends AbstractProjectGroupConstructChartUI {
    private static final long serialVersionUID = 2262489387380668914L;
    protected final Color backgroundColor = Color.LIGHT_GRAY;
    protected Map chartMap = new HashMap();
    protected final int chartMargin = 50;
    protected ChartPanel chartPanel = new ChartPanel();
    protected final int defaultRectWidth = 136;
    protected final int defaultStringWidth = 60;
    protected String displayMode = "V";
    protected final Color dutyRectColor = new Color(13296622);
    protected final Color fontColor = Color.BLACK;
    protected final Color lineColor = Color.GRAY;
    protected final int personMargin = 30;
    protected final Color personRectColor = Color.WHITE;
    protected String projectGroupConstructID = null;
    protected final Color rectBorderColor = Color.GRAY;
    protected final int rectHeightMargin = 5;
    protected final int rectWidthMargin = 3;

    public ProjectGroupConstructChartUI() throws Exception {
        if (this.chartPanel != null) {
            this.chartPanel.setName("chartPanel");
            this.chartPanel.setPreferredSize(new Dimension(660, 460));
            this.spMain.getViewport().add((Component)((Object)this.chartPanel), null);
        }
    }

    @Override
    public void actionDisplaySwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.chartPanel == null) {
            return;
        }
        if ("V".equals(this.displayMode)) {
            this.displayMode = "H";
            this.btnDisplaySwitch.setIcon(EASResource.getIcon((String)"imgTbtn_collect1"));
            this.menuItemDisplaySwitch.setIcon(EASResource.getIcon((String)"imgTbtn_collect1"));
        } else {
            this.displayMode = "V";
            this.btnDisplaySwitch.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
            this.menuItemDisplaySwitch.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        }
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.generateChartData();
        this.chartPanel.repaint();
    }

    @Override
    public void actionSavePicture_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getExtension((File)file);
                if (extension != null) {
                    return extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "JPEG ( *.jpg;*.jpeg )";
            }
        });
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (null != file.getParentFile() && !file.getParentFile().isDirectory()) {
            throw new OrgStructureException(OrgStructureException.OUTPUT_FILE_ERROR);
        }
        if (!file.getAbsolutePath().endsWith(".jpg") && !file.getAbsolutePath().endsWith(".jpeg")) {
            file = new File(file.getAbsolutePath() + ".jpg");
        }
        if (file.exists()) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.FILE_IS_EXIST")) != 0) {
                return;
            }
        } else {
            try {
                file.createNewFile();
                file.delete();
            }
            catch (IOException exc) {
                throw new JobException(JobException.FILE_NAME_ERROR);
            }
        }
        try {
            int width = this.chartPanel.getWidth();
            int height = this.chartPanel.getHeight();
            BufferedImage image = (BufferedImage)this.chartPanel.createImage(width, height);
            Graphics2D graphic2D = image.createGraphics();
            this.chartPanel.print(graphic2D);
            ImageIO.write((RenderedImage)image, "jpeg", file);
            image.flush();
        }
        catch (Throwable t) {
            throw new OrgStructureException(OrgStructureException.SAVE_TO_PIC_ERROR);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        this.projectGroupConstructID = uiContext == null ? null : (uiContext.containsKey("ProjectGroupConstructID") ? (uiContext.get("ProjectGroupConstructID") == null ? null : uiContext.get("ProjectGroupConstructID").toString()) : null);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSavePicture.setIcon(EASResource.getIcon((String)"imgTbtn_showpicture"));
        this.menuItemSavePicture.setIcon(EASResource.getIcon((String)"imgTbtn_showpicture"));
        this.btnDisplaySwitch.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemDisplaySwitch.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
    }

    public void onShow() throws Exception {
        this.generateChartData();
    }

    protected void generateChartData() throws Exception {
        Iterator levelIterator;
        int chartWidth;
        Map chartDataMap;
        Graphics graphics;
        Graphics2D graphics2D;
        if (this.chartPanel == null || this.spMain == null || this.projectGroupConstructID == null) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectCollection = new SelectorItemCollection();
        selectCollection.add(new SelectorItemInfo("id"));
        selectCollection.add(new SelectorItemInfo("seq"));
        selectCollection.add(new SelectorItemInfo("parent.id"));
        selectCollection.add(new SelectorItemInfo("parent.baseStatus"));
        selectCollection.add(new SelectorItemInfo("duty"));
        selectCollection.add(new SelectorItemInfo("person.id"));
        selectCollection.add(new SelectorItemInfo("person.number"));
        selectCollection.add(new SelectorItemInfo("person.name"));
        selectCollection.add(new SelectorItemInfo("orderSeq"));
        selectCollection.add(new SelectorItemInfo("parentSeq"));
        SorterItemCollection sortCollection = new SorterItemCollection();
        sortCollection.add(new SorterItemInfo("parentSeq"));
        sortCollection.add(new SorterItemInfo("orderSeq"));
        filterInfo.getFilterItems().clear();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.projectGroupConstructID, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectCollection);
        entityViewInfo.setSorter(sortCollection);
        ProjectGroupConstructEntryCollection entryCollection = ProjectGroupConstructEntryFactory.getRemoteInstance().getProjectGroupConstructEntryCollection(entityViewInfo);
        if (entryCollection == null) {
            return;
        }
        if (entryCollection.size() == 0) {
            return;
        }
        HashMap levelMap = new HashMap();
        HashMap relationMap = new HashMap();
        HashMap personMap = new HashMap();
        BillBaseStatusEnum baseStatus = null;
        for (int index = 0; index < entryCollection.size(); ++index) {
            String personName;
            ProjectGroupConstructEntryInfo entryInfo = entryCollection.get(index);
            if (entryInfo == null) continue;
            if (baseStatus == null) {
                ProjectGroupConstructInfo billInfo = entryInfo.getParent();
                baseStatus = billInfo == null ? null : billInfo.getBaseStatus();
            }
            int seq = entryInfo.getSeq();
            int parentSeq = entryInfo.getParentSeq();
            if (seq <= 0 || parentSeq < 0) continue;
            String duty = entryInfo.getDuty();
            PersonInfo personInfo = entryInfo.getPerson();
            String string = personName = personInfo == null ? null : personInfo.getName();
            ArrayList childrenList = relationMap.containsKey(parentSeq) ? (relationMap.get(parentSeq) == null ? new ArrayList() : (relationMap.get(parentSeq) instanceof List ? (List)relationMap.get(parentSeq) : new ArrayList())) : new ArrayList();
            HashMap<String, Object> childMap = new HashMap<String, Object>();
            childMap.put("Seq", seq);
            childMap.put("Duty", duty);
            childMap.put("Person", personName);
            childrenList.add(childMap);
            relationMap.put(parentSeq, childrenList);
        }
        if (BillBaseStatusEnum.AUDITED.equals(baseStatus)) {
            if (this.actionSavePicture != null) {
                this.actionSavePicture.setEnabled(true);
                this.actionSavePicture.setVisible(true);
            }
            if (this.menuItemSavePicture != null) {
                this.menuItemSavePicture.setEnabled(true);
                this.menuItemSavePicture.setVisible(true);
            }
            if (this.btnSavePicture != null) {
                this.btnSavePicture.setEnabled(true);
                this.btnSavePicture.setVisible(true);
            }
        } else {
            if (this.actionSavePicture != null) {
                this.actionSavePicture.setEnabled(false);
                this.actionSavePicture.setVisible(false);
            }
            if (this.menuItemSavePicture != null) {
                this.menuItemSavePicture.setEnabled(false);
                this.menuItemSavePicture.setVisible(false);
            }
            if (this.btnSavePicture != null) {
                this.btnSavePicture.setEnabled(false);
                this.btnSavePicture.setVisible(false);
            }
        }
        Graphics2D graphics2D2 = graphics2D = (graphics = this.getGraphics()) == null ? null : (Graphics2D)graphics;
        if (graphics2D == null) {
            return;
        }
        int fontHeight = graphics2D.getFontMetrics().getFont().getSize();
        ArrayList<Integer> parentSeqList = new ArrayList<Integer>();
        parentSeqList.add(0);
        this.generateChartMap(1, 0, parentSeqList, relationMap, levelMap, personMap, graphics2D, fontHeight);
        Map map = personMap.containsKey(0) ? (personMap.get(0) == null ? null : (personMap.get(0) instanceof Map ? (Map)personMap.get(0) : null)) : (chartDataMap = null);
        int n = chartDataMap == null ? 0 : (chartDataMap.containsKey("SpaceWidth") ? (chartDataMap.get("SpaceWidth") == null ? 0 : (chartDataMap.get("SpaceWidth") instanceof Integer ? (Integer)chartDataMap.get("SpaceWidth") : 0)) : (chartWidth = 0));
        int chartHeight = chartDataMap == null ? 0 : (chartDataMap.containsKey("SpaceHeight") ? (chartDataMap.get("SpaceHeight") == null ? 0 : (chartDataMap.get("SpaceHeight") instanceof Integer ? (Integer)chartDataMap.get("SpaceHeight") : 0)) : 0);
        Set levelKeySet = levelMap == null ? null : levelMap.keySet();
        Iterator iterator = levelIterator = levelKeySet == null ? null : levelKeySet.iterator();
        if (levelIterator != null) {
            while (levelIterator.hasNext()) {
                int levelSpaceHeight;
                int levelSpaceWidth;
                Map levelDataMap;
                int key;
                Object keyObject = levelIterator.next();
                int n2 = keyObject == null ? 0 : (key = keyObject instanceof Integer ? (Integer)keyObject : 0);
                Map map2 = levelMap.containsKey(key) ? (levelMap.get(key) == null ? null : (levelMap.get(key) instanceof Map ? (Map)levelMap.get(key) : null)) : (levelDataMap = null);
                int n3 = levelDataMap == null ? 0 : (levelDataMap.containsKey("SpaceWidth") ? (levelDataMap.get("SpaceWidth") == null ? 0 : (levelDataMap.get("SpaceWidth") instanceof Integer ? (Integer)levelDataMap.get("SpaceWidth") : 0)) : (levelSpaceWidth = 0));
                int n4 = levelDataMap == null ? 0 : (levelDataMap.containsKey("SpaceHeight") ? (levelDataMap.get("SpaceHeight") == null ? 0 : (levelDataMap.get("SpaceHeight") instanceof Integer ? (Integer)levelDataMap.get("SpaceHeight") : 0)) : (levelSpaceHeight = 0));
                if ("V".equals(this.displayMode)) {
                    chartHeight += levelSpaceHeight;
                    continue;
                }
                chartWidth += levelSpaceWidth;
            }
        }
        this.chartPanel.setPreferredSize(new Dimension(chartWidth, chartHeight));
        this.spMain.getViewport().setViewSize(new Dimension(chartWidth, chartHeight));
        this.chartMap.put("PersonMap", personMap);
        this.chartMap.put("RelationMap", relationMap);
        this.chartMap.put("LevelMap", levelMap);
        this.chartMap.put("ChartWidth", chartWidth);
        this.chartMap.put("ChartHeight", chartHeight);
    }

    protected void generateChartMap(int level, int parentSeq, List parentSeqList, Map relationMap, Map levelMap, Map personMap, Graphics2D graphics2D, int fontHeight) throws Exception {
        List childrenList;
        int levelSpaceHeight;
        int levelSpaceWidth;
        HashMap<String, Integer> levelDataMap;
        if (level <= 0 || parentSeq < 0 || parentSeqList == null || relationMap == null || levelMap == null || personMap == null || graphics2D == null) {
            return;
        }
        if (parentSeqList.size() == 0 || relationMap.size() == 0) {
            return;
        }
        if (level >= 50) {
            return;
        }
        Map<Object, Object> map = levelMap.containsKey(level) ? (levelMap.get(level) == null ? new HashMap<String, Integer>() : (levelMap.get(level) instanceof Map ? (Map)levelMap.get(level) : new HashMap<String, Integer>())) : (levelDataMap = new HashMap<String, Integer>());
        int n = levelDataMap.containsKey("SpaceWidth") ? (levelDataMap.get("SpaceWidth") == null ? 0 : (levelDataMap.get("SpaceWidth") instanceof Integer ? (Integer)levelDataMap.get("SpaceWidth") : 0)) : (levelSpaceWidth = 0);
        int n2 = levelDataMap.containsKey("SpaceHeight") ? (levelDataMap.get("SpaceHeight") == null ? 0 : (levelDataMap.get("SpaceHeight") instanceof Integer ? (Integer)levelDataMap.get("SpaceHeight") : 0)) : (levelSpaceHeight = 0);
        Object object = relationMap == null ? null : (relationMap.containsKey(parentSeq) ? (relationMap.get(parentSeq) == null ? null : (relationMap.get(parentSeq) instanceof List ? (List)relationMap.get(parentSeq) : null)) : (childrenList = null));
        if (childrenList == null) {
            return;
        }
        if (childrenList.size() == 0) {
            return;
        }
        for (int index = 0; index < childrenList.size(); ++index) {
            int dutyStringWidth;
            String person;
            String duty;
            HashMap<String, Integer> personDataMap;
            int seq;
            Map childMap;
            Map map2 = childrenList.get(index) == null ? null : (childMap = childrenList.get(index) instanceof Map ? (Map)childrenList.get(index) : null);
            if (childMap == null || childMap.size() == 0) continue;
            int n3 = childMap.containsKey("Seq") ? (childMap.get("Seq") == null ? 0 : (childMap.get("Seq") instanceof Integer ? (Integer)childMap.get("Seq") : 0)) : (seq = 0);
            if (seq <= 0) continue;
            Map<Object, Object> map3 = personMap.containsKey(seq) ? (personMap.get(seq) == null ? new HashMap<String, Integer>() : (personMap.get(seq) instanceof Map ? (Map)personMap.get(seq) : new HashMap<String, Integer>())) : (personDataMap = new HashMap<String, Integer>());
            String string = childMap.containsKey("Duty") ? (childMap.get("Duty") == null ? null : childMap.get("Duty").toString()) : (duty = null);
            String string2 = childMap.containsKey("Person") ? (childMap.get("Person") == null ? null : childMap.get("Person").toString()) : (person = null);
            int n4 = duty == null ? this.defaultStringWidth : (dutyStringWidth = duty.trim().length() == 0 ? this.defaultStringWidth : graphics2D.getFontMetrics().stringWidth(duty));
            int personStringWidth = person == null ? this.defaultStringWidth : (person.trim().length() == 0 ? this.defaultStringWidth : graphics2D.getFontMetrics().stringWidth(person));
            int maxStringWidth = dutyStringWidth > personStringWidth ? dutyStringWidth : personStringWidth;
            int rectWidth = maxStringWidth > this.defaultRectWidth ? maxStringWidth + this.rectWidthMargin * 2 : this.defaultRectWidth;
            int rectHeight = fontHeight * 2 + this.rectHeightMargin * 4;
            int dutyRectHeight = fontHeight + this.rectHeightMargin * 2;
            int personRectHeight = fontHeight + this.rectHeightMargin * 2;
            int spaceWidth = rectWidth + this.personMargin * 2;
            int spaceHeight = rectHeight + this.personMargin * 2;
            personDataMap.putAll(childMap);
            personDataMap.put("Level", level);
            personDataMap.put("DutyStringWidth", dutyStringWidth);
            personDataMap.put("PersonStringWidth", personStringWidth);
            personDataMap.put("RectWidth", rectWidth);
            personDataMap.put("RectHeight", rectHeight);
            personDataMap.put("DutyRectHeight", dutyRectHeight);
            personDataMap.put("PersonRectHeight", personRectHeight);
            personDataMap.put("SpaceWidth", spaceWidth);
            personDataMap.put("SpaceHeight", spaceHeight);
            personMap.put(seq, personDataMap);
            if ("V".equals(this.displayMode)) {
                if (spaceHeight > levelSpaceHeight) {
                    levelSpaceHeight = spaceHeight;
                }
            } else if (spaceWidth > levelSpaceWidth) {
                levelSpaceWidth = spaceWidth;
            }
            this.updateParent(index, parentSeqList, spaceWidth, spaceHeight, personMap);
            ArrayList<Integer> newParentSeqList = new ArrayList<Integer>();
            newParentSeqList.addAll(parentSeqList);
            newParentSeqList.add(seq);
            this.generateChartMap(level + 1, seq, newParentSeqList, relationMap, levelMap, personMap, graphics2D, fontHeight);
        }
        levelDataMap.put("SpaceWidth", levelSpaceWidth);
        levelDataMap.put("SpaceHeight", levelSpaceHeight);
        levelMap.put(level, levelDataMap);
    }

    protected void updateParent(int childIndex, List parentSeqList, int spaceWidth, int spaceHeight, Map personMap) throws Exception {
        if (this.displayMode == null || childIndex < 0 || parentSeqList == null || personMap == null) {
            return;
        }
        if (this.displayMode.trim().length() == 0 || parentSeqList == null || personMap.size() == 0) {
            return;
        }
        if (personMap == null) {
            return;
        }
        if (personMap.size() == 0) {
            return;
        }
        for (int index = 0; index < parentSeqList.size(); ++index) {
            int subtract;
            int parentSpaceHeight;
            int parentSpaceWidth;
            HashMap<String, Integer> parentDataMap;
            int parentSeq;
            int n = parentSeqList.get(index) == null ? -1 : (parentSeq = parentSeqList.get(index) instanceof Integer ? (Integer)parentSeqList.get(index) : -1);
            if (parentSeq < 0) continue;
            Map<Object, Object> map = personMap.containsKey(parentSeq) ? (personMap.get(parentSeq) == null ? new HashMap<String, Integer>() : (personMap.get(parentSeq) instanceof Map ? (Map)personMap.get(parentSeq) : new HashMap<String, Integer>())) : (parentDataMap = new HashMap<String, Integer>());
            int n2 = parentDataMap.containsKey("SpaceWidth") ? (parentDataMap.get("SpaceWidth") == null ? 0 : (parentDataMap.get("SpaceWidth") instanceof Integer ? (Integer)parentDataMap.get("SpaceWidth") : 0)) : (parentSpaceWidth = 0);
            int n3 = parentDataMap.containsKey("SpaceHeight") ? (parentDataMap.get("SpaceHeight") == null ? 0 : (parentDataMap.get("SpaceHeight") instanceof Integer ? (Integer)parentDataMap.get("SpaceHeight") : 0)) : (parentSpaceHeight = 0);
            if ("V".equals(this.displayMode)) {
                if (childIndex <= 0) {
                    subtract = spaceWidth - parentSpaceWidth < 0 ? 0 : spaceWidth - parentSpaceWidth;
                    parentDataMap.put("SpaceWidth", parentSpaceWidth + subtract);
                } else {
                    parentDataMap.put("SpaceWidth", parentSpaceWidth + spaceWidth);
                }
            } else if (childIndex <= 0) {
                subtract = spaceHeight - parentSpaceHeight < 0 ? 0 : spaceHeight - parentSpaceHeight;
                parentDataMap.put("SpaceHeight", parentSpaceHeight + subtract);
            } else {
                parentDataMap.put("SpaceHeight", parentSpaceHeight + spaceHeight);
            }
            personMap.put(parentSeq, parentDataMap);
        }
    }

    public class ChartPanel
    extends KDPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 5264026570456326803L;

        public void displayChart(Graphics graphics) {
            Map levelMap;
            Map personMap;
            Map relationMap;
            Graphics2D graphics2D;
            if (graphics == null || ProjectGroupConstructChartUI.this.chartMap == null) {
                return;
            }
            if (ProjectGroupConstructChartUI.this.chartMap.size() == 0) {
                return;
            }
            Graphics2D graphics2D2 = graphics2D = graphics == null ? null : (Graphics2D)graphics;
            if (graphics2D == null) {
                return;
            }
            Map map = ProjectGroupConstructChartUI.this.chartMap.containsKey("RelationMap") ? (ProjectGroupConstructChartUI.this.chartMap.get("RelationMap") == null ? null : (ProjectGroupConstructChartUI.this.chartMap.get("RelationMap") instanceof Map ? (Map)ProjectGroupConstructChartUI.this.chartMap.get("RelationMap") : null)) : (relationMap = null);
            Map map2 = ProjectGroupConstructChartUI.this.chartMap.containsKey("PersonMap") ? (ProjectGroupConstructChartUI.this.chartMap.get("PersonMap") == null ? null : (ProjectGroupConstructChartUI.this.chartMap.get("PersonMap") instanceof Map ? (Map)ProjectGroupConstructChartUI.this.chartMap.get("PersonMap") : null)) : (personMap = null);
            Map map3 = ProjectGroupConstructChartUI.this.chartMap.containsKey("LevelMap") ? (ProjectGroupConstructChartUI.this.chartMap.get("LevelMap") == null ? null : (ProjectGroupConstructChartUI.this.chartMap.get("LevelMap") instanceof Map ? (Map)ProjectGroupConstructChartUI.this.chartMap.get("LevelMap") : null)) : (levelMap = null);
            if (relationMap == null || personMap == null || levelMap == null) {
                return;
            }
            if (relationMap.size() == 0 || personMap.size() == 0 || levelMap.size() == 0) {
                return;
            }
            this.setBackground(ProjectGroupConstructChartUI.this.backgroundColor);
            graphics2D.translate(0, 0);
            int fontHeight = graphics2D.getFontMetrics().getFont().getSize();
            this.displayChart(1, 0, ProjectGroupConstructChartUI.this.chartMargin, ProjectGroupConstructChartUI.this.chartMargin, relationMap, levelMap, personMap, graphics2D, fontHeight);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        protected void displayChart(int level, int parentSeq, int preLevelEndX, int preLevelEndY, Map relationMap, Map levelMap, Map personMap, Graphics2D graphics2D, int fontHeight) {
            List childrenList;
            int levelSpaceHeight;
            int levelSpaceWidth;
            if (level <= 0 || parentSeq < 0 || relationMap == null || levelMap == null || personMap == null || graphics2D == null) {
                return;
            }
            if (relationMap.size() == 0 || levelMap.size() == 0 || personMap.size() == 0) {
                return;
            }
            if (level >= 50) {
                return;
            }
            HashMap levelDataMap = levelMap.containsKey(level) ? (levelMap.get(level) == null ? new HashMap() : (levelMap.get(level) instanceof Map ? (Map)levelMap.get(level) : new HashMap())) : new HashMap();
            int levelX = preLevelEndX;
            int levelY = preLevelEndY;
            int n = levelDataMap.containsKey("SpaceWidth") ? (levelDataMap.get("SpaceWidth") == null ? 0 : (levelDataMap.get("SpaceWidth") instanceof Integer ? (Integer)levelDataMap.get("SpaceWidth") : 0)) : (levelSpaceWidth = 0);
            int n2 = levelDataMap.containsKey("SpaceHeight") ? (levelDataMap.get("SpaceHeight") == null ? 0 : (levelDataMap.get("SpaceHeight") instanceof Integer ? (Integer)levelDataMap.get("SpaceHeight") : 0)) : (levelSpaceHeight = 0);
            Object object = relationMap == null ? null : (relationMap.containsKey(parentSeq) ? (relationMap.get(parentSeq) == null ? null : (relationMap.get(parentSeq) instanceof List ? (List)relationMap.get(parentSeq) : null)) : (childrenList = null));
            if (childrenList == null) {
                return;
            }
            if (childrenList.size() == 0) {
                return;
            }
            int relationLineStartX = 0;
            int relationLineStartY = 0;
            int relationLineEndX = 0;
            int relationLineEndY = 0;
            for (int index = 0; index < childrenList.size(); ++index) {
                int spaceHeight;
                int spaceWidth;
                int personRectHeight;
                int dutyRectHeight;
                int rectHeight;
                int rectWidth;
                int personStringWidth;
                int dutyStringWidth;
                String person;
                String duty;
                HashMap personDataMap;
                int seq;
                Map childMap;
                Map map = childrenList.get(index) == null ? null : (childMap = childrenList.get(index) instanceof Map ? (Map)childrenList.get(index) : null);
                if (childMap == null || childMap.size() == 0) continue;
                int n3 = childMap.containsKey("Seq") ? (childMap.get("Seq") == null ? 0 : (childMap.get("Seq") instanceof Integer ? (Integer)childMap.get("Seq") : 0)) : (seq = 0);
                if (seq <= 0) continue;
                Map map2 = personMap.containsKey(seq) ? (personMap.get(seq) == null ? new HashMap() : (personMap.get(seq) instanceof Map ? (Map)personMap.get(seq) : new HashMap())) : (personDataMap = new HashMap());
                String string = childMap.containsKey("Duty") ? (childMap.get("Duty") == null ? null : childMap.get("Duty").toString()) : (duty = null);
                String string2 = childMap.containsKey("Person") ? (childMap.get("Person") == null ? null : childMap.get("Person").toString()) : (person = null);
                int n4 = personDataMap.containsKey("DutyStringWidth") ? (personDataMap.get("DutyStringWidth") == null ? 0 : (personDataMap.get("DutyStringWidth") instanceof Integer ? (Integer)personDataMap.get("DutyStringWidth") : 0)) : (dutyStringWidth = 0);
                int n5 = personDataMap.containsKey("PersonStringWidth") ? (personDataMap.get("PersonStringWidth") == null ? 0 : (personDataMap.get("PersonStringWidth") instanceof Integer ? (Integer)personDataMap.get("PersonStringWidth") : 0)) : (personStringWidth = 0);
                int n6 = personDataMap.containsKey("RectWidth") ? (personDataMap.get("RectWidth") == null ? 0 : (personDataMap.get("RectWidth") instanceof Integer ? (Integer)personDataMap.get("RectWidth") : 0)) : (rectWidth = 0);
                int n7 = personDataMap.containsKey("RectHeight") ? (personDataMap.get("RectHeight") == null ? 0 : (personDataMap.get("RectHeight") instanceof Integer ? (Integer)personDataMap.get("RectHeight") : 0)) : (rectHeight = 0);
                int n8 = personDataMap.containsKey("DutyRectHeight") ? (personDataMap.get("DutyRectHeight") == null ? 0 : (personDataMap.get("DutyRectHeight") instanceof Integer ? (Integer)personDataMap.get("DutyRectHeight") : 0)) : (dutyRectHeight = 0);
                int n9 = personDataMap.containsKey("PersonRectHeight") ? (personDataMap.get("PersonRectHeight") == null ? 0 : (personDataMap.get("PersonRectHeight") instanceof Integer ? (Integer)personDataMap.get("PersonRectHeight") : 0)) : (personRectHeight = 0);
                int n10 = personDataMap.containsKey("SpaceWidth") ? (personDataMap.get("SpaceWidth") == null ? 0 : (personDataMap.get("SpaceWidth") instanceof Integer ? (Integer)personDataMap.get("SpaceWidth") : 0)) : (spaceWidth = 0);
                int n11 = personDataMap.containsKey("SpaceHeight") ? (personDataMap.get("SpaceHeight") == null ? 0 : (personDataMap.get("SpaceHeight") instanceof Integer ? (Integer)personDataMap.get("SpaceHeight") : 0)) : (spaceHeight = 0);
                if ("V".equals(ProjectGroupConstructChartUI.this.displayMode)) {
                    if (spaceHeight < levelSpaceHeight) {
                        spaceHeight = levelSpaceHeight;
                    }
                } else if (spaceWidth < levelSpaceWidth) {
                    spaceWidth = levelSpaceWidth;
                }
                int rectX = levelX + (spaceWidth - rectWidth) / 2;
                int rectY = levelY + (spaceHeight - rectHeight) / 2;
                int separateLineY = rectY + fontHeight + ProjectGroupConstructChartUI.this.rectHeightMargin * 2;
                int traceUpLineStartX = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? rectX + rectWidth / 2 : levelX;
                int traceUpLineStartY = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? levelY : rectY + rectHeight / 2;
                int traceUpLineEndX = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? traceUpLineStartX : rectX;
                int traceUpLineEndY = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? rectY : traceUpLineStartY;
                int traceDownLineStartX = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? rectX + rectWidth / 2 : rectX + rectWidth;
                int traceDownLineStartY = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? rectY + rectHeight : rectY + rectHeight / 2;
                int traceDownLineEndX = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? traceUpLineStartX : levelX + spaceWidth;
                int traceDownLineEndY = "V".equals(ProjectGroupConstructChartUI.this.displayMode) ? levelY + spaceHeight : traceUpLineStartY;
                graphics2D.setColor(ProjectGroupConstructChartUI.this.dutyRectColor);
                graphics2D.fillRect(rectX, rectY, rectWidth, dutyRectHeight);
                graphics2D.setColor(ProjectGroupConstructChartUI.this.personRectColor);
                graphics2D.fillRect(rectX, separateLineY, rectWidth, personRectHeight);
                graphics2D.setColor(ProjectGroupConstructChartUI.this.fontColor);
                graphics2D.drawString(duty, rectX + (rectWidth - dutyStringWidth) / 2, rectY + fontHeight + ProjectGroupConstructChartUI.this.rectHeightMargin);
                graphics2D.setColor(ProjectGroupConstructChartUI.this.lineColor);
                graphics2D.drawLine(rectX, separateLineY, rectX + rectWidth, separateLineY);
                graphics2D.setColor(ProjectGroupConstructChartUI.this.fontColor);
                graphics2D.drawString(person, rectX + (rectWidth - personStringWidth) / 2, separateLineY + fontHeight + ProjectGroupConstructChartUI.this.rectHeightMargin);
                graphics2D.setColor(ProjectGroupConstructChartUI.this.rectBorderColor);
                graphics2D.drawRect(rectX, rectY, rectWidth, rectHeight);
                if (childrenList.size() > 1 || level > 1) {
                    graphics2D.setColor(ProjectGroupConstructChartUI.this.lineColor);
                    graphics2D.drawLine(traceUpLineStartX, traceUpLineStartY, traceUpLineEndX, traceUpLineEndY);
                }
                if (this.hasChildren(seq, relationMap).booleanValue()) {
                    graphics2D.setColor(ProjectGroupConstructChartUI.this.lineColor);
                    graphics2D.drawLine(traceDownLineStartX, traceDownLineStartY, traceDownLineEndX, traceDownLineEndY);
                    this.displayChart(level + 1, seq, levelX + levelSpaceWidth, levelY + levelSpaceHeight, relationMap, levelMap, personMap, graphics2D, fontHeight);
                }
                if ("V".equals(ProjectGroupConstructChartUI.this.displayMode)) {
                    levelX += spaceWidth;
                    if (index <= 0) {
                        relationLineStartX = rectX + rectWidth / 2;
                        relationLineStartY = levelY;
                        continue;
                    }
                    relationLineEndX = rectX + rectWidth / 2;
                    relationLineEndY = levelY;
                    continue;
                }
                levelY += spaceHeight;
                if (index <= 0) {
                    relationLineStartX = levelX;
                    relationLineStartY = rectY + rectHeight / 2;
                    continue;
                }
                relationLineEndX = levelX;
                relationLineEndY = rectY + rectHeight / 2;
            }
            if (childrenList.size() > 1) {
                graphics2D.setColor(ProjectGroupConstructChartUI.this.lineColor);
                graphics2D.drawLine(relationLineStartX, relationLineStartY, relationLineEndX, relationLineEndY);
            }
        }

        protected Boolean hasChildren(int parentSeq, Map relationMap) {
            List childrenList;
            if (parentSeq < 0 || relationMap == null) {
                return false;
            }
            if (relationMap.size() == 0) {
                return false;
            }
            Object object = relationMap == null ? null : (relationMap.containsKey(parentSeq) ? (relationMap.get(parentSeq) == null ? null : (relationMap.get(parentSeq) instanceof List ? (List)relationMap.get(parentSeq) : null)) : (childrenList = null));
            if (childrenList == null) {
                return false;
            }
            if (childrenList.size() == 0) {
                return false;
            }
            return true;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.displayChart(g);
        }
    }
}

