/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.common.core.GeneSysDefinedEnum;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.FaultLevelEnum;
import com.kingdee.eas.eqm.maintain.client.AbstractCreateFromTaskReqFilterUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CreateFromTaskReqFilterUI
extends AbstractCreateFromTaskReqFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CreateFromTaskReqFilterUI.class);
    private static final String RASKREQ_RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.TaskReqResource";

    protected void initListener() {
        super.initListener();
        this.prmtMaintainOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CreateFromTaskReqFilterUI.this.prmtMaintainOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    CreateFromTaskReqFilterUI.this.handUIException(exc);
                }
            }
        });
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CreateFromTaskReqFilterUI.this.prmtOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    CreateFromTaskReqFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            this.prmtNumberFrom.setEnabled(false);
            this.prmtNumberTo.setEnabled(false);
        } else {
            this.prmtNumberFrom.setEnabled(true);
            this.prmtNumberTo.setEnabled(true);
            try {
                OrgUnitInfo orgInfo = (OrgUnitInfo)e.getNewValue();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.setMaskString("#0 and (#1 or #2 or #3)");
                FilterItemCollection items = filter.getFilterItems();
                items.add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
                items.add(new FilterItemInfo("billStatus", (Object)new Integer(30), CompareType.EQUALS));
                items.add(new FilterItemInfo("billStatus", (Object)new Integer(70), CompareType.EQUALS));
                items.add(new FilterItemInfo("billStatus", (Object)new Integer(40), CompareType.EQUALS));
                view.setFilter(filter);
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtNumberFrom, (String)"com.kingdee.eas.eqm.maintain.app.F7TaskReqQuery", (EntityViewInfo)view);
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtNumberTo, (String)"com.kingdee.eas.eqm.maintain.app.F7TaskReqQuery", (EntityViewInfo)view);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    protected void prmtMaintainOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            this.prmtEquipmentLocation.setEnabled(false);
            this.prmtEquipmentArchives.setEnabled(false);
        } else {
            this.prmtEquipmentLocation.setEnabled(true);
            this.prmtEquipmentArchives.setEnabled(true);
            this.initLocationF7((OrgUnitInfo)e.getNewValue());
            this.initArchivesF7((OrgUnitInfo)e.getNewValue());
        }
    }

    protected void setDefaultValue() {
        OrgUnitInfo orgUnitInfo = super.getDefaultMainBizOrg();
        this.prmtMaintainOrgUnit.setValue((Object)orgUnitInfo);
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainOrgUnit, null, (boolean)false, (OrgType)OrgType.Storage, (boolean)true, (boolean)false);
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtOrgUnit, (String)this.getViewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        this.cboFaultLevel.removeAllItems();
        this.cboFaultLevel.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, FaultLevelEnum.One, FaultLevelEnum.Two, FaultLevelEnum.Three});
    }

    private void initLocationF7(OrgUnitInfo orgUnitInfo) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtEquipmentLocation.setEntityViewInfo(view);
    }

    private void initArchivesF7(OrgUnitInfo orgUnitInfo) throws Exception {
        HashSet<Integer> statusSet = new HashSet<Integer>();
        statusSet.add(new Integer(10));
        statusSet.add(new Integer(20));
        statusSet.add(new Integer(70));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
        items.add(new FilterItemInfo("logic", (Object)Boolean.FALSE, CompareType.EQUALS));
        items.add(new FilterItemInfo("bizStatus", statusSet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtEquipmentArchives.setEntityViewInfo(view);
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("maintainOrgUnit.id", (Component)this.prmtMaintainOrgUnit));
        rootElement.add((IFilterElement)new SingleFilterElement("equipmentArchives.id", (Component)this.prmtEquipmentArchives));
        rootElement.add((IFilterElement)new SingleFilterElement("equipmentLocation.id", (Component)this.prmtEquipmentLocation));
        RangeFilterElement numberElement = new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo);
        numberElement.getFrom().putUserInfo("key", "number");
        numberElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)numberElement);
        rootElement.add((IFilterElement)new SingleFilterElement("faultSort.id", (Component)this.prmtFaultSort));
        SingleFilterElement singleFilterElement = new SingleFilterElement("faultLevel", (Component)this.cboFaultLevel);
        singleFilterElement.setBlankValue((Object)GeneSysDefinedEnum.SELECT_ALL);
        rootElement.add((IFilterElement)singleFilterElement);
        RangeFilterElement bizDateElement = new RangeFilterElement("bizDate", (Component)this.pkCompleteDateFrom, (Component)this.pkCompleteDateTo);
        rootElement.add((IFilterElement)bizDateElement);
    }

    public FilterInfo getFilterInfo() {
        HashSet<Integer> statusSet = new HashSet<Integer>();
        if (this.chkAudit.isSelected()) {
            statusSet.add(new Integer(30));
        }
        if (this.chkPlan.isSelected()) {
            statusSet.add(new Integer(40));
        }
        if (this.chkSuspend.isSelected()) {
            statusSet.add(new Integer(70));
        }
        if (super.getFilterInfo() == null) {
            return null;
        }
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billStatus", statusSet, CompareType.INCLUDE));
        try {
            filterInfo.mergeFilter(filter, "and");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public boolean verify() {
        boolean bRet = true;
        Date bizDateFrom = (Date)this.pkCompleteDateFrom.getValue();
        Date bizDateTo = (Date)this.pkCompleteDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && new Timestamp(bizDateFrom.getTime()).after(new Timestamp(bizDateTo.getTime()))) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RASKREQ_RESOURCE_PATH, (String)"checkCompleteDate"));
            bRet = false;
        }
        return bRet;
    }

    public String getViewPermItemName() {
        return "eqm_maintain_taskreq_01view";
    }
}

