/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationFactory;
import com.kingdee.eas.eqm.maintain.client.AbstractStandardSelectUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class StandardSelectUI
extends AbstractStandardSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(StandardSelectUI.class);

    protected void registerCustomerBindings() {
        EquipmentLocationInfo eqmLocation = (EquipmentLocationInfo)this.getUIContext().get("eqmLocation");
        EquipmentArchivesInfo equipmentArchives = (EquipmentArchivesInfo)this.getUIContext().get("equipmentArchives");
        StorageOrgUnitInfo planOrgunit = (StorageOrgUnitInfo)this.getUIContext().get("planOrgunit");
        if (equipmentArchives != null) {
            this.prmtEquipmentArchives.setValue((Object)equipmentArchives);
            this.txtEquipmentArchivesName.setText(equipmentArchives.getName());
        } else {
            this.prmtEquipmentArchives.setValue(null);
            this.txtEquipmentArchivesName.setText(null);
        }
        if (eqmLocation != null) {
            this.prmtEquipmentLocation.setValue((Object)eqmLocation);
            this.txtEquipmentLocationName.setText(eqmLocation.getName());
        } else {
            this.prmtEquipmentLocation.setValue(null);
            this.txtEquipmentLocationName.setText(null);
        }
        this.prmtplanOrgUnit.setValue((Object)planOrgunit);
        this.kdrCurEqmLocation.setSelected(true);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected void initContextOrg() {
        super.initContextOrg();
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.getUIContext().get("planOrgunit");
        if (orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo) {
            this.initUIMainOrgContext(orgUnitInfo.getId().toString());
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.getUIContext().put("isConfirm", Boolean.TRUE);
        this.disposeUIWindow();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = this.getAllFilterForQuery();
        try {
            filterInfo.mergeFilter(this.getEqmFilterForQuery(), "AND");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return filterInfo;
    }

    protected FilterInfo getAllFilterForQuery() {
        StorageOrgUnitInfo planOrgunit = (StorageOrgUnitInfo)this.getUIContext().get("planOrgunit");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        try {
            items.add(new FilterItemInfo("storageOrgUnit.id", (Object)planOrgunit.getId().toString(), CompareType.EQUALS));
            items.add(new FilterItemInfo("usableStatus", (Object)new Integer(2), CompareType.EQUALS));
            filterInfo.mergeFilter(super.getDefaultFilterForQuery(), "AND");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return filterInfo;
    }

    private FilterInfo getEqmFilterForQuery() {
        EquipmentLocationInfo eqmLocation = (EquipmentLocationInfo)this.getUIContext().get("eqmLocation");
        EquipmentArchivesInfo equipmentArchives = (EquipmentArchivesInfo)this.getUIContext().get("equipmentArchives");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        if (eqmLocation == null && equipmentArchives == null) {
            return filterInfo;
        }
        if (equipmentArchives != null) {
            FilterItemInfo filterItem = new FilterItemInfo("id", (Object)this.createStandOperFilterStr("FEquipmentArchivesID", equipmentArchives.getId().toString()), CompareType.INNER);
            items.add(filterItem);
        } else if (eqmLocation != null) {
            FilterItemInfo filterItem = new FilterItemInfo("id", (Object)this.createStandOperFilterLocationStr("FEquipmentLocationID", eqmLocation.getId().toString()), CompareType.INNER);
            items.add(filterItem);
        }
        return filterInfo;
    }

    private String createStandOperFilterStr(String field, String assetId) {
        String sql = " Select fid from T_EQM_STAOPR  where (fid in (select distinct FStandardOperationID from T_EQM_SOASSET where {0} = {1})) or fid not in (select FStandardOperationID from T_EQM_SOASSET)";
        return MessageFormat.format(sql, field, "'" + assetId + "'");
    }

    private String createStandOperFilterLocationStr(String field, String assetId) {
        String sql = " Select fid from T_EQM_STAOPR  where (fid in (select distinct FStandardOperationID from T_EQM_SOASSET where {0} = {1} and FEquipmentArchivesID is null)) or fid not in (select FStandardOperationID from T_EQM_SOASSET)";
        return MessageFormat.format(sql, field, "'" + assetId + "'");
    }

    @Override
    public void actionExeQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filterInfo = null;
        filterInfo = this.kdrCurEqmLocation.isSelected() ? this.getDefaultFilterForQuery() : this.getAllFilterForQuery();
        this.mainQuery.setFilter(filterInfo);
        this.refresh(e);
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionConfirm_actionPerformed(e);
    }

    protected String getKeyFieldNmae() {
        return "id";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentStandardOperationFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        queryExecutor.option().isIgnorePermissionCheck = true;
        return queryExecutor;
    }
}

