/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentSuspendReasonInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.client.util.GeneClientUtils;
import com.kingdee.eas.eqm.common.core.codingrule.GeneCodingRuleData;
import com.kingdee.eas.eqm.common.core.print.ITDPrintStrategy;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.FaultLevelEnum;
import com.kingdee.eas.eqm.maintain.ITaskReq;
import com.kingdee.eas.eqm.maintain.TaskReqFactory;
import com.kingdee.eas.eqm.maintain.TaskReqInfo;
import com.kingdee.eas.eqm.maintain.TaskReqSrcTypeEnum;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.client.AbstractTaskReqEditUI;
import com.kingdee.eas.eqm.maintain.client.TaskReqTDPrintStrategy;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpFaultSortInfo;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpTaskInfo;
import com.kingdee.eas.eqm.planning.CheckingPlanningInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TaskReqEditUI
extends AbstractTaskReqEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaskReqEditUI.class);
    private static final String RASKREQ_RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.TaskReqResource";
    private TaskReqInfo tempTaskReqInfo = null;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TaskReqFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewDetailData(KDTable table, IRow srcrow) {
        return null;
    }

    @Override
    public void loadFields() {
        EquipmentArchivesInfo newObject;
        if (this.getOprtState().equals("ADDNEW") && this.tempTaskReqInfo != null) {
            this.editData.setSourceType(TaskReqSrcTypeEnum.BYPOINTINSPECTION);
        }
        super.loadFields();
        if (this.getOprtState().equals("ADDNEW") && null != (newObject = (EquipmentArchivesInfo)this.prmtEquipmentArchives.getValue())) {
            this.txtEquipmentArchivesName.setText(newObject.getName());
            EquipmentLocationInfo equipmentLocation = newObject.getLocation();
            if (equipmentLocation == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("location.id"));
                sic.add(new SelectorItemInfo("location.number"));
                sic.add(new SelectorItemInfo("location.name"));
                try {
                    EquipmentArchivesInfo remoteInfo = (EquipmentArchivesInfo)EquipmentArchivesFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(newObject.getId().toString()), sic);
                    if (remoteInfo.getLocation() != null) {
                        equipmentLocation = remoteInfo.getLocation();
                    }
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
            }
            if (equipmentLocation == null) {
                this.prmtEquipmentLocation.setDataNoNotify(null);
                this.txtEquipmentLocationName.setText(null);
            } else {
                this.prmtEquipmentLocation.setDataNoNotify((Object)equipmentLocation);
                this.txtEquipmentLocationName.setText(equipmentLocation.getName());
                String storageOrg = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
                this.filterArchivesByLocation(equipmentLocation, storageOrg);
            }
        }
        try {
            this.setFieldEnabled();
            this.initButtonEnable();
            this.initComboEnable();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void initComboEnable() {
        this.comboSourceType.setEnabled(false);
    }

    private void initButtonEnable() throws Exception {
        if (this.getOprtState() == "ADDNEW" || this.editData.getNumber() == null) {
            this.actionComplete.setEnabled(false);
            this.actionForceComplete.setEnabled(false);
        } else {
            this.actionComplete.setEnabled(true);
            this.actionForceComplete.setEnabled(true);
        }
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected IObjectValue createNewData() {
        if (this.tempTaskReqInfo != null) {
            return this.doCreateNewData((GeneBillBaseInfo)this.tempTaskReqInfo);
        }
        return this.doCreateNewData(null);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        this.setLockComponent(true);
        this.prmtSuspendReason.setEnabled(true);
        this.actionSubmit.setEnabled(false);
        this.actionEdit.setEnabled(true);
    }

    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        TaskReqInfo info = new TaskReqInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        info.setEqmRunning(false);
        info.setFaultLevel(FaultLevelEnum.Two);
        info.setFindDate(new Timestamp(new Date().getTime()));
        info.setSourceType(TaskReqSrcTypeEnum.BYSELF);
        if (this.getEntityValue() instanceof CheckingPlanningInfo) {
            CheckingPlanningInfo checkPlan = (CheckingPlanningInfo)this.getEntityValue();
            Iterator taskItr = checkPlan.getCpTask().iterator();
            Iterator faultItr = checkPlan.getCpFaultSort().iterator();
            info.put("CheckPlanningId", checkPlan.getId().toString());
            while (taskItr.hasNext()) {
                CheckingPlanningCpTaskInfo taskInfo = (CheckingPlanningCpTaskInfo)taskItr.next();
                info.put("TaskEntryId", taskInfo.getId().toString());
            }
            while (faultItr.hasNext()) {
                CheckingPlanningCpFaultSortInfo faultInfo = (CheckingPlanningCpFaultSortInfo)faultItr.next();
                info.put("FaultEntryId", faultInfo.getId().toString());
            }
        }
        this.createTaskInfo4OtherBill(info);
        if (this.getEntityValue() instanceof CheckingPlanningInfo) {
            this.tempTaskReqInfo = new TaskReqInfo();
            this.tempTaskReqInfo = (TaskReqInfo)info.copy();
        }
        return info;
    }

    public void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.pkFindDate.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        this.pkCompleteDate.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        this.kdtCloseDate.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        this.setFocusCycleRoot(false);
        try {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtStorageOrgUnit, (String)this.getAddNewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainOrgUnit, null, (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
            this.initWorkOrderModelF7();
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainWorkShop, (String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)((OrgUnitInfo)this.prmtMaintainOrgUnit.getValue()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.getEntityValue() != null) {
            try {
                if (this.getEntityValue() instanceof CheckingPlanningInfo) {
                    this.comboSourceType.setSelectedItem((Object)TaskReqSrcTypeEnum.BYPOINTINSPECTION);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnForceComplete.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_hardclosing", (Locale)SysContext.getSysContext().getLocale()));
        this.menuItemHardClosing.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_hardclosing", (Locale)SysContext.getSysContext().getLocale()));
    }

    protected void initListener() {
        super.initListener();
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    TaskReqEditUI.this.prmtStorageOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    TaskReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtMaintainOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    TaskReqEditUI.this.prmtMaintainOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    TaskReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtEquipmentLocation.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    TaskReqEditUI.this.prmtEquipmentLocation_dataChanged(e);
                }
                catch (Exception exc) {
                    TaskReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtEquipmentArchives.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    TaskReqEditUI.this.prmtEquipmentArchives_dataChanged(e);
                }
                catch (Exception exc) {
                    TaskReqEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        try {
            this.initEquipmentArchivesF7(newOrgId);
            this.initEquipmentLocationF7(newOrgId);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void initEquipmentLocationF7(String storageOrgUnitID) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        view.setFilter(filter);
        this.prmtEquipmentLocation.setEntityViewInfo(view);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("planOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainDept.*"));
        selector.add(new SelectorItemInfo("*"));
        this.prmtEquipmentLocation.setSelectorCollection(selector);
    }

    private void initEquipmentArchivesF7(String storageOrgUnitID) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
        items.add(new FilterItemInfo("bizStatus", (Object)new Integer(10), CompareType.EQUALS));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3 or #4)");
        view.setFilter(filter);
        this.prmtEquipmentArchives.setEntityViewInfo(view);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("planOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainDept.*"));
        selector.add(new SelectorItemInfo("location.*"));
        selector.add(new SelectorItemInfo("*"));
        this.prmtEquipmentArchives.setSelectorCollection(selector);
    }

    private void initWorkOrderModelF7() throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add("EM");
        set.add("CM");
        EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtWorkOrderModel, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentWorkOrderModelQuery", (String[])new String[]{"parent.number"}, (Object[])new Object[]{set}, (CompareType[])new CompareType[]{CompareType.INCLUDE});
    }

    private void initFinderF7(Set set) throws Exception {
        EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtFinder, (String)"com.kingdee.eas.eqm.basedata.app.F7PersonQuery", (String[])new String[]{"adminOrgUnit.id"}, (Object[])new Object[]{set}, (CompareType[])new CompareType[]{CompareType.INCLUDE});
        this.prmtFinder.setValue(null);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setFieldEnabled();
    }

    private void setFieldEnabled() {
        if (this.editData == null) {
            return;
        }
        if (this.oprtState.equals(OprtState.EDIT) && this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit)) {
            this.setLockComponent(false);
            this.prmtSuspendReason.setEnabled(true);
            this.actionSubmit.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.comboSourceType.setEnabled(false);
        } else if (this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.AddNew)) {
            this.actionSuspend.setEnabled(true);
        } else if (this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Suspend)) {
            this.setLockComponent(false);
            this.txtNumber.setEnabled(false);
            this.actionSuspend.setEnabled(false);
            this.comboSourceType.setEnabled(false);
        } else {
            this.setLockComponent(true);
            this.comboSourceType.setEnabled(false);
        }
        if (this.editData != null && !this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.AddNew)) {
            this.prmtStorageOrgUnit.setEnabled(false);
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected void prmtEquipmentArchives_dataChanged(DataChangeEvent e) throws Exception {
        EquipmentArchivesInfo newObject = (EquipmentArchivesInfo)e.getNewValue();
        if (null != newObject) {
            this.txtEquipmentArchivesName.setText(newObject.getName());
            this.prmtMaintainOrgUnit.setValue((Object)newObject.getMaintainOrgUnit());
            this.prmtMaintainWorkShop.setValue((Object)newObject.getMaintainDept());
            EquipmentLocationInfo equipmentLocation = newObject.getLocation();
            if (equipmentLocation == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("location.id"));
                sic.add(new SelectorItemInfo("location.number"));
                sic.add(new SelectorItemInfo("location.name"));
                try {
                    EquipmentArchivesInfo remoteInfo = (EquipmentArchivesInfo)EquipmentArchivesFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(newObject.getId().toString()), sic);
                    if (remoteInfo.getLocation() != null) {
                        equipmentLocation = remoteInfo.getLocation();
                    }
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
            }
            if (equipmentLocation == null) {
                this.prmtEquipmentLocation.setDataNoNotify(null);
                this.txtEquipmentLocationName.setText(null);
            } else {
                this.prmtEquipmentLocation.setDataNoNotify((Object)equipmentLocation);
                this.txtEquipmentLocationName.setText(equipmentLocation.getName());
                String storageOrg = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
                this.filterArchivesByLocation(equipmentLocation, storageOrg);
            }
        } else {
            this.txtEquipmentArchivesName.setText(null);
            if (this.prmtEquipmentLocation.getValue() == null) {
                this.prmtMaintainOrgUnit.setValue(null);
                this.prmtMaintainWorkShop.setValue(null);
            }
        }
    }

    @Override
    protected void prmtEquipmentLocation_dataChanged(DataChangeEvent e) throws Exception {
        EquipmentLocationInfo newObject = (EquipmentLocationInfo)e.getNewValue();
        if (null != newObject) {
            this.txtEquipmentLocationName.setText(newObject.getName());
            this.prmtMaintainOrgUnit.setValue((Object)newObject.getMaintainOrgUnit());
            this.prmtMaintainWorkShop.setValue((Object)newObject.getMaintainDept());
            this.prmtEquipmentArchives.setValue(null);
        } else {
            this.txtEquipmentLocationName.setText(null);
            if (this.prmtEquipmentArchives.getValue() == null) {
                this.prmtMaintainOrgUnit.setValue(null);
                this.prmtMaintainWorkShop.setValue(null);
            }
        }
        String storageOrg = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        this.filterArchivesByLocation(newObject, storageOrg);
    }

    protected void checkCanEdit(GeneBillBaseInfo editData) throws Exception {
        GeneBillBaseStatusEnum baseStatus = editData.getBillStatus();
        if (baseStatus.equals((Object)GeneBillBaseStatusEnum.CLOSED) || baseStatus.equals((Object)GeneBillBaseStatusEnum.ForceClosed) || baseStatus.equals((Object)GeneBillBaseStatusEnum.Suspend) || baseStatus.equals((Object)GeneBillBaseStatusEnum.Plan)) {
            MsgBox.showWarning((Component)((Object)this), (String)(GeneClientUtils.getResource((String)"BillAt") + baseStatus.getAlias() + GeneClientUtils.getResource((String)"CantBeEdited")));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtMaintainOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainWorkShop, (String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)newObject);
        } else {
            this.prmtMaintainWorkShop.setValue(null);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainWorkShop, (String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)newObject);
        }
    }

    @Override
    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            HashSet set = MMUtils.getAdminOrgByStorageOrg((String)newObject.getId().toString());
            this.initFinderF7(set);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.isSaveAction(e)) {
            return;
        }
        super.verifyInput(e);
        StringBuffer showInfo = new StringBuffer();
        if (this.prmtSuspendReason.getValue() != null) {
            showInfo.append(this.getResourceMsg("checkSubmitSuspendReason") + "\n");
        }
        if (this.prmtEquipmentLocation.getValue() == null && this.prmtEquipmentArchives.getValue() == null) {
            showInfo.append(this.getResourceMsg("equipmentAndLocation_isNull") + "\n");
            this.prmtEquipmentLocation.requestFocus();
        }
        Date bizDateFrom = (Date)this.pkFindDate.getValue();
        Date bizDateTo = (Date)this.pkCompleteDate.getValue();
        if (bizDateFrom != null && bizDateTo != null && new Timestamp(bizDateFrom.getTime()).after(new Timestamp(bizDateTo.getTime()))) {
            showInfo.append(this.getResourceMsg("check_date") + "\n");
        }
        if (showInfo.length() > 0) {
            MsgBox.showInfo((String)showInfo.toString());
            SysUtil.abort();
        }
    }

    @Override
    public void actionComplete_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)GeneResourceUtil.getMsg((String)RASKREQ_RESOURCE_PATH, (String)"alert_complete", null)))) {
            return;
        }
        try {
            ObjectUuidPK retValue = new ObjectUuidPK(this.editData.getId());
            ((ITaskReq)this.getBizInterface()).complete((IObjectPK)retValue);
            this.refreshCurPage();
            GeneClientUtils.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void actionForceComplete_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)GeneResourceUtil.getMsg((String)RASKREQ_RESOURCE_PATH, (String)"alert_forceComplete", null)))) {
            return;
        }
        try {
            ObjectUuidPK retValue = new ObjectUuidPK(this.editData.getId());
            ((ITaskReq)this.getBizInterface()).forceComplete((IObjectPK)retValue);
            this.refreshCurPage();
            GeneClientUtils.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSuspend_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer showInfo = new StringBuffer();
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        String id = this.editData.getId().toString();
        try {
            this.setOprtState("Suspend");
            this.pubFireVOChangeListener(id);
            if (!this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit)) {
                showInfo.append(this.getResourceMsg("check_suspendStatus") + "\n");
            }
            if (this.prmtSuspendReason.getValue() == null) {
                showInfo.append(this.getResourceMsg("check_suspendReason") + "\n");
            }
            if (showInfo.length() > 0) {
                MsgBox.showInfo((String)showInfo.toString());
            } else {
                String strSuspendReasonId = ((EquipmentSuspendReasonInfo)this.prmtSuspendReason.getValue()).getId().toString();
                ((ITaskReq)this.getBizInterface()).suspend(id, strSuspendReasonId);
                this.showSuccessMsg(this.getResourceMsg("suspend_success"));
                this.refreshCurPage();
                this.logExport(this.editData.getNumber(), this.editData.getMainOrgUnit().getId().toString());
            }
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.setOprtState(OprtState.VIEW);
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RASKREQ_RESOURCE_PATH, (String)key);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getInnerSelectors();
    }

    protected void setLockComponent(boolean isEnabled) {
        Component[] comps = this.getComponents();
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof KDPanel || comps[i] instanceof KDScrollPane || comps[i] instanceof KDSplitPane || comps[i] instanceof KDTabbedPane || comps[i] instanceof KDLabelContainer || comps[i] instanceof KDContainer || comps[i] instanceof JPanel) {
                    this.setLockContainer((Container)comps[i], isEnabled);
                    continue;
                }
                if (!(comps[i] instanceof IKDTextComponent) || comps[i].getName().equals("txtNumber")) continue;
                ((IKDTextComponent)comps[i]).setEnabled(isEnabled);
            }
        }
        this.txtEquipmentLocationName.setEnabled(false);
        this.txtEquipmentArchivesName.setEnabled(false);
        this.cboBillStatus.setEnabled(false);
        this.kdtCloseDate.setEnabled(false);
        this.prmtAuditor.setEnabled(false);
        this.dateAuditTime.setEnabled(false);
        this.prmtLastUpdateUser.setEnabled(false);
        this.dateLastUpdateTime.setEnabled(false);
        this.contCreator.setEnabled(false);
        this.contCreateTime.setEnabled(false);
        this.contNumber.setEnabled(false);
        if (this.comboSourceType.getSelectedItem() != null) {
            if ((TaskReqSrcTypeEnum)((Object)this.comboSourceType.getSelectedItem()) != null && ((TaskReqSrcTypeEnum)((Object)this.comboSourceType.getSelectedItem())).getValue() != 10 && isEnabled) {
                this.prmtEquipmentArchives.setEnabled(false);
                this.prmtEquipmentLocation.setEnabled(false);
            } else {
                this.prmtEquipmentArchives.setEnabled(isEnabled);
                this.prmtEquipmentLocation.setEnabled(isEnabled);
            }
        }
    }

    protected void setLockContainer(Container container, boolean isEnabled) {
        Component[] comps = container.getComponents();
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof KDPanel || comps[i] instanceof KDScrollPane || comps[i] instanceof KDSplitPane || comps[i] instanceof KDTabbedPane || comps[i] instanceof KDLabelContainer || comps[i] instanceof KDContainer || comps[i] instanceof JPanel || comps[i] instanceof JViewport) {
                    this.setLockContainer((Container)comps[i], isEnabled);
                    continue;
                }
                if (!(comps[i] instanceof IKDTextComponent) || comps[i].getName().equals("txtNumber")) continue;
                ((IKDTextComponent)comps[i]).setEnabled(isEnabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        if (null != this.editData.getId() && this.editData.getBillStatus().getValue() == 30 || this.editData.getBillStatus().getValue() == 70) {
            StorageOrgUnitInfo orgUnit = this.editData.getMaintainOrgUnit();
            if (orgUnit != null) {
                Context ctx = this.getMainOrgContext();
                UserInfo caller = SysContext.getSysContext().getCurrentUserInfo();
                IPermission perm = PermissionFactory.getRemoteInstanceWithObjectContext((Context)ctx);
                ObjectStringPK userPk = new ObjectStringPK(caller.getId().toString());
                ObjectStringPK orgPK = new ObjectStringPK(orgUnit.getId().toString());
                if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(caller.getId().toString()) && !perm.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPK, "eqm_maintain_workorderplan_02addnew")) {
                    throw new WorkOrderException(WorkOrderException.ADDNEW_USERNOPERMISSION, new String[]{orgUnit.getName()});
                }
            }
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable e1) {
                this.handUIException(e1);
                SysUtil.abort();
            }
            try {
                TaskReqInfo botpObject = this.editData;
                this.getUIContext().put("BOTP_NOTIFYTYPE", Boolean.TRUE);
                this.getBillEdit().CreateTo((CoreBillBaseInfo)botpObject, new WorkOrderInfo().getBOSType().toString());
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(this.editData.getId().toString());
                }
                catch (Throwable e2) {
                    this.handUIException(e2);
                }
                this.setOprtState("VIEW");
                this.refreshCurPage();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)GeneResourceUtil.getMsg((String)RASKREQ_RESOURCE_PATH, (String)"cannot_createto", null));
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setSyncOldValue(true);
        this.editData.setSourceType(TaskReqSrcTypeEnum.BYSELF);
        super.actionCopy_actionPerformed(e);
        this.prmtSuspendReason.setValue(null);
        this.kdtCloseDate.setValue(null);
        this.setLockComponent(true);
        this.comboSourceType.setEnabled(false);
    }

    public ITDPrintStrategy getTDPrintStrategy() throws Exception {
        TaskReqTDPrintStrategy taskReqTDPrintStrategy = new TaskReqTDPrintStrategy();
        return taskReqTDPrintStrategy;
    }

    protected boolean isSupportTDPrint() {
        return true;
    }

    protected void logExport(String number, String orgUnitId) {
        TaskReqInfo taskReqInfo = new TaskReqInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)taskReqInfo.getBOSType(), null, (String)number, (String)"eqm_maintain_taskreq_suspend", (String)orgUnitId);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        GeneCodingRuleData ruleData;
        super.actionAddNew_actionPerformed(e);
        if (this.getDataObject() != null && (ruleData = (GeneCodingRuleData)this.getDataObject().get("codingRuleData")) != null) {
            if ((ruleData != null && ruleData.isModifable() || ruleData == null) && ruleData.isAddView()) {
                this.getNumTextField().setEnabled(true);
            } else {
                this.getNumTextField().setEnabled(false);
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (TaskReqSrcTypeEnum.BYPOINTINSPECTION.equals(this.comboSourceType.getSelectedItem())) {
            CheckingPlanningCpTaskInfo taskInfo = null;
            CheckingPlanningCpFaultSortInfo faultInfo = null;
            if (this.getEntityValue() instanceof CheckingPlanningInfo) {
                CheckingPlanningInfo checkPlan = (CheckingPlanningInfo)this.getEntityValue();
                Iterator taskItr = checkPlan.getCpTask().iterator();
                Iterator faultItr = checkPlan.getCpFaultSort().iterator();
                this.getMainOrgContext().put((Object)"CheckPlanning", (Object)checkPlan);
                while (taskItr.hasNext()) {
                    taskInfo = (CheckingPlanningCpTaskInfo)taskItr.next();
                    this.getMainOrgContext().put((Object)"TaskEntryId", (Object)taskInfo.getId().toString());
                }
                while (faultItr.hasNext()) {
                    faultInfo = (CheckingPlanningCpFaultSortInfo)faultItr.next();
                    this.getMainOrgContext().put((Object)"FaultEntryId", (Object)faultInfo.getId().toString());
                }
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    private String getNumRule(TaskReqInfo taskReq) {
        String result = null;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss sssss");
        String strDate = sf.format(new Timestamp(System.currentTimeMillis()));
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
            if (taskReq.getStorageOrgUnit() != null && taskReq.getStorageOrgUnit().getId() != null && codingRuleManager.isExist((IObjectValue)taskReq, taskReq.getStorageOrgUnit().getId().toString())) {
                result = codingRuleManager.getNumber((IObjectValue)taskReq, taskReq.getStorageOrgUnit().getId().toString());
            }
            if (result == null) {
                result = "Req" + strDate;
            }
            return result;
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e2) {
            this.handleException((Exception)((Object)e2));
        }
        return result;
    }

    protected CoreBaseInfo getEntityValue() {
        CoreBaseInfo info = null;
        if (this.getUIContext().containsKey("EntityValue") && this.getUIContext().get("EntityValue") != null) {
            info = (CoreBaseInfo)this.getUIContext().get("EntityValue");
        }
        if (this.getUIContext().containsKey("CheckPlanning") && this.getUIContext().get("CheckPlanning") != null) {
            CheckingPlanningInfo CPInfo = null;
            if (this.getUIContext().get("CheckPlanning") instanceof CheckingPlanningInfo) {
                CPInfo = (CheckingPlanningInfo)this.getUIContext().get("CheckPlanning");
                CPInfo.getCpFaultSort().clear();
                CPInfo.getCpTask().clear();
                if (this.getUIContext().get("CheckPlanningEntry") != null && this.getUIContext().get("CheckPlanningEntry") instanceof CheckingPlanningCpTaskInfo) {
                    CPInfo.getCpTask().add((CheckingPlanningCpTaskInfo)this.getUIContext().get("CheckPlanningEntry"));
                }
                if (this.getUIContext().get("CheckPlanningEntry") != null && this.getUIContext().get("CheckPlanningEntry") instanceof CheckingPlanningCpFaultSortInfo) {
                    CPInfo.getCpFaultSort().add((CheckingPlanningCpFaultSortInfo)this.getUIContext().get("CheckPlanningEntry"));
                }
            }
            info = CPInfo;
        }
        return info;
    }

    protected void applyBillDefaultValue(GeneBillBaseInfo vo) {
        super.applyBillDefaultValue(vo);
        vo.setNumber(this.getNumRule((TaskReqInfo)vo));
    }

    private void baseData4TaskReq(TaskReqInfo info) {
        try {
            Date today = new Date();
            info.setBizDate(new Timestamp(today.getTime()));
            info.setEqmRunning(false);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void createTaskInfo4OtherBill(TaskReqInfo info) {
        this.baseData4TaskReq(info);
        if (this.getEntityValue() != null && this.getEntityValue() instanceof EquipmentArchivesInfo) {
            EquipmentArchivesInfo equipment = (EquipmentArchivesInfo)this.getEntityValue();
            info.setStorageOrgUnit(equipment.getStorageOrgUnit());
            info.setSourceType(TaskReqSrcTypeEnum.BYSELF);
            info.setFindDate(Calendar.getInstance().getTime());
            if (equipment.getMaintainOrgUnit() != null) {
                info.setMaintainOrgUnit(equipment.getMaintainOrgUnit());
            }
            if (equipment.getMaintainDept() != null) {
                info.setMaintainWorkShop(equipment.getMaintainDept());
            }
            info.setEquipmentArchives(equipment);
            if (equipment.getLocation() != null) {
                info.setEquipmentLocation(equipment.getLocation());
            }
        }
        if (this.getEntityValue() instanceof EquipmentLocationInfo) {
            Date today = new Date();
            EquipmentLocationInfo location = (EquipmentLocationInfo)this.getEntityValue();
            info.setStorageOrgUnit(location.getStorageOrgUnit());
            info.setSourceType(TaskReqSrcTypeEnum.BYSELF);
            info.setFindDate(new Timestamp(today.getTime()));
            if (location.getMaintainOrgUnit() != null) {
                info.setMaintainOrgUnit(location.getMaintainOrgUnit());
            }
            if (location.getMaintainDept() != null) {
                info.setMaintainWorkShop(location.getMaintainDept());
            }
            info.setEquipmentLocation(location);
        }
        if (this.getEntityValue() instanceof CheckingPlanningInfo) {
            CheckingPlanningInfo checkPlanning = (CheckingPlanningInfo)this.getEntityValue();
            info.setStorageOrgUnit(checkPlanning.getMaintainOrg());
            info.setSourceType(TaskReqSrcTypeEnum.BYPOINTINSPECTION);
            if (checkPlanning.getMaintainOrg() != null) {
                info.setMaintainOrgUnit(checkPlanning.getMaintainOrg());
            }
            info.setCreator(checkPlanning.getCreator());
            Iterator taskIter = checkPlanning.getCpTask().iterator();
            Iterator faultIter = checkPlanning.getCpFaultSort().iterator();
            while (taskIter.hasNext()) {
                CheckingPlanningCpTaskInfo taskInfo = (CheckingPlanningCpTaskInfo)taskIter.next();
                if (taskInfo.getAchieves() != null && taskInfo.getLocation() != null || taskInfo.getLocation() == null && taskInfo.getAchieves() != null) {
                    info.setEquipmentArchives(taskInfo.getAchieves());
                }
                if (taskInfo.getAchieves() == null && taskInfo.getLocation() != null) {
                    info.setEquipmentLocation(taskInfo.getLocation());
                }
                info.setFindDate(Calendar.getInstance().getTime());
            }
            while (faultIter.hasNext()) {
                CheckingPlanningCpFaultSortInfo faultInfo = (CheckingPlanningCpFaultSortInfo)faultIter.next();
                if (faultInfo.getAchieves() != null && faultInfo.getLocation() != null || faultInfo.getLocation() == null && faultInfo.getAchieves() != null) {
                    info.setEquipmentArchives(faultInfo.getAchieves());
                }
                if (faultInfo.getAchieves() == null && faultInfo.getLocation() != null) {
                    info.setEquipmentLocation(faultInfo.getLocation());
                }
                info.setMainReqOrFault(faultInfo.getDescription());
                info.setFaultSort(faultInfo.getFaultSort());
                if (faultInfo.getFaultLevel() != null) {
                    info.setFaultLevel(faultInfo.getFaultLevel());
                } else {
                    info.setFaultLevel(FaultLevelEnum.Two);
                }
                if (faultInfo.getDiscoverer() != null) {
                    info.setFinder(faultInfo.getDiscoverer());
                }
                if (faultInfo.getDiscoverTime() != null) {
                    info.setFindDate(faultInfo.getDiscoverTime());
                }
                if (faultInfo.getPhone() == null) continue;
                info.setWorkTel(faultInfo.getPhone());
            }
        }
    }

    protected void setMaxWindow() {
        Window dialog = null;
        if (this instanceof IUIObject) {
            dialog = SwingUtilities.getWindowAncestor((Component)this.txtNumber);
        }
        if (dialog != null && dialog instanceof UIModelDialog) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
            dialog.setBounds(0, 0, desktopBounds.width, desktopBounds.height);
        }
    }

    @Override
    public void onShow() throws Exception {
        this.setMaxWindow();
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
        } else {
            this.dateBizDate.requestFocusInWindow();
        }
        this.setFieldEnabled();
    }

    protected void filterArchivesByLocation(EquipmentLocationInfo location, String storageOrgUnitID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
        items.add(new FilterItemInfo("bizStatus", (Object)new Integer(10), CompareType.EQUALS));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        if (location != null && location.getId() != null) {
            items.add(new FilterItemInfo("location.id", (Object)location.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4) and #5");
        } else {
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4)");
        }
        view.setFilter(filter);
        this.prmtEquipmentArchives.setEntityViewInfo(view);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("planOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainDept.*"));
        selector.add(new SelectorItemInfo("location.*"));
        selector.add(new SelectorItemInfo("*"));
        this.prmtEquipmentArchives.setSelectorCollection(selector);
    }

    protected String getEquipmentIDForView() {
        if (this.prmtEquipmentArchives.getValue() != null) {
            return ((EquipmentArchivesInfo)this.prmtEquipmentArchives.getValue()).getId().toString();
        }
        return null;
    }
}

