/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.common.core.GeneSysDefinedEnum;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.TaskReqSrcTypeEnum;
import com.kingdee.eas.eqm.maintain.client.AbstractTaskReqFilterUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaskReqFilterUI
extends AbstractTaskReqFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TaskReqFilterUI.class);
    private static final String RASKREQ_RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.TaskReqResource";

    private void initEquipmentLocationF7(Set set) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)set, CompareType.INCLUDE));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)set, CompareType.INCLUDE));
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)set, CompareType.INCLUDE));
        filter.setMaskString("#0 or #1 or #2");
        view.setFilter(filter);
        this.prmtEquipmentLocationFrom.setEntityViewInfo(view);
        this.prmtEquipmentLocationTo.setEntityViewInfo(view);
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.comboSourceType.removeAllItems();
        this.comboSourceType.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, TaskReqSrcTypeEnum.BYSELF, TaskReqSrcTypeEnum.BYMETER, TaskReqSrcTypeEnum.BYPOINTINSPECTION});
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        RangeFilterElement equipmentLocationElement = new RangeFilterElement("equipmentLocation.number", (Component)this.prmtEquipmentLocationFrom, (Component)this.prmtEquipmentLocationTo);
        equipmentLocationElement.getFrom().putUserInfo("key", "number");
        equipmentLocationElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)equipmentLocationElement);
        RangeFilterElement numberElement = new RangeFilterElement("equipmentArchives.number", (Component)this.prmtEquipmentArchivesFrom, (Component)this.prmtEquipmentArchivesTo);
        numberElement.getFrom().putUserInfo("key", "number");
        numberElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)numberElement);
        RangeFilterElement bizDateElement = new RangeFilterElement("bizDate", (Component)this.dateBizDateFrom, (Component)this.dateBizDateTo);
        rootElement.add((IFilterElement)bizDateElement);
        SingleFilterElement sourceTypeElement = new SingleFilterElement("sourceType", (Component)this.comboSourceType);
        rootElement.add((IFilterElement)sourceTypeElement);
    }

    public FilterInfo getFilterInfo() {
        HashSet<Integer> statusSet = new HashSet<Integer>();
        if (this.chkSave.isSelected()) {
            statusSet.add(new Integer(10));
        }
        if (this.chkSubmit.isSelected()) {
            statusSet.add(new Integer(20));
        }
        if (this.chkAudit.isSelected()) {
            statusSet.add(new Integer(30));
        }
        if (this.chkPlan.isSelected()) {
            statusSet.add(new Integer(40));
        }
        if (this.chkForceComplete.isSelected()) {
            statusSet.add(new Integer(60));
        }
        if (this.chkComplete.isSelected()) {
            statusSet.add(new Integer(49));
        }
        if (this.chkSuspend.isSelected()) {
            statusSet.add(new Integer(70));
        }
        if (super.getFilterInfo() == null) {
            return null;
        }
        FilterInfo filterInfo = super.getFilterInfo();
        if (!statusSet.isEmpty()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billStatus", statusSet, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "and");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (GeneSysDefinedEnum.SELECT_ALL.equals(this.comboSourceType.getSelectedItem())) {
            FilterItemInfo sourceTypeFilterItem = new FilterItemInfo("sourceType", null, CompareType.NOTEQUALS);
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = filterInfo.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equals(sourceTypeFilterItem.getPropertyName())) continue;
                filterInfo.getFilterItems().removeObject(i);
                filterInfo.getFilterItems().addObject(i, (IObjectValue)sourceTypeFilterItem);
                break;
            }
        }
        return filterInfo;
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo[] orgs) {
        super.afterMainOrgChanged(oldOrg, orgs);
        try {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < orgs.length; ++i) {
                if (orgs[i] == null) continue;
                set.add(orgs[i].getId().toString());
            }
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchivesFrom, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForPlanOrgQuery", (String[])new String[]{"history.orgID"}, (Object[])new Object[]{set}, (CompareType[])new CompareType[]{CompareType.INCLUDE});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchivesTo, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForPlanOrgQuery", (String[])new String[]{"history.orgID"}, (Object[])new Object[]{set}, (CompareType[])new CompareType[]{CompareType.INCLUDE});
            this.initEquipmentLocationF7(set);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public boolean verify() {
        boolean bRet = super.verify();
        StringBuffer msgInfo = new StringBuffer();
        Date bizDateFrom = (Date)this.dateBizDateFrom.getValue();
        Date bizDateTo = (Date)this.dateBizDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && new Timestamp(bizDateFrom.getTime()).after(new Timestamp(bizDateTo.getTime()))) {
            msgInfo.append(ResourceUtils.getMessage((String)RASKREQ_RESOURCE_PATH, (String)"checkBizDate") + "\n");
            bRet = false;
        }
        if (!(this.chkSave.isSelected() || this.chkSubmit.isSelected() || this.chkAudit.isSelected() || this.chkPlan.isSelected() || this.chkForceComplete.isSelected() || this.chkComplete.isSelected() || this.chkSuspend.isSelected())) {
            msgInfo.append(ResourceUtils.getMessage((String)RASKREQ_RESOURCE_PATH, (String)"chkBillStatus") + "\n");
            bRet = false;
        }
        if (!bRet) {
            MsgBox.showInfo((String)msgInfo.toString());
        }
        return bRet;
    }

    protected void setDefaultValue() {
        Date dPlanStartTimeFrom = GeneDateUtils.dateAddByMonth((Date)new Date(), (int)-1);
        dPlanStartTimeFrom = GeneDateUtils.time((Date)dPlanStartTimeFrom, (int)0);
        this.dateBizDateFrom.setValue((Object)dPlanStartTimeFrom);
        Timestamp dPlanStartTimeTo = GeneDateUtils.time((Date)new Date(), (int)1);
        this.dateBizDateTo.setValue((Object)dPlanStartTimeTo);
        this.chkSave.setSelected(true);
        this.chkSubmit.setSelected(true);
        this.chkAudit.setSelected(true);
        this.chkPlan.setSelected(true);
        this.chkForceComplete.setSelected(true);
        this.chkComplete.setSelected(true);
        this.chkSuspend.setSelected(true);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.chkSave.setSelected(false);
        this.chkSubmit.setSelected(false);
        this.chkAudit.setSelected(false);
        this.chkPlan.setSelected(false);
        this.chkForceComplete.setSelected(false);
        this.chkComplete.setSelected(false);
        this.chkSuspend.setSelected(false);
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if (!filterItemInfo.getPropertyName().equals("billStatus")) continue;
                    Set statusSet = (Set)filterItemInfo.getCompareValue();
                    for (Integer intStatus : statusSet) {
                        switch (intStatus) {
                            case 10: {
                                this.chkSave.setSelected(true);
                                break;
                            }
                            case 20: {
                                this.chkSubmit.setSelected(true);
                                break;
                            }
                            case 30: {
                                this.chkAudit.setSelected(true);
                                break;
                            }
                            case 40: {
                                this.chkPlan.setSelected(true);
                                break;
                            }
                            case 60: {
                                this.chkForceComplete.setSelected(true);
                                break;
                            }
                            case 49: {
                                this.chkComplete.setSelected(true);
                                break;
                            }
                            case 70: {
                                this.chkSuspend.setSelected(true);
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

