/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneSysDefinedEnum;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.DateCasterEnum;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.util.GeneFilterUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderSrcTypeEnum;
import com.kingdee.eas.eqm.maintain.WorkOrderTypeEnum;
import com.kingdee.eas.eqm.maintain.client.AbstractWorkOrderFilterUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class WorkOrderFilterUI
extends AbstractWorkOrderFilterUI {
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";
    private static final Logger logger = CoreUIObject.getLogger(WorkOrderFilterUI.class);

    public WorkOrderFilterUI() throws Exception {
        this.setIsSupportMultiOrgs(false);
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("maintainOrgUnit.id", (Component)this.prmtMaintainOrgUnit));
        RangeFilterElement numberElement = new RangeFilterElement("number", (Component)this.txtNumberFrom, (Component)this.txtNumberTo);
        numberElement.getFrom().putUserInfo("key", "number");
        numberElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)numberElement);
        rootElement.add((IFilterElement)new SingleFilterElement("equipmentArchives.id", (Component)this.prmtEquipmentArchives));
        rootElement.add((IFilterElement)new SingleFilterElement("eqmLocation.id", (Component)this.prmtEquipmentLocation));
        rootElement.add((IFilterElement)new SingleFilterElement("workOrderModel.id", (Component)this.prmtWorkOrderModel));
        SingleFilterElement workOrderSrcTypeElement = new SingleFilterElement("sourcetype", (Component)this.comboSourceType);
        workOrderSrcTypeElement.setBlankValue((Object)GeneSysDefinedEnum.SELECT_ALL);
        workOrderSrcTypeElement.setDefaultValue(String.valueOf(999));
        workOrderSrcTypeElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add((IFilterElement)workOrderSrcTypeElement);
        RangeFilterElement bizDateElement = new RangeFilterElement("planStartTime", (Component)this.planStartTimeFrom, (Component)this.planStartTimeTo);
        rootElement.add((IFilterElement)bizDateElement);
        rootElement.add((IFilterElement)new SingleFilterElement("pmstrategy.id", (Component)this.prmtPMStrategy));
        rootElement.add((IFilterElement)new SingleFilterElement("planVersion.id", (Component)this.prmtPlanningScheme));
        rootElement.add((IFilterElement)new SingleFilterElement("maintainDept.id", (Component)this.prmtMaintainDept));
        rootElement.add((IFilterElement)new SingleFilterElement("maintainTeam.id", (Component)this.prmtMaintainTeam));
        rootElement.add((IFilterElement)new SingleFilterElement("manager.id", (Component)this.prmtManager));
        rootElement.add((IFilterElement)new SingleFilterElement("manageCrafts.id", (Component)this.prmtMaintainCrafts));
        rootElement.add((IFilterElement)new SingleFilterElement("parent.id", (Component)this.prmtParent));
        rootElement.add((IFilterElement)new SingleFilterElement("superParent.id", (Component)this.prmtTopParent));
        rootElement.add((IFilterElement)new SingleFilterElement("sourceOrder.id", (Component)this.prmtSourceWO));
        SingleFilterElement bizStatusFilterElement = new SingleFilterElement("taskType", (Component)this.comboTaskType);
        bizStatusFilterElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add((IFilterElement)bizStatusFilterElement);
        SingleFilterElement billStatusElement = new SingleFilterElement("billStatus", (Component)this.comboBillStatus);
        billStatusElement.setBlankValue((Object)GeneSysDefinedEnum.SELECT_ALL);
        billStatusElement.setDefaultValue(String.valueOf(GeneSysDefinedEnum.SELECT_ALL));
        billStatusElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add((IFilterElement)billStatusElement);
        SingleFilterElement billStatusSave = new SingleFilterElement("parent.id", (Component)this.chkSuperParent);
        billStatusSave.putUserInfo("falseEqualAll", "true");
        rootElement.add((IFilterElement)billStatusSave);
        this.getFilterManager().getRootElement().getVerifyManager().addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                if (WorkOrderFilterUI.this.planStartTimeFrom.getValue() == null || WorkOrderFilterUI.this.planStartTimeTo.getValue() == null) {
                    return true;
                }
                return true;
            }
        });
        this.prmtMaintainOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WorkOrderFilterUI.this.prmtMaintainOrgUnit_stateChanged(e);
            }
        });
        this.prmtEquipmentLocation.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                WorkOrderFilterUI.this.prmtlocation_dataChanged(e);
            }
        });
        this.planStartTimeFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                WorkOrderFilterUI.this.planStartTimeFrom_dataChanged(e);
            }
        });
    }

    protected void planStartTimeFrom_dataChanged(DataChangeEvent e) {
        if (null != e && GeneEqualsUtils.equals((Object)e.getNewValue(), (Object)e.getOldValue())) {
            return;
        }
        if (e.getNewValue() instanceof Date) {
            Date d = (Date)e.getNewValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(d);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            Timestamp t = new Timestamp(calendar.getTimeInMillis());
            this.planStartTimeFrom.setValue((Object)t);
        }
    }

    protected void prmtlocation_dataChanged(DataChangeEvent e) {
        block10: {
            EquipmentLocationInfo info;
            if (null != e && GeneEqualsUtils.equals((Object)e.getNewValue(), (Object)e.getOldValue())) {
                return;
            }
            EquipmentLocationInfo equipmentLocationInfo = info = null == e ? (EquipmentLocationInfo)this.prmtEquipmentLocation.getValue() : (EquipmentLocationInfo)e.getNewValue();
            if (null == info) {
                try {
                    if (this.getMainBizOrgF7() == this.prmtOrgUnit) {
                        EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForPlanOrgQuery", (String[])new String[]{"history.orgID"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS}, (boolean)true);
                        break block10;
                    }
                    EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForMaintainOrgQuery", (String[])new String[]{"history.orgID"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS}, (boolean)true);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            } else {
                try {
                    if (this.getMainBizOrgF7() == this.prmtOrgUnit) {
                        EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForPlanOrgQuery", (String[])new String[]{"history.orgID", "location.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString(), info.getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
                    } else {
                        EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForMaintainOrgQuery", (String[])new String[]{"history.orgID", "location.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString(), info.getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
                    }
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            }
        }
    }

    protected void prmtMaintainOrgUnit_stateChanged(ChangeEvent e) {
        try {
            this.prmtMaintainDept.setValue(null);
            this.prmtMaintainTeam.setValue(null);
            this.prmtManager.setValue(null);
            if (this.prmtMaintainOrgUnit.getValue() == null) {
                this.prmtMaintainDept.setEnabled(false);
                this.prmtMaintainTeam.setEnabled(false);
                this.prmtManager.setEnabled(false);
                return;
            }
            this.prmtMaintainDept.setEnabled(true);
            this.prmtMaintainTeam.setEnabled(true);
            this.prmtManager.setEnabled(true);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainDept, (String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)((OrgUnitInfo)this.prmtMaintainOrgUnit.getValue()));
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtMaintainTeam, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentMaintainGroupQuery", (String[])new String[]{"storageOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.prmtMaintainOrgUnit.getValue()).getId().toString()});
            EQMPromptDialogFactory.createPeoplePrmptList((KDBizPromptBox)this.prmtManager, (String)"com.kingdee.eas.eqm.basedata.app.F7PersonQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)((OrgUnitInfo)this.prmtMaintainOrgUnit.getValue()), (String[])new String[]{"deletedStatus"}, (Object[])new Object[]{new Integer(1)}, (CompareType[])new CompareType[]{CompareType.EQUALS});
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    protected void registerCustomerBindings() {
        this.comboSourceType.removeAllItems();
        this.comboSourceType.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, WorkOrderSrcTypeEnum.MANUAL, WorkOrderSrcTypeEnum.MAINTAINTASKREQ, WorkOrderSrcTypeEnum.MAINTAINSTRATEGY, WorkOrderSrcTypeEnum.MAINTAINROUTE, WorkOrderSrcTypeEnum.MAINTAINSCHEMA, WorkOrderSrcTypeEnum.TASK, WorkOrderSrcTypeEnum.STATUSTEST, WorkOrderSrcTypeEnum.CHECKPLAN});
        this.comboTaskType.removeAllItems();
        this.comboTaskType.addItems(new Object[]{WorkOrderTypeEnum.WORKORDER, WorkOrderTypeEnum.TASK, GeneSysDefinedEnum.SELECT_ALL});
        this.comboBillStatus.removeAllItems();
        this.comboBillStatus.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, GeneBillBaseStatusEnum.SAVE, GeneBillBaseStatusEnum.Submit, GeneBillBaseStatusEnum.Audit, GeneBillBaseStatusEnum.Release, GeneBillBaseStatusEnum.StartWork, GeneBillBaseStatusEnum.Finish, GeneBillBaseStatusEnum.Check, GeneBillBaseStatusEnum.CLOSED, GeneBillBaseStatusEnum.ForceClosed});
        super.registerCustomerBindings();
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainOrgUnit, null, (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtWorkOrderModel, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentWorkOrderModelQuery", (String[])new String[0], (Object[])new Object[0]);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtMaintainCrafts, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentMaintainCraftQuery", (String[])new String[0], (Object[])new Object[0]);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        this.prmtMaintainOrgUnit_stateChanged(null);
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtOrgUnit, (String)this.getViewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainOrgUnit, null, (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtOrgUnit;
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    protected String getMainBizOrgField() {
        return "planOrgunit";
    }

    protected void setDefaultValue() {
        Timestamp dPlanStartTimeFrom = GeneDateUtils.time((Date)new Date(), (int)0);
        this.planStartTimeFrom.setValue((Object)dPlanStartTimeFrom);
        Date dPlanStartTimeTo = GeneDateUtils.dateAddByMonth((Date)new Date(), (int)1);
        dPlanStartTimeTo = GeneDateUtils.time((Date)dPlanStartTimeTo, (int)1);
        this.planStartTimeTo.setValue((Object)dPlanStartTimeTo);
        OrgUnitInfo defaultOrgUnit = this.getDefaultMainBizOrg();
        this.prmtOrgUnit.setValue((Object)defaultOrgUnit);
        this.prmtMaintainOrgUnit.setValue((Object)defaultOrgUnit);
        this.chkSuperParent.setSelected(true);
        this.comboTaskType.setSelectedItem((Object)WorkOrderTypeEnum.WORKORDER);
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        super.afterMainOrgChanged(oldOrg, org);
        try {
            if (this.getMainBizOrgF7() == this.prmtOrgUnit) {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForPlanOrgQuery", (String[])new String[]{"history.orgID"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            } else {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForMaintainOrgQuery", (String[])new String[]{"history.orgID"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            }
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentLocation, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery", (String[])new String[]{"planOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtPMStrategy, (String)"com.kingdee.eas.eqm.planning.app.F7PreMaintainStrategyQuery", (String[])new String[]{"storageOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtPlanningScheme, (String)"com.kingdee.eas.eqm.planning.app.F7EquipmentMaintainSchemaQuery", (String[])new String[]{"storageOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.txtNumberFrom, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"planOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.txtNumberTo, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"planOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtParent, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"planOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtTopParent, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"planOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtSourceWO, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"planOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public FilterInfo getFilterInfo() {
        if (super.getFilterInfo() == null) {
            return null;
        }
        FilterInfo filterInfo = super.getFilterInfo();
        FilterItemInfo superParentFilterItem = new FilterItemInfo("parent.id", null);
        if (this.chkSuperParent.isSelected()) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = filterInfo.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equals(superParentFilterItem.getPropertyName())) continue;
                filterInfo.getFilterItems().removeObject(i);
                filterInfo.getFilterItems().addObject(i, (IObjectValue)superParentFilterItem);
                break;
            }
        }
        if (this.comboTaskType.getSelectedItem().equals(GeneSysDefinedEnum.SELECT_ALL)) {
            FilterItemInfo taskTypeFilterItem = new FilterItemInfo("taskType", null, CompareType.NOTEQUALS);
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = filterInfo.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equals(taskTypeFilterItem.getPropertyName())) continue;
                filterInfo.getFilterItems().removeObject(i);
                filterInfo.getFilterItems().addObject(i, (IObjectValue)taskTypeFilterItem);
                break;
            }
        }
        if (this.prmtEquipmentArchives.getValue() == null && this.prmtEquipmentLocation.getValue() != null) {
            GeneFilterUtils.mergeFilter((FilterInfo)filterInfo, (FilterItemInfo)new FilterItemInfo("equipmentArchives.id", null, CompareType.EQUALS));
        }
        if (!this.isFastReport()) {
            GeneFilterUtils.mergeFilter((FilterInfo)filterInfo, (FilterItemInfo)new FilterItemInfo("fastReport", (Object)false, CompareType.EQUALS));
        }
        return filterInfo;
    }

    protected boolean isFastReport() {
        return false;
    }

    public boolean verify() {
        boolean bRet = super.verify();
        Date planDateFrom = (Date)this.planStartTimeFrom.getValue();
        Date planDateTo = (Date)this.planStartTimeTo.getValue();
        if (planDateFrom != null && planDateTo != null && new Timestamp(planDateFrom.getTime()).after(new Timestamp(planDateTo.getTime()))) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RESOURCE_PATH, (String)"PLANTIME_INVALID"));
            bRet = false;
        }
        return bRet;
    }

    public String getViewPermItemName() {
        return "eqm_maintain_workorderplan_01view";
    }
}

